/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.tools.ExportFormat;

public class ExportGnuplotFormat
implements ExportFormat {
    public String description() {
        return "Text";
    }

    public String extension() {
        return "txt";
    }

    void exportDataset(PrintWriter pw, Dataset data, int index) throws IOException {
        double[] x = data.getXPoints();
        double[] y = data.getYPoints();
        pw.print("\n# name: data" + index + "\n" + "# type: matrix\n" + "# rows: " + x.length + "\n" + "# columns: " + 2 + "\n");
        for (int j = 0; j < x.length; ++j) {
            pw.println(x[j] + " " + y[j]);
        }
    }

    void exportGridData(PrintWriter pw, GridData gridData, int index) throws IOException {
        int nx = gridData.getNx();
        int ny = gridData.getNy();
        double x0 = gridData.getLeft();
        double dx = gridData.getDx();
        pw.println("\n# name: col_range" + index + "\n" + "# type: matrix\n" + "# rows: 1\n" + "# columns: " + nx);
        for (int i = 0; i < nx; ++i) {
            pw.print(x0 + (double)i * dx + " ");
        }
        pw.println("\n");
        double y0 = gridData.getTop();
        double dy = gridData.getDy();
        pw.println("# name: row_range" + index + "\n" + "# type: matrix\n" + "# rows: 1\n" + "# columns: " + ny);
        for (int i = 0; i < ny; ++i) {
            pw.print(y0 + (double)i * dy + " ");
        }
        pw.println("\n");
        int nc = gridData.getComponentCount();
        for (int c = 0; c < nc; ++c) {
            String cname = gridData.getComponentName(c);
            pw.println("# name: grid_" + index + '_' + cname + '\n' + "# type: matrix\n" + "# rows: " + ny + '\n' + "# columns: " + nx);
            for (int i = 0; i < ny; ++i) {
                for (int j = 0; j < nx; ++j) {
                    pw.print(gridData.getValue(j, i, c) + " ");
                }
                pw.println();
            }
        }
    }

    public void export(File file, List data) {
        try {
            FileWriter fw = new FileWriter(file);
            PrintWriter pw = new PrintWriter(fw);
            pw.println("# Created by the Open Source Physics library");
            Iterator it = data.iterator();
            int i = 0;
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof Dataset) {
                    this.exportDataset(pw, (Dataset)o, i);
                } else if (o instanceof GridData) {
                    this.exportGridData(pw, (GridData)o, i);
                }
                ++i;
            }
            pw.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "An error occurred while saving your file. Please try again.", "Error", 0);
        }
    }
}

