/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchBuilder;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class LaunchSaver
extends JDialog {
    private String prevTabSetName;
    private String prevTabSetBasePath;
    private boolean prevTabSetSelfContained;
    private Map prevNodeNames = new HashMap();
    private Map prevNodeSelfContains = new HashMap();
    private LaunchBuilder builder;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private ArrayList treePaths = new ArrayList();
    private JTextField pathField;
    private JButton chooseButton;
    private JButton inspectButton;
    private Node root;
    private JScrollPane treeScroller;
    private boolean approved = false;
    private Editor editor = new Editor();
    private JDialog inspector;
    private boolean active;

    public LaunchSaver(LaunchBuilder builder) {
        super((Frame)builder.frame, true);
        this.createGUI();
        this.setBuilder(builder);
        if (FontSizer.getLevel() != 0) {
            FontSizer.setFonts(this.getContentPane(), FontSizer.getLevel());
        }
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        ((Component)this).setLocation(x, y);
    }

    public void setBuilder(LaunchBuilder builder) {
        this.builder = builder;
        this.createTree();
        this.refresh();
        this.approved = false;
    }

    public void setSelectedNode(Node node) {
        if (node == null) {
            return;
        }
        this.tree.setSelectionPath(new TreePath(node.getPath()));
    }

    public Node getSelectedNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (Node)path.getLastPathComponent();
    }

    public boolean isApproved() {
        return this.approved;
    }

    private void refresh() {
        this.inspectButton.setEnabled(this.getSelectedNode() != null);
        String path = null;
        path = !Launcher.tabSetBasePath.equals("") ? Launcher.tabSetBasePath : (this.builder.jarBasePath != null ? this.builder.jarBasePath : XML.forwardSlash(XML.getUserDirectory()));
        if (path.indexOf("javaws") > -1) {
            Launcher.tabSetBasePath = path = XML.forwardSlash(System.getProperty("user.home", "."));
        }
        this.pathField.setText(path + "/");
        this.pathField.setBackground(Color.white);
        this.treeModel.nodeChanged(this.root);
        this.tree.repaint();
    }

    private void inspectSelectedNode() {
        Object obj;
        Node node = this.getSelectedNode();
        if (node == null) {
            node = this.root;
        }
        if ((obj = node.node) == null) {
            LaunchBuilder launchBuilder = this.builder;
            launchBuilder.getClass();
            obj = new Launcher.LaunchSet(launchBuilder, this.builder, this.builder.tabSetName);
        }
        XMLControlElement xml = new XMLControlElement(obj);
        XMLTreePanel treePanel = new XMLTreePanel(xml, false);
        this.inspector.setContentPane(treePanel);
        String name = node != this.root ? node.node.getFileName() : this.builder.tabSetName;
        name = XML.getResolvedPath(name, Launcher.tabSetBasePath);
        this.inspector.setTitle(LaunchRes.getString("Inspector.Title.File") + " \"" + name + "\"");
        ((Component)this.inspector).setVisible(true);
    }

    private void revert() {
        Launcher.tabSetBasePath = this.prevTabSetBasePath;
        this.builder.tabSetName = this.prevTabSetName;
        this.builder.selfContained = this.prevTabSetSelfContained;
        for (int i = 0; i < this.builder.tabbedPane.getTabCount(); ++i) {
            LaunchNode root = this.builder.getTab(i).getRootNode();
            root.parentSelfContained = this.prevTabSetSelfContained;
        }
        Iterator it = this.prevNodeNames.keySet().iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            String path = (String)this.prevNodeNames.get(node);
            node.node.setFileName(path);
            Boolean bool = (Boolean)this.prevNodeSelfContains.get(node);
            node.node.setSelfContained(bool);
        }
    }

    private void setTabSetBasePath(String path) {
        path = XML.forwardSlash(path);
        boolean leadingSlash = false;
        while (path.startsWith("/")) {
            leadingSlash = true;
            path = path.substring(1);
        }
        if (leadingSlash) {
            path = "/" + path;
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!path.startsWith("/") && path.indexOf(":") == -1) {
            String base = XML.forwardSlash(XML.getUserDirectory());
            if (this.builder.jarBasePath != null) {
                base = this.builder.jarBasePath;
            }
            if (!path.equals("")) {
                base = base + "/";
            }
            path = base + path;
        }
        Launcher.tabSetBasePath = path;
        this.refresh();
    }

    private String setTabSetName(String proposed) {
        String name = XML.getName(proposed);
        if (!"xset".equals(XML.getExtension(name))) {
            while (name.indexOf(".") > -1) {
                name = name.substring(0, name.length() - 1);
            }
            name = name + ".xset";
        }
        this.builder.tabSetName = name;
        this.refresh();
        return name;
    }

    private void createGUI() {
        this.inspector = new JDialog((Dialog)this, false);
        ((Component)this.inspector).setSize(new Dimension(600, 300));
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.inspector.getBounds().width) / 2;
        int y = (dim.height - this.inspector.getBounds().height) / 2;
        ((Component)this.inspector).setLocation(x, y);
        this.setTitle(LaunchRes.getString("Saver.Title"));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(600, 300));
        this.setContentPane(panel);
        JPanel legend = new JPanel(new GridLayout(1, 4));
        panel.add((Component)legend, "North");
        JLabel label = new JLabel(LaunchRes.getString("Saver.Legend.New"), Launcher.greenFileIcon, 0);
        label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        legend.add(label);
        label = new JLabel(LaunchRes.getString("Saver.Legend.Replace"), Launcher.yellowFileIcon, 0);
        label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        legend.add(label);
        label = new JLabel(LaunchRes.getString("Saver.Legend.ReadOnly"), Launcher.redFileIcon, 0);
        label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        legend.add(label);
        label = new JLabel(LaunchRes.getString("Saver.Legend.SelfContained"), Launcher.whiteFolderIcon, 0);
        label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        legend.add(label);
        legend.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel lower = new JPanel(new BorderLayout());
        panel.add((Component)lower, "South");
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        lower.add((Component)toolbar, "North");
        label = new JLabel(LaunchRes.getString("Saver.Label.Base"));
        label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
        toolbar.add(label);
        this.pathField = new JTextField();
        this.pathField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LaunchSaver.this.setTabSetBasePath(LaunchSaver.this.pathField.getText());
                } else {
                    LaunchSaver.this.pathField.setBackground(Color.yellow);
                }
            }
        });
        this.pathField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                LaunchSaver.this.setTabSetBasePath(LaunchSaver.this.pathField.getText());
            }
        });
        toolbar.add(this.pathField);
        this.chooseButton = new JButton(LaunchRes.getString("Saver.Button.Choose"));
        this.chooseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LaunchSaver.this.chooseTabSet();
            }
        });
        this.inspectButton = new JButton(LaunchRes.getString("MenuItem.Inspect"));
        this.inspectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LaunchSaver.this.inspectSelectedNode();
            }
        });
        JToolBar buttonbar = new JToolBar();
        buttonbar.setFloatable(false);
        buttonbar.add(Box.createHorizontalGlue());
        buttonbar.add(Box.createHorizontalGlue());
        buttonbar.add(Box.createHorizontalGlue());
        JPanel buttons = new JPanel(new GridLayout(1, 4));
        buttonbar.add(buttons);
        buttons.add(this.inspectButton);
        buttons.add(this.chooseButton);
        lower.add((Component)buttonbar, "South");
        JButton saveButton = new JButton(LaunchRes.getString("Saver.Button.Save"));
        buttons.add(saveButton);
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LaunchSaver.this.approved = true;
                ((Component)LaunchSaver.this).setVisible(false);
            }
        });
        JButton cancelButton = new JButton(LaunchRes.getString("Saver.Button.Cancel"));
        buttons.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LaunchSaver.this.revert();
                ((Component)LaunchSaver.this).setVisible(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (!LaunchSaver.this.isApproved()) {
                    LaunchSaver.this.revert();
                }
            }
        });
    }

    private void createTree() {
        TreePath path;
        this.active = false;
        this.treePaths.clear();
        this.prevNodeNames.clear();
        this.prevNodeSelfContains.clear();
        this.prevTabSetName = this.builder.tabSetName;
        this.prevTabSetBasePath = Launcher.tabSetBasePath;
        this.prevTabSetSelfContained = this.builder.selfContained;
        this.root = new Node();
        this.treePaths.add(new TreePath(this.root.getPath()));
        int n = this.builder.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            Node tab = new Node(this.builder.getTab(i).getRootNode());
            if (tab.node.getFileName() != null) {
                this.root.add(tab);
                this.addChildren(tab);
                continue;
            }
            LaunchNode[] nodes = tab.node.getChildOwnedNodes();
            for (int k = 0; k < nodes.length; ++k) {
                Node node = new Node(nodes[k]);
                this.root.add(node);
                this.addChildren(node);
            }
        }
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer(new Renderer());
        this.tree.setCellEditor(this.editor);
        this.tree.setEditable(true);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TreePath path = LaunchSaver.this.tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    LaunchSaver.this.editor.stopCellEditing();
                }
            }
        });
        this.tree.addTreeWillExpandListener(new ExpansionListener());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (LaunchSaver.this.inspector.isVisible()) {
                    LaunchSaver.this.inspectSelectedNode();
                }
            }
        });
        FontRenderContext frc = new FontRenderContext(null, false, false);
        Font font = this.editor.field.getFont();
        Rectangle2D rect = font.getStringBounds("A", frc);
        int h = (int)rect.getHeight();
        this.tree.setRowHeight(h + 3);
        this.tree.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        if (this.treeScroller != null) {
            this.getContentPane().remove(this.treeScroller);
        }
        this.treeScroller = new JScrollPane(this.tree);
        this.getContentPane().add((Component)this.treeScroller, "Center");
        this.setSelectedNode(this.root);
        ListIterator it = ((AbstractList)this.treePaths).listIterator();
        while (it.hasNext()) {
            path = (TreePath)it.next();
            this.tree.expandPath(path);
        }
        while (it.hasPrevious()) {
            path = (TreePath)it.previous();
            Node node = (Node)path.getLastPathComponent();
            if (!this.isFolder(node)) continue;
            this.tree.collapsePath(path);
        }
        this.active = true;
    }

    private void addChildren(Node node) {
        this.prevNodeNames.put(node, node.node.getFileName());
        this.prevNodeSelfContains.put(node, new Boolean(((Node)node).node.selfContained));
        this.treePaths.add(new TreePath(node.getPath()));
        LaunchNode[] nodes = node.node.getChildOwnedNodes();
        for (int k = 0; k < nodes.length; ++k) {
            Node child = new Node(nodes[k]);
            node.add(child);
            this.addChildren(child);
        }
    }

    private boolean isFolder(Node node) {
        if (node == this.root) {
            return this.builder.selfContained;
        }
        return ((Node)node).node.selfContained && !node.isLeaf();
    }

    private void chooseTabSet() {
        String fileName = XML.getResolvedPath(this.builder.tabSetName, Launcher.tabSetBasePath);
        JFileChooser chooser = Launcher.getXMLChooser();
        chooser.setSelectedFile(new File(fileName));
        chooser.setFileFilter(Launcher.xsetFileFilter);
        int result = chooser.showDialog(this, LaunchRes.getString("Saver.FileChooser.Title"));
        if (result == 0) {
            File file = chooser.getSelectedFile();
            fileName = file.getAbsolutePath();
            this.setTabSetName(fileName);
            this.setTabSetBasePath(XML.getDirectoryPath(fileName));
        }
        this.refresh();
    }

    private Icon getIcon(Node node) {
        String path;
        Resource res;
        File file = node == this.root ? ((res = ResourceLoader.getResource(path = XML.getResolvedPath(this.builder.tabSetName, Launcher.tabSetBasePath))) == null ? null : res.getFile()) : node.node.getFile();
        if (file == null) {
            if (this.isFolder(node)) {
                return Launcher.greenFolderIcon;
            }
            return Launcher.greenFileIcon;
        }
        if (file.canWrite()) {
            if (this.isFolder(node)) {
                return Launcher.yellowFolderIcon;
            }
            return Launcher.yellowFileIcon;
        }
        if (this.isFolder(node)) {
            return Launcher.redFolderIcon;
        }
        return Launcher.redFileIcon;
    }

    private class ExpansionListener
    implements TreeWillExpandListener {
        private ExpansionListener() {
        }

        public void treeWillExpand(TreeExpansionEvent e) {
            TreePath path = e.getPath();
            this.set(path, false);
        }

        public void treeWillCollapse(TreeExpansionEvent e) {
            TreePath path = e.getPath();
            this.set(path, true);
        }

        private void set(TreePath path, boolean selfContained) {
            if (LaunchSaver.this.active) {
                Node node = (Node)path.getLastPathComponent();
                if (node == LaunchSaver.this.root) {
                    ((LaunchSaver)LaunchSaver.this).builder.selfContained = selfContained;
                    for (int i = 0; i < ((LaunchSaver)LaunchSaver.this).builder.tabbedPane.getTabCount(); ++i) {
                        LaunchNode root = LaunchSaver.this.builder.getTab(i).getRootNode();
                        root.parentSelfContained = selfContained;
                    }
                } else {
                    node.node.setSelfContained(selfContained);
                }
                if (LaunchSaver.this.inspector.isVisible()) {
                    LaunchSaver.this.inspectSelectedNode();
                }
            }
        }
    }

    private class Editor
    extends AbstractCellEditor
    implements TreeCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        JTextField field = new JTextField();
        JLabel label = new JLabel();

        Editor() {
            this.panel.add((Component)this.label, "West");
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
            this.field.setBorder(BorderFactory.createLineBorder(Color.black));
            this.field.setEditable(true);
            this.field.setColumns(30);
            this.field.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Editor.this.stopCellEditing();
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        Editor.this.stopCellEditing();
                    } else {
                        Editor.this.field.setBackground(Color.yellow);
                    }
                }
            });
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            Node node = (Node)value;
            String name = node != LaunchSaver.this.root ? node.node.getFileName() : ((LaunchSaver)LaunchSaver.this).builder.tabSetName;
            this.field.setText(name);
            this.label.setIcon(LaunchSaver.this.getIcon(node));
            this.label.setText(node.toString());
            if (FontSizer.getLevel() != 0) {
                FontSizer.setFonts(this.panel, FontSizer.getLevel());
            }
            return this.panel;
        }

        public boolean isCellEditable(EventObject e) {
            return e instanceof MouseEvent;
        }

        public Object getCellEditorValue() {
            this.field.setBackground(Color.white);
            Node node = LaunchSaver.this.getSelectedNode();
            String name = this.field.getText();
            String prev = node.node != null ? node.node.getFileName() : ((LaunchSaver)LaunchSaver.this).builder.tabSetName;
            if (LaunchSaver.this.builder.getOpenPaths().contains(name) && !prev.equals(name)) {
                JOptionPane.showMessageDialog(LaunchSaver.this, LaunchRes.getString("Dialog.DuplicateFileName.Message") + " \"" + name + "\"", LaunchRes.getString("Dialog.DuplicateFileName.Title"), 2);
                LaunchSaver.this.refresh();
                return null;
            }
            if (node.node != null) {
                node.node.setFileName(name);
            } else {
                name = LaunchSaver.this.setTabSetName(name);
            }
            return name;
        }
    }

    class Renderer
    implements TreeCellRenderer {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel();
        JTextField field = new JTextField();

        public Renderer() {
            this.panel.add((Component)this.label, "West");
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.field.setBorder(null);
            this.field.setBackground(this.field.getSelectionColor());
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Node node = (Node)value;
            String name = node != LaunchSaver.this.root ? node.node.getFileName() : ((LaunchSaver)LaunchSaver.this).builder.tabSetName;
            this.field.setText(name);
            this.label.setIcon(LaunchSaver.this.getIcon(node));
            this.label.setText(node.toString());
            if (FontSizer.getLevel() != 0) {
                FontSizer.setFonts(this.panel, FontSizer.getLevel());
            }
            this.field.setOpaque(selected);
            return this.panel;
        }
    }

    private class Node
    extends DefaultMutableTreeNode {
        private LaunchNode node;

        Node() {
        }

        Node(LaunchNode node) {
            this.node = node;
        }

        public String toString() {
            if (this.node == null) {
                return LaunchRes.getString("Saver.Tree.TabSet") + ":";
            }
            if (this.node.isRoot()) {
                return LaunchRes.getString("Saver.Tree.Tab") + " \"" + this.node.name + "\":";
            }
            return LaunchRes.getString("Saver.Tree.Node") + " \"" + this.node.name + "\":";
        }
    }
}

