/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.controls.MessageFrame;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.OSPParameters;
import org.opensourcephysics.controls.Password;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.tools.Diagnostics;
import org.opensourcephysics.tools.EncryptionTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchBuilder;
import org.opensourcephysics.tools.LaunchClassChooser;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchPanel;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.TranslatorTool;

public class Launcher {
    protected static String defaultFileName = "launcher_default";
    protected static String resourcesPath = "/org/opensourcephysics/resources/tools/";
    protected static String classPath;
    protected static String tabSetBasePath;
    protected static String version;
    protected static String releaseDate;
    protected static JFileChooser chooser;
    protected static FileFilter xmlFileFilter;
    protected static FileFilter xsetFileFilter;
    protected static FileFilter launcherFileFilter;
    protected static int wInit;
    protected static int hInit;
    protected static JDialog splashDialog;
    protected static JLabel splashTitleLabel;
    protected static JLabel splashPathLabel;
    protected static Timer splashTimer;
    protected static boolean isWebStart;
    protected static float baseMenuFontSize;
    protected static Icon launchIcon;
    protected static Icon launchedIcon;
    protected static Icon singletonIcon;
    protected static Icon whiteFolderIcon;
    protected static Icon redFileIcon;
    protected static Icon greenFileIcon;
    protected static Icon magentaFileIcon;
    protected static Icon yellowFileIcon;
    protected static Icon whiteFileIcon;
    protected static Icon noFileIcon;
    protected static Icon ghostFileIcon;
    protected static Icon redFolderIcon;
    protected static Icon greenFolderIcon;
    protected static Icon yellowFolderIcon;
    protected static Icon linkIcon;
    protected static Icon htmlIcon;
    protected static Icon launchEmptyIcon;
    public static boolean singleAppMode;
    public static boolean singletonMode;
    private static boolean newVMAllowed;
    protected static Timer frameFinder;
    protected static ArrayList existingFrames;
    public static LaunchNode activeNode;
    protected JDialog inspector;
    protected int divider = 160;
    public JFrame frame;
    protected JPanel contentPane;
    protected JTabbedPane tabbedPane;
    protected JMenuItem singleAppItem;
    protected LaunchNode selectedNode;
    protected LaunchNode previousNode;
    protected String tabSetName;
    protected JEditorPane textPane;
    protected JScrollPane textScroller;
    protected boolean showText = true;
    protected JMenu fileMenu;
    protected JMenu displayMenu;
    protected JMenu helpMenu;
    protected JMenuItem openItem;
    protected JMenu openFromJarMenu;
    protected JMenuItem closeTabItem;
    protected JMenuItem closeAllItem;
    protected JMenuItem editItem;
    protected JMenuItem exitItem;
    protected JMenuItem inspectItem;
    protected JMenuItem hideItem;
    protected JMenuItem backItem;
    protected JMenu languageMenu;
    protected JMenuItem sizeUpItem;
    protected JMenuItem sizeDownItem;
    protected JMenuItem lookFeelItem;
    protected JMenuItem logItem;
    protected JMenuItem aboutItem;
    protected JMenu diagnosticMenu;
    protected JMenuItem[] languageItems;
    protected LaunchClassChooser classChooser;
    protected JPopupMenu popup = new JPopupMenu();
    protected Set openPaths = new HashSet();
    protected Launcher spawner;
    protected boolean previewing = false;
    protected boolean editorEnabled = true;
    protected Set changedFiles = new HashSet();
    protected MouseListener tabListener;
    protected boolean newNodeSelected = false;
    protected boolean selfContained = false;
    protected String jarBasePath = null;
    protected String title;
    protected ArrayList tabs = new ArrayList();
    protected UndoManager undoManager;
    protected UndoableEditSupport undoSupport;
    protected String password;
    protected boolean pwRequiredToLoad;
    protected LinkEdit undoEdit;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$opensourcephysics$tools$LaunchNode;
    static /* synthetic */ Class class$org$opensourcephysics$tools$Launcher;
    static /* synthetic */ Class class$org$opensourcephysics$tools$Launcher$LaunchSet;

    public Launcher() {
        this(true);
    }

    public Launcher(boolean splash) {
        this.createGUI(splash);
        XML.setLoader(class$org$opensourcephysics$tools$Launcher$LaunchSet == null ? (class$org$opensourcephysics$tools$Launcher$LaunchSet = Launcher.class$("org.opensourcephysics.tools.Launcher$LaunchSet")) : class$org$opensourcephysics$tools$Launcher$LaunchSet, new LaunchSet());
        if (OSPFrame.applet == null) {
            Runnable launchRunner = new Runnable(){

                public void run() {
                    try {
                        Process proc = Runtime.getRuntime().exec("java");
                        newVMAllowed = true;
                        proc.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            try {
                Thread thread = new Thread(launchRunner);
                thread.start();
                thread.join(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (FontSizer.getLevel() != 0) {
            this.setFontLevel(FontSizer.getLevel());
        } else {
            this.refreshStringResources();
            this.refreshGUI();
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.frame.getBounds().width) / 2;
        int y = (dim.height - this.frame.getBounds().height) / 2;
        ((Component)this.frame).setLocation(x, y);
    }

    public Launcher(String fileName) {
        this(fileName, fileName == null || !fileName.startsWith("<?xml"));
    }

    public Launcher(String fileName, boolean splash) {
        this.createGUI(splash);
        XML.setLoader(class$org$opensourcephysics$tools$Launcher$LaunchSet == null ? (class$org$opensourcephysics$tools$Launcher$LaunchSet = Launcher.class$("org.opensourcephysics.tools.Launcher$LaunchSet")) : class$org$opensourcephysics$tools$Launcher$LaunchSet, new LaunchSet());
        String path = null;
        if (fileName == null) {
            if (ResourceLoader.launchJarName != null) {
                fileName = XML.stripExtension(ResourceLoader.launchJarName) + ".xset";
                path = this.open(fileName);
            }
            if (path == null) {
                fileName = defaultFileName + ".xset";
                path = this.open(fileName);
            }
            if (path == null) {
                fileName = defaultFileName + ".xml";
                path = this.open(fileName);
            }
        } else {
            path = this.open(fileName);
        }
        if (FontSizer.getLevel() != 0) {
            this.setFontLevel(FontSizer.getLevel());
        } else {
            this.refreshStringResources();
            this.refreshGUI();
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.frame.getBounds().width) / 2;
        int y = (dim.height - this.frame.getBounds().height) / 2;
        ((Component)this.frame).setLocation(x, y);
    }

    public Dimension getSize() {
        return this.contentPane.getSize();
    }

    public void setSize(Dimension dim) {
        this.contentPane.setPreferredSize(dim);
        this.frame.pack();
    }

    public void setSize(int width, int height) {
        this.contentPane.setPreferredSize(new Dimension(width, height));
        this.frame.pack();
    }

    public int getDivider() {
        return this.divider;
    }

    public void setDivider(int loc) {
        this.divider = loc;
        this.refreshGUI();
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }

    public void setVisible(boolean visible) {
        ((Component)this.frame).setVisible(visible);
    }

    public LaunchPanel getSelectedTab() {
        return (LaunchPanel)this.tabbedPane.getSelectedComponent();
    }

    public LaunchPanel setSelectedTab(String path) {
        if (path == null) {
            return null;
        }
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            LaunchPanel tab = this.getTab(i);
            if (!path.startsWith(tab.getRootNode().name)) continue;
            this.tabbedPane.setSelectedComponent(tab);
            return tab;
        }
        return null;
    }

    public LaunchNode getSelectedNode() {
        this.selectedNode = this.getSelectedTab() == null ? null : this.getSelectedTab().getSelectedNode();
        return this.selectedNode;
    }

    public LaunchNode setSelectedNode(String path) {
        if (path == null) {
            return null;
        }
        path = XML.forwardSlash(path);
        this.setSelectedTab(path);
        LaunchPanel tab = this.getSelectedTab();
        if (tab == null) {
            return null;
        }
        Enumeration<TreeNode> e = tab.getRootNode().breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            LaunchNode node = (LaunchNode)e.nextElement();
            if (!path.equals(node.getPathString())) continue;
            tab.setSelectedNode(node);
            return node;
        }
        return null;
    }

    public LaunchNode getRootNode() {
        if (this.getSelectedTab() == null) {
            return null;
        }
        return this.getSelectedTab().getRootNode();
    }

    public LaunchPanel getTab(int i) {
        if (i >= this.tabbedPane.getTabCount()) {
            return null;
        }
        return (LaunchPanel)this.tabbedPane.getComponentAt(i);
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public String open(String[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        String path = this.open(args[0]);
        if (args.length > 1 && args[1] != null) {
            this.setSelectedNode(args[1]);
        }
        return path;
    }

    public String open(String name) {
        Class type;
        if (name == null || name.equals("")) {
            return null;
        }
        ResourceLoader.addSearchPath(resourcesPath);
        ResourceLoader.addSearchPath(tabSetBasePath);
        String path = name;
        String absolutePath = "";
        XMLControlElement control = new XMLControlElement();
        if (name.startsWith("<?xml")) {
            control.readXML(name);
            if (control.failedToRead()) {
                return null;
            }
        }
        if (control.getObjectClassName().equals((class$java$lang$Object == null ? (class$java$lang$Object = Launcher.class$("java.lang.Object")) : class$java$lang$Object).getName())) {
            absolutePath = control.read(path);
        }
        if (control.failedToRead()) {
            String jar = XML.stripExtension(ResourceLoader.launchJarName);
            if (!name.startsWith(defaultFileName) && jar != null && !name.startsWith(jar)) {
                OSPLog.info(LaunchRes.getString("Log.Message.InvalidXML") + " " + name);
                JOptionPane.showMessageDialog(null, LaunchRes.getString("Dialog.InvalidXML.Message") + " \"" + name + "\"", LaunchRes.getString("Dialog.InvalidXML.Title"), 2);
            }
            return null;
        }
        OSPLog.fine(name);
        String returnPath = XML.forwardSlash(absolutePath);
        this.jarBasePath = null;
        String jarName = LaunchRes.getString("Splash.Label.Internal");
        int zip = Math.max(returnPath.indexOf("jar!"), returnPath.indexOf("zip!"));
        if (zip > -1) {
            jarName = XML.getName(returnPath.substring(0, zip + 3));
            String s = XML.getDirectoryPath(returnPath.substring(0, zip + 3));
            this.jarBasePath = s.equals("") ? XML.forwardSlash(System.getProperty("user.dir", "")) : s;
            returnPath = returnPath.substring(zip + 5);
        }
        String prevPassword = this.password;
        if (control.getPassword() != null) {
            boolean pwRequired = control.getBoolean("pw_required_by_launcher");
            if (this instanceof LaunchBuilder || pwRequired) {
                if (Password.verify(control.getPassword(), returnPath)) {
                    this.password = control.getPassword();
                } else {
                    if (this.undoEdit != null) {
                        this.undoSupport.postEdit(new LinkEdit(this.undoEdit));
                        this.undoEdit = null;
                    }
                    return null;
                }
            }
        }
        if ((class$org$opensourcephysics$tools$Launcher$LaunchSet == null ? (class$org$opensourcephysics$tools$Launcher$LaunchSet = Launcher.class$("org.opensourcephysics.tools.Launcher$LaunchSet")) : class$org$opensourcephysics$tools$Launcher$LaunchSet).equals(type = control.getObjectClass())) {
            if (!returnPath.equals("") && splashDialog != null && splashDialog.isVisible()) {
                Resource res = ResourceLoader.getResource(path);
                String loading = LaunchRes.getString("Log.Message.Loading") + ": ";
                boolean bl = isWebStart = res.getAbsolutePath().indexOf("javaws") > -1;
                if (res.getFile() != null) {
                    OSPLog.info(loading + res.getAbsolutePath());
                    splashDialog.getContentPane().setBackground(new Color(228, 228, 255));
                    splashPathLabel.setIcon(magentaFileIcon);
                    splashPathLabel.setText(loading + name);
                } else {
                    boolean internal;
                    loading = LaunchRes.getString("Log.Message.LoadingFrom") + " " + jarName + ": " + name;
                    boolean bl2 = internal = jarName.equals(LaunchRes.getString("Splash.Label.Internal")) || jarName.equals(ResourceLoader.launchJarName);
                    if (internal) {
                        splashDialog.getContentPane().setBackground(new Color(255, 255, 204));
                        splashPathLabel.setIcon(greenFileIcon);
                    } else {
                        splashDialog.getContentPane().setBackground(new Color(228, 228, 255));
                        splashPathLabel.setIcon(magentaFileIcon);
                    }
                    splashPathLabel.setText(loading);
                    loading = LaunchRes.getString("Log.Message.Loading") + ": ";
                    OSPLog.info(loading + res.getAbsolutePath());
                }
            }
            if (!this.removeAllTabs()) {
                this.password = prevPassword;
                if (this.undoEdit != null) {
                    this.undoSupport.postEdit(new LinkEdit(this.undoEdit));
                    this.undoEdit = null;
                }
                return null;
            }
            this.tabSetName = XML.getName(returnPath);
            if (!returnPath.equals("")) {
                tabSetBasePath = this.jarBasePath != null ? "" : XML.getDirectoryPath(returnPath);
            }
            OSPLog.finest(LaunchRes.getString("Log.Message.Loading") + ": " + returnPath);
            LaunchSet tabset = new LaunchSet(this, this.tabSetName);
            control.loadObject(tabset);
            if (tabset.failedToLoad) {
                if (this.tabSetName.equals(XML.getName(returnPath))) {
                    this.tabSetName = null;
                }
                returnPath = null;
            }
            this.changedFiles.clear();
            OSPLog.fine("returning " + returnPath);
            this.undoEdit = null;
            return returnPath;
        }
        if ((class$org$opensourcephysics$tools$LaunchNode == null ? (class$org$opensourcephysics$tools$LaunchNode = Launcher.class$("org.opensourcephysics.tools.LaunchNode")) : class$org$opensourcephysics$tools$LaunchNode).equals(type)) {
            OSPLog.finest(LaunchRes.getString("Log.Message.Loading") + ": " + path);
            LaunchNode node = new LaunchNode(LaunchRes.getString("NewNode.Name"));
            node.setFileName(XML.getPathRelativeTo(returnPath, tabSetBasePath));
            control.loadObject(node);
            String tabName = Launcher.getDisplayName(returnPath);
            for (int i = 0; i < this.tabbedPane.getComponentCount(); ++i) {
                LaunchNode root;
                if (!this.tabbedPane.getTitleAt(i).equals(tabName) || !(root = ((LaunchPanel)this.tabbedPane.getComponent(i)).getRootNode()).matches(node)) continue;
                this.tabbedPane.setSelectedIndex(i);
                return null;
            }
            if (this.tabSetName == null) {
                this.tabSetName = LaunchRes.getString("Tabset.Name.New");
                this.title = null;
                tabSetBasePath = XML.getDirectoryPath(returnPath);
                this.editorEnabled = true;
            }
            this.addTab(node);
            Enumeration<TreeNode> e = node.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                LaunchNode next = (LaunchNode)e.nextElement();
                next.setLaunchClass(next.launchClassName);
            }
            return returnPath;
        }
        OSPLog.info(LaunchRes.getString("Log.Message.NotLauncherFile"));
        JOptionPane.showMessageDialog(null, LaunchRes.getString("Dialog.NotLauncherFile.Message") + " \"" + name + "\"", LaunchRes.getString("Dialog.NotLauncherFile.Title"), 2);
        return null;
    }

    protected boolean addTab(LaunchNode root) {
        final LaunchPanel tab = new LaunchPanel(root, this);
        tab.textPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (splashDialog != null) {
                    splashDialog.dispose();
                }
                tab.textPane.removeMouseListener(this);
            }
        });
        this.tabs.add(tab);
        if (root.isHiddenInLauncher() && !(this instanceof LaunchBuilder)) {
            return false;
        }
        tab.tree.setCellRenderer(new LaunchRenderer());
        tab.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                Launcher.this.newNodeSelected = true;
                Launcher.this.refreshGUI();
            }
        });
        tab.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (splashDialog != null) {
                    splashDialog.dispose();
                }
                tab.tree.removeMouseListener(this);
            }
        });
        tab.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Launcher.this.popup.removeAll();
                Launcher.this.handleMousePressed(e, tab);
            }
        });
        this.tabbedPane.addTab(root.toString(), tab);
        this.tabbedPane.setSelectedComponent(tab);
        tab.setSelectedNode(root);
        if (!root.tooltip.equals("")) {
            this.tabbedPane.setToolTipTextAt(this.tabbedPane.getSelectedIndex(), root.tooltip);
        }
        tab.dataPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Launcher.this.divider = tab.splitPane.getDividerLocation();
            }
        });
        return true;
    }

    protected void showButtonView(final LaunchNode node) {
        block7: {
            String type;
            String string = type = LaunchPanel.defaultType == null ? "text" : LaunchPanel.defaultType;
            if (node.url != null) {
                try {
                    if (node.url.getContent() != null) {
                        this.textPane.setPage(node.url);
                    }
                    break block7;
                }
                catch (IOException ex) {
                    OSPLog.finest(LaunchRes.getString("Log.Message.BadURL") + " " + node.url);
                    if (this.showText) {
                        this.textPane.setContentType(type);
                        this.textPane.setText(node.description);
                    }
                    break block7;
                }
            }
            if (this.showText) {
                this.textPane.setContentType(type);
                this.textPane.setText(node.description);
            }
        }
        this.contentPane.removeAll();
        this.contentPane.add((Component)this.textScroller, "Center");
        JPanel box = new JPanel();
        this.contentPane.add((Component)box, "South");
        AbstractAction openAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int i = Integer.parseInt(e.getActionCommand());
                LaunchNode child = (LaunchNode)node.getChildAt(i);
                if (child.getLaunchClass() == null) {
                    if (Launcher.this.tabSetName != null) {
                        LinkEdit edit = new LinkEdit(child.args);
                        if (Launcher.this.open(child.args) != null) {
                            Launcher.this.undoSupport.postEdit(edit);
                            Launcher.this.refreshGUI();
                        }
                    } else if (Launcher.this.open(child.args) != null) {
                        Launcher.this.refreshGUI();
                    }
                } else {
                    child.launch();
                }
            }
        };
        for (int i = 0; i < node.getChildCount(); ++i) {
            LaunchNode child = (LaunchNode)node.getChildAt(i);
            JButton button = new JButton(child.name);
            button.addActionListener(openAction);
            button.setActionCommand(String.valueOf(i));
            button.setToolTipText(child.tooltip);
            box.add(button);
        }
        this.frame.validate();
        this.refreshGUI();
        this.frame.repaint();
    }

    protected void showTabbedPaneView() {
        if (this.contentPane.getComponent(0) == this.tabbedPane) {
            return;
        }
        this.contentPane.removeAll();
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.frame.validate();
        this.refreshGUI();
        this.frame.repaint();
    }

    protected String open() {
        Launcher.getXMLChooser().setFileFilter(launcherFileFilter);
        int result = Launcher.getXMLChooser().showOpenDialog(null);
        if (result == 0) {
            File file = Launcher.getXMLChooser().getSelectedFile();
            String fileName = XML.forwardSlash(file.getAbsolutePath());
            OSPFrame.chooserDir = XML.getDirectoryPath(fileName);
            return this.open(fileName);
        }
        return null;
    }

    protected boolean removeSelectedTab() {
        int i = this.tabbedPane.getSelectedIndex();
        if (i < 0) {
            return false;
        }
        LinkEdit edit = null;
        if (this.tabSetName != null && new File(this.tabSetName).exists()) {
            String[] args = new String[]{" "};
            edit = new LinkEdit(args);
        }
        ((AbstractCollection)this.tabs).remove(this.getTab(i));
        this.tabbedPane.removeTabAt(i);
        this.previousNode = this.selectedNode;
        this.newNodeSelected = true;
        if (this.tabbedPane.getTabCount() == 0) {
            this.tabSetName = null;
            this.title = null;
            if (edit != null) {
                this.undoSupport.postEdit(edit);
            }
        }
        this.refreshGUI();
        return true;
    }

    protected boolean removeAllTabs() {
        int i;
        int n = this.tabbedPane.getTabCount();
        if (n == 0) {
            return true;
        }
        for (i = n - 1; i >= 0; --i) {
            this.tabbedPane.removeTabAt(i);
        }
        if (this.tabbedPane.getTabCount() == 0) {
            this.tabSetName = null;
            this.title = null;
            this.password = null;
        } else {
            this.previousNode = this.selectedNode;
            this.newNodeSelected = true;
        }
        this.refreshGUI();
        this.tabs.clear();
        for (i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            this.tabs.add(this.tabbedPane.getComponentAt(i));
        }
        return this.tabbedPane.getTabCount() == 0;
    }

    protected void refreshStringResources() {
        this.fileMenu.setText(LaunchRes.getString("Menu.File"));
        this.displayMenu.setText(LaunchRes.getString("Menu.Display"));
        this.openItem.setText(LaunchRes.getString("Menu.File.Open"));
        this.closeTabItem.setText(LaunchRes.getString("Menu.File.CloseTab"));
        this.closeAllItem.setText(LaunchRes.getString("Menu.File.CloseAll"));
        this.editItem.setText(LaunchRes.getString("Menu.File.Edit"));
        this.backItem.setText(LaunchRes.getString("Menu.File.Back"));
        this.helpMenu.setText(LaunchRes.getString("Menu.Help"));
        this.logItem.setText(LaunchRes.getString("Menu.Help.MessageLog"));
        this.inspectItem.setText(LaunchRes.getString("Menu.Help.Inspect"));
        this.aboutItem.setText(LaunchRes.getString("Menu.Help.About"));
        this.diagnosticMenu.setText(LaunchRes.getString("Menu.Help.Diagnostics"));
        if (this.exitItem != null) {
            this.exitItem.setText(LaunchRes.getString("Menu.File.Exit"));
        }
        this.languageMenu.setText(LaunchRes.getString("Menu.Display.Language"));
        this.sizeUpItem.setText(LaunchRes.getString("Menu.Display.IncreaseFontSize"));
        this.sizeDownItem.setText(LaunchRes.getString("Menu.Display.DecreaseFontSize"));
        this.lookFeelItem.setText(LaunchRes.getString("Menu.Display.LookAndFeel"));
        if (this.openFromJarMenu != null) {
            this.openFromJarMenu.setText(LaunchRes.getString("Menu.File.OpenFromJar"));
        }
        Locale[] locales = OSPFrame.getDefaultLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].getLanguage().equals(LaunchRes.locale.getLanguage())) continue;
            this.languageItems[i].setSelected(true);
        }
    }

    protected void refreshGUI() {
        String name = this.title == null ? this.tabSetName : this.title;
        name = name == null ? LaunchRes.getString("Frame.Title") : LaunchRes.getString("Frame.Title") + ": " + name;
        LaunchPanel tab = this.getSelectedTab();
        if (tab != null) {
            this.getSelectedTab().splitPane.setDividerLocation(this.divider);
        }
        this.fileMenu.removeAll();
        if (this.undoManager.canUndo()) {
            this.fileMenu.add(this.backItem);
            this.fileMenu.addSeparator();
        }
        if (!(OSPFrame.applet != null || tab != null && tab.getRootNode().isButtonView())) {
            this.fileMenu.add(this.openItem);
        }
        if (this.openFromJarMenu != null) {
            this.fileMenu.add(this.openFromJarMenu);
        }
        if (OSPFrame.applet != null) {
            this.fileMenu.add(this.hideItem);
            return;
        }
        if (tab != null) {
            if (this.fileMenu.getItemCount() > 0) {
                this.fileMenu.addSeparator();
            }
            boolean showCloseTab = true;
            if (this.getClass() == (class$org$opensourcephysics$tools$Launcher == null ? (class$org$opensourcephysics$tools$Launcher = Launcher.class$("org.opensourcephysics.tools.Launcher")) : class$org$opensourcephysics$tools$Launcher)) {
                if (tab.getRootNode().isButtonView()) {
                    showCloseTab = false;
                    name = LaunchRes.getString("Frame.Title") + ": " + tab.getRootNode().name;
                } else if (this.tabbedPane.getTabCount() == 1) {
                    showCloseTab = false;
                }
            }
            if (showCloseTab) {
                this.fileMenu.add(this.closeTabItem);
                this.closeAllItem.setText(LaunchRes.getString("Menu.File.CloseAll"));
            } else {
                this.closeAllItem.setText(LaunchRes.getString("MenuItem.Close"));
            }
            this.fileMenu.add(this.closeAllItem);
        }
        if (this.editorEnabled) {
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.editItem);
        }
        this.fileMenu.addSeparator();
        if (this.exitItem != null) {
            this.fileMenu.add(this.exitItem);
        }
        this.inspectItem.setEnabled(this.password == null || this instanceof LaunchBuilder);
        this.sizeDownItem.setEnabled((float)this.fileMenu.getFont().getSize() > baseMenuFontSize);
        this.frame.setTitle(name);
    }

    private void appletGUI() {
        this.hideItem = new JMenuItem(LaunchRes.getString("Menu.File.Hide"));
        this.hideItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Launcher.this.exit();
            }
        });
    }

    protected void createGUI(boolean splash) {
        this.appletGUI();
        Frame[] frames = Frame.getFrames();
        int n = frames.length;
        for (int i = 0; i < n; ++i) {
            existingFrames.add(frames[i]);
        }
        OSPLog.getOSPLog();
        TranslatorTool.getTool();
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        this.frame = new LauncherFrame();
        existingFrames.add(this.frame);
        if (splash && OSPFrame.applet == null) {
            this.splash();
        }
        this.inspector = new JDialog((Frame)this.frame, false);
        ((Component)this.inspector).setSize(new Dimension(600, 300));
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.inspector.getBounds().width) / 2;
        int y = (dim.height - this.inspector.getBounds().height) / 2;
        ((Component)this.inspector).setLocation(x, y);
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setPreferredSize(new Dimension(wInit, hInit));
        this.frame.setContentPane(this.contentPane);
        this.frame.setDefaultCloseOperation(1);
        String imageFile = "/org/opensourcephysics/resources/tools/images/launch.gif";
        launchIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/launched.gif";
        launchedIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/singleton.gif";
        singletonIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/nofile.gif";
        noFileIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/greenfile.gif";
        greenFileIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/magentafile.gif";
        magentaFileIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/link.gif";
        linkIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/html.gif";
        htmlIcon = ResourceLoader.getIcon(imageFile);
        imageFile = "/org/opensourcephysics/resources/tools/images/launchempty.gif";
        launchEmptyIcon = ResourceLoader.getIcon(imageFile);
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Launcher.this.textPane.setPage(e.getURL());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.textScroller = new JScrollPane(this.textPane);
        this.tabbedPane = new JTabbedPane(3);
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LaunchNode root = Launcher.this.getRootNode();
                if (root != null && root.isButtonView() && Launcher.this.getClass() == (class$org$opensourcephysics$tools$Launcher == null ? (class$org$opensourcephysics$tools$Launcher = Launcher.class$("org.opensourcephysics.tools.Launcher")) : class$org$opensourcephysics$tools$Launcher)) {
                    Launcher.this.showButtonView(root);
                } else {
                    Launcher.this.showTabbedPaneView();
                }
                Launcher.this.previousNode = Launcher.this.selectedNode;
                Launcher.this.newNodeSelected = true;
                Launcher.this.refreshGUI();
            }
        });
        this.tabListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (Launcher.this.contentPane.getTopLevelAncestor() != Launcher.this.frame) {
                    return;
                }
                if (e.isPopupTrigger() || e.getButton() == 3 || e.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem item = new JMenuItem(LaunchRes.getString("MenuItem.Close"));
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Launcher.this.removeSelectedTab();
                        }
                    });
                    popup.add(item);
                    popup.show(Launcher.this.tabbedPane, e.getX(), e.getY() + 8);
                }
            }
        };
        this.tabbedPane.addMouseListener(this.tabListener);
        JMenuBar menubar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.fileMenu.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (splashDialog != null) {
                    splashDialog.dispose();
                }
                Launcher.this.fileMenu.removeMouseListener(this);
            }
        });
        menubar.add(this.fileMenu);
        this.openItem = new JMenuItem();
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, mask));
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String[] args = new String[]{" "};
                if (Launcher.this.tabSetName != null && new File(Launcher.this.tabSetName).exists()) {
                    LinkEdit edit = new LinkEdit(args);
                    String fileName = Launcher.this.open();
                    if (fileName != null) {
                        edit.args[0] = fileName;
                        Launcher.this.undoSupport.postEdit(edit);
                        Launcher.this.refreshGUI();
                    }
                } else {
                    Launcher.this.open();
                    Launcher.this.refreshGUI();
                }
            }
        });
        this.closeTabItem = new JMenuItem();
        this.closeTabItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Launcher.this.removeSelectedTab();
            }
        });
        this.closeAllItem = new JMenuItem();
        this.closeAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LinkEdit edit = null;
                if (Launcher.this.tabSetName != null && new File(Launcher.this.tabSetName).exists()) {
                    String[] args = new String[]{" "};
                    edit = new LinkEdit(args);
                }
                if (Launcher.this.removeAllTabs() && edit != null) {
                    Launcher.this.undoSupport.postEdit(edit);
                }
                Launcher.this.refreshGUI();
            }
        });
        this.editItem = new JMenuItem();
        this.editItem.setAccelerator(KeyStroke.getKeyStroke(69, mask));
        this.editItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Launcher.this.password != null && !Launcher.this.pwRequiredToLoad && !Password.verify(Launcher.this.password, Launcher.this.tabSetName)) {
                    return;
                }
                if (Launcher.this.previewing) {
                    LaunchNode node;
                    Launcher.this.previewing = false;
                    if (Launcher.this.spawner != null && (node = Launcher.this.getSelectedNode()) != null) {
                        Launcher.this.spawner.setSelectedNode(node.getPathString());
                    }
                    Launcher.this.exit();
                } else {
                    LaunchBuilder builder;
                    if (Launcher.this.tabSetName == null) {
                        builder = new LaunchBuilder(false);
                        builder.newItem.doClick();
                    } else {
                        LaunchSet tabset = new LaunchSet(Launcher.this, Launcher.this.tabSetName);
                        XMLControlElement control = new XMLControlElement(tabset);
                        control.setPassword(null);
                        builder = new LaunchBuilder(control.toXML());
                        LaunchNode node = Launcher.this.getSelectedNode();
                        if (node != null) {
                            builder.setSelectedNode(node.getPathString());
                        }
                        builder.tabSetName = Launcher.this.tabSetName;
                        builder.password = Launcher.this.password;
                    }
                    builder.spawner = Launcher.this;
                    builder.jarBasePath = Launcher.this.jarBasePath;
                    Point p = Launcher.this.frame.getLocation();
                    ((Component)builder.frame).setLocation(p.x + 24, p.y + 24);
                    ((Component)builder.frame).setVisible(true);
                    builder.frame.setDefaultCloseOperation(0);
                }
            }
        });
        this.backItem = new JMenuItem();
        this.backItem.setAccelerator(KeyStroke.getKeyStroke(37, mask));
        this.backItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Launcher.this.undoManager.undo();
            }
        });
        this.displayMenu = new JMenu();
        menubar.add(this.displayMenu);
        LaunchRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                Launcher.this.refreshStringResources();
                Launcher.this.refreshGUI();
            }
        });
        this.languageMenu = new JMenu();
        final Locale[] locales = OSPFrame.getDefaultLocales();
        AbstractAction languageAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String language = e.getActionCommand();
                OSPLog.finest("setting language to " + language);
                for (int i = 0; i < locales.length; ++i) {
                    if (!language.equals(locales[i].getDisplayName())) continue;
                    LaunchRes.setLocale(locales[i]);
                    return;
                }
            }
        };
        ButtonGroup languageGroup = new ButtonGroup();
        this.languageItems = new JMenuItem[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            this.languageItems[i] = new JRadioButtonMenuItem(locales[i].getDisplayName(locales[i]));
            this.languageItems[i].setActionCommand(locales[i].getDisplayName());
            this.languageItems[i].addActionListener(languageAction);
            this.languageMenu.add(this.languageItems[i]);
            languageGroup.add(this.languageItems[i]);
        }
        this.displayMenu.add(this.languageMenu);
        this.displayMenu.addSeparator();
        FontSizer.addPropertyChangeListener("level", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                int level = (Integer)e.getNewValue();
                Launcher.this.setFontLevel(level);
            }
        });
        this.sizeUpItem = new JMenuItem();
        this.sizeUpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontSizer.levelUp();
            }
        });
        this.displayMenu.add(this.sizeUpItem);
        this.sizeDownItem = new JMenuItem();
        this.sizeDownItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontSizer.levelDown();
            }
        });
        this.displayMenu.add(this.sizeDownItem);
        this.displayMenu.addSeparator();
        this.lookFeelItem = new JCheckBoxMenuItem();
        this.lookFeelItem.setSelected(!OSPFrame.DEFAULT_LOOK_AND_FEEL);
        this.lookFeelItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean selected = Launcher.this.lookFeelItem.isSelected();
                Launcher.this.setLookAndFeel(!selected);
            }
        });
        this.displayMenu.add(this.lookFeelItem);
        this.helpMenu = new JMenu();
        this.helpMenu.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (splashDialog != null) {
                    splashDialog.dispose();
                }
                Launcher.this.helpMenu.removeMouseListener(this);
            }
        });
        menubar.add(this.helpMenu);
        this.logItem = new JMenuItem();
        this.logItem.setAccelerator(KeyStroke.getKeyStroke(76, mask));
        this.logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (OSPFrame.applet == null) {
                    OSPLog log = OSPLog.getOSPLog();
                    if (log.getLocation().x == 0 && log.getLocation().y == 0) {
                        Point p = Launcher.this.frame.getLocation();
                        ((Component)log).setLocation(p.x + 28, p.y + 28);
                    }
                }
                OSPLog.showLog();
            }
        });
        this.helpMenu.add(this.logItem);
        this.inspectItem = new JMenuItem();
        this.helpMenu.add(this.inspectItem);
        this.inspectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LaunchSet tabSet = new LaunchSet(Launcher.this, Launcher.this.tabSetName);
                tabSet.showHiddenNodes = Launcher.this instanceof LaunchBuilder;
                XMLControlElement xml = new XMLControlElement(tabSet);
                XMLTreePanel treePanel = new XMLTreePanel(xml, false);
                Launcher.this.inspector.setContentPane(treePanel);
                Launcher.this.inspector.setTitle(LaunchRes.getString("Inspector.Title.TabSet") + " \"" + Launcher.getDisplayName(Launcher.this.tabSetName) + "\"");
                ((Component)Launcher.this.inspector).setVisible(true);
            }
        });
        this.diagnosticMenu = new JMenu();
        this.helpMenu.add(this.diagnosticMenu);
        JMenuItem vmItem = new JMenuItem("Java VM");
        vmItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Diagnostics.aboutJava();
            }
        });
        this.diagnosticMenu.add(vmItem);
        JMenuItem qtItem = new JMenuItem("QuickTime");
        qtItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Diagnostics.aboutQTJava();
            }
        });
        this.diagnosticMenu.add(qtItem);
        JMenuItem j3dItem = new JMenuItem("Java 3D");
        j3dItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Diagnostics.aboutJava3D();
            }
        });
        this.diagnosticMenu.add(j3dItem);
        JMenuItem joglItem = new JMenuItem("JOGL");
        joglItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Diagnostics.aboutJOGL();
            }
        });
        this.diagnosticMenu.add(joglItem);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem();
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Launcher.this.showAboutDialog();
            }
        });
        this.helpMenu.add(this.aboutItem);
        if (OSPFrame.applet == null) {
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    Launcher.this.exit();
                }

                public void windowGainedFocus(WindowEvent e) {
                    OSPFrame.setAuthorMode(false);
                }

                public void windowActivated(WindowEvent e) {
                    OSPFrame.setAuthorMode(false);
                }
            });
            this.fileMenu.addSeparator();
            this.exitItem = new JMenuItem();
            this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, mask));
            this.exitItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Launcher.this.exit();
                }
            });
        }
        if (ResourceLoader.launchJarPath != null) {
            JarFile jar = null;
            try {
                if (OSPFrame.applet == null) {
                    jar = new JarFile(ResourceLoader.launchJarPath);
                } else {
                    URL url = ResourceLoader.launchJarPath.startsWith("http:") ? new URL("jar:" + ResourceLoader.launchJarPath + "!/") : new URL("jar:file:/" + ResourceLoader.launchJarPath + "!/");
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    jar = conn.getJarFile();
                }
            }
            catch (IOException ex) {
                OSPLog.warning(ex.getClass().getName() + ": " + ex.getMessage());
            }
            catch (SecurityException ex) {
                OSPLog.warning(ex.getClass().getName() + ": " + ex.getMessage());
            }
            if (jar != null) {
                AbstractAction action = new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        String fileName = ((JMenuItem)e.getSource()).getText();
                        fileName = ResourceLoader.launchJarName + "!/" + fileName;
                        if (Launcher.this.tabSetName != null) {
                            LinkEdit edit = new LinkEdit(new String[]{fileName});
                            if (Launcher.this.open(fileName) != null) {
                                Launcher.this.undoSupport.postEdit(edit);
                                Launcher.this.refreshGUI();
                            }
                        } else {
                            Launcher.this.open(fileName);
                            Launcher.this.refreshGUI();
                        }
                    }
                };
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".xset") || name.startsWith(resourcesPath.substring(1)) || name.startsWith(defaultFileName)) continue;
                    if (this.openFromJarMenu == null) {
                        this.openFromJarMenu = new JMenu();
                    }
                    JMenuItem item = new JMenuItem(name);
                    item.addActionListener(action);
                    this.openFromJarMenu.add(item);
                }
            }
        }
        baseMenuFontSize = this.fileMenu.getFont().getSize();
        this.frame.setJMenuBar(menubar);
        this.frame.pack();
    }

    protected void setFontLevel(int level) {
        FontSizer.setFonts(this.frame.getJMenuBar(), level);
        FontSizer.setFonts(this.frame.getContentPane(), level);
        this.refreshStringResources();
        LaunchPanel tab = this.getSelectedTab();
        if (tab != null) {
            Enumeration<TreeNode> en = tab.getRootNode().breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                LaunchNode node = (LaunchNode)en.nextElement();
                tab.treeModel.nodeChanged(node);
            }
        }
        this.refreshGUI();
    }

    protected Set getOpenPaths() {
        this.openPaths.clear();
        this.openPaths.add(this.tabSetName);
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            LaunchPanel panel = (LaunchPanel)this.tabbedPane.getComponentAt(i);
            LaunchNode[] nodes = panel.getRootNode().getAllOwnedNodes();
            for (int j = 0; j < nodes.length; ++j) {
                this.openPaths.add(nodes[j].getFileName());
            }
            this.openPaths.add(panel.getRootNode().getFileName());
        }
        return this.openPaths;
    }

    protected void setLookAndFeel(boolean defaultLF) {
        if (OSPFrame.DEFAULT_LOOK_AND_FEEL == defaultLF) {
            return;
        }
        OSPFrame.DEFAULT_LOOK_AND_FEEL = defaultLF;
        JFrame.setDefaultLookAndFeelDecorated(defaultLF);
        JDialog.setDefaultLookAndFeelDecorated(defaultLF);
        this.exitCurrentApps();
        this.frame.dispose();
        LaunchSet tabset = new LaunchSet(this, this.tabSetName);
        XMLControlElement control = new XMLControlElement(tabset);
        control.setPassword(null);
        control.setValue("default_look_and_feel", null);
        Launcher launcher = this instanceof LaunchBuilder ? new LaunchBuilder(control.toXML()) : new Launcher(control.toXML());
        launcher.tabSetName = this.tabSetName;
        launcher.password = this.password;
        launcher.jarBasePath = this.jarBasePath;
        launcher.frame.setDefaultCloseOperation(this.frame.getDefaultCloseOperation());
        launcher.setVisible(true);
    }

    protected void showAboutDialog() {
        String newline = XML.NEW_LINE;
        String aboutString = "Launcher " + version + "   " + releaseDate + newline + "Open Source Physics Project" + newline + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(this.frame, aboutString, LaunchRes.getString("Help.About.Title") + " Launcher", 1);
    }

    protected boolean isLink(LaunchNode node) {
        if (node == null || !node.isLeaf() || node.launchClassName != null && !node.launchClassName.equals("")) {
            return false;
        }
        return !node.args[0].equals("") || node.args.length > 1 && !node.args[1].equals("") || node.args.length > 2 && !node.args[2].equals("");
    }

    protected boolean isLaunchable(LaunchNode node) {
        if (node == null || !node.isLeaf()) {
            return false;
        }
        return Launcher.isLaunchable(node.getLaunchClass());
    }

    protected static boolean isLaunchable(Class type) {
        if (type == null) {
            return false;
        }
        try {
            type.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Launcher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    protected void handleMousePressed(MouseEvent e, final LaunchPanel tab) {
        LaunchNode selectedNode = this.getSelectedNode();
        if (e.isPopupTrigger() || e.getButton() == 3 || e.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1) {
            TreePath path = tab.tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            tab.tree.setSelectionPath(path);
            final LaunchNode node = this.getSelectedNode();
            if (node == null) {
                return;
            }
            JMenuItem inspectItem = new JMenuItem(LaunchRes.getString("MenuItem.Inspect"));
            inspectItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Launcher.this.inspectXML(node);
                }
            });
            inspectItem.setEnabled(this.password == null || this instanceof LaunchBuilder);
            this.popup.add(inspectItem);
            if (node.getLaunchClass() != null) {
                if (node.launchCount == 0) {
                    this.popup.addSeparator();
                    JMenuItem launchItem = new JMenuItem(LaunchRes.getString("MenuItem.Launch"));
                    this.popup.add(launchItem);
                    launchItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            node.launch(tab);
                        }
                    });
                } else {
                    this.popup.addSeparator();
                    JMenuItem terminateItem = new JMenuItem(LaunchRes.getString("MenuItem.Terminate"));
                    this.popup.add(terminateItem);
                    terminateItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            node.terminateAll();
                        }
                    });
                    if (node.launchCount > 1) {
                        terminateItem.setText(LaunchRes.getString("MenuItem.TerminateAll"));
                    }
                    if (!node.isSingleton()) {
                        JMenuItem launchItem = new JMenuItem(LaunchRes.getString("MenuItem.Relaunch"));
                        this.popup.add(launchItem);
                        launchItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                node.launch(tab);
                            }
                        });
                    }
                }
            }
            if (this.getClass().equals(class$org$opensourcephysics$tools$Launcher == null ? (class$org$opensourcephysics$tools$Launcher = Launcher.class$("org.opensourcephysics.tools.Launcher")) : class$org$opensourcephysics$tools$Launcher)) {
                this.popup.show(tab, e.getX() + 4, e.getY() + 12);
            }
        } else if (e.getClickCount() == 2 && this.isLaunchable(selectedNode)) {
            if (selectedNode.launchCount == 0) {
                selectedNode.launch(tab);
            } else if (selectedNode.isSingleton() || selectedNode.isSingleVM() && selectedNode.isSingleApp()) {
                JOptionPane.showMessageDialog(this.frame, LaunchRes.getString("Dialog.Singleton.Message") + " \"" + selectedNode.toString() + "\"", LaunchRes.getString("Dialog.Singleton.Title"), 1);
            } else {
                int selected = JOptionPane.showConfirmDialog(this.frame, LaunchRes.getString("Dialog.Relaunch.Message"), LaunchRes.getString("Dialog.Relaunch.Title"), 0);
                if (selected == 0) {
                    selectedNode.launch(tab);
                }
            }
            if (selectedNode.launchPanel != null) {
                selectedNode.launchPanel.repaint();
            }
        } else if (e.getClickCount() == 2 && this.isLink(selectedNode)) {
            if (this.tabSetName != null) {
                LinkEdit edit = new LinkEdit(selectedNode.args);
                if (this.open(selectedNode.args) != null) {
                    this.undoSupport.postEdit(edit);
                    this.refreshGUI();
                } else {
                    this.open(selectedNode.args);
                    this.refreshGUI();
                }
            }
        } else if (e.getClickCount() == 2 && selectedNode.getLaunchClass() == null && selectedNode.launchClassName != null && !selectedNode.launchClassName.equals("")) {
            String[] jars = LaunchClassChooser.parsePath(selectedNode.getClassPath(), true);
            String jarList = "";
            for (int i = 0; i < jars.length; ++i) {
                if (!jarList.equals("")) {
                    if (jars[i].equals(ResourceLoader.launchJarName)) continue;
                    jarList = jarList + ", ";
                }
                jarList = jarList + jars[i];
            }
            JOptionPane.showMessageDialog(this.frame, LaunchRes.getString("Dialog.ClassNotFound.Message1") + selectedNode.launchClassName + XML.NEW_LINE + LaunchRes.getString("Dialog.ClassNotFound.Message2") + jarList, LaunchRes.getString("Dialog.ClassNotFound.Title"), 2);
        }
    }

    private void exitCurrentApps() {
        Frame[] prevFrames = Frame.getFrames();
        int n = prevFrames.length;
        for (int i = 0; i < n; ++i) {
            if (existingFrames.contains(prevFrames[i]) || prevFrames[i] instanceof LauncherFrame) continue;
            WindowListener[] listeners = prevFrames[i].getWindowListeners();
            for (int j = 0; j < listeners.length; ++j) {
                listeners[j].windowClosing(null);
            }
            if (!prevFrames[i].isVisible()) continue;
            prevFrames[i].dispose();
        }
    }

    private void splash() {
        int w = 360;
        int h = 120;
        if (splashDialog == null) {
            splashDialog = new JDialog((Frame)this.frame, false);
            splashDialog.setUndecorated(true);
            Color darkred = new Color(128, 0, 0);
            JPanel splash = new JPanel(new BorderLayout());
            splash.setBackground(new Color(255, 255, 255));
            splash.setPreferredSize(new Dimension(w, h));
            splash.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    splashDialog.dispose();
                }
            });
            this.frame.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    splashDialog.dispose();
                    Launcher.this.frame.removeMouseListener(this);
                }
            });
            Border etch = BorderFactory.createEtchedBorder();
            splash.setBorder(etch);
            splashDialog.setContentPane(splash);
            Box labels = Box.createVerticalBox();
            JLabel titleLabel = new JLabel("OSP Launcher");
            if (this instanceof LaunchBuilder) {
                titleLabel.setText("OSP Launch Builder");
            }
            Font font = titleLabel.getFont().deriveFont(1);
            titleLabel.setFont(font.deriveFont(20.0f));
            titleLabel.setForeground(darkred);
            titleLabel.setAlignmentX(0.5f);
            titleLabel.setHorizontalAlignment(0);
            JLabel creditsLabel = new JLabel("By Douglas Brown");
            creditsLabel.setFont(font.deriveFont(10.0f));
            creditsLabel.setHorizontalAlignment(0);
            creditsLabel.setAlignmentX(0.5f);
            splashPathLabel = new JLabel(" "){

                public void setText(String s) {
                    int max = 80;
                    if (s != null && s.length() > max) {
                        s = s.substring(0, max - 4) + "...";
                    }
                    super.setText(s);
                }
            };
            font = font.deriveFont(0);
            splashPathLabel.setFont(font.deriveFont(12.0f));
            splashPathLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 10, 2));
            splashPathLabel.setHorizontalAlignment(0);
            labels.add(Box.createGlue());
            labels.add(titleLabel);
            labels.add(creditsLabel);
            labels.add(Box.createGlue());
            splash.add((Component)labels, "Center");
            splash.add((Component)splashPathLabel, "South");
            splashDialog.pack();
            splashTimer = new Timer(4000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (Launcher.this.frame.isShowing()) {
                        splashDialog.dispose();
                        splashTimer.stop();
                    }
                }
            });
        }
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = dim.width / 2;
        int y = dim.height / 2;
        ((Component)splashDialog).setLocation(x - w / 2, y - h / 2);
        ((Component)splashDialog).setVisible(true);
        splashTimer.start();
    }

    protected void exit() {
        if (!this.terminateApps()) {
            final int op = this.frame.getDefaultCloseOperation();
            this.frame.setDefaultCloseOperation(0);
            Runnable runner = new Runnable(){

                public void run() {
                    Launcher.this.frame.setDefaultCloseOperation(op);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        if (OSPFrame.applet == null && this.frame.getDefaultCloseOperation() == 1) {
            System.exit(0);
        } else {
            this.exitCurrentApps();
            ((Component)this.frame).setVisible(false);
        }
    }

    protected boolean terminateApps() {
        if (this.frame.getDefaultCloseOperation() == 1) {
            boolean approved = false;
            Frame[] frames = Frame.getFrames();
            int n = frames.length;
            for (int i = 0; i < n; ++i) {
                if (approved || !frames[i].isVisible() || frames[i] instanceof LauncherFrame || frames[i] instanceof OSPLog || frames[i] instanceof EncryptionTool || existingFrames.contains(frames[i])) continue;
                int selected = JOptionPane.showConfirmDialog(this.frame, LaunchRes.getString("Dialog.Terminate.Message") + XML.NEW_LINE + LaunchRes.getString("Dialog.Terminate.Question"), LaunchRes.getString("Dialog.Terminate.Title"), 0);
                if (selected == 0) {
                    approved = true;
                    continue;
                }
                return false;
            }
            approved = false;
            boolean declined = false;
            Component[] comps = this.tabbedPane.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                LaunchPanel tab = (LaunchPanel)comps[i];
                Enumeration<TreeNode> e = tab.getRootNode().breadthFirstEnumeration();
                while (e.hasMoreElements()) {
                    LaunchNode node = (LaunchNode)e.nextElement();
                    if (node.processes.isEmpty()) continue;
                    if (!approved && !declined) {
                        int selected = JOptionPane.showConfirmDialog(this.frame, LaunchRes.getString("Dialog.TerminateSeparateVM.Message") + XML.NEW_LINE + LaunchRes.getString("Dialog.TerminateSeparateVM.Question"), LaunchRes.getString("Dialog.TerminateSeparateVM.Title"), 0);
                        approved = selected == 0;
                        boolean bl = declined = !approved;
                    }
                    if (approved) {
                        Iterator it = node.processes.iterator();
                        while (it.hasNext()) {
                            Process proc = (Process)it.next();
                            it.remove();
                            proc.destroy();
                        }
                        continue;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    protected Icon getFileIcon(LaunchNode node) {
        if (node.getFileName().length() == 0) {
            return null;
        }
        File file = node.getFile();
        Resource res = node.getResource();
        boolean changed = this.changedFiles.contains(node.getFileName());
        if (changed) {
            return yellowFileIcon;
        }
        if (res == null || node.isParentSelfContained()) {
            return ghostFileIcon;
        }
        if (file != null && file.canWrite()) {
            return whiteFileIcon;
        }
        if (file == null) {
            return magentaFileIcon;
        }
        return redFileIcon;
    }

    public static void launch(Class type) {
        Launcher.launch(type, null, null);
    }

    public static void launch(Class type, String[] args) {
        Launcher.launch(type, args, null);
    }

    public static void launch(final Class type, String[] args, final LaunchNode node) {
        if (type == null) {
            OSPLog.info(LaunchRes.getString("Log.Message.NoClass"));
            JOptionPane.showMessageDialog(null, LaunchRes.getString("Dialog.NoLaunchClass.Message"), LaunchRes.getString("Dialog.NoLaunchClass.Title"), 2);
            return;
        }
        String desc = LaunchRes.getString("Log.Message.Launching") + " " + type + ", args ";
        if (args == null) {
            desc = desc + args;
        } else {
            desc = desc + "{";
            for (int i = 0; i < args.length; ++i) {
                desc = desc + args[i];
                if (i >= args.length - 1) continue;
                desc = desc + ", ";
            }
            desc = desc + "}";
        }
        OSPLog.fine(desc);
        if (OSPParameters.launchingInSingleVM || !newVMAllowed) {
            OSPParameters.launchingInSingleVM = true;
            OSPLog.finer(LaunchRes.getString("Log.Message.LaunchCurrentVM"));
            final Frame[] prevFrames = Frame.getFrames();
            if (singleAppMode) {
                OSPLog.finer(LaunchRes.getString("Log.Message.LaunchSingleApp"));
                boolean vis = OSPLog.isLogVisible();
                int n = prevFrames.length;
                for (int i = 0; i < n; ++i) {
                    if (existingFrames.contains(prevFrames[i]) || prevFrames[i] instanceof LauncherFrame) continue;
                    WindowListener[] listeners = prevFrames[i].getWindowListeners();
                    for (int j = 0; j < listeners.length; ++j) {
                        listeners[j].windowClosing(null);
                    }
                    prevFrames[i].dispose();
                }
                if (vis) {
                    OSPLog.showLog();
                }
            }
            if (node != null) {
                String classPath = node.getClassPath();
                XML.setClassLoader(LaunchClassChooser.getClassLoader(classPath));
            }
            final String[] arg = args;
            final Runnable launchRunner = new Runnable(){

                public void run() {
                    activeNode = node;
                    try {
                        Method m = type.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Launcher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                        m.invoke((Object)type, new Object[]{arg});
                    }
                    catch (NoSuchMethodException ex) {
                    }
                    catch (InvocationTargetException ex) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    node.threads.remove(this);
                    activeNode = null;
                    if (frameFinder != null) {
                        Launcher.findFramesFor(node, prevFrames, this);
                        if (frameFinder != null) {
                            frameFinder.stop();
                            frameFinder = null;
                        }
                    }
                }
            };
            if (frameFinder != null) {
                frameFinder.stop();
            }
            frameFinder = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Launcher.findFramesFor(node, prevFrames, launchRunner);
                }
            });
            Thread launchThread = new Thread(launchRunner);
            launchThread.setDaemon(true);
            node.threads.put(launchRunner, launchThread);
            launchThread.start();
            frameFinder.start();
            return;
        }
        OSPLog.finer(LaunchRes.getString("Log.Message.LaunchSeparateVM"));
        final Vector<String> cmd = new Vector<String>();
        cmd.add("java");
        if (classPath != null && !classPath.equals("")) {
            String jar = Launcher.getDefaultJar();
            if (jar != null && classPath.indexOf(jar) == -1) {
                classPath = classPath + ";" + jar;
            }
            int i = classPath.indexOf(":");
            while (i != -1) {
                classPath = classPath.substring(0, i) + ";" + classPath.substring(i + 1);
                i = classPath.indexOf(":");
            }
            char pathSeparator = System.getProperty("path.separator").charAt(0);
            classPath = classPath.replace(';', pathSeparator);
            cmd.add("-classpath");
            cmd.add(classPath);
        }
        cmd.add(type.getName());
        if (args != null) {
            for (int i = 0; i < args.length && args[i] != null; ++i) {
                cmd.add(args[i]);
            }
        }
        Runnable launchRunner = new Runnable(){

            public void run() {
                block4: {
                    OSPLog.finer(LaunchRes.getString("Log.Message.Command") + " " + cmd.toString());
                    String[] cmdarray = cmd.toArray(new String[0]);
                    try {
                        Process proc = Runtime.getRuntime().exec(cmdarray);
                        if (node != null) {
                            node.processes.add(proc);
                        }
                        proc.waitFor();
                        if (node != null) {
                            node.threadRunning(false);
                            node.processes.remove(proc);
                        }
                    }
                    catch (Exception ex) {
                        OSPLog.info(ex.toString());
                        if (node == null) break block4;
                        node.threadRunning(false);
                    }
                }
            }
        };
        if (node != null) {
            node.threadRunning(true);
        }
        new Thread(launchRunner).start();
    }

    public static void main(String[] args) {
        Launcher launcher = new Launcher();
        if (args != null && args.length > 0) {
            launcher.open(args);
        } else {
            String path = null;
            if (ResourceLoader.launchJarName != null) {
                path = launcher.open(XML.stripExtension(ResourceLoader.launchJarName) + ".xset");
            }
            if (path == null) {
                path = launcher.open(defaultFileName + ".xset");
            }
            if (path == null) {
                path = launcher.open(defaultFileName + ".xml");
            }
        }
        launcher.refreshGUI();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - launcher.frame.getBounds().width) / 2;
        int y = (dim.height - launcher.frame.getBounds().height) / 2;
        ((Component)launcher.frame).setLocation(x, y);
        ((LauncherFrame)launcher.frame).setKeepHidden(false);
        ((Component)launcher.frame).setVisible(true);
    }

    protected LaunchClassChooser getClassChooser() {
        if (this.classChooser == null) {
            this.classChooser = new LaunchClassChooser(this.contentPane);
        }
        return this.classChooser;
    }

    protected static JFileChooser getXMLChooser() {
        if (chooser != null) {
            return chooser;
        }
        chooser = new JFileChooser(new File(OSPFrame.chooserDir));
        launcherFileFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = null;
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i > 0 && i < name.length() - 1) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                return extension != null && (extension.equals("xset") || extension.equals("xml") || extension.equals("zip"));
            }

            public String getDescription() {
                return LaunchRes.getString("FileChooser.LauncherFilter.Description");
            }
        };
        xmlFileFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = null;
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i > 0 && i < name.length() - 1) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                return extension != null && extension.equals("xml");
            }

            public String getDescription() {
                return LaunchRes.getString("FileChooser.XMLFilter.Description");
            }
        };
        xsetFileFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = null;
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i > 0 && i < name.length() - 1) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                return extension != null && extension.equals("xset");
            }

            public String getDescription() {
                return LaunchRes.getString("FileChooser.XSETFilter.Description");
            }
        };
        chooser.addChoosableFileFilter(xmlFileFilter);
        chooser.addChoosableFileFilter(xsetFileFilter);
        chooser.addChoosableFileFilter(launcherFileFilter);
        return chooser;
    }

    protected static String getDisplayName(String fileName) {
        int i = (fileName = XML.getName(fileName)).lastIndexOf(".");
        if (i != -1) {
            return fileName.substring(0, i);
        }
        return fileName;
    }

    protected static String getDefaultJar() {
        URL url = ClassLoader.getSystemResource(defaultFileName + ".xset");
        if (url == null) {
            url = ClassLoader.getSystemResource(defaultFileName + ".xml");
        }
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        int i = path.indexOf("/" + defaultFileName);
        if (i == -1) {
            return null;
        }
        if ((i = (path = path.substring(0, i)).lastIndexOf("!")) == -1) {
            return null;
        }
        return path.substring(path.lastIndexOf("/") + 1, i);
    }

    private void inspectXML(LaunchNode node) {
        XMLControlElement xml = new XMLControlElement(node);
        XMLTreePanel treePanel = new XMLTreePanel(xml, false);
        this.inspector.setContentPane(treePanel);
        this.inspector.setTitle(LaunchRes.getString("Inspector.Title.Node") + " \"" + node.name + "\"");
        ((Component)this.inspector).setVisible(true);
    }

    private static void findFramesFor(LaunchNode node, Frame[] prevFrames, Runnable runner) {
        int i;
        Frame[] frames = Frame.getFrames();
        ArrayList<Frame> newFrames = new ArrayList<Frame>();
        for (i = 0; i < frames.length; ++i) {
            JFrame frame;
            if (frames[i] instanceof JFrame && ((frame = (JFrame)frames[i]).getDefaultCloseOperation() == 0 || frame instanceof MessageFrame || frame instanceof LauncherFrame) || frames[i].getClass().getName().indexOf("SharedOwnerFrame") > -1 || frames[i].getClass().getName().indexOf("QTFrame") > -1) continue;
            newFrames.add(frames[i]);
        }
        for (i = 0; i < prevFrames.length; ++i) {
            newFrames.remove(prevFrames[i]);
        }
        if (newFrames.isEmpty()) {
            return;
        }
        frames = newFrames.toArray(new Frame[0]);
        newFrames.clear();
        FrameCloser frameCloser = new FrameCloser(node, newFrames, runner);
        for (int i2 = 0; i2 < frames.length; ++i2) {
            if (!(frames[i2] instanceof JFrame)) continue;
            JFrame frame = (JFrame)frames[i2];
            if (frame instanceof OSPFrame && ((OSPFrame)frame).wishesToExit() || frame.getDefaultCloseOperation() == 3) {
                if (frame.getDefaultCloseOperation() == 3) {
                    frame.setDefaultCloseOperation(2);
                }
                frame.addWindowListener(frameCloser);
            }
            newFrames.add(frame);
        }
        if (node != null) {
            node.frames.addAll(newFrames);
            ++node.launchCount;
            if (frameFinder != null) {
                frameFinder.stop();
                frameFinder = null;
            }
        }
        if (node.launchPanel != null) {
            node.launchPanel.repaint();
        }
    }

    static {
        tabSetBasePath = "";
        version = "1.3";
        releaseDate = "September 2006";
        wInit = 480;
        hInit = 400;
        isWebStart = false;
        singleAppMode = false;
        singletonMode = false;
        newVMAllowed = false;
        existingFrames = new ArrayList();
        OSPFrame.setAuthorMode(false);
        OSPFrame.setLauncherMode(true);
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class FrameCloser
    extends WindowAdapter {
        LaunchNode node;
        Collection frames;
        Runnable runner;

        FrameCloser(LaunchNode node, Collection newFrames, Runnable runner) {
            this.frames = newFrames;
            this.node = node;
            this.runner = runner;
        }

        public void windowClosing(WindowEvent e) {
            Iterator it = this.frames.iterator();
            while (it.hasNext()) {
                Frame frame = (Frame)it.next();
                frame.removeWindowListener(this);
                frame.dispose();
            }
            if (this.node != null) {
                Thread thread = (Thread)this.node.threads.get(this.runner);
                if (thread != null) {
                    thread.interrupt();
                    this.node.threads.put(this.runner, null);
                }
                this.node.frames.removeAll(this.frames);
                this.node.launchCount = Math.max(0, --this.node.launchCount);
                if (this.node.launchPanel != null) {
                    this.node.launchPanel.repaint();
                }
            }
        }
    }

    protected class LinkEdit
    extends AbstractUndoableEdit {
        String[] args = new String[2];
        String[] prev = new String[2];

        public LinkEdit(String[] arguments) {
            this.args[0] = arguments[0];
            this.args[1] = arguments.length < 2 ? "" : arguments[1];
            String fileName = Launcher.this.tabSetName;
            if (!fileName.startsWith(defaultFileName) && tabSetBasePath.equals("")) {
                fileName = ResourceLoader.launchJarName + "!/" + fileName;
            }
            String string = this.prev[0] = this.args[0].equals("") ? "" : fileName;
            this.prev[1] = Launcher.this.getSelectedNode() != null ? Launcher.this.getSelectedNode().getPathString() : (Launcher.this.getSelectedTab() == null ? "" : Launcher.this.getSelectedTab().getRootNode().name);
        }

        public LinkEdit(LinkEdit edit) {
            this.args = edit.args;
            this.prev = edit.prev;
        }

        public void undo() throws CannotUndoException {
            Launcher.this.undoEdit = this;
            Launcher.this.open(this.prev);
            Launcher.this.refreshGUI();
        }

        public void redo() throws CannotUndoException {
            Launcher.this.open(this.args);
            Launcher.this.refreshGUI();
        }

        public String getPresentationName() {
            return "Link";
        }
    }

    public class LaunchSet
    implements XML.ObjectLoader {
        private Launcher launcher;
        private String name;
        boolean failedToLoad = false;
        public boolean showHiddenNodes = true;

        public LaunchSet() {
            this.launcher = Launcher.this;
        }

        protected LaunchSet(Launcher launcher2, String path) {
            this.launcher = launcher2;
            this.name = XML.getName(XML.forwardSlash(path));
        }

        public void saveObject(XMLControl control, Object obj) {
            boolean hasPW;
            LaunchSet tabset = (LaunchSet)obj;
            Launcher launcher = tabset.launcher;
            control.setValue("classpath", classPath);
            control.setValue("title", launcher.title);
            Dimension dim = launcher.contentPane.getSize();
            control.setValue("width", dim.width);
            control.setValue("height", dim.height);
            control.setValue("divider", launcher.divider);
            control.setValue("default_look_and_feel", OSPFrame.DEFAULT_LOOK_AND_FEEL);
            ArrayList<Object> nodes = new ArrayList<Object>();
            for (int i = 0; i < launcher.tabs.size(); ++i) {
                LaunchNode root = ((LaunchPanel)launcher.tabs.get(i)).getRootNode();
                if (root.isHiddenInLauncher() && !tabset.showHiddenNodes) continue;
                root.parentSelfContained = false;
                root.previewing = false;
                root.saveHiddenNodes = tabset.showHiddenNodes;
                if (launcher.selfContained) {
                    root.setSelfContained(false);
                    root.parentSelfContained = true;
                    nodes.add(root);
                    continue;
                }
                if (launcher.previewing) {
                    root.previewing = true;
                    nodes.add(root);
                    continue;
                }
                if (root.getFileName() == null || root.getFileName().equals("")) {
                    nodes.add(root);
                    continue;
                }
                nodes.add(root.getFileName());
            }
            control.setValue("launch_nodes", nodes);
            if (launcher.editorEnabled) {
                control.setValue("editor_enabled", true);
            }
            boolean bl = hasPW = launcher.password != null && !launcher.password.equals("");
            if (hasPW && Launcher.this.pwRequiredToLoad) {
                control.setValue("pw_required_by_launcher", true);
            }
            control.setValue("xml_password", launcher.password);
        }

        public Object createObject(XMLControl control) {
            return null;
        }

        public Object loadObject(XMLControl control, Object obj) {
            LaunchSet tabset = (LaunchSet)obj;
            final Launcher launcher = tabset.launcher;
            if (control.getPropertyNames().contains("launchset")) {
                String path = launcher.open(control.getString("launchset"));
                tabset.failedToLoad = path == null;
                return obj;
            }
            if (control.getPropertyNames().contains("classpath")) {
                classPath = control.getString("classpath");
            }
            if (control.getPropertyNames().contains("default_look_and_feel")) {
                final boolean selected = control.getBoolean("default_look_and_feel");
                Runnable runner = new Runnable(){

                    public void run() {
                        while (!launcher.isVisible()) {
                        }
                        launcher.setLookAndFeel(selected);
                    }
                };
                SwingUtilities.invokeLater(runner);
            }
            control.setValue("default_look_and_feel", OSPFrame.DEFAULT_LOOK_AND_FEEL);
            Collection nodes = (Collection)control.getObject("launch_nodes");
            if (nodes != null && !nodes.isEmpty()) {
                int i = launcher.tabbedPane.getSelectedIndex();
                Iterator it = nodes.iterator();
                boolean tabAdded = false;
                LaunchNode buttonNode = null;
                while (it.hasNext()) {
                    Object next = it.next();
                    if (tabset.name != null && tabset.name.equals(next)) continue;
                    if (next instanceof String) {
                        String path = XML.getResolvedPath((String)next, tabSetBasePath);
                        if (launcher.open(path) == null) continue;
                        tabAdded = true;
                        continue;
                    }
                    if (!(next instanceof LaunchNode)) continue;
                    LaunchNode node = (LaunchNode)next;
                    tabAdded = launcher.addTab(node) || tabAdded;
                    if (launcher.getClass() != (class$org$opensourcephysics$tools$Launcher == null ? Launcher.class$("org.opensourcephysics.tools.Launcher") : class$org$opensourcephysics$tools$Launcher) || !node.isButtonView() || buttonNode != null) continue;
                    buttonNode = node;
                }
                if (buttonNode != null) {
                    for (int j = 0; j < Launcher.this.tabbedPane.getTabCount(); ++j) {
                        if (Launcher.this.getTab(j).getRootNode() != buttonNode) continue;
                        Launcher.this.tabbedPane.setSelectedIndex(j);
                    }
                } else if (tabAdded) {
                    launcher.tabbedPane.setSelectedIndex(i + 1);
                }
            }
            launcher.title = control.getString("title");
            launcher.editorEnabled = control.getBoolean("editor_enabled");
            launcher.password = control.getString("xml_password");
            launcher.pwRequiredToLoad = control.getBoolean("pw_required_by_launcher");
            if (control.getPropertyNames().contains("width") && control.getPropertyNames().contains("height")) {
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                dim.width = Math.min(8 * dim.width / 10, control.getInt("width"));
                dim.height = Math.min(8 * dim.height / 10, control.getInt("height"));
                launcher.contentPane.setPreferredSize(dim);
                launcher.frame.pack();
            }
            if (control.getPropertyNames().contains("divider")) {
                launcher.divider = control.getInt("divider");
                launcher.refreshGUI();
            }
            return obj;
        }
    }

    private class LaunchRenderer
    extends DefaultTreeCellRenderer {
        private LaunchRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            LaunchNode node = (LaunchNode)value;
            this.setToolTipText(node.tooltip.equals("") ? null : node.tooltip);
            if (node.getFileName() != null && Launcher.this instanceof LaunchBuilder) {
                this.setToolTipText(LaunchRes.getString("ToolTip.FileName") + " \"" + node.getFileName() + "\"");
                this.setIcon(Launcher.this.getFileIcon(node));
            } else if (node.launchCount > 0) {
                if (node.isSingleton()) {
                    this.setIcon(singletonIcon);
                } else if (node.isSingleVM() && node.isSingleApp()) {
                    this.setIcon(singletonIcon);
                } else {
                    this.setIcon(launchedIcon);
                }
            } else if (Launcher.this.isLaunchable(node)) {
                this.setIcon(launchIcon);
            } else if (Launcher.this.isLink(node)) {
                this.setIcon(linkIcon);
            } else if (node.isLeaf()) {
                if (node.getLaunchClass() == null && node.launchClassName != null && !node.launchClassName.equals("")) {
                    this.setIcon(launchEmptyIcon);
                } else if (node.url != null) {
                    this.setIcon(htmlIcon);
                } else {
                    this.setIcon(noFileIcon);
                }
            }
            return this;
        }
    }

    private class LauncherFrame
    extends OSPFrame {
        LaunchNode node;

        public LauncherFrame() {
            this.setName("LauncherTool");
        }

        public LaunchNode getLaunchNode() {
            return this.node;
        }
    }
}

