/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jigcell.sbml2.Compartment;
import jigcell.sbml2.Event;
import jigcell.sbml2.FunctionDefinition;
import jigcell.sbml2.KineticLaw;
import jigcell.sbml2.Parameter;
import jigcell.sbml2.Reaction;
import jigcell.sbml2.Rule;
import jigcell.sbml2.SBase;
import jigcell.sbml2.SBaseId;
import jigcell.sbml2.Species;
import jigcell.sbml2.Unit;
import jigcell.sbml2.UnitDefinition;
import jigcell.sbml2.XMLPrinter;

public final class Model
extends SBaseId {
    public static final int COMPARTMENT = 1;
    public static final int EVENT = 2;
    public static final int FUNCTIONDEFINITION = 4;
    public static final int PARAMETER = 8;
    public static final int REACTION = 16;
    public static final int SPECIES = 32;
    public static final int UNITDEFINITION = 64;
    public static final int GLOBAL = 63;
    private final List compartments = new ArrayList();
    private final List events = new ArrayList();
    private final List functionDefinitions = new ArrayList();
    private final List parameters = new ArrayList();
    private final List reactions = new ArrayList();
    private final List rules = new ArrayList();
    private final List species = new ArrayList();
    private final List unitDefinitions = new ArrayList();
    private final SBase compartmentsElement = new SBase();
    private final SBase eventsElement = new SBase();
    private final SBase functionDefinitionsElement = new SBase();
    private final SBase parametersElement = new SBase();
    private final SBase reactionsElement = new SBase();
    private final SBase rulesElement = new SBase();
    private final SBase speciesElement = new SBase();
    private final SBase unitDefinitionsElement = new SBase();

    public Model() {
        this(null);
    }

    public Model(String name) {
        super(null, name);
    }

    public void addCompartment(Compartment element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.compartments.add(element);
    }

    public void addEvent(Event element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.events.add(element);
    }

    public void addFunctionDefinition(FunctionDefinition element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.functionDefinitions.add(element);
    }

    public void addParameter(Parameter element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.parameters.add(element);
    }

    public void addReaction(Reaction element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.reactions.add(element);
    }

    public void addRule(Rule element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.rules.add(element);
    }

    public void addSpecies(Species element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.species.add(element);
    }

    public void addUnitDefinition(UnitDefinition element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        String id = element.getId();
        if (Unit.findBaseUnit(id) != null) {
            throw new IllegalArgumentException("Base units cannot be redefined.");
        }
        this.unitDefinitions.add(element);
    }

    public SBaseId findElementWithId(String id, int flags) {
        SBaseId element = null;
        if ((flags & 1) == 1) {
            element = Model.searchListForId(this.compartments, id);
        }
        if (element != null) {
            return element;
        }
        if ((flags & 2) == 2) {
            element = Model.searchListForId(this.events, id);
        }
        if (element != null) {
            return element;
        }
        if ((flags & 4) == 4) {
            element = Model.searchListForId(this.functionDefinitions, id);
        }
        if (element != null) {
            return element;
        }
        if ((flags & 8) == 8) {
            element = Model.searchListForId(this.parameters, id);
        }
        if (element != null) {
            return element;
        }
        if ((flags & 0x10) == 16) {
            element = Model.searchListForId(this.reactions, id);
        }
        if (element != null) {
            return element;
        }
        if ((flags & 0x20) == 32) {
            element = Model.searchListForId(this.species, id);
        }
        if (element != null) {
            return element;
        }
        if ((flags & 0x40) == 64) {
            element = Model.searchListForId(this.unitDefinitions, id);
        }
        return element;
    }

    public List getCompartments() {
        return this.compartments;
    }

    public SBase getCompartmentsElement() {
        return this.compartmentsElement;
    }

    public List getEvents() {
        return this.events;
    }

    public SBase getEventsElement() {
        return this.eventsElement;
    }

    public List getFunctionDefinitions() {
        return this.functionDefinitions;
    }

    public SBase getFunctionDefinitionsElement() {
        return this.functionDefinitionsElement;
    }

    public List getParameters() {
        return this.parameters;
    }

    public SBase getParametersElement() {
        return this.parametersElement;
    }

    public List getReactions() {
        return this.reactions;
    }

    public SBase getReactionsElement() {
        return this.reactionsElement;
    }

    public List getRules() {
        return this.rules;
    }

    public SBase getRulesElement() {
        return this.rulesElement;
    }

    public List getSpecies() {
        return this.species;
    }

    public SBase getSpeciesElement() {
        return this.speciesElement;
    }

    public List getUnitDefinitions() {
        return this.unitDefinitions;
    }

    public SBase getUnitDefinitionsElement() {
        return this.unitDefinitionsElement;
    }

    public boolean hasLocalParameters() {
        Iterator iterator = this.reactions.iterator();
        while (iterator.hasNext()) {
            KineticLaw kineticLaw = ((Reaction)iterator.next()).getKineticLaw();
            if (kineticLaw == null || kineticLaw.getParameter().size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected XMLPrinter print(XMLPrinter parent) {
        return this.print(parent, "model");
    }

    @Override
    protected XMLPrinter print(XMLPrinter parent, String name) {
        XMLPrinter printer = super.print(parent, name);
        printer.addElementList(this.getFunctionDefinitionsElement(), "listOfFunctionDefinitions", this.getFunctionDefinitions());
        printer.addElementList(this.getUnitDefinitionsElement(), "listOfUnitDefinitions", this.getUnitDefinitions());
        printer.addElementList(this.getCompartmentsElement(), "listOfCompartments", this.getCompartments());
        printer.addElementList(this.getSpeciesElement(), "listOfSpecies", this.getSpecies());
        printer.addElementList(this.getParametersElement(), "listOfParameters", this.getParameters());
        printer.addElementList(this.getRulesElement(), "listOfRules", this.getRules());
        printer.addElementList(this.getReactionsElement(), "listOfReactions", this.getReactions());
        printer.addElementList(this.getEventsElement(), "listOfEvents", this.getEvents());
        return printer;
    }
}

