/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import jigcell.sbml2.SimpleSpeciesReference;
import jigcell.sbml2.Species;
import jigcell.sbml2.StoichiometryMath;
import jigcell.sbml2.XMLPrinter;
import org.xml.sax.Attributes;

public final class SpeciesReference
extends SimpleSpeciesReference {
    private double stoichiometry;
    private StoichiometryMath stoichiometryMath;

    public SpeciesReference() {
        this((Species)null);
    }

    public SpeciesReference(SpeciesReference reference) {
        this();
        this.setSpecies(reference.getSpecies());
        this.setStoichiometry(reference.getStoichiometry());
        if (reference.getStoichiometryMath() != null) {
            this.setStoichiometryMath(new StoichiometryMath(reference.getStoichiometryMath()));
        }
    }

    public SpeciesReference(Species species) {
        this.setSpecies(species);
        this.setStoichiometry(1.0);
    }

    public double getStoichiometry() {
        return this.stoichiometry;
    }

    public StoichiometryMath getStoichiometryMath() {
        return this.stoichiometryMath;
    }

    public void setStoichiometry(double stoichiometry) {
        if (stoichiometry < 0.0) {
            throw new IllegalArgumentException("Stoichiometry must be non-negative.");
        }
        this.stoichiometry = stoichiometry;
        if (!Double.isNaN(stoichiometry)) {
            this.setStoichiometryMath(null);
        }
    }

    public void setStoichiometryMath(StoichiometryMath stoichiometryMath) {
        this.stoichiometryMath = stoichiometryMath;
        if (stoichiometryMath != null) {
            this.stoichiometry = Double.NaN;
        }
    }

    @Override
    protected void parse(Attributes attributes) {
        super.parse(attributes);
        if (attributes.getIndex("stoichiometry") != -1) {
            this.setStoichiometry(Double.parseDouble(attributes.getValue("stoichiometry")));
        }
    }

    @Override
    protected XMLPrinter print(XMLPrinter parent) {
        return this.print(parent, "speciesReference");
    }

    @Override
    protected XMLPrinter print(XMLPrinter parent, String name) {
        XMLPrinter printer = super.print(parent, name);
        printer.addElement(this.getStoichiometryMath());
        if (!Double.isNaN(this.getStoichiometry()) && this.getStoichiometry() != 1.0) {
            printer.addAttribute("stoichiometry", String.valueOf(this.getStoichiometry()));
        }
        return printer;
    }
}

