/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.jep;

import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jigcell.sbml2.jep.FunctionTable;
import jigcell.sbml2.jep.Node;
import jigcell.sbml2.jep.ParseException;
import jigcell.sbml2.jep.Parser;
import jigcell.sbml2.jep.ParserDumpVisitor;
import jigcell.sbml2.jep.function.PostfixMathCommand;
import jigcell.sbml2.jep.function.PostfixMathCommandI;
import jigcell.sbml2.jep.type.DoubleNumberFactory;
import jigcell.sbml2.jep.type.NumberFactory;

public class JEP {
    private static final boolean debug = false;
    private static final HashMap mathMLFunctions = new HashMap();
    protected boolean implicitMul;
    protected FunctionTable funTab;
    protected Hashtable symTab;
    protected Vector errorList;
    private boolean traverse;
    private Node topNode = null;
    private NumberFactory numberFactory;
    private Parser parser;

    public static boolean isMathMLFunction(String s) {
        return mathMLFunctions.containsKey(s);
    }

    public JEP() {
        this.traverse = false;
        this.implicitMul = false;
        this.numberFactory = new DoubleNumberFactory();
        this.initFunTab();
        this.symTab = new Hashtable();
        this.errorList = new Vector();
        this.parser = new Parser(new StringReader(""));
        this.parseExpression("");
    }

    public JEP(boolean traverse_in, boolean allowUndeclared_in, boolean implicitMul_in, NumberFactory numberFactory_in) {
        this.traverse = traverse_in;
        this.implicitMul = implicitMul_in;
        this.numberFactory = numberFactory_in == null ? new DoubleNumberFactory() : numberFactory_in;
        this.initFunTab();
        this.symTab = new Hashtable();
        this.errorList = new Vector();
        this.parser = new Parser(new StringReader(""));
        this.parseExpression("");
    }

    public void addFunction(String functionName, PostfixMathCommandI function) {
        this.funTab.put(functionName, function);
    }

    public void addStandardFunctions() {
        this.funTab.put("sin", new PostfixMathCommand(1));
        this.funTab.put("cos", new PostfixMathCommand(1));
        this.funTab.put("tan", new PostfixMathCommand(1));
        this.funTab.put("sec", new PostfixMathCommand(1));
        this.funTab.put("csc", new PostfixMathCommand(1));
        this.funTab.put("cot", new PostfixMathCommand(1));
        this.funTab.put("sech", new PostfixMathCommand(1));
        this.funTab.put("csch", new PostfixMathCommand(1));
        this.funTab.put("coth", new PostfixMathCommand(1));
        this.funTab.put("arcsech", new PostfixMathCommand(1));
        this.funTab.put("arcsec", new PostfixMathCommand(1));
        this.funTab.put("arccsc", new PostfixMathCommand(1));
        this.funTab.put("arccsch", new PostfixMathCommand(1));
        this.funTab.put("arccot", new PostfixMathCommand(1));
        this.funTab.put("arccoth", new PostfixMathCommand(1));
        this.funTab.put("arcsin", new PostfixMathCommand(1));
        this.funTab.put("arccos", new PostfixMathCommand(1));
        this.funTab.put("arctan", new PostfixMathCommand(1));
        this.funTab.put("sinh", new PostfixMathCommand(1));
        this.funTab.put("cosh", new PostfixMathCommand(1));
        this.funTab.put("tanh", new PostfixMathCommand(1));
        this.funTab.put("arcsinh", new PostfixMathCommand(1));
        this.funTab.put("arccosh", new PostfixMathCommand(1));
        this.funTab.put("arctanh", new PostfixMathCommand(1));
        this.funTab.put("log", new PostfixMathCommand(2));
        this.funTab.put("log10", new PostfixMathCommand(1));
        this.funTab.put("ln", new PostfixMathCommand(1));
        this.funTab.put("floor", new PostfixMathCommand(1));
        this.funTab.put("ceiling", new PostfixMathCommand(1));
        this.funTab.put("factorial", new PostfixMathCommand(1));
        this.funTab.put("exp", new PostfixMathCommand(1));
        this.funTab.put("sqrt", new PostfixMathCommand(1));
        this.funTab.put("root", new PostfixMathCommand(2));
        this.funTab.put("abs", new PostfixMathCommand(1));
        this.funTab.put("delay", new PostfixMathCommand(2));
        this.funTab.put("sqrt", new PostfixMathCommand(1));
    }

    public String getErrorInfo() {
        if (this.hasError()) {
            String str = "";
            for (int i = 0; i < this.errorList.size(); ++i) {
                str = str + this.errorList.elementAt(i) + "\n";
            }
            return str;
        }
        return null;
    }

    public NumberFactory getNumberFactory() {
        return this.numberFactory;
    }

    public String getSBMLString(String expression_in) {
        StringReader reader = new StringReader(expression_in);
        this.symTab = new Hashtable();
        try {
            this.errorList.removeAllElements();
            this.topNode = this.parser.parseStream(reader, this);
        }
        catch (Throwable e) {
            this.topNode = null;
            if (e instanceof ParseException) {
                this.errorList.addElement(((ParseException)e).getErrorInfo());
            }
            this.errorList.addElement("Syntax error");
        }
        if (!this.hasError()) {
            ParserDumpVisitor v = new ParserDumpVisitor();
            this.topNode.jjtAccept(v, null);
            return v.getSBMLString();
        }
        return "";
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public Enumeration getVariables() {
        return this.symTab.elements();
    }

    public Enumeration getVariablesInExpression(String eq) {
        this.parseExpression(eq);
        return this.getVariables();
    }

    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    public void initFunTab() {
        this.funTab = new FunctionTable();
    }

    public boolean isFunction(String s) {
        return this.funTab.containsKey(s);
    }

    public void parseExpression(String expression_in) {
        StringReader reader = new StringReader(expression_in);
        this.symTab = new Hashtable();
        try {
            this.errorList.removeAllElements();
            this.topNode = this.parser.parseStream(reader, this);
        }
        catch (Throwable e) {
            this.topNode = null;
            if (e instanceof ParseException) {
                this.errorList.addElement(((ParseException)e).getErrorInfo());
            }
            this.errorList.addElement("Syntax error");
        }
        if (this.traverse && !this.hasError()) {
            ParserDumpVisitor v = new ParserDumpVisitor();
            this.topNode.jjtAccept(v, null);
            System.out.println(v.getSBMLString());
        }
    }

    public Object removeFunction(String name) {
        return this.funTab.remove(name);
    }

    public void setImplicitMul(boolean value) {
        this.implicitMul = value;
    }

    public void setTraverse(boolean value) {
        this.traverse = value;
    }

    static {
        mathMLFunctions.put("sin", new PostfixMathCommand(1));
        mathMLFunctions.put("cos", new PostfixMathCommand(1));
        mathMLFunctions.put("tan", new PostfixMathCommand(1));
        mathMLFunctions.put("sec", new PostfixMathCommand(1));
        mathMLFunctions.put("csc", new PostfixMathCommand(1));
        mathMLFunctions.put("cot", new PostfixMathCommand(1));
        mathMLFunctions.put("sech", new PostfixMathCommand(1));
        mathMLFunctions.put("csch", new PostfixMathCommand(1));
        mathMLFunctions.put("coth", new PostfixMathCommand(1));
        mathMLFunctions.put("arcsech", new PostfixMathCommand(1));
        mathMLFunctions.put("arcsec", new PostfixMathCommand(1));
        mathMLFunctions.put("arccsc", new PostfixMathCommand(1));
        mathMLFunctions.put("arccsch", new PostfixMathCommand(1));
        mathMLFunctions.put("arccot", new PostfixMathCommand(1));
        mathMLFunctions.put("arccoth", new PostfixMathCommand(1));
        mathMLFunctions.put("arcsin", new PostfixMathCommand(1));
        mathMLFunctions.put("arccos", new PostfixMathCommand(1));
        mathMLFunctions.put("arctan", new PostfixMathCommand(1));
        mathMLFunctions.put("sinh", new PostfixMathCommand(1));
        mathMLFunctions.put("cosh", new PostfixMathCommand(1));
        mathMLFunctions.put("tanh", new PostfixMathCommand(1));
        mathMLFunctions.put("arcsinh", new PostfixMathCommand(1));
        mathMLFunctions.put("arccosh", new PostfixMathCommand(1));
        mathMLFunctions.put("arctanh", new PostfixMathCommand(1));
        mathMLFunctions.put("log", new PostfixMathCommand(2));
        mathMLFunctions.put("ln", new PostfixMathCommand(1));
        mathMLFunctions.put("floor", new PostfixMathCommand(1));
        mathMLFunctions.put("ceiling", new PostfixMathCommand(1));
        mathMLFunctions.put("factorial", new PostfixMathCommand(1));
        mathMLFunctions.put("exp", new PostfixMathCommand(1));
        mathMLFunctions.put("root", new PostfixMathCommand(2));
        mathMLFunctions.put("abs", new PostfixMathCommand(1));
        mathMLFunctions.put("plus", new PostfixMathCommand(2));
        mathMLFunctions.put("minus", new PostfixMathCommand(2));
        mathMLFunctions.put("times", new PostfixMathCommand(2));
        mathMLFunctions.put("divide", new PostfixMathCommand(2));
        mathMLFunctions.put("eq", new PostfixMathCommand(2));
        mathMLFunctions.put("neq", new PostfixMathCommand(2));
        mathMLFunctions.put("gt", new PostfixMathCommand(2));
        mathMLFunctions.put("lt", new PostfixMathCommand(2));
        mathMLFunctions.put("geq", new PostfixMathCommand(2));
        mathMLFunctions.put("leq", new PostfixMathCommand(2));
        mathMLFunctions.put("and", new PostfixMathCommand(2));
        mathMLFunctions.put("or", new PostfixMathCommand(2));
        mathMLFunctions.put("xor", new PostfixMathCommand(2));
        mathMLFunctions.put("not", new PostfixMathCommand(1));
        mathMLFunctions.put("power", new PostfixMathCommand(1));
    }
}

