/*
 * Decompiled with CFR 0.152.
 */
package org.compbiollab.algorithms;

import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseVertex;
import edu.uci.ics.jung.statistics.GraphStatistics;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import org.enfin.squad.dl.VectorTools;

public class GraphAlgorithms {
    public static Vector getAllCycles(DirectedSparseGraph theGraph) {
        Vector allCycles = new Vector();
        Vector allNodes = new Vector(theGraph.getVertices());
        for (int i = 0; i < allNodes.size(); ++i) {
            Vector cyclesFromNode = new Vector();
            Vertex node = (Vertex)allNodes.get(i);
            cyclesFromNode = GraphAlgorithms.getCyclesFromNode(theGraph, node);
            for (int j = 0; j < cyclesFromNode.size(); ++j) {
                if (VectorTools.vectorIsAlreadyIncluded((Vector)cyclesFromNode.elementAt(j), allCycles)) continue;
                allCycles.add(cyclesFromNode.elementAt(j));
            }
        }
        return allCycles;
    }

    public static Vector getAllCyclesByName(DirectedSparseGraph theGraph) {
        Vector allCycles = new Vector();
        Vector allNodes = new Vector(theGraph.getVertices());
        for (int i = 0; i < allNodes.size(); ++i) {
            Vector cyclesFromNode = new Vector();
            Vertex node = (Vertex)allNodes.get(i);
            cyclesFromNode = GraphAlgorithms.getCyclesFromNode(theGraph, node);
            for (int j = 0; j < cyclesFromNode.size(); ++j) {
                if (VectorTools.vectorIsAlreadyIncluded((Vector)cyclesFromNode.elementAt(j), allCycles)) continue;
                allCycles.add(cyclesFromNode.elementAt(j));
            }
        }
        Vector<Vector> allCyclesByName = new Vector<Vector>();
        for (int i = 0; i < allCycles.size(); ++i) {
            allCyclesByName.add(GraphAlgorithms.getNamesOfVertices((Vector)allCycles.get(i), theGraph));
        }
        return allCyclesByName;
    }

    public static Vector getAllNegativeCycles(DirectedSparseGraph theGraph) {
        Vector allNegativeCycles = new Vector();
        Vector allCycles = new Vector(GraphAlgorithms.getAllCycles(theGraph));
        for (int i = 0; i < allCycles.size(); ++i) {
            if (!GraphAlgorithms.isANegativeCycle((Vector)allCycles.get(i), theGraph)) continue;
            allNegativeCycles.add(allCycles.get(i));
        }
        return allNegativeCycles;
    }

    private static Vector getCyclesFromNode(DirectedSparseGraph theGraph, Vertex node) {
        Vector nodesToVisit = new Vector(node.getSuccessors());
        Vector<Vertex> history = new Vector<Vertex>();
        history.add(node);
        Vector cycles = new Vector();
        cycles = GraphAlgorithms.visit(nodesToVisit, history, cycles);
        return cycles;
    }

    private static Vector visit(Vector nodesToVisit, Vector history, Vector cycles) {
        for (int i = 0; i < nodesToVisit.size(); ++i) {
            if (nodesToVisit.elementAt(i).equals(history.elementAt(0))) {
                cycles.add(history);
                continue;
            }
            if (history.contains(nodesToVisit.elementAt(i)) || ((Vertex)nodesToVisit.get(i)).getSuccessors() == null) continue;
            Vector localHistory = new Vector(history);
            localHistory.add(nodesToVisit.elementAt(i));
            Vertex presentNode = (Vertex)nodesToVisit.get(i);
            Vector localNodesToVisit = new Vector(presentNode.getSuccessors());
            cycles = GraphAlgorithms.visit(localNodesToVisit, localHistory, cycles);
        }
        return cycles;
    }

    public static String StringWithAllCycles(DirectedSparseGraph theGraph) {
        String outputText = null;
        Vector allCycles = new Vector(GraphAlgorithms.getAllCycles(theGraph));
        for (int i = 0; i < allCycles.size(); ++i) {
            Vector oneCycle = (Vector)allCycles.get(i);
            for (int j = 0; j < oneCycle.size(); ++j) {
                Vertex node = (Vertex)oneCycle.get(j);
                String name = node.getUserDatum((Object)"id").toString();
                outputText = outputText + name + " ";
            }
            outputText = outputText + "\n";
        }
        return outputText;
    }

    public static Vector getUpstreamNodesByName(DirectedSparseGraph theGraph) {
        DirectedSparseGraph graphToModify = new DirectedSparseGraph();
        graphToModify = (DirectedSparseGraph)theGraph.copy();
        Vector result = new Vector(GraphAlgorithms.getNodesWithoutInputs(graphToModify));
        Vector batchOfNodesToRemove = new Vector(result);
        while (batchOfNodesToRemove.size() > 0) {
            for (int i = 0; i < batchOfNodesToRemove.size(); ++i) {
                graphToModify.removeVertex((Vertex)batchOfNodesToRemove.get(i));
            }
            Vector newBatch = GraphAlgorithms.getNodesWithoutInputs(graphToModify);
            result.addAll(newBatch);
            batchOfNodesToRemove = newBatch;
        }
        result = GraphAlgorithms.getNamesOfVertices(result, graphToModify);
        return result;
    }

    public static Vector getNamesOfVertices(Vector vertices, DirectedSparseGraph theGraph) {
        Vector<Object> names = new Vector<Object>();
        for (int i = 0; i < vertices.size(); ++i) {
            Vertex oneVertex = (Vertex)vertices.get(i);
            names.add(oneVertex.getUserDatum((Object)"id"));
        }
        return names;
    }

    public static Vector getNamesOfVertices(Vector vertices, UndirectedSparseGraph theGraph) {
        Vector<Object> names = new Vector<Object>();
        for (int i = 0; i < vertices.size(); ++i) {
            Vertex oneVertex = (Vertex)vertices.get(i);
            names.add(oneVertex.getUserDatum((Object)"id"));
        }
        return names;
    }

    private static Vector getNodesWithoutInputs(DirectedSparseGraph theGraph) {
        Vector<Vertex> result = new Vector<Vertex>();
        Vector allNodes = new Vector(theGraph.getVertices());
        for (int i = 0; i < allNodes.size(); ++i) {
            Vertex node = (Vertex)allNodes.get(i);
            Vector inputs = new Vector(node.getPredecessors());
            if (inputs.size() != 0) continue;
            result.add(node);
        }
        return result;
    }

    public static Vector getDownstreamNodes(DirectedSparseGraph theGraph) {
        Vector result = new Vector();
        result = GraphAlgorithms.getNodesWithoutOutputs(theGraph);
        Vector batchOfNodesToRemove = new Vector(result);
        while (batchOfNodesToRemove.size() > 0) {
            for (int i = 0; i < batchOfNodesToRemove.size(); ++i) {
                theGraph.removeVertex((Vertex)batchOfNodesToRemove.get(i));
            }
            Vector newBatch = GraphAlgorithms.getNodesWithoutOutputs(theGraph);
            result.addAll(newBatch);
            batchOfNodesToRemove = newBatch;
        }
        return result;
    }

    private static Vector getNodesWithoutOutputs(DirectedSparseGraph theGraph) {
        Vector<Vertex> result = new Vector<Vertex>();
        Vector allNodes = new Vector(theGraph.getVertices());
        for (int i = 0; i < allNodes.size(); ++i) {
            Vertex node = (Vertex)allNodes.get(i);
            Vector inputs = new Vector(node.getSuccessors());
            if (inputs.size() != 0) continue;
            result.add(node);
        }
        return result;
    }

    private static boolean isANegativeCycle(Vector cycle, DirectedSparseGraph theGraph) {
        Vertex nodeTo;
        Vertex nodeFrom;
        int numberOfNegativeInteractions = 0;
        for (int i = 1; i < cycle.size(); ++i) {
            nodeFrom = (Vertex)cycle.get(i - 1);
            String sign = GraphAlgorithms.getSignOfInteraction(nodeFrom, nodeTo = (Vertex)cycle.get(i), theGraph);
            if (!sign.equals("negative")) continue;
            ++numberOfNegativeInteractions;
        }
        nodeFrom = (Vertex)cycle.get(cycle.size() - 1);
        String sign = GraphAlgorithms.getSignOfInteraction(nodeFrom, nodeTo = (Vertex)cycle.get(0), theGraph);
        if (sign.equals("negative")) {
            ++numberOfNegativeInteractions;
        }
        return numberOfNegativeInteractions % 2 != 0;
    }

    public static String getSignOfInteraction(Vertex nodeFrom, Vertex nodeTo, DirectedSparseGraph theGraph) {
        Vector allEdges = new Vector(theGraph.getEdges());
        for (int i = 0; i < allEdges.size(); ++i) {
            Vertex to;
            DirectedSparseEdge edge = (DirectedSparseEdge)allEdges.get(i);
            Vertex from = edge.getSource();
            if (!(from == nodeFrom & (to = edge.getDest()) == nodeTo)) continue;
            return edge.getUserDatum((Object)"sign").toString();
        }
        return "positive";
    }

    public static String getSignOfInteraction(String nodeNameFrom, String nodeNameTo, DirectedSparseGraph theGraph) {
        Vertex nodeFrom = GraphAlgorithms.getNodeByName((Graph)theGraph, nodeNameFrom);
        Vertex nodeTo = GraphAlgorithms.getNodeByName((Graph)theGraph, nodeNameTo);
        Vector allEdges = new Vector(theGraph.getEdges());
        for (int i = 0; i < allEdges.size(); ++i) {
            Vertex to;
            DirectedSparseEdge edge = (DirectedSparseEdge)allEdges.get(i);
            Vertex from = edge.getSource();
            if (!(from == nodeFrom & (to = edge.getDest()) == nodeTo)) continue;
            return edge.getUserDatum((Object)"sign").toString();
        }
        return "positive";
    }

    public static Vertex getNodeByName(Graph theGraph, String name) {
        int which = 0;
        Vector allNodes = new Vector(theGraph.getVertices());
        for (int i = 0; i < allNodes.size(); ++i) {
            if (!((Vertex)allNodes.get(i)).getUserDatum((Object)"id").toString().equals(name)) continue;
            which = i;
            break;
        }
        return (Vertex)allNodes.get(which);
    }

    public static Vertex getNodeByName(UndirectedSparseGraph theGraph, String name) {
        int which = 0;
        Vector allNodes = new Vector(theGraph.getVertices());
        for (int i = 0; i < allNodes.size(); ++i) {
            if (!((Vertex)allNodes.get(i)).getUserDatum((Object)"id").toString().equals(name)) continue;
            which = i;
            break;
        }
        return (Vertex)allNodes.get(which);
    }

    public static Vector getInputsToNodeByName(Graph theGraph, String nodeName) {
        Vertex node = GraphAlgorithms.getNodeByName(theGraph, nodeName);
        Vector allInputs = new Vector(node.getPredecessors());
        Vector<String> allNames = new Vector<String>();
        for (int i = 0; i < allInputs.size(); ++i) {
            Vertex oneInput = (Vertex)allInputs.get(i);
            allNames.add(oneInput.getUserDatum((Object)"id").toString());
        }
        return allNames;
    }

    public static Vector getPositiveInputsToNodeByName(DirectedSparseGraph theGraph, String nodeName) {
        Vector<String> positiveInputs = new Vector<String>();
        Vector allInputs = GraphAlgorithms.getInputsToNodeByName((Graph)theGraph, nodeName);
        for (int i = 0; i < allInputs.size(); ++i) {
            String sign = GraphAlgorithms.getSignOfInteraction((String)allInputs.get(i), nodeName, theGraph);
            if (!sign.equalsIgnoreCase("positive")) continue;
            positiveInputs.add(allInputs.get(i).toString());
        }
        return positiveInputs;
    }

    public static Vector getNegativeInputsToNodeByName(DirectedSparseGraph theGraph, String nodeName) {
        Vector<String> negativeInputs = new Vector<String>();
        Vector allInputs = GraphAlgorithms.getInputsToNodeByName((Graph)theGraph, nodeName);
        for (int i = 0; i < allInputs.size(); ++i) {
            String sign = GraphAlgorithms.getSignOfInteraction((String)allInputs.get(i), nodeName, theGraph);
            if (!sign.equalsIgnoreCase("negative")) continue;
            negativeInputs.add(allInputs.get(i).toString());
        }
        return negativeInputs;
    }

    public static Vector getNodesDegreeByName(UndirectedSparseGraph theGraph) {
        Vector degrees = new Vector();
        Vector allNodes = new Vector(theGraph.getVertices());
        Vector nodeNames = new Vector(GraphAlgorithms.getNamesOfVertices(allNodes, theGraph));
        nodeNames = VectorTools.convertStringToInteger(nodeNames);
        Collections.sort(nodeNames);
        for (int i = 0; i < nodeNames.size(); ++i) {
            Integer number = new Integer(nodeNames.get(i).toString());
            Vertex oneNode = GraphAlgorithms.getNodeByName(theGraph, number.toString());
            Vector pair = new Vector();
            pair.add(nodeNames.get(i));
            pair.add(oneNode.getIncidentEdges().size());
            degrees.add(pair);
        }
        return degrees;
    }

    public static Vector getNodesConnectivityByName(UndirectedSparseGraph theGraph) {
        Vector<Vector> degrees = new Vector<Vector>();
        Vector allNodes = new Vector(theGraph.getVertices());
        Vector nodeNames = new Vector(GraphAlgorithms.getNamesOfVertices(allNodes, theGraph));
        nodeNames = VectorTools.convertStringToInteger(nodeNames);
        Collections.sort(nodeNames);
        for (int i = 0; i < nodeNames.size(); ++i) {
            Integer number = new Integer(nodeNames.get(i).toString());
            Vertex oneNode = GraphAlgorithms.getNodeByName(theGraph, number.toString());
            Vector pair = new Vector();
            pair.add(nodeNames.get(i));
            Vector adjacent = new Vector(oneNode.getNeighbors());
            Vector incidentNames = GraphAlgorithms.getNamesOfVertices(adjacent, theGraph);
            pair = VectorTools.joinVectors(pair, incidentNames);
            degrees.add(pair);
        }
        return degrees;
    }

    public static Vector getDegreeDistribution(UndirectedSparseGraph theGraph) {
        HashMap<Integer, Integer> distributionHash = new HashMap<Integer, Integer>();
        Vector allVertices = new Vector(theGraph.getVertices());
        for (int i = 0; i < allVertices.size(); ++i) {
            Vertex oneNode = (Vertex)allVertices.get(i);
            int numberOfEdges = oneNode.getNeighbors().size();
            if (!distributionHash.containsKey(numberOfEdges)) {
                distributionHash.put(numberOfEdges, 1);
                continue;
            }
            Integer value = new Integer(distributionHash.get(numberOfEdges).toString());
            distributionHash.put(numberOfEdges, value + 1);
        }
        return VectorTools.integerHashToVector(distributionHash);
    }

    public static Vector getDegreeDistribution(Vector connectivity) {
        HashMap<Integer, Integer> distributionHash = new HashMap<Integer, Integer>();
        for (int i = 0; i < connectivity.size(); ++i) {
            Vector oneNodeData = (Vector)connectivity.get(i);
            int numberOfEdges = oneNodeData.size() - 1;
            if (!distributionHash.containsKey(numberOfEdges)) {
                distributionHash.put(numberOfEdges, 1);
                continue;
            }
            Integer value = new Integer(distributionHash.get(numberOfEdges).toString());
            distributionHash.put(numberOfEdges, value + 1);
        }
        return VectorTools.integerHashToVector(distributionHash);
    }

    public static Vector getAllConnectedSubgraphs(UndirectedSparseGraph theGraph) {
        WeakComponentClusterer component = new WeakComponentClusterer();
        ClusterSet cluster = component.extract((ArchetypeGraph)theGraph);
        Vector<Graph> allSubgraphs = new Vector<Graph>();
        for (int i = 0; i < cluster.size(); ++i) {
            allSubgraphs.add(cluster.getClusterAsNewSubGraph(i));
        }
        return allSubgraphs;
    }

    public static Vector getDiameterOfConnectedSubgraphs(UndirectedSparseGraph theGraph) {
        Vector results = new Vector();
        Vector allComponents = GraphAlgorithms.getAllConnectedSubgraphs(theGraph);
        for (int i = 0; i < allComponents.size(); ++i) {
            UndirectedSparseGraph oneSubgraph = (UndirectedSparseGraph)allComponents.get(i);
            Vector<Number> onePair = new Vector<Number>();
            onePair.add(oneSubgraph.getVertices().size());
            onePair.add(GraphStatistics.diameter((ArchetypeGraph)oneSubgraph));
            results.add(onePair);
        }
        return results;
    }

    public static double getDiameterOfLargestSubgraph(UndirectedSparseGraph theGraph) {
        UndirectedSparseGraph graph = new UndirectedSparseGraph();
        graph = (UndirectedSparseGraph)theGraph.copy();
        Vector allVertices = new Vector(graph.getVertices());
        for (int i = 0; i < allVertices.size(); ++i) {
            UndirectedSparseVertex oneVertex = (UndirectedSparseVertex)allVertices.get(i);
            if (oneVertex.degree() != 0) continue;
            graph.removeVertex((Vertex)oneVertex);
        }
        Vector allValues = GraphAlgorithms.getDiameterOfConnectedSubgraphs(graph);
        Vector allSizes = VectorTools.getColumn(allValues, 0);
        Vector allDiameters = VectorTools.getColumn(allValues, 1);
        int index = VectorTools.indexOfLargestValue(allSizes);
        Double result = new Double(allDiameters.get(index).toString());
        return result;
    }

    public static double getAverageClusteringCoefficient(UndirectedSparseGraph theGraph) {
        HashMap clustering = new HashMap(GraphStatistics.clusteringCoefficients((ArchetypeGraph)theGraph));
        double total = 0.0;
        Vector keys = new Vector(clustering.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            total += ((Double)clustering.get(keys.get(i))).doubleValue();
        }
        return total /= (double)keys.size();
    }

    public static double getAverageDistanceOfLargestSubgaph(UndirectedSparseGraph theGraph) {
        UndirectedSparseGraph component = GraphAlgorithms.getLargestComponent(theGraph);
        HashMap distances = new HashMap(GraphStatistics.averageDistances((ArchetypeGraph)component));
        Vector keys = new Vector(distances.keySet());
        double total = 0.0;
        for (int i = 0; i < keys.size(); ++i) {
            total += ((Double)distances.get(keys.get(i))).doubleValue();
        }
        return total /= (double)keys.size();
    }

    public static UndirectedSparseGraph getLargestComponent(UndirectedSparseGraph theGraph) {
        UndirectedSparseGraph graph = new UndirectedSparseGraph();
        graph = (UndirectedSparseGraph)theGraph.copy();
        Vector allVertices = new Vector(graph.getVertices());
        for (int i = 0; i < allVertices.size(); ++i) {
            UndirectedSparseVertex oneVertex = (UndirectedSparseVertex)allVertices.get(i);
            if (oneVertex.degree() != 0) continue;
            graph.removeVertex((Vertex)oneVertex);
        }
        Vector allComponents = GraphAlgorithms.getAllConnectedSubgraphs(graph);
        Vector<Integer> indices = new Vector<Integer>();
        for (int i = 0; i < allComponents.size(); ++i) {
            indices.add(((UndirectedSparseGraph)allComponents.get(i)).getVertices().size());
        }
        int largest = VectorTools.indexOfLargestValue(indices);
        return (UndirectedSparseGraph)allComponents.get(largest);
    }

    public static double getAverageClusteringCoefficientOfLargestComponent(UndirectedSparseGraph graph) {
        UndirectedSparseGraph theGraph = GraphAlgorithms.getLargestComponent(graph);
        HashMap clustering = new HashMap(GraphStatistics.clusteringCoefficients((ArchetypeGraph)theGraph));
        double total = 0.0;
        Vector keys = new Vector(clustering.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            total += ((Double)clustering.get(keys.get(i))).doubleValue();
        }
        return total /= (double)keys.size();
    }

    public static String getPropertyOfInteraction(DirectedSparseGraph theGraph, String nodeNameFrom, String nodeNameTo, String property) {
        Vertex nodeFrom = GraphAlgorithms.getNodeByName((Graph)theGraph, nodeNameFrom);
        Vertex nodeTo = GraphAlgorithms.getNodeByName((Graph)theGraph, nodeNameTo);
        Vector allEdges = new Vector(theGraph.getEdges());
        for (int i = 0; i < allEdges.size(); ++i) {
            Vertex to;
            DirectedSparseEdge edge = (DirectedSparseEdge)allEdges.get(i);
            Vertex from = edge.getSource();
            if (!(from == nodeFrom & (to = edge.getDest()) == nodeTo) || !edge.containsUserDatumKey((Object)property)) continue;
            return edge.getUserDatum((Object)property).toString();
        }
        return null;
    }

    public static boolean edgeExists(DirectedSparseGraph theGraph, Vertex nodeFrom, Vertex nodeTo) {
        String nodeFromName = nodeFrom.getUserDatum((Object)"id").toString();
        String nodeToName = nodeTo.getUserDatum((Object)"id").toString();
        Vector inputNodes = new Vector(GraphAlgorithms.getInputsToNodeByName((Graph)theGraph, nodeToName));
        return inputNodes.contains(nodeFromName);
    }

    public static Vector getSortedNodeNames(Graph theGraph) {
        Vector graphNodes = new Vector(theGraph.getVertices());
        Vector<String> nodeNames = new Vector<String>();
        for (int i = 0; i < theGraph.getVertices().size(); ++i) {
            Vertex oneNode = (Vertex)graphNodes.get(i);
            nodeNames.add(oneNode.getUserDatum((Object)"id").toString());
        }
        Collections.sort(nodeNames);
        return nodeNames;
    }
}

