/*
 * Decompiled with CFR 0.152.
 */
package org.compbiollab.dataanalysis;

import java.util.Vector;
import org.compbiollab.algorithms.GraphAlgorithms;
import org.enfin.squad.dl.Stdout;
import org.enfin.squad.dl.TabSeparatedDataFile;
import org.enfin.squad.dl.VectorTools;

public class GraphStatistics {
    public Vector getDistributionFromConnectivity(String fileName) {
        TabSeparatedDataFile dataFile = new TabSeparatedDataFile(fileName);
        return GraphAlgorithms.getDegreeDistribution(dataFile.read());
    }

    public Vector fuseDistriutions(Vector distributions) {
        int i;
        Vector<Integer> sizes = new Vector<Integer>();
        for (int i2 = 0; i2 < distributions.size(); ++i2) {
            sizes.add(((Vector)distributions.get(i2)).size());
        }
        int largestVector = VectorTools.indexOfLargestValue(sizes);
        int rows = ((Vector)distributions.get(largestVector)).size();
        int columns = distributions.size() + 1;
        Vector metaDistribution = VectorTools.getZeroMatrix(rows, columns);
        for (i = 0; i < rows; ++i) {
            VectorTools.setValueOfMatrix(metaDistribution, i, 0, i);
        }
        for (i = 0; i < distributions.size(); ++i) {
            Vector oneDistribution = (Vector)distributions.get(i);
            for (int j = 0; j < oneDistribution.size(); ++j) {
                int value = (Integer)VectorTools.getValue(oneDistribution, j, 1);
                VectorTools.setValueOfMatrix(metaDistribution, j, i + 1, value);
            }
        }
        return metaDistribution;
    }

    public static Vector getAverageAndStdDev(Vector data) {
        Vector<Double> results = new Vector<Double>();
        int n = data.size();
        Double average = new Double(data.get(0).toString());
        double sum = 0.0;
        for (int i = 1; i < n; ++i) {
            Double dataPoint = new Double(data.get(i).toString());
            double newAverage = average + (dataPoint - average) / (double)(i + 1);
            sum += (dataPoint - average) * (dataPoint - newAverage);
            average = newAverage;
        }
        results.add(average);
        results.add(Math.sqrt(sum / (double)(n - 1)));
        return results;
    }

    public static void main(String[] args) {
        GraphStatistics stats = new GraphStatistics();
        Vector<Vector> allDistributions = new Vector<Vector>();
        for (int i = 1; i <= 100; ++i) {
            String file = "/home/luis/projects/SpherePackingData/exp2/sphere_touching_data." + i + ".txt";
            Vector oneDistribution = stats.getDistributionFromConnectivity(file);
            allDistributions.add(oneDistribution);
        }
        Vector metaDistribution = stats.fuseDistriutions(allDistributions);
        for (int i = 0; i < metaDistribution.size(); ++i) {
            Vector data = (Vector)metaDistribution.get(i);
            data.remove(0);
            Vector result = GraphStatistics.getAverageAndStdDev(data);
            result.insertElementAt(i, 0);
            Stdout.vector(result);
        }
    }
}

