/*
 * Decompiled with CFR 0.152.
 */
package org.compbiollab.datavisualization;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import com.tlabs.dcolt.DecoratedDoubleMatrix2D;
import de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import org.compbiollab.datavisualization.Blot;
import org.compbiollab.squad2.Log4JConfigurator;
import org.enfin.squad.dl.TabSeparatedDataFile;

public class BlotPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    JScrollPane scrollPane;
    JComboBox combScale;
    DoubleMatrix2D allData;
    List<String> nodeNames;

    public BlotPanel(DecoratedDoubleMatrix2D dataMatrix, int initialScale) {
        this.allData = dataMatrix.viewDice();
        this.nodeNames = dataMatrix.getColumnHeaders();
        this.generateBlotPanel(initialScale);
        this.validate();
    }

    private void generateBlotPanel(int scale) {
        this.removeAll();
        this.setBackground(Color.white);
        GridLayout lt = new GridLayout(this.allData.rows(), 1, 0, 5);
        this.setLayout(lt);
        this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        BlotLineContentHolder bltheader = new BlotLineContentHolder("Time", this.allData.viewRow(0).viewStrides(scale).toArray(), true);
        this.add(bltheader);
        Object columnSelection = null;
        for (int j = 1; j < this.allData.rows(); ++j) {
            DoubleMatrix1D row = this.allData.viewRow(j);
            String rowHeader = this.nodeNames.get(j);
            BlotLineContentHolder bltData = new BlotLineContentHolder(rowHeader, row.viewStrides(scale).toArray(), false);
            this.add(bltData);
        }
    }

    public DoubleMatrix2D getData() {
        return this.allData;
    }

    public void changeTimeScale(Integer scale) {
        this.generateBlotPanel(scale);
        this.setSize(new Dimension(this.getComponent(0).getWidth(), this.getHeight()));
        this.validate();
    }

    public static void main(String[] args) {
        Log4JConfigurator.configureLog4J("/conf/squad.log4j.properties");
        try {
            TabSeparatedDataFile dataFile = new TabSeparatedDataFile("test_sets/timeseries.res");
            DecoratedDoubleMatrix2D dt = dataFile.readMatrix();
            BlotPanel vB = new BlotPanel(dt, 10);
            JFrame fr = new JFrame();
            JScrollPane scr = new JScrollPane(vB);
            fr.setSize(600, 400);
            fr.getContentPane().add(scr);
            fr.setDefaultCloseOperation(3);
            fr.setVisible(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new SyntheticaStandardLookAndFeel());
            String sysVersion = System.getProperty("java.version");
            if (Integer.parseInt(((Object)sysVersion.subSequence(2, 3)).toString()) < 6) {
                JOptionPane.showMessageDialog(null, "JAVA version 1.6 or above is required to run this applications, some features might not function properly ", "Java Version Warning", 2);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private static class BlotLineContentHolder
    extends JPanel {
        JPanel dataPanel = new JPanel();

        public BlotLineContentHolder(String label, double[] values, boolean isColumnHeader) {
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            FlowLayout lt = new FlowLayout(0);
            this.dataPanel.setLayout(lt);
            this.dataPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.dataPanel.setOpaque(false);
            if (!isColumnHeader) {
                this.dataPanel.setBorder(new LineBorder(Color.black));
            }
            JLabel lblHeader = new JLabel(label.trim(), 4);
            lblHeader.setPreferredSize(new Dimension(150, 5));
            this.add((Component)lblHeader, "West");
            int wdt = 30;
            int hgh = 10;
            this.add(this.dataPanel);
            DecimalFormat df = new DecimalFormat("0.00");
            double[] arr$ = values;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Double vla = arr$[i$];
                if (isColumnHeader) {
                    JLabel lbl = new JLabel(df.format(vla), 0);
                    lbl.setPreferredSize(new Dimension(wdt, hgh));
                    lbl.setMaximumSize(new Dimension(wdt, hgh));
                    lbl.setMinimumSize(new Dimension(wdt, hgh));
                    lbl.setOpaque(false);
                    this.dataPanel.add(lbl);
                    continue;
                }
                Blot blt = new Blot(Float.valueOf(vla.toString()).floatValue());
                blt.setPreferredSize(new Dimension(wdt, hgh));
                blt.setMaximumSize(new Dimension(wdt, hgh));
                blt.setMinimumSize(new Dimension(wdt, hgh));
                blt.setOpaque(false);
                this.dataPanel.add(blt);
            }
            this.dataPanel.setMaximumSize(new Dimension((wdt + 5) * this.dataPanel.getComponentCount() + 3, hgh + 15));
            this.dataPanel.setMinimumSize(new Dimension((wdt + 5) * this.dataPanel.getComponentCount() + 3, hgh + 15));
            this.dataPanel.setPreferredSize(new Dimension((wdt + 5) * this.dataPanel.getComponentCount() + 3, hgh + 15));
            this.dataPanel.validate();
        }
    }
}

