/*
 * Decompiled with CFR 0.152.
 */
package org.compbiollab.datavisualization;

import com.tlabs.dcolt.DecoratedDoubleMatrix2D;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.compbiollab.datavisualization.BlotPanel;
import org.enfin.squad.bl.ode.ODESystemSolver;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.pl.PlotFrameDisplay;

public class ReportFrame
extends JFrame {
    private DecoratedDoubleMatrix2D data;
    BlotPanel blot;
    JPanel plot;
    JScrollPane legend;
    ButtonGroup grp = new ButtonGroup();
    private JMenu mnuBlot;
    private JMenuBar mnuMain;
    private JSplitPane splitHoriz;
    private JSplitPane splitVert;

    public ReportFrame() {
        this.initComponents();
    }

    public ReportFrame(DecoratedDoubleMatrix2D data) {
        this.data = data;
        this.blot = this.generateVirtualBlot();
        this.plot = this.generatePlot();
        this.legend = this.generateLegend();
        this.init(this.blot, this.plot, this.legend);
    }

    public ReportFrame(DecoratedDoubleMatrix2D data, String title) {
        this(data);
        this.setTitle(title);
    }

    private void init(Component blot, Component plot, Component legend) {
        this.initComponents();
        JScrollPane jscrBlot = new JScrollPane(blot);
        jscrBlot.setAutoscrolls(true);
        this.splitHoriz.setBottomComponent(jscrBlot);
        JScrollPane legScroll = new JScrollPane(legend);
        legScroll.setAutoscrolls(true);
        this.splitVert.setRightComponent(legScroll);
        this.splitVert.setLeftComponent(plot);
        Toolkit tl = Toolkit.getDefaultToolkit();
        this.setSize(800, 600);
        this.splitHoriz.setDividerLocation(this.getHeight() / 3);
        this.splitVert.setDividerLocation(this.getWidth() / 20 * 13);
        int colsNum = this.data.rows();
        JRadioButtonMenuItem chk1 = new JRadioButtonMenuItem(" scale 1/1");
        chk1.addActionListener(new BlotScaleEvent(1));
        this.mnuBlot.add(chk1);
        this.grp.add(chk1);
        chk1.setSelected(true);
        JRadioButtonMenuItem chkX = new JRadioButtonMenuItem("scale 1/2");
        chkX.addActionListener(new BlotScaleEvent(2));
        this.mnuBlot.add(chkX);
        this.grp.add(chkX);
        chkX = new JRadioButtonMenuItem("scale 1/3");
        chkX.addActionListener(new BlotScaleEvent(3));
        this.mnuBlot.add(chkX);
        this.grp.add(chkX);
        chkX = new JRadioButtonMenuItem("scale 1/5");
        chkX.addActionListener(new BlotScaleEvent(5));
        this.mnuBlot.add(chkX);
        this.grp.add(chkX);
        chkX = new JRadioButtonMenuItem("scale 1/10");
        chk1.addActionListener(new BlotScaleEvent(10));
        this.mnuBlot.add(chkX);
        this.grp.add(chkX);
        chkX = new JRadioButtonMenuItem("scale 1/20");
        chkX.addActionListener(new BlotScaleEvent(20));
        this.mnuBlot.add(chkX);
        this.grp.add(chkX);
        this.mnuBlot.validate();
        this.validate();
    }

    public JPanel generatePlot() {
        PlotFrameDisplay ptf = new PlotFrameDisplay(this.data);
        return ptf.getDrawingPanel();
    }

    public BlotPanel generateVirtualBlot() {
        BlotPanel vt = new BlotPanel(this.data, 1);
        return vt;
    }

    public JScrollPane generateLegend() {
        PlotFrameDisplay ptf = new PlotFrameDisplay(this.data);
        return ptf.getLegendFrame();
    }

    private void initComponents() {
        this.splitHoriz = new JSplitPane();
        this.splitVert = new JSplitPane();
        this.mnuMain = new JMenuBar();
        this.mnuBlot = new JMenu();
        this.setDefaultCloseOperation(2);
        this.splitHoriz.setDividerLocation(100);
        this.splitHoriz.setOrientation(0);
        this.splitHoriz.setTopComponent(this.splitVert);
        this.getContentPane().add((Component)this.splitHoriz, "Center");
        this.mnuBlot.setText("Blot Options");
        this.mnuBlot.setToolTipText("Changes the scale of the virtual blot");
        this.mnuMain.add(this.mnuBlot);
        this.setJMenuBar(this.mnuMain);
        this.pack();
    }

    public static void main(String[] args) {
        try {
            GraphContainer gr = new GraphContainer("test_sets/THelper_network.net");
            final ODESystemSolver slv = new ODESystemSolver(gr);
            gr.getNodes().get(0).setInitialState(1.0, true);
            slv.initialize();
            slv.runSync();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new ReportFrame(slv.getResults()).setVisible(true);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class BlotScaleEvent
    implements ActionListener {
        int blotscale;

        public BlotScaleEvent(int scale) {
            this.blotscale = scale;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReportFrame.this.blot.changeTimeScale(this.blotscale);
            ReportFrame.this.blot.validate();
        }
    }
}

