/*
 * Decompiled with CFR 0.152.
 */
package org.compbiollab.dynamicalsystem;

import com.sun.org.apache.regexp.internal.RE;
import com.sun.org.apache.regexp.internal.RESyntaxException;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.compbiollab.algorithms.GraphAlgorithms;
import org.compbiollab.dynamicalsystem.Simulator;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.dl.GraphContainer;

public class OctaveExport {
    private static GraphContainer grCont;

    public static String getTextForOctave(GraphContainer graph, Integer maxTime, Integer slices) throws RESyntaxException {
        int i;
        grCont = graph;
        Vector<String> ODEs = null;
        String octaveInput = "#!/usr/bin/octave -q\n#RESULTS\n";
        octaveInput = octaveInput + "#Nodes have the following order:\nnode_names = [";
        for (int i2 = 0; i2 < grCont.getNodes().size(); ++i2) {
            octaveInput = octaveInput + "\"" + grCont.getNodes().get(i2).getName() + "\";";
        }
        Integer timeSlices = maxTime / slices;
        octaveInput = octaveInput + "];\n# Global variables\npoints_to_be_steady = 10;\nresolution = 0.0001;\ntime_slices = " + timeSlices + ";\n" + "t_interval = 5;\n" + "t_maximal = " + maxTime + ";\n" + "# ODEs\n" + "function xdot = f(x,t)\n";
        for (i = 1; i <= grCont.getNodes().size(); ++i) {
            String nodeName = grCont.getNodes().get(i - 1).getName();
            Vector<String> allInputsNames = new Vector<String>(GraphAlgorithms.getInputsToNodeByName(grCont.getGraph(), nodeName));
            Vector allInputsPositions = new Vector(OctaveExport.getElementPositions(grCont.getNodes(), allInputsNames));
            AbstractGraphNode theNode = GraphContainer.getNodeByName(grCont.getNodes(), nodeName);
            String nodeDecay = theNode.getDecay().toString();
            for (int j = 0; j < allInputsPositions.size(); ++j) {
                String inputWeight = "1";
                String interactionWeight = GraphAlgorithms.getPropertyOfInteraction((DirectedSparseGraph)grCont.getGraph(), allInputsNames.get(j), nodeName, "weight");
                if (interactionWeight != null) {
                    inputWeight = interactionWeight;
                }
                octaveInput = octaveInput + "    x" + i + "_" + allInputsPositions.get(j).toString() + "=" + inputWeight + ";\n";
            }
            octaveInput = octaveInput + "    x" + i + "_decay=" + nodeDecay + ";\n";
        }
        ODEs = OctaveExport.createEquations(grCont);
        for (i = 0; i < ODEs.size(); ++i) {
            octaveInput = octaveInput + "    " + ODEs.get(i) + ";\n";
        }
        octaveInput = octaveInput + "endfunction\n#Initial states:\n#The following initial state correspond to the value of the nodes in the following order:\n# ";
        for (i = 0; i < grCont.getNodes().size(); ++i) {
            octaveInput = octaveInput + "\"" + grCont.getNodes().get(i).getName() + "\";";
        }
        octaveInput = octaveInput + "\n";
        octaveInput = octaveInput + "initial_state =[";
        for (i = 0; i < grCont.getNodes().size(); ++i) {
            octaveInput = octaveInput + " " + grCont.getNodes().get(i).getInitialState();
        }
        octaveInput = octaveInput + "];\n";
        octaveInput = octaveInput + "# The guts\nx0 = initial_state;\nis_steady_state = false;\nt_initial = 0;\nt_final = t_initial + t_interval;\niteration_counter = 0;\nwhile(is_steady_state==false & t_final<=t_maximal)\n   t=linspace(t_initial,t_final,time_slices);\n   x=lsode(\"f\",x0,t);\n   points_inside_resolution = 0;\n   for i = (time_slices-points_to_be_steady+1 : time_slices)\n        difference = abs(x(i,:) - x(i-1,:));\n        if (all(all(difference<resolution)))\n            points_inside_resolution++;\n        endif\n    endfor\n    if(points_inside_resolution==points_to_be_steady)\n        is_steady_state = true;\n        steady_state = x(time_slices,:);\n    endif\n    final_time = t_final;\n    x0 = x(time_slices,:);\n    t_initial = t_final;\n    t_final = t_initial + t_interval;\n    iteration_counter++;\nendwhile\n   t=linspace(0,final_time,time_slices*iteration_counter);\n   x=lsode(\"f\",initial_state,t);\n\ntrans_t = t';\ndata = [trans_t x];\nheader = [\"time";
        for (i = 0; i < grCont.getNodes().size(); ++i) {
            octaveInput = octaveInput + " " + grCont.getNodes().get(i).getName();
        }
        octaveInput = octaveInput + "\"];\nsave_header_format_string = \"\";\nsave -text - header data;\n";
        return octaveInput;
    }

    private static Vector<String> createEquations(GraphContainer gr) throws RESyntaxException {
        String ODE2 = "((-exp(0.5*GAIN)+exp(-GAIN*(TOTALINPUT-0.5)))./((1-exp(0.5*GAIN))*(1+exp(-GAIN*(TOTALINPUT-0.5)))))-";
        String TOTALINPUT = "x";
        Vector<String> equations = new Vector<String>();
        for (int i = 1; i <= gr.getNodes().size(); ++i) {
            Vector positiveInputs = new Vector(OctaveExport.getPositiveInputsTo(gr.getNodes().get(i - 1).getName()));
            Vector negativeInputs = new Vector(OctaveExport.getNegativeInputsTo(gr.getNodes().get(i - 1).getName()));
            String finalEquation = new String();
            String finalInput = new String();
            if (positiveInputs.size() + negativeInputs.size() > 0) {
                finalEquation = "xdot(" + i + ")=" + ODE2 + "(x" + i + "_decay*x(" + i + "))";
                RE substituteGain = new RE("GAIN");
                finalEquation = substituteGain.subst(finalEquation, gr.getNodes().get(i - 1).getInitialDecay().toString());
                finalInput = OctaveExport.getIntegratedInputs(i, positiveInputs, negativeInputs);
                RE substituteTotalInput = new RE("TOTALINPUT");
                finalEquation = substituteTotalInput.subst(finalEquation, finalInput);
            } else {
                finalEquation = "xdot(" + i + ")=-(x" + i + "_decay*x(" + i + "))";
            }
            equations.add(finalEquation);
        }
        return equations;
    }

    private static String getIntegratedInputs(int position, Vector positiveInputs, Vector negativeInputs) {
        int i;
        String saturating;
        String normalizer;
        Vector inputs;
        String totalPositive = "";
        String totalNegative = "";
        if (positiveInputs.size() > 0) {
            inputs = new Vector(OctaveExport.getElementPositions(grCont.getNodes(), positiveInputs));
            normalizer = "";
            saturating = "";
            for (i = 0; i < inputs.size(); ++i) {
                normalizer = normalizer + "x" + position + "_" + inputs.get(i).toString();
                saturating = saturating + "x" + position + "_" + inputs.get(i).toString() + "*x(" + inputs.get(i).toString() + ")";
                if (i == inputs.size() - 1) continue;
                normalizer = normalizer + "+";
                saturating = saturating + "+";
            }
            normalizer = "(1+" + normalizer + ")./(" + normalizer + ")";
            saturating = "(" + saturating + ")./(1+" + saturating + ")";
            totalPositive = "((" + normalizer + ")*(" + saturating + "))";
        }
        if (negativeInputs.size() > 0) {
            inputs = new Vector(OctaveExport.getElementPositions(grCont.getNodes(), negativeInputs));
            normalizer = "";
            saturating = "";
            for (i = 0; i < inputs.size(); ++i) {
                normalizer = normalizer + "x" + position + "_" + inputs.get(i).toString();
                saturating = saturating + "x" + position + "_" + inputs.get(i).toString() + "*x(" + inputs.get(i).toString() + ")";
                if (i == inputs.size() - 1) continue;
                normalizer = normalizer + "+";
                saturating = saturating + "+";
            }
            normalizer = "(1+" + normalizer + ")./(" + normalizer + ")";
            saturating = "(" + saturating + ")./(1+" + saturating + ")";
            totalNegative = "(1-(" + normalizer + ")*(" + saturating + "))";
        }
        if (totalPositive.equals("")) {
            return totalNegative;
        }
        if (totalNegative.equals("")) {
            return totalPositive;
        }
        return "(" + totalPositive + ")*(" + totalNegative + ")";
    }

    public static Vector getPositiveInputsTo(String node) {
        Vector allInputs = new Vector(GraphAlgorithms.getInputsToNodeByName(grCont.getGraph(), node));
        Vector<String> positives = new Vector<String>();
        for (int i = 0; i < allInputs.size(); ++i) {
            String sign = GraphAlgorithms.getSignOfInteraction(allInputs.get(i).toString(), node, (DirectedSparseGraph)grCont.getGraph());
            if (!sign.equals("positive")) continue;
            positives.add(allInputs.get(i).toString());
        }
        return positives;
    }

    public static Vector getNegativeInputsTo(String node) {
        Vector allInputs = new Vector(GraphAlgorithms.getInputsToNodeByName(grCont.getGraph(), node));
        Vector<String> negatives = new Vector<String>();
        for (int i = 0; i < allInputs.size(); ++i) {
            String sign = GraphAlgorithms.getSignOfInteraction(allInputs.get(i).toString(), node, (DirectedSparseGraph)grCont.getGraph());
            if (!sign.equals("negative")) continue;
            negatives.add(allInputs.get(i).toString());
        }
        return negatives;
    }

    private static Vector getElementPositions(List<AbstractGraphNode> nodes, Vector<String> inputNames) {
        Vector<Integer> positions = new Vector<Integer>();
        for (int i = 0; i < inputNames.size(); ++i) {
            positions.add(GraphContainer.getNodeIndexByName(nodes, inputNames.get(i)) + 1);
        }
        return positions;
    }

    public static void main(String[] args) {
        try {
            GraphContainer grc = new GraphContainer("test_sets/2states.net");
            Simulator sim1 = new Simulator(grc);
            sim1.setUseBDDnalysis(false);
            sim1.setExtractContinuousState(false);
            sim1.getAttractorsDiscrete();
            System.out.println(OctaveExport.getTextForOctave(grc, 100, 3));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

