/*
 * Decompiled with CFR 0.152.
 */
package org.compbiollab.squad2;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class Log4JConfigurator {
    public static final String APPLICATION_LOGDIR_KEY = "application.logdir";
    public static final File APP_DIR = new File(Log4JConfigurator.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile();
    public static final String[] SYSTEM_LOGDIR_SUBFOLDERS = new String[]{"log"};

    public static void configureLog4J(String log4JPropertyFile) {
        Object value = null;
        Object folder = null;
        try {
            if (System.getProperty(APPLICATION_LOGDIR_KEY) == null) {
                File logFolder = null;
                logFolder = new File(APP_DIR.getAbsolutePath() + "/" + SYSTEM_LOGDIR_SUBFOLDERS[0]);
                if (!logFolder.exists()) {
                    logFolder.mkdir();
                }
                System.setProperty(APPLICATION_LOGDIR_KEY, logFolder.getAbsolutePath());
            }
            Properties p = new Properties();
            p.load(new FileInputStream(APP_DIR.getAbsolutePath() + "/" + log4JPropertyFile));
            System.out.println("logging on: " + System.getProperty(APPLICATION_LOGDIR_KEY));
            PropertyConfigurator.configure((Properties)p);
        }
        catch (IOException e) {
            System.err.println("Unable to load log4j configuration file:");
        }
    }
}

