/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.bl;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.IEdge;

public class GraphEdge
implements IEdge,
Cloneable {
    Double initialWeight = 1.0;
    Edge delegate;

    public GraphEdge(Edge edg) {
        this.delegate = edg;
        this.initializeEdge();
    }

    public GraphEdge(AbstractGraphNode startNode, AbstractGraphNode endNode, String edgeType, Double edgeWeight) {
        this.delegate = new DirectedSparseEdge(startNode.getVertex(), endNode.getVertex());
        this.initializeEdge();
        this.setSource(startNode.getName());
        this.setTarget(endNode.getName());
        this.setSign(edgeType);
        this.setWeight(edgeWeight);
        this.initialWeight = this.getWeight();
    }

    @Override
    public Double getInitialWeight() {
        return this.initialWeight;
    }

    @Override
    public void setInitialWeight(Double inWei, boolean resetCurrentState) {
        this.initialWeight = inWei;
        if (resetCurrentState) {
            this.setWeight(inWei);
        }
    }

    private void initializeEdge() {
        if (this.delegate.getUserDatum((Object)"weight") == null) {
            this.delegate.addUserDatum((Object)"weight", (Object)1.0, UserData.SHARED);
        }
        if (this.delegate.getUserDatum((Object)"active") == null) {
            this.delegate.addUserDatum((Object)"active", (Object)true, UserData.SHARED);
        }
        if (this.delegate.getUserDatum((Object)"gain") == null) {
            this.delegate.addUserDatum((Object)"gain", (Object)10, UserData.SHARED);
        }
    }

    public static ArrayList<IEdge> getIedgesFromGraph(Graph theGraph) {
        ArrayList<IEdge> edgeList = new ArrayList<IEdge>();
        Iterator itr = theGraph.getEdges().iterator();
        while (itr.hasNext()) {
            edgeList.add(new GraphEdge((Edge)itr.next()));
        }
        return edgeList;
    }

    @Override
    public boolean getActive() {
        return Boolean.parseBoolean(this.delegate.getUserDatum((Object)"active").toString());
    }

    @Override
    public Double getWeight() {
        Object myWg = this.delegate.getUserDatum((Object)"weight");
        if (myWg != null) {
            return Double.parseDouble(myWg.toString());
        }
        return 1.0;
    }

    public Double getGain() {
        Object myGain = this.delegate.getUserDatum((Object)"gain");
        if (myGain != null) {
            return Double.parseDouble(myGain.toString());
        }
        return 10.0;
    }

    public void setGain(double gain) {
        this.delegate.setUserDatum((Object)"gain", (Object)gain, UserData.SHARED);
    }

    @Override
    public void setActive(boolean isActive) {
        this.delegate.setUserDatum((Object)"active", (Object)isActive, UserData.SHARED);
    }

    @Override
    public void setWeight(Double wg) {
        this.delegate.setUserDatum((Object)"weight", (Object)wg, UserData.SHARED);
    }

    @Override
    public String getName() {
        if (this.delegate.getUserDatum((Object)"id") != null) {
            return this.delegate.getUserDatum((Object)"id").toString();
        }
        String signSymbol = this.getSign().equals("positive") ? " -> " : " -| ";
        return this.getSource() + signSymbol + this.getTarget();
    }

    @Override
    public String getSign() {
        return this.delegate.getUserDatum((Object)"sign").toString();
    }

    @Override
    public void setSign(String edgeSign) {
        this.delegate.setUserDatum((Object)"sign", (Object)edgeSign, UserData.SHARED);
    }

    @Override
    public String getSource() {
        return this.delegate.getUserDatum((Object)"source").toString();
    }

    @Override
    public String getTarget() {
        return this.delegate.getUserDatum((Object)"target").toString();
    }

    @Override
    public void setSource(String nodeName) {
        this.delegate.setUserDatum((Object)"source", (Object)nodeName, UserData.SHARED);
    }

    @Override
    public void setTarget(String nodeName) {
        this.delegate.setUserDatum((Object)"target", (Object)nodeName, UserData.SHARED);
    }

    @Override
    public String getDescription() {
        String mySign = this.getSign().equals("positive") ? "--" : "-|";
        return this.getSource() + " " + mySign + " " + this.getTarget();
    }

    @Override
    public Edge getEdge() {
        return this.delegate;
    }

    public void setEdge(Edge edg) {
        this.delegate = edg;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        GraphEdge newEdge = (GraphEdge)this.clone();
        newEdge.setEdge((Edge)this.delegate.clone());
        return newEdge;
    }

    public void addUserDatum(Object arg0, Object arg1, UserDataContainer.CopyAction arg2) {
        this.delegate.addUserDatum(arg0, arg1, arg2);
    }

    public boolean containsUserDatumKey(Object arg0) {
        return this.delegate.containsUserDatumKey(arg0);
    }

    public ArchetypeEdge copy(ArchetypeGraph arg0) {
        return this.delegate.copy(arg0);
    }

    public Pair getEndpoints() {
        return this.delegate.getEndpoints();
    }

    public ArchetypeEdge getEqualEdge(ArchetypeGraph arg0) {
        return this.delegate.getEqualEdge(arg0);
    }

    @Deprecated
    public ArchetypeEdge getEquivalentEdge(ArchetypeGraph arg0) {
        return this.delegate.getEquivalentEdge(arg0);
    }

    public ArchetypeGraph getGraph() {
        return this.delegate.getGraph();
    }

    public Set getIncidentElements() {
        return this.delegate.getIncidentElements();
    }

    public Set getIncidentVertices() {
        return this.delegate.getIncidentVertices();
    }

    public Vertex getOpposite(Vertex arg0) {
        return this.delegate.getOpposite(arg0);
    }

    public Object getUserDatum(Object arg0) {
        return this.delegate.getUserDatum(arg0);
    }

    public UserDataContainer.CopyAction getUserDatumCopyAction(Object arg0) {
        return this.delegate.getUserDatumCopyAction(arg0);
    }

    public Iterator getUserDatumKeyIterator() {
        return this.delegate.getUserDatumKeyIterator();
    }

    public void importUserData(UserDataContainer arg0) {
        this.delegate.importUserData(arg0);
    }

    public boolean isIncident(ArchetypeVertex arg0) {
        return this.delegate.isIncident(arg0);
    }

    public int numVertices() {
        return this.delegate.numVertices();
    }

    public Object removeUserDatum(Object arg0) {
        return this.delegate.removeUserDatum(arg0);
    }

    public void setUserDatum(Object arg0, Object arg1, UserDataContainer.CopyAction arg2) {
        this.delegate.setUserDatum(arg0, arg1, arg2);
    }
}

