/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.bl.ode;

import cern.colt.matrix.DoubleMatrix1D;
import com.tlabs.dcolt.DecoratedDoubleMatrix2D;
import com.tlabs.dcolt.DynamicDoubleFactory2D;
import com.tlabs.dcolt.DynamicDoubleMatrix2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.IEdge;
import org.enfin.squad.bl.IObservable;
import org.enfin.squad.bl.IObserver;
import org.enfin.squad.bl.ode.AbstractStandardizedODE;
import org.enfin.squad.bl.ode.RK4NegativeCorrection;
import org.enfin.squad.bl.ode.StandardizedODE;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.perturbations.bl.Perturbator;
import org.enfin.squad.perturbations.bl.ode.PerturbableRK4NegativeCorrection;
import org.enfin.squad.perturbations.bl.ode.PerturbableStandardizedODE;
import org.opensourcephysics.numerics.ODESolver;

public class ODESystemSolver
implements IObservable,
Runnable {
    private int numberOfNodes;
    private ODESolver theSolver;
    private AbstractStandardizedODE theODE;
    private Perturbator thePerturbator = null;
    private ArrayList<IObserver> observers = new ArrayList();
    private int stepDelay = 0;
    protected int stepsPerDisplay = 1;
    protected int stepCounter = 0;
    protected volatile Thread animationThread;
    Boolean isStopAtSteadyState;
    int slices;
    double time;
    int slicesPerUnit;
    int timeMax;
    double stepSize;
    int iterationNumber = 0;
    double[] states;
    List<AbstractGraphNode> nodeList;
    List<IEdge> edgeList;
    DecoratedDoubleMatrix2D mainResultValues;
    int points_to_be_steady = 10;
    double resolution = 1.0E-4;
    boolean is_steady_state = false;
    double points_inside_resolution;
    int t_initial;
    int t_maximal;
    String nodePrefix = "";

    public ODESystemSolver(GraphContainer gr) {
        this.nodeList = gr.getNodes();
        this.edgeList = gr.getEdges();
        this.numberOfNodes = this.nodeList.size();
        this.timeMax = 100;
        this.slicesPerUnit = 3;
        this.isStopAtSteadyState = true;
        this.t_initial = 0;
    }

    public ODESystemSolver(GraphContainer gr, Perturbator pert) {
        this(gr);
        this.thePerturbator = pert;
    }

    public void initialize() {
        this.initializeResultMatrix();
        this.time = 0.0;
        this.stepDelay = 0;
        this.stepSize = 1.0 / (double)this.slicesPerUnit;
        if (this.thePerturbator != null) {
            this.thePerturbator.getInitialState().fillNodesWithState(this.nodeList, true);
        } else {
            for (AbstractGraphNode nd : this.nodeList) {
                nd.setToInitialState();
            }
        }
        this.states = new double[this.numberOfNodes + 1];
        for (int n = 0; n < this.nodeList.size(); ++n) {
            this.states[n] = this.nodeList.get(n).getState();
        }
        if (this.thePerturbator != null) {
            this.theODE = new PerturbableStandardizedODE(this.nodeList, this.edgeList, this.thePerturbator);
            this.theSolver = new PerturbableRK4NegativeCorrection((PerturbableStandardizedODE)this.theODE);
        } else {
            this.theODE = new StandardizedODE(this.nodeList, this.edgeList);
            this.theSolver = new RK4NegativeCorrection(this.theODE);
        }
        this.theSolver.initialize(this.stepSize);
        this.iterationNumber = 0;
    }

    public void doStep() {
        this.nodeList = this.theODE.updateNodesWithStateValues(this.nodeList);
        this.collectResults();
        this.notifyObservers();
        if (this.thePerturbator != null) {
            this.thePerturbator.performPerturbation(this.nodeList, this.theODE.getTime());
        }
        this.theSolver.step();
        this.nodeList = this.theODE.updateNodesWithStateValues(this.nodeList);
        ++this.iterationNumber;
    }

    private void initializeResultMatrix() {
        this.mainResultValues = DynamicDoubleFactory2D.fulldynamic_dense.makeDecorated(0, this.nodeList.size() + 1);
        this.mainResultValues.setDiskMode();
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("time");
        for (AbstractGraphNode nd : this.nodeList) {
            columnNames.add(nd.getName());
        }
        this.mainResultValues.setColumnHeaders(columnNames);
    }

    private void collectResults() {
        this.mainResultValues.extendTo(this.mainResultValues.rows() + 1, this.mainResultValues.columns());
        double[] newValues = (double[])this.theODE.getState().clone();
        this.mainResultValues.set(this.mainResultValues.rows() - 1, 0, newValues[newValues.length - 1]);
        for (int f = 0; f < newValues.length - 1; ++f) {
            this.mainResultValues.set(this.mainResultValues.rows() - 1, f + 1, newValues[f]);
        }
    }

    private void notifyObservers() {
        for (IObserver obs : this.observers) {
            if (obs == null) continue;
            obs.updateObserver(this, null);
        }
    }

    @Override
    public void run() {
        long sleepTime = this.stepDelay;
        while (this.animationThread == Thread.currentThread()) {
            long currentTime = System.currentTimeMillis();
            for (int i = 0; i < this.stepsPerDisplay; ++i) {
                this.doStep();
                ++this.stepCounter;
                if (this.animationThread != Thread.currentThread()) break;
                Thread.yield();
            }
            sleepTime = Math.max(10L, (long)this.stepDelay - (System.currentTimeMillis() - currentTime));
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ie) {}
        }
    }

    public DynamicDoubleMatrix2D runSync() {
        while (!(!(this.theODE.getState()[this.numberOfNodes] <= (double)this.timeMax) || this.isStopAtSteadyState.booleanValue() && this.testForStableState())) {
            this.doStep();
        }
        return this.getResults();
    }

    public synchronized void start() {
        if (this.animationThread != null) {
            return;
        }
        this.animationThread = new Thread(this);
        this.animationThread.setPriority(5);
        this.animationThread.setDaemon(true);
        this.animationThread.start();
    }

    public synchronized void stop() {
        if (this.animationThread == null) {
            return;
        }
        Thread tempThread = this.animationThread;
        this.animationThread = null;
        if (Thread.currentThread() == tempThread) {
            return;
        }
        if (tempThread != null && tempThread != Thread.currentThread()) {
            try {
                tempThread.interrupt();
                tempThread.join(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void resetAnimation() {
        if (this.animationThread != null) {
            this.stop();
        }
    }

    public List<AbstractGraphNode> getNodes() {
        return this.nodeList;
    }

    @Override
    public void registerObserver(IObserver observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    @Override
    public void removeObserver(IObserver observer) {
        if (this.observers.contains(observer)) {
            int obsIndex = this.observers.indexOf(observer);
            this.observers.remove(obsIndex);
            this.observers.trimToSize();
        }
        if (observer == null) {
            this.observers.clear();
        }
    }

    public Double getCurrentSimulationTime() {
        if (this.theODE != null && this.nodeList.size() > 0) {
            return this.theODE.getState()[this.nodeList.size()];
        }
        return 0.0;
    }

    public boolean testForStableState() {
        if (this.mainResultValues.rows() < 2) {
            return false;
        }
        DoubleMatrix1D previousResultRow = this.mainResultValues.viewRow(this.mainResultValues.rows() - 2);
        DoubleMatrix1D lastResultRow = this.mainResultValues.viewRow(this.mainResultValues.rows() - 1);
        boolean isSteady = true;
        for (int z = 1; z < this.mainResultValues.columns(); ++z) {
            if (!(Math.abs(lastResultRow.get(z) - previousResultRow.get(z)) > this.resolution)) continue;
            isSteady = false;
            break;
        }
        this.points_inside_resolution = isSteady ? (this.points_inside_resolution += 1.0) : 0.0;
        if (this.points_inside_resolution >= (double)(this.points_to_be_steady * this.slicesPerUnit)) {
            this.is_steady_state = true;
            return true;
        }
        this.is_steady_state = false;
        return false;
    }

    public DecoratedDoubleMatrix2D getResults() {
        return this.mainResultValues;
    }

    public String getResultsAsString() {
        StringBuilder out = new StringBuilder();
        String headers = "";
        for (Object colName : this.mainResultValues.getColumnHeaders()) {
            headers = headers + colName.toString() + "\t";
        }
        headers = headers.trim();
        out.append(headers + "\n");
        String data = "";
        for (int row = 0; row < this.mainResultValues.rows(); ++row) {
            data = "";
            for (int column = 0; column < this.mainResultValues.columns(); ++column) {
                data = data + String.valueOf(this.mainResultValues.get(row, column)) + "\t";
            }
            data = data.trim();
            out.append(data + "\n");
        }
        return out.toString();
    }

    public static void main(String[] args) {
        try {
            String fileName = "samples/2states.mml";
            GraphContainer grCont = new GraphContainer(fileName);
            ODESystemSolver theSimulator = new ODESystemSolver(grCont);
            theSimulator.initialize();
            theSimulator.runSync();
            System.out.println(theSimulator.getResultsAsString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getNodePrefix() {
        return this.nodePrefix;
    }

    public void setNodePrefix(String nodePrefix) {
        this.nodePrefix = nodePrefix;
    }

    public int getStepDelay() {
        return this.stepDelay;
    }

    public void setStepDelay(int stepDelay) {
        this.stepDelay = stepDelay;
    }

    public int getTimeMax() {
        return this.timeMax;
    }

    public void setTimeMax(int timeMax) {
        this.timeMax = timeMax;
    }

    public int getSlicesPerUnit() {
        return this.slicesPerUnit;
    }

    public void setSlicesPerUnit(int slicesPerUnit) {
        this.slicesPerUnit = slicesPerUnit;
    }

    public Boolean getStopAtSteadyState() {
        return this.isStopAtSteadyState;
    }

    public void setStopAtSteadyState(Boolean isStopAtSteadyState) {
        this.isStopAtSteadyState = isStopAtSteadyState;
    }

    public void dispose() {
        this.mainResultValues.dispose();
    }
}

