/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.dl;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MMLFileHandler
extends DefaultHandler {
    private Graph mmlGraph;
    private StringLabeller mmlLabeller;

    protected Graph getGraph() {
        return this.mmlGraph;
    }

    protected StringLabeller getLabeller() {
        return this.mmlLabeller;
    }

    private Map getAttributeMap(Attributes attrs) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                map.put(attrs.getQName(i), attrs.getValue(i));
            }
        }
        return map;
    }

    protected void createGraph(Map attributeMap) {
        this.mmlGraph = new DirectedSparseGraph();
        this.mmlLabeller = StringLabeller.getLabeller((Graph)this.mmlGraph);
        for (Object key : attributeMap.keySet()) {
            Object value = attributeMap.get(key);
            this.mmlGraph.setUserDatum(key, value, UserData.SHARED);
        }
    }

    protected Edge createEdge(Map attributeMap) {
        String sourceId = (String)attributeMap.get("source");
        Vertex sourceVertex = this.mmlLabeller.getVertex(sourceId);
        String targetId = (String)attributeMap.get("target");
        Vertex targetVertex = this.mmlLabeller.getVertex(targetId);
        Edge theEdge = GraphUtils.addEdge((Graph)this.mmlGraph, (Vertex)sourceVertex, (Vertex)targetVertex);
        for (Object key : attributeMap.keySet()) {
            Object value = attributeMap.get(key);
            theEdge.setUserDatum(key, value, UserData.SHARED);
        }
        return theEdge;
    }

    protected ArchetypeVertex createNode(Map attributeMap) {
        if (this.mmlGraph == null) {
            throw new FatalException("Error parsing graph. Graph element must be specified before node element.");
        }
        Vertex theNode = this.mmlGraph.addVertex((Vertex)new SparseVertex());
        String idString = (String)attributeMap.get("id");
        try {
            this.mmlLabeller.setLabel(theNode, idString);
        }
        catch (StringLabeller.UniqueLabelException ule) {
            throw new FatalException("Ids must be unique");
        }
        for (Object key : attributeMap.keySet()) {
            Object value = attributeMap.get(key);
            theNode.setUserDatum(key, value, UserData.SHARED);
        }
        return theNode;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        Map attributeMap = this.getAttributeMap(attrs);
        if (qName.toLowerCase().equals("graph")) {
            this.createGraph(attributeMap);
        } else if (qName.toLowerCase().equals("node")) {
            this.createNode(attributeMap);
        } else if (qName.toLowerCase().equals("edge")) {
            this.createEdge(attributeMap);
        }
    }
}

