/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.guiutils;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.bl.NodeValueState;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.guiutils.IGUIXMLMappable;
import org.enfin.squad.guiutils.PropertiesMap;
import org.enfin.squad.perturbations.bl.AbstractGraphAction;
import org.enfin.squad.perturbations.bl.Perturbator;
import org.enfin.squad.perturbations.bl.Protocol;

public class GUIFactory {
    public static final int COMPONENT_HEIGHT = 5;
    public static final String[] GRAPHNODE_PARAMETERS = new String[]{"state", "decay", "gain"};
    public static final String[] GRAPHEDGE_PARAMETERS = new String[]{"weight", "sign"};

    public static Component getComponent(final PropertiesMap prop, final IGUIXMLMappable mappable, Protocol prot, GraphContainer gr) {
        if (mappable.getClass().getGenericSuperclass() == AbstractGraphAction.class && prop.propertyName == "target") {
            JComboBox jt = GUIFactory.getComboBox();
            jt.setBackground(Color.white);
            for (AbstractGraphNode nd : gr.getNodes()) {
                jt.addItem(nd.getName());
            }
            jt.setSelectedItem(prop.value);
            jt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    prop.value = ((JComboBox)arg0.getSource()).getSelectedItem();
                    mappable.getPropertyMaps().put(prop.propertyName, prop);
                }
            });
            return jt;
        }
        if (mappable.getClass().equals(NodeValueState.class) && prop.propertyName == "id") {
            JComboBox jt = GUIFactory.getComboBox();
            jt.setBackground(Color.white);
            for (AbstractGraphNode nd : gr.getNodes()) {
                jt.addItem(nd.getName());
            }
            jt.setSelectedItem(prop.value);
            jt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    prop.value = ((JComboBox)arg0.getSource()).getSelectedItem().toString();
                    mappable.getPropertyMaps().put(prop.propertyName, prop);
                }
            });
            return jt;
        }
        if (mappable.getClass().getGenericSuperclass() == AbstractGraphAction.class && prop.propertyName == "parameter") {
            JComboBox jt = GUIFactory.getComboBox();
            jt.setBackground(Color.white);
            for (String st : GRAPHNODE_PARAMETERS) {
                jt.addItem(st);
            }
            jt.setSelectedItem(prop.value);
            jt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    prop.value = ((JComboBox)arg0.getSource()).getSelectedItem();
                    mappable.getPropertyMaps().put(prop.propertyName, prop);
                }
            });
            return jt;
        }
        if (mappable.getClass() == Perturbator.class && prop.propertyName == "initialstate") {
            JComboBox jt = GUIFactory.getComboBox();
            jt.setBackground(Color.white);
            for (NetworkState st : prot.getStates()) {
                jt.addItem(st.getId());
            }
            jt.setSelectedItem(prop.value);
            jt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    prop.value = ((JComboBox)arg0.getSource()).getSelectedItem();
                    mappable.getPropertyMaps().put(prop.propertyName, prop);
                }
            });
            return jt;
        }
        if (prop.classType == String.class) {
            JTextField jt = GUIFactory.getTextBox();
            jt.setText((String)prop.value);
            jt.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent arg0) {
                }

                @Override
                public void insertUpdate(DocumentEvent arg0) {
                    try {
                        Document dc = arg0.getDocument();
                        prop.value = dc.getText(0, dc.getLength());
                        mappable.getPropertyMaps().put(prop.propertyName, prop);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent arg0) {
                    try {
                        Document dc = arg0.getDocument();
                        prop.value = dc.getText(0, dc.getLength());
                        mappable.getPropertyMaps().put(prop.propertyName, prop);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            });
            return jt;
        }
        if (prop.classType == Double.class) {
            SpinnerNumberModel model = new SpinnerNumberModel();
            model.setValue(0.0);
            model.setStepSize(0.1);
            JSpinner jt = GUIFactory.getSpinner(model);
            jt.setValue(prop.value);
            jt.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    JSpinner sp = (JSpinner)arg0.getSource();
                    SpinnerNumberModel mod = (SpinnerNumberModel)sp.getModel();
                    prop.value = mod.getNumber().doubleValue();
                    mappable.getPropertyMaps().put(prop.propertyName, prop);
                }
            });
            return jt;
        }
        return null;
    }

    public static JTextField getTextBox() {
        JTextField jt = new JTextField();
        jt.setSize(50, 5);
        jt.setForeground(Color.BLUE);
        return jt;
    }

    public static JSpinner getSpinner(SpinnerModel md) {
        JSpinner jt = new JSpinner(md);
        jt.setSize(20, 5);
        jt.setForeground(Color.BLUE);
        return jt;
    }

    public static JComboBox getComboBox() {
        JComboBox jt = new JComboBox();
        jt.setSize(20, 5);
        jt.setForeground(Color.BLUE);
        return jt;
    }

    public static JLabel getLabel() {
        JLabel jt = new JLabel();
        jt.setSize(20, 5);
        jt.setHorizontalAlignment(4);
        jt.setVerticalAlignment(0);
        return jt;
    }
}

