/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.perturbations.pl;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.compbiollab.datavisualization.ReportFrame;
import org.compbiollab.squad2.AppProperties;
import org.compbiollab.squad2.Log4JConfigurator;
import org.enfin.squad.bl.IObservable;
import org.enfin.squad.bl.IObserver;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.bl.ode.ODESystemSolver;
import org.enfin.squad.dl.FileFilterNetwork;
import org.enfin.squad.dl.FileUtils;
import org.enfin.squad.dl.FileViewNetwork;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.perturbations.bl.ODESytemSolverPoolPerturbation;
import org.enfin.squad.perturbations.bl.Perturbator;
import org.enfin.squad.perturbations.bl.Protocol;
import org.enfin.squad.perturbations.bl.ProtocolFactory;
import org.enfin.squad.perturbations.pl.DisplayNodeTableModel;
import org.enfin.squad.perturbations.pl.EditFrame;
import org.enfin.squad.perturbations.pl.TileAction;
import org.enfin.squad.pl.GraphAnimator;
import org.enfin.squad.pl.PlotFrameDisplay;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class PerturbationFrame
extends JFrame
implements IObserver {
    private static final Logger log = Logger.getLogger(PerturbationFrame.class);
    private static final long serialVersionUID = 1L;
    ODESytemSolverPoolPerturbation odeSolverPool;
    ArrayList<PlotFrameDisplay> plots = new ArrayList();
    ArrayList<GraphAnimator> graphs = new ArrayList();
    int simulationCounter = 0;
    GraphContainer grCont;
    Protocol prot;
    JTable tblInitialState;
    List<NetworkState> states;
    HashMap<String, JInternalFrame> currentPanels = new HashMap();
    private JButton butEditPerturbation;
    private ButtonGroup butGroup;
    private JButton butInitialize;
    private JButton butLoadNetwork;
    private JButton butLoadProtocol;
    private JButton butReset;
    private JButton butRunSimulation;
    private JButton butStepRunSimulation;
    private JButton butStepStopSimulation;
    private JButton butViewNetwork;
    private JButton butViewReport;
    private JRadioButton chkCompleteSimulation;
    private JRadioButton chkProgrSimulation;
    private JComboBox cmbAnalysisList;
    private JDesktopPane deskPlayGround;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JLabel lblMaxTime;
    private JLabel lblMaxTime1;
    private JCheckBoxMenuItem mnuChkEraseWindows;
    private JCheckBoxMenuItem mnuChkTile;
    private JMenuItem mnuErase;
    private JMenuBar mnuMain;
    private JMenuItem mnuTile;
    private JMenu mnuWindows;
    private JPanel pnlCompleteSimulation;
    private JPanel pnlLogo;
    private JScrollPane pnlNodeVisibility;
    private JPanel pnlProgressiveSimulation;
    private JPanel pnlResults;
    private JPanel pnlRunType;
    private JPanel pnlSimulationControls;
    private JPanel pnlSimulatorTabs;
    private JSlider slideSpeed;
    private JTabbedPane tabsPerturb;
    private JSpinner txtMaxTime;
    private JTextField txtNetworkFile;
    private JTextField txtPerturbFile;
    private JSpinner txtSlices;

    public static void main(String[] args) {
        Log4JConfigurator.configureLog4J(AppProperties.LOG4JCONFIG);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PerturbationFrame("test_sets/THelper_network.xml", "test_sets/THelper_perturbation.prt").setVisible(true);
            }
        });
    }

    public PerturbationFrame() {
        this.initComponents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PerturbationFrame.this.closeWindowEvents();
            }
        });
        this.setTitle("SQUAD");
        ClassLoader cl = this.getClass().getClassLoader();
        ImageIcon im = new ImageIcon(cl.getResource("images/SquadLogo.png"));
        this.setTitle("Squad Perturbation Desk");
        this.pnlLogo.setLayout(new BorderLayout());
        JLabel jl = new JLabel(im);
        this.pnlLogo.add((Component)jl, "North");
        this.pnlProgressiveSimulation.setVisible(false);
        this.pnlResults.setVisible(false);
    }

    public PerturbationFrame(String networkFileName, String perturbationFileName) {
        this();
        if (networkFileName != null && !networkFileName.equals("")) {
            this.loadNetwork(networkFileName);
        }
        if (perturbationFileName != null && !perturbationFileName.equals("")) {
            this.loadPerturbation(perturbationFileName);
        }
    }

    public PerturbationFrame(GraphContainer gr) {
        this();
        try {
            this.grCont = (GraphContainer)gr.clone();
            this.txtNetworkFile.setText(this.grCont.getFileName());
            this.loadNodeVisibilityTable();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public PerturbationFrame(String networkFileName) {
        this(networkFileName, (String)null);
    }

    @Override
    public void updateObserver(IObservable obsvble, Object args) {
        if (obsvble.getClass() == ODESystemSolver.class) {
            this.deskPlayGround.repaint();
        }
    }

    private void initializeAll() {
        if (this.grCont == null) {
            JOptionPane.showMessageDialog(this, "You need to load a valid network file", "Initialization warning", 2);
            return;
        }
        if (this.prot == null) {
            JOptionPane.showMessageDialog(this, "You need to load a valid perturbation file", "Initialization warning", 2);
            return;
        }
        if (this.mnuChkEraseWindows.isSelected()) {
            this.deskPlayGround.removeAll();
            this.tabsPerturb.removeAll();
        }
        try {
            if (this.odeSolverPool != null) {
                this.odeSolverPool.dispose();
                this.odeSolverPool = null;
            }
            this.odeSolverPool = new ODESytemSolverPoolPerturbation(this.grCont, this.prot);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this, "The network file could not be read", "Initialization warning", 0);
            this.grCont = null;
            this.txtNetworkFile.setText("");
            return;
        }
        int simCounter = 0;
        this.graphs.clear();
        this.plots.clear();
        for (ODESystemSolver sim : this.odeSolverPool) {
            PlotFrameDisplay plt = new PlotFrameDisplay("time", "state", "dynamic simulation", this);
            plt.setTitle(this.prot.getPerturbations().get(simCounter).getId());
            this.plots.add(plt);
            JInternalFrame jt = plt.getAsInternalFrame(false);
            jt.setClosable(true);
            jt.setMaximizable(true);
            jt.setResizable(true);
            jt.setVisible(true);
            jt.setSize(new Dimension(500, 300));
            this.currentPanels.put(this.prot.getPerturbations().get(simCounter).getId() + "_PLOT", jt);
            this.deskPlayGround.add(jt);
            try {
                jt.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            jt.setVisible(true);
            sim.registerObserver(plt);
            ++simCounter;
        }
        this.setControlsForSimulationStart();
        if (this.mnuChkTile.isSelected()) {
            TileAction.tile(this.deskPlayGround);
        }
    }

    private void loadNetwork(String networkFileName) {
        try {
            this.grCont = null;
            this.grCont = new GraphContainer(networkFileName);
            this.txtNetworkFile.setText(this.grCont.getFileName());
            this.loadNodeVisibilityTable();
            this.prot = null;
            this.txtPerturbFile.setText("");
        }
        catch (IOException e) {
            this.txtNetworkFile.setText("");
            JOptionPane.showMessageDialog(this, "An error occurred while parsing the network file", "Initialization warning", 0);
            this.grCont = null;
            this.txtNetworkFile.setText("");
        }
    }

    private void loadPerturbation(String perturbationFileName) {
        try {
            this.txtPerturbFile.setText(perturbationFileName);
            this.prot = ProtocolFactory.generate(perturbationFileName);
        }
        catch (Exception e) {
            this.prot = null;
            this.txtPerturbFile.setText("");
            JOptionPane.showMessageDialog(this, "An error occurred while parsing the perturbation file", "Initialization warning", 0);
            log.error((Object)"An error occurred while parsing the perturbation file", (Throwable)e);
            e.printStackTrace();
            return;
        }
    }

    private void loadNodeVisibilityTable() {
        DisplayNodeTableModel initTableModel = new DisplayNodeTableModel(this.grCont.getNodes());
        this.tblInitialState = new JTable(initTableModel);
        this.pnlNodeVisibility.getViewport().removeAll();
        this.pnlNodeVisibility.getViewport().add(this.tblInitialState);
        TableCellRenderer tcr = this.tblInitialState.getDefaultRenderer(String.class);
        DefaultTableCellRenderer dtcr = (DefaultTableCellRenderer)tcr;
        dtcr.setHorizontalAlignment(0);
        dtcr.setForeground(Color.blue);
        TableCellRenderer tcr1 = this.tblInitialState.getDefaultRenderer(Double.class);
        DefaultTableCellRenderer dtcr1 = (DefaultTableCellRenderer)tcr1;
        dtcr1.setHorizontalAlignment(0);
    }

    private void viewNetwork() {
        if (this.grCont != null) {
            GraphAnimator gr = new GraphAnimator(this.grCont.getGraph(), GraphAnimator.DEFAULT_COLOR());
            gr.setVisible(true);
        }
    }

    public void runSimulation() {
        this.odeSolverPool.runSimulation(this.chkCompleteSimulation.isSelected(), (Integer)this.txtMaxTime.getValue(), (Integer)this.txtSlices.getValue());
        this.pnlSimulatorTabs.removeAll();
        this.pnlSimulatorTabs.add(this.plots.get(0).getLegendFrame());
        this.pnlSimulatorTabs.validate();
        this.deskPlayGround.repaint();
        this.displayResultPanel();
    }

    public void startStepSimulation() {
        this.butStepStopSimulation.setEnabled(true);
        this.butStepRunSimulation.setEnabled(false);
        this.butRunSimulation.setEnabled(false);
        this.txtMaxTime.setEnabled(false);
        this.txtSlices.setEnabled(false);
        this.odeSolverPool.registerObserver(this);
        this.odeSolverPool.startStepSimulation(this.slideSpeed.getValue());
        this.pnlSimulatorTabs.removeAll();
        this.pnlSimulatorTabs.add(this.plots.get(0).getLegendFrame());
        this.pnlSimulatorTabs.validate();
        this.pnlResults.setVisible(false);
    }

    public void stopStepSimulation() {
        this.butStepStopSimulation.setEnabled(false);
        this.odeSolverPool.stopStepSimulation();
        this.butStepRunSimulation.setEnabled(true);
        this.displayResultPanel();
    }

    public void reset() {
        this.butInitialize.setEnabled(true);
        this.butReset.setEnabled(false);
        this.butEditPerturbation.setEnabled(true);
        this.tblInitialState.setEnabled(true);
        this.butRunSimulation.setEnabled(false);
        this.txtMaxTime.setEnabled(false);
        this.txtSlices.setEnabled(false);
        this.chkProgrSimulation.setEnabled(false);
        this.chkCompleteSimulation.setEnabled(false);
        this.butStepRunSimulation.setEnabled(false);
        this.butStepStopSimulation.setEnabled(false);
        this.slideSpeed.setEnabled(false);
        this.graphs.clear();
        this.plots.clear();
        this.odeSolverPool.reset();
        this.butLoadNetwork.setEnabled(true);
        this.butLoadProtocol.setEnabled(true);
        this.butEditPerturbation.setEnabled(true);
        this.txtNetworkFile.setEnabled(true);
        this.txtPerturbFile.setEnabled(true);
        this.pnlResults.setVisible(false);
    }

    private void displayResultPanel() {
        this.pnlResults.setVisible(true);
        this.cmbAnalysisList.removeAllItems();
        for (Perturbator prt : this.prot.getPerturbations()) {
            this.cmbAnalysisList.addItem(prt.getId());
        }
    }

    private void viewReport() {
        final int reportIndex = this.cmbAnalysisList.getSelectedIndex();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (reportIndex > -1) {
                    ReportFrame rp = new ReportFrame(((ODESystemSolver)PerturbationFrame.this.odeSolverPool.get(reportIndex)).getResults(), PerturbationFrame.this.cmbAnalysisList.getSelectedItem().toString());
                    rp.setVisible(true);
                }
            }
        });
    }

    private void editPerturbationFile() {
        EditFrame ed;
        if (this.grCont == null) {
            JOptionPane.showMessageDialog(this, "You need to load a network file first", "Edit protocol", 1);
        }
        if (this.prot == null) {
            ed = new EditFrame(this.grCont);
            log.info((Object)"edit default protocol");
        } else {
            ed = new EditFrame(this.grCont, (Protocol)this.prot.clone());
            log.info((Object)"edit existing protocol");
        }
        ed.setModal(true);
        ed.setVisible(true);
        File newProtocolFile = null;
        if (ed.getValue() != 0) {
            log.info((Object)"do not modify protocol");
            return;
        }
        int result = JOptionPane.showConfirmDialog(this, "Save changes to file?\n If you choose NO, the edited protocol will be kept in memory and used\n but will erased when the application is closed", "Edit protocol", 0);
        try {
            if (result == 0) {
                newProtocolFile = PerturbationFrame.saveProtocolToFile(ed.getProtocol(), this.txtPerturbFile.getText());
                log.info((Object)"protocol file updated");
                this.txtPerturbFile.setText(newProtocolFile.getAbsolutePath());
            } else {
                newProtocolFile = PerturbationFrame.createTempProtocolFile(ed.getProtocol());
                log.info((Object)"protocol replaced with new protocol from temp file");
            }
            if (newProtocolFile != null) {
                this.prot = ProtocolFactory.generate(newProtocolFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            log.error((Object)"Error writing the modified protocol file", (Throwable)e);
            JOptionPane.showMessageDialog(this, "Error writing the modified protocol file", "Edit protocol", 0);
        }
        catch (Exception e) {
            log.error((Object)"Error re-loading the modified protocol file", (Throwable)e);
            JOptionPane.showMessageDialog(this, "Error re-loading the modified protocol file", "Edit protocol", 0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File saveProtocolToFile(Protocol prot, String fileName) throws IOException {
        File fileOut = null;
        if (fileName == null || fileName.equals("")) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.addChoosableFileFilter(new FileFilterNetwork(new String[]{"prt"}));
            fileChooser.setFileView(new FileViewNetwork());
            int returnValue = fileChooser.showSaveDialog(null);
            if (returnValue != 0) return null;
            fileOut = FileUtils.changeFileExtension("prt", fileChooser.getSelectedFile(), true);
        } else {
            fileOut = new File(fileName);
        }
        EditFrame.saveToFile(prot, fileOut.getAbsolutePath().toString());
        return fileOut;
    }

    private static File createTempProtocolFile(Protocol prot) throws IOException {
        File tmp = File.createTempFile("squad_protocol", ".tmp");
        EditFrame.saveToFile(prot, tmp.getAbsolutePath().toString());
        tmp.deleteOnExit();
        return tmp;
    }

    public void setControlsForSimulationStart() {
        this.butInitialize.setEnabled(false);
        this.butReset.setEnabled(true);
        this.butEditPerturbation.setEnabled(false);
        this.tblInitialState.setEnabled(false);
        this.butLoadNetwork.setEnabled(false);
        this.butLoadProtocol.setEnabled(false);
        this.butEditPerturbation.setEnabled(false);
        this.txtNetworkFile.setEnabled(false);
        this.txtPerturbFile.setEnabled(false);
        this.butRunSimulation.setEnabled(true);
        this.txtMaxTime.setEnabled(true);
        this.txtSlices.setEnabled(true);
        this.lblMaxTime.setEnabled(true);
        this.lblMaxTime1.setEnabled(true);
        this.chkProgrSimulation.setEnabled(true);
        this.chkCompleteSimulation.setEnabled(true);
        this.butStepRunSimulation.setEnabled(true);
        this.butStepStopSimulation.setEnabled(false);
        this.slideSpeed.setEnabled(true);
        if (this.chkProgrSimulation.isSelected()) {
            this.pnlCompleteSimulation.setVisible(false);
            this.pnlProgressiveSimulation.setVisible(true);
        } else {
            this.pnlCompleteSimulation.setVisible(true);
            this.pnlProgressiveSimulation.setVisible(false);
        }
    }

    public void updateDelayTime() {
        this.odeSolverPool.updateDelayTime(this.slideSpeed.getValue());
    }

    public void closeWindowEvents() {
        if (this.odeSolverPool != null) {
            this.odeSolverPool.dispose();
        }
    }

    private void initComponents() {
        this.butGroup = new ButtonGroup();
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.tabsPerturb = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.butLoadNetwork = new JButton();
        this.txtNetworkFile = new JTextField();
        this.butLoadProtocol = new JButton();
        this.txtPerturbFile = new JTextField();
        this.pnlLogo = new JPanel();
        this.pnlSimulationControls = new JPanel();
        this.pnlCompleteSimulation = new JPanel();
        this.butRunSimulation = new JButton();
        this.txtMaxTime = new JSpinner();
        this.lblMaxTime = new JLabel();
        this.txtSlices = new JSpinner();
        this.lblMaxTime1 = new JLabel();
        this.pnlProgressiveSimulation = new JPanel();
        this.butStepRunSimulation = new JButton();
        this.butStepStopSimulation = new JButton();
        this.slideSpeed = new JSlider();
        this.jLabel2 = new JLabel();
        this.pnlRunType = new JPanel();
        this.chkCompleteSimulation = new JRadioButton();
        this.chkProgrSimulation = new JRadioButton();
        this.butInitialize = new JButton();
        this.butReset = new JButton();
        this.pnlNodeVisibility = new JScrollPane();
        this.butEditPerturbation = new JButton();
        this.butViewNetwork = new JButton();
        this.pnlResults = new JPanel();
        this.cmbAnalysisList = new JComboBox();
        this.jLabel1 = new JLabel();
        this.butViewReport = new JButton();
        this.pnlSimulatorTabs = new JPanel();
        this.deskPlayGround = new JDesktopPane();
        this.mnuMain = new JMenuBar();
        this.mnuWindows = new JMenu();
        this.mnuTile = new JMenuItem();
        this.mnuErase = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.mnuChkTile = new JCheckBoxMenuItem();
        this.mnuChkEraseWindows = new JCheckBoxMenuItem();
        this.setDefaultCloseOperation(3);
        this.jSplitPane2.setDividerLocation(600);
        this.jSplitPane2.setOrientation(0);
        this.tabsPerturb.setTabLayoutPolicy(1);
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.tabsPerturb.addTab("All perturbations", this.jPanel1);
        this.jSplitPane2.setBottomComponent(this.tabsPerturb);
        this.jPanel3.setBackground(new Color(204, 204, 204));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel3.setOpaque(false);
        this.butLoadNetwork.setText("Load Network");
        this.butLoadNetwork.setToolTipText("Initialize or reset the simulation");
        this.butLoadNetwork.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.butLoadNetworkActionPerformed(evt);
            }
        });
        this.txtNetworkFile.setEditable(false);
        this.txtNetworkFile.setForeground(new Color(51, 51, 255));
        this.txtNetworkFile.setHorizontalAlignment(4);
        this.butLoadProtocol.setText("Load Protocol");
        this.butLoadProtocol.setToolTipText("Initialize or reset the simulation");
        this.butLoadProtocol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.butLoadProtocolActionPerformed(evt);
            }
        });
        this.txtPerturbFile.setEditable(false);
        this.txtPerturbFile.setForeground(new Color(51, 51, 255));
        this.txtPerturbFile.setHorizontalAlignment(4);
        this.pnlLogo.setOpaque(false);
        GroupLayout pnlLogoLayout = new GroupLayout((Container)this.pnlLogo);
        this.pnlLogo.setLayout((LayoutManager)pnlLogoLayout);
        pnlLogoLayout.setHorizontalGroup((GroupLayout.Group)pnlLogoLayout.createParallelGroup(1).add(0, 308, Short.MAX_VALUE));
        pnlLogoLayout.setVerticalGroup((GroupLayout.Group)pnlLogoLayout.createParallelGroup(1).add(0, 69, Short.MAX_VALUE));
        this.pnlSimulationControls.setLayout((LayoutManager)new AbsoluteLayout());
        this.pnlSimulationControls.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Simulation controls"));
        this.pnlSimulationControls.setFont(new Font("Tahoma", 0, 10));
        this.pnlSimulationControls.setOpaque(false);
        this.pnlCompleteSimulation.setLayout(new GridBagLayout());
        this.pnlCompleteSimulation.setAlignmentX(0.0f);
        this.pnlCompleteSimulation.setAlignmentY(0.0f);
        this.pnlCompleteSimulation.setEnabled(false);
        this.pnlCompleteSimulation.setFont(new Font("Tahoma", 0, 10));
        this.pnlCompleteSimulation.setMaximumSize(new Dimension(26, 30));
        this.pnlCompleteSimulation.setMinimumSize(new Dimension(26, 30));
        this.pnlCompleteSimulation.setOpaque(false);
        this.pnlCompleteSimulation.setPreferredSize(new Dimension(26, 30));
        this.butRunSimulation.setText("Run");
        this.butRunSimulation.setToolTipText("Run the analysis");
        this.butRunSimulation.setAlignmentX(0.5f);
        this.butRunSimulation.setEnabled(false);
        this.butRunSimulation.setPreferredSize(new Dimension(57, 20));
        this.butRunSimulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.butRunSimulationActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.pnlCompleteSimulation.add((Component)this.butRunSimulation, gridBagConstraints);
        this.txtMaxTime.setToolTipText("Maximum time of the simulation");
        this.txtMaxTime.setEnabled(false);
        this.txtMaxTime.setMaximumSize(new Dimension(15, 18));
        this.txtMaxTime.setMinimumSize(new Dimension(15, 18));
        this.txtMaxTime.setPreferredSize(new Dimension(50, 18));
        this.txtMaxTime.setValue(100);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.pnlCompleteSimulation.add((Component)this.txtMaxTime, gridBagConstraints);
        this.lblMaxTime.setFont(new Font("Tahoma", 0, 10));
        this.lblMaxTime.setHorizontalAlignment(0);
        this.lblMaxTime.setText("max time");
        this.lblMaxTime.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 3;
        this.pnlCompleteSimulation.add((Component)this.lblMaxTime, gridBagConstraints);
        this.txtSlices.setToolTipText("Number of timepoints per unit opf time to collect");
        this.txtSlices.setEnabled(false);
        this.txtSlices.setPreferredSize(new Dimension(40, 20));
        this.txtSlices.setValue(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 4;
        this.pnlCompleteSimulation.add((Component)this.txtSlices, gridBagConstraints);
        this.lblMaxTime1.setFont(new Font("Tahoma", 0, 10));
        this.lblMaxTime1.setHorizontalAlignment(0);
        this.lblMaxTime1.setText("slices / time");
        this.lblMaxTime1.setEnabled(false);
        this.lblMaxTime1.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 4;
        this.pnlCompleteSimulation.add((Component)this.lblMaxTime1, gridBagConstraints);
        this.pnlSimulationControls.add((Component)this.pnlCompleteSimulation, new AbsoluteConstraints(10, 40, 290, 30));
        this.pnlProgressiveSimulation.setLayout(new GridBagLayout());
        this.pnlProgressiveSimulation.setBackground(new Color(204, 204, 255));
        this.pnlProgressiveSimulation.setAlignmentX(0.0f);
        this.pnlProgressiveSimulation.setAlignmentY(0.0f);
        this.pnlProgressiveSimulation.setFont(new Font("Tahoma", 0, 10));
        this.pnlProgressiveSimulation.setOpaque(false);
        this.butStepRunSimulation.setText("Start");
        this.butStepRunSimulation.setToolTipText("Run the simulation in a step-wise manner");
        this.butStepRunSimulation.setAlignmentX(0.5f);
        this.butStepRunSimulation.setEnabled(false);
        this.butStepRunSimulation.setPreferredSize(new Dimension(57, 20));
        this.butStepRunSimulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.butStepRunSimulationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 14);
        this.pnlProgressiveSimulation.add((Component)this.butStepRunSimulation, gridBagConstraints);
        this.butStepStopSimulation.setText("Stop");
        this.butStepStopSimulation.setToolTipText("Stop the simulation");
        this.butStepStopSimulation.setAlignmentX(0.5f);
        this.butStepStopSimulation.setEnabled(false);
        this.butStepStopSimulation.setPreferredSize(new Dimension(55, 20));
        this.butStepStopSimulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.butStepStopSimulationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.pnlProgressiveSimulation.add((Component)this.butStepStopSimulation, gridBagConstraints);
        this.slideSpeed.setBackground(new Color(255, 255, 255));
        this.slideSpeed.setForeground(new Color(0, 0, 0));
        this.slideSpeed.setMaximum(500);
        this.slideSpeed.setMinimum(10);
        this.slideSpeed.setToolTipText("Speed of the simulation");
        this.slideSpeed.setValue(100);
        this.slideSpeed.setAlignmentX(0.0f);
        this.slideSpeed.setAlignmentY(0.0f);
        this.slideSpeed.setEnabled(false);
        this.slideSpeed.setExtent(2);
        this.slideSpeed.setInverted(true);
        this.slideSpeed.setOpaque(false);
        this.slideSpeed.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                PerturbationFrame.this.slideSpeedMouseReleased(evt);
            }
        });
        this.pnlProgressiveSimulation.add((Component)this.slideSpeed, new GridBagConstraints());
        this.jLabel2.setFont(new Font("Tahoma", 0, 10));
        this.jLabel2.setText(" speed");
        this.pnlProgressiveSimulation.add((Component)this.jLabel2, new GridBagConstraints());
        this.pnlSimulationControls.add((Component)this.pnlProgressiveSimulation, new AbsoluteConstraints(10, 70, 400, 30));
        this.pnlRunType.setLayout(new GridLayout(1, 2));
        this.pnlRunType.setEnabled(false);
        this.butGroup.add(this.chkCompleteSimulation);
        this.chkCompleteSimulation.setSelected(true);
        this.chkCompleteSimulation.setText("Complete simulation");
        this.chkCompleteSimulation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkCompleteSimulation.setEnabled(false);
        this.chkCompleteSimulation.setMargin(new Insets(0, 0, 0, 0));
        this.chkCompleteSimulation.setOpaque(false);
        this.chkCompleteSimulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.chkCompleteSimulationActionPerformed(evt);
            }
        });
        this.pnlRunType.add(this.chkCompleteSimulation);
        this.butGroup.add(this.chkProgrSimulation);
        this.chkProgrSimulation.setText("Progressive simulation");
        this.chkProgrSimulation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkProgrSimulation.setEnabled(false);
        this.chkProgrSimulation.setMargin(new Insets(0, 0, 0, 0));
        this.chkProgrSimulation.setOpaque(false);
        this.chkProgrSimulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.chkProgrSimulationActionPerformed(evt);
            }
        });
        this.pnlRunType.add(this.chkProgrSimulation);
        this.pnlSimulationControls.add((Component)this.pnlRunType, new AbsoluteConstraints(20, 20, 300, 20));
        this.butInitialize.setText("Initialize ");
        this.butInitialize.setToolTipText("Initialize or reset the simulation");
        this.butInitialize.setPreferredSize(new Dimension(100, 20));
        this.butInitialize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.butInitializeActionPerformed(evt);
            }
        });
        this.butReset.setText("Reset");
        this.butReset.setToolTipText("Initialize or reset the simulation");
        this.butReset.setEnabled(false);
        this.butReset.setPreferredSize(new Dimension(100, 20));
        this.butReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.butResetActionPerformed(evt);
            }
        });
        this.pnlNodeVisibility.setBackground(new Color(255, 255, 255));
        this.pnlNodeVisibility.setBorder(BorderFactory.createTitledBorder("Options"));
        this.pnlNodeVisibility.setAlignmentX(0.0f);
        this.pnlNodeVisibility.setAlignmentY(0.0f);
        this.pnlNodeVisibility.setFont(new Font("Tahoma", 0, 10));
        this.pnlNodeVisibility.setOpaque(false);
        this.butEditPerturbation.setText("Edit Protocol");
        this.butEditPerturbation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.butEditPerturbationActionPerformed(evt);
            }
        });
        this.butViewNetwork.setText("View Network");
        this.butViewNetwork.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.butViewNetworkActionPerformed(evt);
            }
        });
        this.pnlResults.setBackground(new Color(255, 204, 102));
        this.pnlResults.setBorder(BorderFactory.createTitledBorder(new LineBorder(new Color(0, 0, 0), 1, true), "Results"));
        this.cmbAnalysisList.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel1.setText("Analysis:");
        this.butViewReport.setText("View Report");
        this.butViewReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.butViewReportActionPerformed(evt);
            }
        });
        GroupLayout pnlResultsLayout = new GroupLayout((Container)this.pnlResults);
        this.pnlResults.setLayout((LayoutManager)pnlResultsLayout);
        pnlResultsLayout.setHorizontalGroup((GroupLayout.Group)pnlResultsLayout.createParallelGroup(1).add((GroupLayout.Group)pnlResultsLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.cmbAnalysisList, 0, 233, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.butViewReport).add(37, 37, 37)));
        pnlResultsLayout.setVerticalGroup((GroupLayout.Group)pnlResultsLayout.createParallelGroup(1).add((GroupLayout.Group)pnlResultsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)pnlResultsLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.butViewReport).add((Component)this.cmbAnalysisList, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.pnlResults, -1, -1, Short.MAX_VALUE).add((Component)this.pnlNodeVisibility, -1, 434, Short.MAX_VALUE).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.pnlLogo, -2, -1, -2).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(2, false).add((Component)this.butLoadProtocol, -1, -1, Short.MAX_VALUE).add((Component)this.butLoadNetwork, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1, false).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.txtPerturbFile, -2, 203, -2).addPreferredGap(0).add((Component)this.butEditPerturbation, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.txtNetworkFile, -2, 203, -2).addPreferredGap(0).add((Component)this.butViewNetwork))))).addContainerGap(23, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addPreferredGap(0).add((Component)this.butInitialize, -2, -1, -2).addPreferredGap(0).add((Component)this.butReset, -2, 108, -2).addContainerGap()).add((Component)this.pnlSimulationControls, -1, 434, Short.MAX_VALUE))));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.pnlLogo, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.butLoadNetwork).add((Component)this.txtNetworkFile, -2, -1, -2).add((Component)this.butViewNetwork)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.txtPerturbFile, -2, -1, -2).add((Component)this.butLoadProtocol).add((Component)this.butEditPerturbation)).add(22, 22, 22).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.butInitialize, -2, -1, -2).add((Component)this.butReset, -2, -1, -2)).addPreferredGap(0).add((Component)this.pnlSimulationControls, -2, 109, -2).addPreferredGap(0).add((Component)this.pnlNodeVisibility, -2, 213, -2).addPreferredGap(0).add((Component)this.pnlResults, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane2.setTopComponent(this.jPanel3);
        this.pnlSimulatorTabs.setLayout(new BorderLayout());
        this.pnlSimulatorTabs.setBackground(new Color(204, 204, 255));
        this.pnlSimulatorTabs.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.pnlSimulatorTabs.setOpaque(false);
        this.jSplitPane2.setRightComponent(this.pnlSimulatorTabs);
        this.jSplitPane1.setLeftComponent(this.jSplitPane2);
        this.deskPlayGround.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.deskPlayGround.setAutoscrolls(true);
        this.deskPlayGround.setDragMode(1);
        this.jSplitPane1.setRightComponent(this.deskPlayGround);
        this.mnuWindows.setText("Windows");
        this.mnuTile.setText("Tile windows");
        this.mnuTile.setToolTipText("Tiles the plot windows");
        this.mnuTile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.mnuTileActionPerformed(evt);
            }
        });
        this.mnuWindows.add(this.mnuTile);
        this.mnuErase.setText("Clear windows");
        this.mnuErase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PerturbationFrame.this.mnuEraseActionPerformed(evt);
            }
        });
        this.mnuWindows.add(this.mnuErase);
        this.mnuWindows.add(this.jSeparator1);
        this.mnuChkTile.setSelected(true);
        this.mnuChkTile.setText("Tile windows on Initialize");
        this.mnuChkTile.setToolTipText("Tile the plots at each initialization");
        this.mnuWindows.add(this.mnuChkTile);
        this.mnuChkEraseWindows.setSelected(true);
        this.mnuChkEraseWindows.setText("Auto erase windows on initialize");
        this.mnuChkEraseWindows.setToolTipText("If checked, at every initialization all the graphs and plots are cleared");
        this.mnuWindows.add(this.mnuChkEraseWindows);
        this.mnuMain.add(this.mnuWindows);
        this.setJMenuBar(this.mnuMain);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSplitPane1, -1, 1135, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSplitPane1, -1, 770, Short.MAX_VALUE));
        this.pack();
    }

    private void butViewReportActionPerformed(ActionEvent evt) {
        this.viewReport();
    }

    private void butViewNetworkActionPerformed(ActionEvent evt) {
        this.viewNetwork();
    }

    private void butEditPerturbationActionPerformed(ActionEvent evt) {
        this.editPerturbationFile();
    }

    private void mnuEraseActionPerformed(ActionEvent evt) {
        this.deskPlayGround.removeAll();
    }

    private void mnuTileActionPerformed(ActionEvent evt) {
        TileAction.tile(this.deskPlayGround);
    }

    private void butResetActionPerformed(ActionEvent evt) {
        this.reset();
    }

    private void butInitializeActionPerformed(ActionEvent evt) {
        this.initializeAll();
    }

    private void chkProgrSimulationActionPerformed(ActionEvent evt) {
        this.pnlCompleteSimulation.setVisible(false);
        this.pnlProgressiveSimulation.setVisible(true);
    }

    private void chkCompleteSimulationActionPerformed(ActionEvent evt) {
        this.pnlCompleteSimulation.setVisible(true);
        this.pnlProgressiveSimulation.setVisible(false);
    }

    private void slideSpeedMouseReleased(MouseEvent evt) {
        if (this.slideSpeed.isEnabled()) {
            this.updateDelayTime();
        }
    }

    private void butStepStopSimulationActionPerformed(ActionEvent evt) {
        this.stopStepSimulation();
    }

    private void butStepRunSimulationActionPerformed(ActionEvent evt) {
        this.startStepSimulation();
    }

    private void butRunSimulationActionPerformed(ActionEvent evt) {
        try {
            this.runSimulation();
        }
        catch (OutOfMemoryError e) {
            JOptionPane.showMessageDialog(this, "Out of memory error \n The computation was not completed \n Try increasing the heap space size by chaning the -Xmx value in the Squad.bat or Squad.sh file", "Memory error", 0);
            e.printStackTrace();
        }
    }

    private void butLoadProtocolActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilterNetwork(new String[]{"prt"}));
        fileChooser.setFileView(new FileViewNetwork());
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.loadPerturbation(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void butLoadNetworkActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileFilterNetwork(new String[]{"net", "xml", "mml", "mml"}));
        fileChooser.setFileView(new FileViewNetwork());
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.loadNetwork(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    static {
        try {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new SyntheticaStandardLookAndFeel());
                String sysVersion = System.getProperty("java.version");
                if (Integer.parseInt(((Object)sysVersion.subSequence(2, 3)).toString()) < 6) {
                    JOptionPane.showMessageDialog(null, "JAVA version 1.6 or above is required to run this applications, some features might not function properly ", "Java Version Warning", 2);
                }
                if (!System.getProperty("os.name").startsWith("Windows")) {
                    SyntheticaLookAndFeel.setExtendedFileChooserEnabled((boolean)false);
                }
            }
            catch (UnsupportedLookAndFeelException e) {
                e.printStackTrace();
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

