/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.perturbations.pl;

import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.enfin.squad.bl.ode.ODESystemSolver;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.perturbations.bl.Perturbator;
import org.enfin.squad.perturbations.bl.Protocol;
import org.enfin.squad.perturbations.bl.ProtocolFactory;
import org.enfin.squad.perturbations.pl.PerturbationFrame;

public class Perturbation_Main {
    public static void main(String[] args) {
        String networkFileName = args[0];
        String perturbatorFileName = args[1];
        if (args.length > 2 && args[2].equals("-d")) {
            Perturbation_Main.perturbOdeInteractive(networkFileName, perturbatorFileName);
        } else {
            Perturbation_Main.perturbOde(networkFileName, perturbatorFileName);
        }
    }

    public static void perturbOdeInteractive(String networkFileName, String perturbatorFileName) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        PerturbationFrame pertFrame = new PerturbationFrame(networkFileName, perturbatorFileName);
        pertFrame.setVisible(true);
        pertFrame.pack();
    }

    public static void perturbOde(String networkFileName, String perturbatorFileName) {
        Protocol perturbations;
        try {
            perturbations = ProtocolFactory.generate(perturbatorFileName);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error reading perturbation file", e.getMessage().toString(), 0);
            return;
        }
        try {
            int iterator = 1;
            for (Perturbator pert : perturbations) {
                GraphContainer gr = new GraphContainer(networkFileName);
                ODESystemSolver ode = new ODESystemSolver(gr);
                ode.setStopAtSteadyState(true);
                ode.initialize();
                if (iterator > 1) {
                    ode.setNodePrefix("pert" + iterator);
                }
                ode.runSync();
                System.out.println(ode.getResultsAsString());
                System.out.println();
                ++iterator;
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error reading network file", e.getMessage().toString(), 0);
            return;
        }
    }
}

