/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.pl;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.enfin.squad.bl.IEdge;

public class EdgesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    String[] columnNames = new String[]{"Source", "Sign", "Target", "Weight"};
    ArrayList<IEdge> edgeList = new ArrayList();

    public EdgesTableModel() {
    }

    public EdgesTableModel(ArrayList<IEdge> edges) {
        this.edgeList = edges;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.edgeList.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        IEdge ed = this.edgeList.get(row);
        switch (col) {
            case 0: {
                return ed.getSource();
            }
            case 1: {
                if (ed.getSign().equals("positive")) {
                    return "---->";
                }
                return "----|";
            }
            case 2: {
                return ed.getTarget();
            }
            case 3: {
                return ed.getInitialWeight();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        IEdge ed = this.edgeList.get(rowIndex);
        switch (columnIndex) {
            case 3: {
                ed.setInitialWeight((Double)aValue, true);
                super.setValueAt(aValue, rowIndex, columnIndex);
            }
        }
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 3;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }
}

