/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.pl;

import com.sun.org.apache.regexp.internal.RESyntaxException;
import com.tlabs.dcolt.DecoratedDoubleMatrix2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.compbiollab.dynamicalsystem.OctaveExport;
import org.enfin.squad.bl.AbstractGraphNode;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.bl.ode.ODESystemSolver;
import org.enfin.squad.dl.FileFilterNetwork;
import org.enfin.squad.dl.FileUtils;
import org.enfin.squad.dl.FileViewNetwork;
import org.enfin.squad.dl.GraphContainer;
import org.enfin.squad.perturbations.bl.Perturbator;
import org.enfin.squad.pl.DialNotepad;
import org.enfin.squad.pl.EdgesTableModel;
import org.enfin.squad.pl.GUI;
import org.enfin.squad.pl.GraphAnimator;
import org.enfin.squad.pl.InitialStateTableModel;
import org.enfin.squad.pl.PlotFrameDisplay;
import org.enfin.squad.pl.SpinnerCellEditor;
import org.enfin.squad.pl.StatesCellRender;
import org.enfin.squad.pl.SteadyStateSelector;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class OdeSimulatorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GraphContainer grCont;
    private JTable tblInitialState;
    private JTable tblEdges;
    private ODESystemSolver theODESystemSolver;
    private List<NetworkState> theSteadyStates = new ArrayList<NetworkState>();
    private PlotFrameDisplay plot = null;
    private Perturbator pert;
    private Container parentGUI = null;
    private GraphAnimator theGraphAnimator = null;
    private InitialStateTableModel initTableModel;
    private boolean isStandAlone = false;
    private JButton butExportOctave;
    private JButton butInitialize;
    private JButton butLoadStates;
    private JButton butReset;
    private JButton butRunSimulation;
    private JButton butSaveNetworkStates;
    private JButton butShowData;
    private JButton butShowGraph;
    private JButton butStepRunSimulation;
    private JButton butStepStopSimulation;
    private JCheckBox chkColorByNodeName;
    private JRadioButton chkCompleteSimulation;
    private JCheckBox chkDisplayNetwork;
    private JCheckBox chkOptimalTime;
    private JRadioButton chkProgrSimulation;
    private ButtonGroup grpAuto_ManualSim;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JTabbedPane jTabbedPane1;
    private JLabel lblMaxTime;
    private JLabel lblMaxTime1;
    private JLabel lblSS;
    private JPanel pnlCompleteSimulation;
    private JScrollPane pnlEdges;
    private JPanel pnlProgressiveSimulation;
    private JPanel pnlRunType;
    private JScrollPane pnlSStates;
    private JPanel pnlSimulationControls;
    private JPanel pnlTimeSimulation1;
    private JSlider slideSpeed;
    private JSpinner txtMaxTime;
    private JTextField txtNumbStates;
    private JSpinner txtSlices;

    public static void main(String[] args) throws IOException, RESyntaxException {
        String fileName = "samples/2statesMML.mml";
        OdeSimulatorPanel theSimulator = new OdeSimulatorPanel(fileName, null);
        JFrame mainFrame = new JFrame();
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setResizable(false);
        mainFrame.add((Component)theSimulator, "Center");
        mainFrame.setVisible(true);
    }

    public OdeSimulatorPanel(boolean standalone) {
        this.initComponents();
        if (this.isStandAlone) {
            this.butShowData.setVisible(false);
            this.isStandAlone = true;
        } else {
            this.butShowData.setVisible(true);
            this.isStandAlone = false;
        }
        this.pnlProgressiveSimulation.setVisible(false);
        this.chkCompleteSimulation.setEnabled(false);
        this.chkProgrSimulation.setEnabled(false);
    }

    public OdeSimulatorPanel(GraphContainer gr, Container parent) {
        this(parent == null);
        this.parentGUI = parent;
        this.loadNetworkDataFromGraph(gr);
        try {
            this.loadSteadyStates(this.grCont.getStates());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.theSteadyStates.size() > 0) {
            this.butLoadStates.setEnabled(true);
        }
    }

    public OdeSimulatorPanel(String fileName, Container parent) throws IOException {
        this(new GraphContainer(fileName), parent);
    }

    public DecoratedDoubleMatrix2D getCurrentResults() {
        return this.theODESystemSolver.getResults();
    }

    private void loadSteadyStates(List<NetworkState> sStates) {
        this.theSteadyStates.clear();
        if (sStates != null) {
            if (this.grCont.getNodes().size() > 0 && sStates.size() > 0) {
                this.theSteadyStates = sStates;
                this.txtNumbStates.setText(String.valueOf(this.theSteadyStates.size()));
                this.theSteadyStates.get(0).fillNodesWithState(this.grCont.getNodes(), true);
                this.fillInitialStateTable();
            }
        } else {
            this.txtNumbStates.setText("0");
        }
    }

    public void loadNetworkDataFromGraph(GraphContainer inputGraph) {
        this.grCont = inputGraph;
        Collections.sort(this.grCont.getNodes(), new AbstractGraphNode.NodeSorter());
        this.fillInitialStateTable();
        this.fillEdges();
    }

    public void setAutoRunParemeters(boolean stopAtSS, int maxTime, int timeSlices) {
        this.chkOptimalTime.setSelected(stopAtSS);
        this.txtMaxTime.setValue(maxTime);
        this.txtSlices.setValue(timeSlices);
    }

    public void saveNetwork() {
        Integer dialResult = JOptionPane.showOptionDialog(this, "Would you also like to save the current node and edge configuration ?", "Save network", 1, 3, null, null, 0);
        if (dialResult == 2) {
            return;
        }
        JFileChooser savDi = new JFileChooser();
        savDi.setAcceptAllFileFilterUsed(false);
        savDi.addChoosableFileFilter(new FileFilterNetwork(new String[]{"mml"}));
        savDi.setFileView(new FileViewNetwork());
        if (savDi.showSaveDialog(this) == 0) {
            try {
                File fileOut = FileUtils.changeFileExtension("mml", savDi.getSelectedFile(), true);
                if (fileOut == null) {
                    return;
                }
                GraphContainer.saveGraphFromFile(this.grCont.getGraph(), this.theSteadyStates, fileOut, dialResult.equals(0));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "An error has occurred while saving the file", 0);
                e.printStackTrace();
            }
        }
    }

    public void loadNetworkDataFromFile(String fileName) {
        try {
            this.theSteadyStates = null;
            this.grCont = null;
            GraphContainer grCont = new GraphContainer(fileName);
            this.initComponents();
            this.loadNetworkDataFromGraph(grCont);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void fillInitialStateTable() {
        this.initTableModel = new InitialStateTableModel(this.grCont.getNodes().toArray(new AbstractGraphNode[0]));
        this.tblInitialState = new JTable(this.initTableModel);
        this.tblInitialState.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblInitialState.setDefaultRenderer(Object.class, new StatesCellRender());
        this.tblInitialState.setSurrendersFocusOnKeystroke(true);
        this.tblInitialState.getColumnModel().getColumn(2).setCellEditor(new SpinnerCellEditor(0.0, 1.0, 0.1));
        this.tblInitialState.getColumnModel().getColumn(3).setCellEditor(new SpinnerCellEditor(1.0, null, 1.0));
        this.tblInitialState.getColumnModel().getColumn(4).setCellEditor(new SpinnerCellEditor(0.0, 1000.0, 1.0));
        this.pnlSStates.getViewport().removeAll();
        this.pnlSStates.getViewport().add(this.tblInitialState);
    }

    private void fillEdges() {
        this.tblEdges = new JTable(new EdgesTableModel(this.grCont.getEdges()));
        this.tblEdges.setDefaultRenderer(Object.class, new StatesCellRender());
        this.pnlEdges.getViewport().removeAll();
        this.pnlEdges.getViewport().add(this.tblEdges);
    }

    public void setSteadyStateVisibility(boolean isVisible) {
        this.txtNumbStates.setVisible(isVisible);
        this.butLoadStates.setVisible(isVisible);
        this.lblSS.setVisible(isVisible);
        this.butSaveNetworkStates.setVisible(isVisible);
    }

    public void setLoadButtonsVisibility(boolean isVisible) {
    }

    public void initializeSimulation() {
        this.plot = null;
        this.plot = new PlotFrameDisplay("time", "state", "dynamic simulation", this.parentGUI);
        this.theODESystemSolver = null;
        if (this.theODESystemSolver != null) {
            this.resetResultDataOnGUI();
            this.theODESystemSolver.dispose();
        }
        this.theODESystemSolver = new ODESystemSolver(this.grCont, this.pert);
        this.theODESystemSolver.initialize();
        if (this.pert != null) {
            this.plot.setTitle(this.pert.getId());
        }
        this.theODESystemSolver.registerObserver(this.plot);
        if (this.theGraphAnimator != null) {
            this.theODESystemSolver.registerObserver(this.theGraphAnimator);
            this.theGraphAnimator.updateDisplay();
        }
        this.setControlsForSimulationStart();
    }

    private void initializeVisualization() {
        if (this.plot != null) {
            this.showPlot();
        }
        if (this.chkDisplayNetwork.isSelected() && this.theGraphAnimator == null) {
            this.displayNetwork();
            this.theGraphAnimator.setLocation(new Point(this.plot.getX(), this.plot.getY() + this.plot.getHeight() + 1));
        }
    }

    public void showPlot() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OdeSimulatorPanel.this.plot.setVisible(true);
            }
        });
    }

    public PlotFrameDisplay getPlot() {
        return this.plot;
    }

    public void showPlotAsIntFrame(Container parentContainer, final boolean displayLegend) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JInternalFrame jt = OdeSimulatorPanel.this.plot.getAsInternalFrame(displayLegend);
                jt.setVisible(true);
            }
        });
    }

    public void runSimulation() {
        if (this.chkOptimalTime.isSelected()) {
            this.theODESystemSolver.setStopAtSteadyState(true);
        } else {
            this.theODESystemSolver.setStopAtSteadyState(false);
            this.theODESystemSolver.setTimeMax((Integer)this.txtMaxTime.getValue());
            this.theODESystemSolver.setSlicesPerUnit((Integer)this.txtSlices.getValue());
        }
        this.butInitialize.setEnabled(false);
        this.butStepRunSimulation.setEnabled(false);
        this.butStepStopSimulation.setEnabled(false);
        this.slideSpeed.setEnabled(false);
        this.plot.setColorByName(this.chkColorByNodeName.isSelected());
        this.chkColorByNodeName.setEnabled(false);
        this.theODESystemSolver.runSync();
        this.reset();
        this.plot.repaint();
        this.displayResultDataToGUI();
    }

    public void startStepSimulation(int initialSpeed) {
        this.butStepStopSimulation.setEnabled(true);
        this.butStepRunSimulation.setEnabled(false);
        this.butRunSimulation.setEnabled(false);
        this.chkOptimalTime.setEnabled(false);
        this.txtMaxTime.setEnabled(false);
        this.txtSlices.setEnabled(false);
        this.butShowData.setEnabled(false);
        this.theODESystemSolver.setStepDelay(initialSpeed);
        this.plot.setColorByName(this.chkColorByNodeName.isSelected());
        this.chkColorByNodeName.setEnabled(false);
        this.theODESystemSolver.start();
    }

    public void stopStepSimulation() {
        this.theODESystemSolver.stop();
        this.chkOptimalTime.setEnabled(true);
        this.butStepStopSimulation.setEnabled(false);
        this.butStepRunSimulation.setEnabled(true);
        this.butShowData.setEnabled(true);
    }

    public void reset() {
        this.tblEdges.setEnabled(true);
        this.tblInitialState.setEnabled(true);
        this.butInitialize.setEnabled(true);
        this.butReset.setEnabled(false);
        this.butRunSimulation.setEnabled(false);
        this.chkOptimalTime.setEnabled(false);
        this.txtMaxTime.setEnabled(false);
        this.txtSlices.setEnabled(false);
        this.chkProgrSimulation.setEnabled(false);
        this.chkCompleteSimulation.setEnabled(false);
        this.butStepRunSimulation.setEnabled(false);
        this.chkOptimalTime.setEnabled(false);
        this.butStepStopSimulation.setEnabled(false);
        this.slideSpeed.setEnabled(false);
        this.butShowData.setEnabled(false);
        this.chkColorByNodeName.setEnabled(true);
        if (this.theGraphAnimator != null) {
            this.theODESystemSolver.removeObserver(this.theGraphAnimator);
            this.theGraphAnimator.updateDisplay();
        }
        this.tblEdges.setEnabled(true);
        this.tblInitialState.setEnabled(true);
    }

    public void setControlsForSimulationStart() {
        this.butInitialize.setEnabled(false);
        this.butReset.setEnabled(true);
        this.butRunSimulation.setEnabled(true);
        this.chkOptimalTime.setEnabled(true);
        this.chkOptimalTimeStateChanged(null);
        this.chkProgrSimulation.setEnabled(true);
        this.chkCompleteSimulation.setEnabled(true);
        this.butStepRunSimulation.setEnabled(true);
        this.butStepStopSimulation.setEnabled(false);
        this.butShowData.setEnabled(false);
        this.slideSpeed.setEnabled(true);
        this.tblEdges.setEnabled(false);
        this.tblInitialState.setEnabled(false);
    }

    public void displayNetwork() {
        this.theGraphAnimator = new GraphAnimator(this.grCont.getGraph(), GraphAnimator.ANIMATED_COLOR());
        if (this.theODESystemSolver != null) {
            this.theODESystemSolver.registerObserver(this.theGraphAnimator);
        }
        this.theGraphAnimator.setVisible(true);
    }

    public void hideNetwork() {
        this.theODESystemSolver.removeObserver(this.theGraphAnimator);
        this.theGraphAnimator.setVisible(false);
    }

    public void setShowSimulationControls(boolean show) {
        this.pnlSimulationControls.setVisible(show);
        this.butInitialize.setVisible(show);
        this.butReset.setVisible(show);
        this.chkDisplayNetwork.setVisible(false);
        this.chkDisplayNetwork.setSelected(show);
        if (!show) {
            // empty if block
        }
    }

    private void displayResultDataToGUI() {
        if (this.parentGUI != null) {
            this.tblEdges.setEnabled(true);
            this.tblInitialState.setEnabled(true);
            this.butInitialize.setEnabled(true);
            this.butRunSimulation.setEnabled(false);
            this.butStepRunSimulation.setEnabled(false);
            this.butStepStopSimulation.setEnabled(false);
            this.chkOptimalTime.setEnabled(false);
            this.chkOptimalTimeStateChanged(null);
            ((GUI)this.parentGUI).showResults(this.grCont.getNodes(), this.getCurrentResults());
        }
    }

    private void resetResultDataOnGUI() {
        if (this.parentGUI != null) {
            ((GUI)this.parentGUI).eraseResults();
        }
    }

    private void displaySteadyStateSelector() {
        SteadyStateSelector ssSelect = new SteadyStateSelector(this.theSteadyStates, this.grCont.getGraph());
        ssSelect.setModal(true);
        ssSelect.setVisible(true);
        Integer selectedStateIndex = ssSelect.getSelectedStateIndex();
        if (selectedStateIndex != null) {
            this.theSteadyStates.get(selectedStateIndex).fillNodesWithState(this.grCont.getNodes(), true);
            this.fillInitialStateTable();
        }
    }

    public void updateDelayTime(int time) {
        if (this.theODESystemSolver != null) {
            this.theODESystemSolver.setStepDelay(time);
        }
    }

    public void exportToOctave() {
        String octOut = null;
        octOut = OctaveExport.getTextForOctave(this.grCont, Integer.valueOf(this.txtMaxTime.getValue().toString()), Integer.valueOf(this.txtSlices.getValue().toString()));
        new DialNotepad((Frame)new JFrame(), true, octOut, "Octave Script").setVisible(true);
    }

    public ODESystemSolver getODESystemSolver() {
        return this.theODESystemSolver;
    }

    private void initComponents() {
        this.grpAuto_ManualSim = new ButtonGroup();
        this.butLoadStates = new JButton();
        this.lblSS = new JLabel();
        this.txtNumbStates = new JTextField();
        this.pnlSimulationControls = new JPanel();
        this.pnlCompleteSimulation = new JPanel();
        this.butRunSimulation = new JButton();
        this.chkOptimalTime = new JCheckBox();
        this.txtMaxTime = new JSpinner();
        this.lblMaxTime = new JLabel();
        this.txtSlices = new JSpinner();
        this.lblMaxTime1 = new JLabel();
        this.pnlProgressiveSimulation = new JPanel();
        this.butStepRunSimulation = new JButton();
        this.butStepStopSimulation = new JButton();
        this.butShowData = new JButton();
        this.slideSpeed = new JSlider();
        this.jLabel2 = new JLabel();
        this.pnlRunType = new JPanel();
        this.chkCompleteSimulation = new JRadioButton();
        this.chkProgrSimulation = new JRadioButton();
        this.butInitialize = new JButton();
        this.butReset = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.pnlSStates = new JScrollPane();
        this.pnlEdges = new JScrollPane();
        this.pnlTimeSimulation1 = new JPanel();
        this.chkColorByNodeName = new JCheckBox();
        this.chkDisplayNetwork = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.butExportOctave = new JButton();
        this.butSaveNetworkStates = new JButton();
        this.butShowGraph = new JButton();
        this.butLoadStates.setText("Load Steady State");
        this.butLoadStates.setToolTipText("Selects a node configuration from the computed steady-states");
        this.butLoadStates.setEnabled(false);
        this.butLoadStates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OdeSimulatorPanel.this.butLoadStatesActionPerformed(evt);
            }
        });
        this.lblSS.setFont(new Font("Tahoma", 0, 12));
        this.lblSS.setText("Steady states found:");
        this.txtNumbStates.setEditable(false);
        this.txtNumbStates.setFont(new Font("Tahoma", 0, 12));
        this.txtNumbStates.setForeground(new Color(51, 102, 255));
        this.txtNumbStates.setHorizontalAlignment(0);
        this.txtNumbStates.setToolTipText("Number of steady-states identified by the logical analysis of the network");
        this.txtNumbStates.setOpaque(false);
        this.pnlSimulationControls.setLayout((LayoutManager)new AbsoluteLayout());
        this.pnlSimulationControls.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Simulation controls"));
        this.pnlSimulationControls.setFont(new Font("Tahoma", 0, 10));
        this.pnlSimulationControls.setOpaque(false);
        this.pnlCompleteSimulation.setLayout(new GridBagLayout());
        this.pnlCompleteSimulation.setAlignmentX(0.0f);
        this.pnlCompleteSimulation.setAlignmentY(0.0f);
        this.pnlCompleteSimulation.setEnabled(false);
        this.pnlCompleteSimulation.setFont(new Font("Tahoma", 0, 10));
        this.pnlCompleteSimulation.setMaximumSize(new Dimension(26, 30));
        this.pnlCompleteSimulation.setMinimumSize(new Dimension(26, 30));
        this.pnlCompleteSimulation.setOpaque(false);
        this.pnlCompleteSimulation.setPreferredSize(new Dimension(26, 30));
        this.butRunSimulation.setText("Run");
        this.butRunSimulation.setToolTipText("Run the analysis");
        this.butRunSimulation.setAlignmentX(0.5f);
        this.butRunSimulation.setEnabled(false);
        this.butRunSimulation.setPreferredSize(new Dimension(57, 20));
        this.butRunSimulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OdeSimulatorPanel.this.butRunSimulationActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 4;
        this.pnlCompleteSimulation.add((Component)this.butRunSimulation, gridBagConstraints);
        this.chkOptimalTime.setFont(new Font("Tahoma", 0, 10));
        this.chkOptimalTime.setSelected(true);
        this.chkOptimalTime.setText("Stop at std-state");
        this.chkOptimalTime.setToolTipText("If checked the simulation stops as soon as a steady state is reached");
        this.chkOptimalTime.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkOptimalTime.setEnabled(false);
        this.chkOptimalTime.setMargin(new Insets(0, 0, 0, 0));
        this.chkOptimalTime.setMinimumSize(new Dimension(200, 13));
        this.chkOptimalTime.setOpaque(false);
        this.chkOptimalTime.setPreferredSize(new Dimension(110, 13));
        this.chkOptimalTime.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OdeSimulatorPanel.this.chkOptimalTimeStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 9, 0, 4);
        this.pnlCompleteSimulation.add((Component)this.chkOptimalTime, gridBagConstraints);
        this.txtMaxTime.setToolTipText("Maximum time of the simulation");
        this.txtMaxTime.setEnabled(false);
        this.txtMaxTime.setMaximumSize(new Dimension(15, 18));
        this.txtMaxTime.setMinimumSize(new Dimension(15, 18));
        this.txtMaxTime.setPreferredSize(new Dimension(50, 18));
        this.txtMaxTime.setValue(100);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.pnlCompleteSimulation.add((Component)this.txtMaxTime, gridBagConstraints);
        this.lblMaxTime.setFont(new Font("Tahoma", 0, 10));
        this.lblMaxTime.setHorizontalAlignment(0);
        this.lblMaxTime.setText("max time");
        this.lblMaxTime.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 3;
        this.pnlCompleteSimulation.add((Component)this.lblMaxTime, gridBagConstraints);
        this.txtSlices.setToolTipText("Number of timepoints per unit opf time to collect");
        this.txtSlices.setEnabled(false);
        this.txtSlices.setPreferredSize(new Dimension(40, 20));
        this.txtSlices.setValue(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 4;
        this.pnlCompleteSimulation.add((Component)this.txtSlices, gridBagConstraints);
        this.lblMaxTime1.setFont(new Font("Tahoma", 0, 10));
        this.lblMaxTime1.setHorizontalAlignment(0);
        this.lblMaxTime1.setText("slices / time");
        this.lblMaxTime1.setEnabled(false);
        this.lblMaxTime1.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 4;
        this.pnlCompleteSimulation.add((Component)this.lblMaxTime1, gridBagConstraints);
        this.pnlSimulationControls.add((Component)this.pnlCompleteSimulation, new AbsoluteConstraints(0, 40, 410, 30));
        this.pnlProgressiveSimulation.setLayout(new GridBagLayout());
        this.pnlProgressiveSimulation.setBackground(new Color(204, 204, 255));
        this.pnlProgressiveSimulation.setAlignmentX(0.0f);
        this.pnlProgressiveSimulation.setAlignmentY(0.0f);
        this.pnlProgressiveSimulation.setFont(new Font("Tahoma", 0, 10));
        this.pnlProgressiveSimulation.setOpaque(false);
        this.butStepRunSimulation.setText("Start");
        this.butStepRunSimulation.setToolTipText("Run the simulation in a step-wise manner");
        this.butStepRunSimulation.setAlignmentX(0.5f);
        this.butStepRunSimulation.setEnabled(false);
        this.butStepRunSimulation.setPreferredSize(new Dimension(57, 20));
        this.butStepRunSimulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OdeSimulatorPanel.this.butStepRunSimulationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 14);
        this.pnlProgressiveSimulation.add((Component)this.butStepRunSimulation, gridBagConstraints);
        this.butStepStopSimulation.setText("Stop");
        this.butStepStopSimulation.setToolTipText("Stop the simulation");
        this.butStepStopSimulation.setAlignmentX(0.5f);
        this.butStepStopSimulation.setEnabled(false);
        this.butStepStopSimulation.setPreferredSize(new Dimension(55, 20));
        this.butStepStopSimulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OdeSimulatorPanel.this.butStepStopSimulationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.pnlProgressiveSimulation.add((Component)this.butStepStopSimulation, gridBagConstraints);
        this.butShowData.setText("Results");
        this.butShowData.setToolTipText("Display the numerical results of the simulation");
        this.butShowData.setAlignmentX(0.5f);
        this.butShowData.setEnabled(false);
        this.butShowData.setMinimumSize(new Dimension(90, 23));
        this.butShowData.setPreferredSize(new Dimension(67, 20));
        this.butShowData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OdeSimulatorPanel.this.butShowDataActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.pnlProgressiveSimulation.add((Component)this.butShowData, gridBagConstraints);
        this.slideSpeed.setBackground(new Color(255, 255, 255));
        this.slideSpeed.setForeground(new Color(0, 0, 0));
        this.slideSpeed.setMaximum(500);
        this.slideSpeed.setMinimum(10);
        this.slideSpeed.setToolTipText("Speed of the simulation");
        this.slideSpeed.setValue(100);
        this.slideSpeed.setAlignmentX(0.0f);
        this.slideSpeed.setAlignmentY(0.0f);
        this.slideSpeed.setEnabled(false);
        this.slideSpeed.setExtent(2);
        this.slideSpeed.setInverted(true);
        this.slideSpeed.setOpaque(false);
        this.slideSpeed.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                OdeSimulatorPanel.this.slideSpeedMouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 32;
        gridBagConstraints.anchor = 17;
        this.pnlProgressiveSimulation.add((Component)this.slideSpeed, gridBagConstraints);
        this.jLabel2.setFont(new Font("Tahoma", 0, 10));
        this.jLabel2.setText(" speed");
        this.pnlProgressiveSimulation.add((Component)this.jLabel2, new GridBagConstraints());
        this.pnlSimulationControls.add((Component)this.pnlProgressiveSimulation, new AbsoluteConstraints(0, 70, 410, 30));
        this.pnlRunType.setLayout(new GridLayout(1, 2));
        this.pnlRunType.setEnabled(false);
        this.grpAuto_ManualSim.add(this.chkCompleteSimulation);
        this.chkCompleteSimulation.setSelected(true);
        this.chkCompleteSimulation.setText("Complete simulation");
        this.chkCompleteSimulation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkCompleteSimulation.setMargin(new Insets(0, 0, 0, 0));
        this.chkCompleteSimulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OdeSimulatorPanel.this.chkCompleteSimulationActionPerformed(evt);
            }
        });
        this.pnlRunType.add(this.chkCompleteSimulation);
        this.grpAuto_ManualSim.add(this.chkProgrSimulation);
        this.chkProgrSimulation.setText("Progressive simulation");
        this.chkProgrSimulation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkProgrSimulation.setMargin(new Insets(0, 0, 0, 0));
        this.chkProgrSimulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OdeSimulatorPanel.this.chkProgrSimulationActionPerformed(evt);
            }
        });
        this.pnlRunType.add(this.chkProgrSimulation);
        this.pnlSimulationControls.add((Component)this.pnlRunType, new AbsoluteConstraints(20, 20, 300, 20));
        this.butInitialize.setText("Initialize ");
        this.butInitialize.setToolTipText("Initialize or reset the simulation");
        this.butInitialize.setPreferredSize(new Dimension(100, 20));
        this.butInitialize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OdeSimulatorPanel.this.butInitializeActionPerformed(evt);
            }
        });
        this.butReset.setText("Reset");
        this.butReset.setToolTipText("Initialize or reset the simulation");
        this.butReset.setEnabled(false);
        this.butReset.setPreferredSize(new Dimension(100, 20));
        this.butReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OdeSimulatorPanel.this.butResetActionPerformed(evt);
            }
        });
        this.pnlSStates.setBackground(new Color(255, 255, 255));
        this.pnlSStates.setBorder(BorderFactory.createTitledBorder("Current Node Configuration"));
        this.pnlSStates.setAlignmentX(0.0f);
        this.pnlSStates.setAlignmentY(0.0f);
        this.pnlSStates.setFont(new Font("Tahoma", 0, 10));
        this.pnlSStates.setOpaque(false);
        this.jTabbedPane1.addTab("Nodes", this.pnlSStates);
        this.pnlEdges.setBackground(new Color(255, 255, 255));
        this.pnlEdges.setBorder(BorderFactory.createTitledBorder("Current Edge Configuration"));
        this.pnlEdges.setAlignmentX(0.0f);
        this.pnlEdges.setAlignmentY(0.0f);
        this.pnlEdges.setFont(new Font("Tahoma", 0, 10));
        this.pnlEdges.setOpaque(false);
        this.jTabbedPane1.addTab("Edges", this.pnlEdges);
        this.jTabbedPane1.getAccessibleContext().setAccessibleName("Nodes");
        this.pnlTimeSimulation1.setLayout(new GridLayout(3, 0));
        this.pnlTimeSimulation1.setBorder(BorderFactory.createTitledBorder(null, "Options"));
        this.pnlTimeSimulation1.setAlignmentX(0.0f);
        this.pnlTimeSimulation1.setAlignmentY(0.0f);
        this.pnlTimeSimulation1.setEnabled(false);
        this.pnlTimeSimulation1.setFont(new Font("Tahoma", 0, 10));
        this.pnlTimeSimulation1.setMaximumSize(new Dimension(26, 30));
        this.pnlTimeSimulation1.setMinimumSize(new Dimension(26, 30));
        this.pnlTimeSimulation1.setOpaque(false);
        this.pnlTimeSimulation1.setPreferredSize(new Dimension(26, 30));
        this.chkColorByNodeName.setText("Color plot by node name");
        this.chkColorByNodeName.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkColorByNodeName.setMargin(new Insets(0, 0, 0, 0));
        this.pnlTimeSimulation1.add(this.chkColorByNodeName);
        this.chkDisplayNetwork.setSelected(true);
        this.chkDisplayNetwork.setText("Always display network during simulations");
        this.chkDisplayNetwork.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkDisplayNetwork.setMargin(new Insets(0, 0, 0, 0));
        this.pnlTimeSimulation1.add(this.chkDisplayNetwork);
        this.butExportOctave.setText("Export to Octave");
        this.butExportOctave.setToolTipText("Exports the ODEs to the OCTAVE numerical solver");
        this.butExportOctave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OdeSimulatorPanel.this.butExportOctaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.butExportOctave).addContainerGap(289, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.butExportOctave, -2, 17, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlTimeSimulation1.add(this.jPanel1);
        this.butSaveNetworkStates.setText("Save Network & Data");
        this.butSaveNetworkStates.setToolTipText("Saves the current network with the associated steady-states");
        this.butSaveNetworkStates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OdeSimulatorPanel.this.butSaveNetworkStatesActionPerformed(evt);
            }
        });
        this.butShowGraph.setText("Display network");
        this.butShowGraph.setToolTipText("Initialize or reset the simulation");
        this.butShowGraph.setPreferredSize(new Dimension(100, 40));
        this.butShowGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OdeSimulatorPanel.this.butShowGraphActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.butSaveNetworkStates).addPreferredGap(0, 134, Short.MAX_VALUE).add((Component)this.butShowGraph, -2, 131, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.butInitialize, -2, 91, -2).addPreferredGap(0).add((Component)this.butReset, -2, 88, -2).addPreferredGap(0, 94, Short.MAX_VALUE).add((Component)this.butLoadStates)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblSS).add(5, 5, 5).add((Component)this.txtNumbStates, -2, 31, -2))).addContainerGap()).add((Component)this.jTabbedPane1, -1, 420, Short.MAX_VALUE).add((Component)this.pnlSimulationControls, -1, 420, Short.MAX_VALUE).add((Component)this.pnlTimeSimulation1, -1, 420, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(38, 38, 38).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.butInitialize, -2, -1, -2).add((Component)this.butReset, -2, -1, -2))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblSS).add((Component)this.txtNumbStates, -2, -1, -2)).addPreferredGap(0).add((Component)this.butLoadStates))).addPreferredGap(0).add((Component)this.pnlSimulationControls, -2, 108, -2).addPreferredGap(0).add((Component)this.jTabbedPane1, -2, 207, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.butSaveNetworkStates).add((Component)this.butShowGraph, -2, 22, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.pnlTimeSimulation1, -2, 81, -2)));
    }

    private void butExportOctaveActionPerformed(ActionEvent evt) {
        this.exportToOctave();
    }

    private void butSaveNetworkStates1ActionPerformed(ActionEvent evt) {
    }

    private void butSaveNetworkStates2ActionPerformed(ActionEvent evt) {
    }

    private void chkCompleteSimulationActionPerformed(ActionEvent evt) {
        this.pnlCompleteSimulation.setVisible(true);
        this.pnlProgressiveSimulation.setVisible(false);
    }

    private void chkProgrSimulationActionPerformed(ActionEvent evt) {
        this.pnlCompleteSimulation.setVisible(false);
        this.pnlProgressiveSimulation.setVisible(true);
    }

    private void butShowDataActionPerformed(ActionEvent evt) {
        this.displayResultDataToGUI();
    }

    private void butShowGraphActionPerformed(ActionEvent evt) {
        this.displayNetwork();
    }

    private void butResetActionPerformed(ActionEvent evt) {
        this.reset();
    }

    private void butSaveNetworkStatesActionPerformed(ActionEvent evt) {
        this.saveNetwork();
    }

    private void butLoadStatesActionPerformed(ActionEvent evt) {
        this.displaySteadyStateSelector();
    }

    private void slideSpeedMouseReleased(MouseEvent evt) {
        if (this.slideSpeed.isEnabled()) {
            this.updateDelayTime(this.slideSpeed.getValue());
        }
    }

    private void butStepStopSimulationActionPerformed(ActionEvent evt) {
        this.stopStepSimulation();
    }

    private void butStepRunSimulationActionPerformed(ActionEvent evt) {
        this.startStepSimulation(this.slideSpeed.getValue());
    }

    private void butRunSimulationActionPerformed(ActionEvent evt) {
        this.runSimulation();
    }

    private void butInitializeActionPerformed(ActionEvent evt) {
        this.initializeSimulation();
        this.initializeVisualization();
    }

    private void chkOptimalTimeStateChanged(ChangeEvent evt) {
        if (this.chkOptimalTime.isSelected()) {
            this.txtMaxTime.setEnabled(false);
            this.txtSlices.setEnabled(false);
        } else {
            this.txtMaxTime.setEnabled(true);
            this.txtSlices.setEnabled(true);
        }
    }
}

