/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.pl;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;

public class SpinnerCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    final JSpinner spinner;
    SpinnerNumberModel model = new SpinnerNumberModel();
    Double prevValue = 0.0;
    Double maxValue = null;
    Double minValue = null;

    public SpinnerCellEditor(Double min, Double max, Double stepSize) {
        this.maxValue = max;
        this.minValue = min;
        this.model.setValue(0.0);
        this.model.setStepSize(stepSize);
        this.spinner = new JSpinner(this.model);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.spinner.setValue((Double)value);
        return this.spinner;
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            return ((MouseEvent)evt).getClickCount() >= 1;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return Double.parseDouble(this.spinner.getValue().toString());
    }

    @Override
    public boolean stopCellEditing() {
        Double currentValue = Double.parseDouble(this.spinner.getValue().toString());
        if (this.maxValue != null && currentValue > this.maxValue) {
            this.displayMessage();
            return false;
        }
        if (this.minValue != null && currentValue < this.minValue) {
            this.displayMessage();
            return false;
        }
        Boolean result = super.stopCellEditing();
        return result;
    }

    private void displayMessage() {
        String message = "";
        if (this.maxValue != null && this.minValue != null) {
            message = "The value has to be >= " + this.minValue + " and <= " + this.maxValue;
        } else if (this.maxValue != null) {
            message = "The value has to be <= " + this.maxValue;
        } else if (this.minValue != null) {
            message = "The value has to be >= " + this.minValue;
        }
        JOptionPane.showMessageDialog(this.spinner, message, "", 2);
    }

    private class RangeVerify
    extends InputVerifier {
        Double maxValue = null;
        Double minValue = null;

        public RangeVerify(Double min, Double max) {
            this.maxValue = max;
            this.minValue = min;
        }

        @Override
        public boolean verify(JComponent arg0) {
            return true;
        }
    }

    public class SpinnerListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent evt) {
            JSpinner spinner = (JSpinner)evt.getSource();
            Object value = spinner.getValue();
            System.out.println(value);
        }
    }
}

