/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.pl;

import edu.uci.ics.jung.graph.Graph;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.enfin.squad.bl.IObservable;
import org.enfin.squad.bl.IObserver;
import org.enfin.squad.bl.NetworkState;
import org.enfin.squad.pl.SteadyStatePanel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class SteadyStateSelector
extends JDialog
implements IObserver {
    private static final long serialVersionUID = 1L;
    Graph theGraph;
    private List<NetworkState> theStates;
    private Integer currentSelectedState = 0;
    private JPanel container;
    private JButton butCancel;
    private JButton butOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane pnlSSContainer;
    private JScrollPane pnlSSContainer1;

    public SteadyStateSelector() {
        this.initComponents();
    }

    public SteadyStateSelector(List<NetworkState> states, Graph gr) {
        this.theStates = states;
        this.theGraph = gr;
        this.initComponents();
        this.pnlSSContainer.setAutoscrolls(true);
        this.container = new JPanel();
        this.container.setLayout(new BoxLayout(this.container, 1));
        int panelIndex = 0;
        for (NetworkState st : this.theStates) {
            SteadyStatePanel stPan = new SteadyStatePanel(st, panelIndex, this.theGraph);
            stPan.registerObserver(this);
            this.container.add(stPan);
            if (panelIndex == 0) {
                stPan.setSelected(true);
            }
            ++panelIndex;
        }
        this.pnlSSContainer.setViewportView(this.container);
        this.validate();
        this.pack();
    }

    @Override
    public void updateObserver(IObservable obsvble, Object args) {
        if (obsvble.getClass() == SteadyStatePanel.class) {
            this.currentSelectedState = (Integer)args;
            for (int m = 0; m < this.container.getComponentCount(); ++m) {
                if (m == this.currentSelectedState) continue;
                ((SteadyStatePanel)this.container.getComponent(m)).setSelected(false);
            }
        }
    }

    public Integer getSelectedStateIndex() {
        return this.currentSelectedState;
    }

    public SteadyStateSelector(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.pnlSSContainer = new JScrollPane();
        this.pnlSSContainer1 = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.jLabel2 = new JLabel();
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.white);
        this.setResizable(false);
        this.pnlSSContainer.setAutoscrolls(true);
        this.pnlSSContainer1.setBackground(new Color(153, 153, 153));
        this.pnlSSContainer1.setAutoscrolls(true);
        this.pnlSSContainer.setViewportView(this.pnlSSContainer1);
        this.getContentPane().add((Component)this.pnlSSContainer, new AbsoluteConstraints(0, 50, 290, 180));
        this.jLabel1.setForeground(new Color(51, 102, 255));
        this.jLabel1.setText("Select a steady state using the radio buttons.");
        this.getContentPane().add((Component)this.jLabel1, new AbsoluteConstraints(10, 10, 280, -1));
        this.butOK.setText("OK");
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SteadyStateSelector.this.butOKActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.butOK, new AbsoluteConstraints(170, 240, 70, -1));
        this.butCancel.setText("Cancel");
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SteadyStateSelector.this.butCancelActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.butCancel, new AbsoluteConstraints(90, 240, 70, -1));
        this.jLabel2.setForeground(new Color(51, 102, 255));
        this.jLabel2.setText("For each state, only the nodes with state > 0 are shown");
        this.getContentPane().add((Component)this.jLabel2, new AbsoluteConstraints(10, 30, 280, -1));
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.currentSelectedState = null;
        this.setVisible(false);
    }

    private void butOKActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SteadyStateSelector((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }
}

