/*
 * Decompiled with CFR 0.152.
 */
package org.enfin.squad.pl;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.table.AbstractTableModel;
import org.enfin.squad.bl.NetworkState;

public class SteadyStateTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    ArrayList<String> names;
    NetworkState state;

    public SteadyStateTableModel() {
    }

    public SteadyStateTableModel(NetworkState netState) {
        this.parseData(netState);
    }

    private void parseData(NetworkState netState) {
        this.state = netState;
        this.names = new ArrayList<String>(netState.getNonZeroNodes().keySet());
        Collections.sort(this.names);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.names.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.names.get(row);
            }
            case 1: {
                return this.state.getContinuousValue(this.names.get(row));
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "Node";
        }
        return "Value";
    }

    public void updateData(NetworkState netState) {
        this.parseData(netState);
        super.fireTableDataChanged();
    }
}

