/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.awt;

import java.awt.TextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Vector;

public class AutoFillTextField
extends TextField
implements Serializable {
    protected static final int REMEMBERED = 20;
    private RememberList _remembered = new RememberList(20);

    public AutoFillTextField() {
        this.addKeyListener(new AutoFillKeyAdapter());
    }

    public AutoFillTextField(int n) {
        super(n);
        this.addKeyListener(new AutoFillKeyAdapter());
    }

    public void setListSize(int n) throws IllegalArgumentException {
        this.getRememberList().setMax(n);
    }

    protected RememberList getRememberList() {
        return this._remembered;
    }

    class AutoFillKeyAdapter
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    AutoFillTextField.this.getRememberList().add(AutoFillTextField.this.getText());
                    return;
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c != '\uffff') {
                String string = AutoFillTextField.this.getText().substring(0, AutoFillTextField.this.getCaretPosition()) + c;
                String string2 = AutoFillTextField.this.getRememberList().get(string);
                if (string2 != null) {
                    AutoFillTextField.this.setText(string2);
                    AutoFillTextField.this.setCaretPosition(string.length());
                    AutoFillTextField.this.select(string.length(), string2.length());
                    keyEvent.consume();
                }
            }
        }
    }

    class RememberList
    implements Serializable {
        private int _maxRemembered;
        private String _firstToRemove = null;
        private Vector _list;

        public RememberList() {
            this(20);
        }

        public RememberList(int n) {
            this._list = new Vector(n);
            this.setMax(n);
        }

        private int whereToAddBefore(String string) {
            int n;
            int n2 = this.getList().size();
            String string2 = null;
            for (n = 0; n < n2; ++n) {
                string2 = (String)this.getList().elementAt(n);
                int n3 = string2.compareTo(string);
                if (n3 == 0) {
                    return -1;
                }
                if (string2.compareTo(string) <= 0) continue;
                return n;
            }
            return n;
        }

        private String closestMatch(String string, int n) {
            while (n >= 0) {
                int n2 = this.elementAt(n).compareTo(string);
                if (n2 == 0) {
                    return string;
                }
                if (n2 > 0) {
                    String string2 = this.elementAt(n);
                    if (string2.startsWith(string)) {
                        return string2;
                    }
                    return this.closestMatch(string, n - 1);
                }
                --n;
            }
            return n == -1 ? null : this.elementAt(0);
        }

        public synchronized void add(String string) {
            int n;
            if (this.getList().size() == 0) {
                this._firstToRemove = string;
                this.getList().addElement(string);
                return;
            }
            if (this.getList().size() == this._maxRemembered) {
                this.getList().removeElement(this._firstToRemove);
            }
            if ((n = this.whereToAddBefore(string)) == -1) {
                return;
            }
            if (n == this.getList().size()) {
                this.getList().addElement(string);
            } else {
                this.getList().insertElementAt(string, n);
            }
        }

        public synchronized void clear() {
            this.getList().removeAllElements();
            this._firstToRemove = null;
        }

        public synchronized String get(String string) {
            return this.closestMatch(string, this.getList().size() - 1);
        }

        private final String elementAt(int n) {
            return (String)this.getList().elementAt(n);
        }

        public int getMax() {
            return this._maxRemembered;
        }

        public void setMax(int n) throws IllegalArgumentException {
            if (n < 0) {
                throw new IllegalArgumentException(this.getClass().getName() + "setMax() : invalid value " + n);
            }
            this._maxRemembered = n;
        }

        protected Vector getList() {
            return this._list;
        }

        public String toString() {
            return this.getClass().getName() + "\nSize(max) : " + this.getList().size() + " ( " + this._maxRemembered + ") / First To remove : " + this._firstToRemove + "\n" + this.getList().toString();
        }
    }
}

