/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.servlet;

import com.tlabs.servlet.ExtensibleHttpServlet;
import com.tlabs.servlet.HttpServletRequestHandler;
import com.tlabs.servlet.SchedulerServletTask;
import com.tlabs.servlet.ServletConfigAdapter;
import com.tlabs.util.Scheduler;
import com.tlabs.util.SchedulerTask;
import com.tlabs.util.SchedulerTaskAdapter;
import com.tlabs.util.SchedulerTaskEvent;
import com.tlabs.util.SchedulerTaskListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SchedulerServlet
extends ExtensibleHttpServlet {
    private static final String GET_MODE = "mode";
    private static final String MODE_LOG = "log";
    private static final String MODE_CLEARLOG = "clear";
    private static final String MODE_START = "start";
    private static final String MODE_STOP = "stop";
    private static final String MODE_STATUS = "status";
    private static final String MODE_HELP = "help";
    private static final String MODE_ADD = "add";
    private static final String MODE_REMOVE = "remove";
    private static final String PARAMETER_TASK_NAME = "task";
    private static final String PARAMETER_CLASS_NAME = "class";
    private static final String INIT_TASK_SEPARATOR = ".";
    private static final String INIT_TASK_PREFIX = "task.";
    private static final String INIT_SECURITY = "security";
    private static final String LOG_REPORT = "TaskServlet";
    private static final String INIT_REPORT_FILE = "report.url";
    private SchedulerTaskListener myTaskListener;
    private Scheduler myScheduler = new Scheduler();
    private Map myTasks = new Hashtable();
    private URL myReportURL = null;
    static /* synthetic */ Class class$javax$servlet$ServletConfig;

    public SchedulerServlet() {
        this.myTaskListener = new ServletTaskListener();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String string = servletConfig.getInitParameter(INIT_REPORT_FILE);
        String string2 = string = null == string ? "" : string.trim();
        if (string.length() > 0) {
            try {
                this.myReportURL = new URL(string);
                this.log("Report file is " + this.myReportURL);
            }
            catch (MalformedURLException malformedURLException) {
                this.log(malformedURLException.getLocalizedMessage());
                this.log("report.url: invalid servlet parameter");
                this.myReportURL = null;
            }
        }
        Enumeration enumeration = servletConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(INIT_TASK_PREFIX)) continue;
            int n = string3.indexOf(INIT_TASK_SEPARATOR);
            int n2 = string3.lastIndexOf(INIT_TASK_SEPARATOR);
            if (n <= 0 || n != n2 || n2 >= string3.length()) continue;
            String string4 = string3.substring(INIT_TASK_PREFIX.length());
            String string5 = servletConfig.getInitParameter(string3);
            this.addTask(string4, this.createNewTask(string4, string5, new ServletConfigAdapter(this.getServletConfig(), string3 + INIT_TASK_SEPARATOR)));
        }
        this.addHandler(new LogHandler());
        this.addHandler(new ClearLogHandler());
        this.addHandler(new StopHandler());
        this.addHandler(new StartHandler());
        this.addHandler(new AddHandler());
        this.addHandler(new RemoveHandler());
        this.addHandler(new StatusHandler());
        this.addHandler(new HelpHandler());
    }

    public synchronized void destroy() {
        this.stop();
        this.myTasks.clear();
        super.destroy();
    }

    public void taskStarted(SchedulerTask schedulerTask) {
    }

    public void taskCompleted(SchedulerTask schedulerTask) {
    }

    public void taskCancelled(SchedulerTask schedulerTask) {
    }

    public void taskError(SchedulerTask schedulerTask) {
    }

    protected synchronized void addTask(String string, SchedulerServletTask schedulerServletTask) throws ServletException {
        if (this.myTasks.containsKey(string)) {
            throw new ServletException("task \"" + string + "\" already exists");
        }
        this.myTasks.put(string, new TaskEntry(string, schedulerServletTask));
        schedulerServletTask.addTaskListener(this.myTaskListener);
        this.log("Added task \"" + string + "\" (" + schedulerServletTask.getClass().getName() + ")");
        if (schedulerServletTask.isAutoStartEnabled()) {
            this.start(string);
        }
    }

    protected synchronized void addTask(String string, String string2) throws ServletException {
        if (this.myTasks.containsKey(string)) {
            throw new ServletException("task \"" + string + "\" already exists");
        }
        this.addTask(string, this.createNewTask(string, string2, new ServletConfigAdapter(this.getServletConfig(), string + INIT_TASK_SEPARATOR)));
    }

    protected synchronized void removeTask(String string) throws ServletException {
        if (!this.myTasks.containsKey(string)) {
            throw new ServletException("task \"" + string + "\" does not exists");
        }
        TaskEntry taskEntry = (TaskEntry)this.myTasks.remove(string);
        taskEntry.getTask().removeTaskListener(this.myTaskListener);
        this.stop(string);
        this.log("Removed task \"" + string + "\"");
    }

    protected synchronized int stop() {
        int n = 0;
        Iterator iterator = this.myTasks.keySet().iterator();
        while (iterator.hasNext()) {
            if (!this.stop((String)iterator.next())) continue;
            ++n;
        }
        this.log(n + " tasks stopped...");
        return n;
    }

    protected synchronized int start() {
        int n = 0;
        Iterator iterator = this.myTasks.keySet().iterator();
        while (iterator.hasNext()) {
            if (!this.start((String)iterator.next())) continue;
            ++n;
        }
        this.log(n + " tasks started...");
        return n;
    }

    protected synchronized boolean stop(String string) {
        TaskEntry taskEntry = (TaskEntry)this.myTasks.get(string);
        if (null == taskEntry || !this.myScheduler.containsTask(taskEntry.getTask())) {
            this.log("Stop error: \"" + string + "\" : task not found");
            return false;
        }
        this.myScheduler.removeTask(taskEntry.getTask());
        this.log("Stopped task \"" + string + "\" : " + taskEntry);
        return true;
    }

    protected synchronized boolean start(String string) {
        TaskEntry taskEntry = (TaskEntry)this.myTasks.get(string);
        if (null == taskEntry || this.myScheduler.containsTask(taskEntry.getTask())) {
            this.log("Start error: \"" + string + "\" : task already started");
            return false;
        }
        this.myScheduler.addTask(taskEntry.getTask());
        this.log("Started task \"" + string + "\" : " + taskEntry);
        return true;
    }

    private synchronized File getReportFile() {
        if (null == this.myReportURL) {
            return null;
        }
        try {
            File file = new File(this.myReportURL.getFile());
            if (!file.exists()) {
                file.createNewFile();
            }
            return file;
        }
        catch (IOException iOException) {
            this.log(iOException);
            this.log("Cannot create report file " + this.myReportURL);
            return null;
        }
    }

    private void writeHeader(Writer writer) throws IOException {
        writer.write("<html>");
        writer.write("<head>");
        writer.write("<meta http-equiv=\"pragma\" content=\"no-cache\">");
        writer.write("<meta http-equiv=\"expires\" content=\"now\">");
        writer.write("<title></title>");
        writer.write("</head><body>");
    }

    private void writeFooter(Writer writer) throws IOException {
        writer.write("</body></html>");
    }

    private SchedulerServletTask createNewTask(String string, String string2, ServletConfig servletConfig) throws ServletException {
        this.log("Creating new task \"" + string + "\" using " + string2);
        Class<?> clazz = null;
        SchedulerServletTask schedulerServletTask = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServletException("Cannot find task class \"" + string2 + "\"");
        }
        try {
            Class[] classArray = new Class[]{class$javax$servlet$ServletConfig == null ? (class$javax$servlet$ServletConfig = SchedulerServlet.class$("javax.servlet.ServletConfig")) : class$javax$servlet$ServletConfig};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{servletConfig};
            schedulerServletTask = (SchedulerServletTask)constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.log(string2 + " will not be initialized using current Servlet configuration - using default constructor");
            try {
                schedulerServletTask = (SchedulerServletTask)clazz.newInstance();
            }
            catch (Exception exception) {
                this.log(exception);
                throw new ServletException("Cannot instantiate class \"" + string2 + "\" : " + exception.getLocalizedMessage());
            }
        }
        catch (SecurityException securityException) {
            throw new ServletException("Cannot use class constructor using ServletConfig - security manager prevents access");
        }
        catch (ClassCastException classCastException) {
            throw new ServletException("Invalid task class (" + classCastException.getLocalizedMessage() + ")");
        }
        catch (Exception exception) {
            this.log(exception);
            throw new ServletException("Cannot instantiate class \"" + string2 + "\" : " + exception.getLocalizedMessage());
        }
        this.log("Created Task \"" + string + " (" + schedulerServletTask + ")");
        return schedulerServletTask;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ServletTaskListener
    extends SchedulerTaskAdapter {
        public void taskStarted(SchedulerTaskEvent schedulerTaskEvent) {
            SchedulerServlet.this.log(schedulerTaskEvent.getTask() + ": task started");
            this.reportBegin(schedulerTaskEvent, "task started");
            this.report(schedulerTaskEvent);
            this.reportEnd(schedulerTaskEvent, null);
            SchedulerServlet.this.taskStarted(schedulerTaskEvent.getTask());
        }

        public void taskCompleted(SchedulerTaskEvent schedulerTaskEvent) {
            SchedulerServlet.this.log(schedulerTaskEvent.getTask() + ": task completed");
            this.reportBegin(schedulerTaskEvent, "task completed");
            this.report(schedulerTaskEvent);
            this.reportEnd(schedulerTaskEvent, null);
            SchedulerServlet.this.taskCompleted(schedulerTaskEvent.getTask());
        }

        public void taskCancelled(SchedulerTaskEvent schedulerTaskEvent) {
            SchedulerServlet.this.log(schedulerTaskEvent.getTask() + ": task cancelled");
            this.reportBegin(schedulerTaskEvent, "task cancelled");
            this.report(schedulerTaskEvent);
            this.reportEnd(schedulerTaskEvent, null);
            SchedulerServlet.this.taskCancelled(schedulerTaskEvent.getTask());
        }

        public void taskError(SchedulerTaskEvent schedulerTaskEvent) {
            SchedulerServlet.this.log(schedulerTaskEvent.getTask() + ": task error");
            this.reportBegin(schedulerTaskEvent, "task error");
            this.report(schedulerTaskEvent);
            Throwable throwable = schedulerTaskEvent.getError();
            if (null != throwable) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<p>");
                stringBuffer.append("<b><i>");
                stringBuffer.append(throwable.getLocalizedMessage());
                stringBuffer.append("</i></b>");
                stringBuffer.append(SchedulerServlet.getStackTrace(throwable));
                stringBuffer.append("</p>");
                this.report(stringBuffer.toString());
            }
            this.reportEnd(schedulerTaskEvent, null);
            SchedulerServlet.this.taskError(schedulerTaskEvent.getTask());
        }

        private void reportBegin(SchedulerTaskEvent schedulerTaskEvent, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<hr color=\"#000080\"><h3>");
            stringBuffer.append(new Date());
            if (null != string) {
                stringBuffer.append(" : " + string);
            }
            stringBuffer.append(" (" + schedulerTaskEvent.getTask() + ")");
            stringBuffer.append("</h3><br>");
            this.report(stringBuffer.toString());
        }

        private void reportEnd(SchedulerTaskEvent schedulerTaskEvent, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            if (null != string) {
                stringBuffer.append(string + "<br>");
            }
            stringBuffer.append("<hr color=\"#000080\">");
            this.report(stringBuffer.toString());
        }

        private synchronized void report(String string) {
            File file = SchedulerServlet.this.getReportFile();
            if (null == file) {
                SchedulerServlet.this.log(string);
            } else {
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file.getAbsolutePath(), true));
                    bufferedWriter.write(string, 0, string.length());
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    SchedulerServlet.this.log(iOException.getLocalizedMessage());
                }
            }
        }

        private synchronized void report(SchedulerTaskEvent schedulerTaskEvent) {
            if (schedulerTaskEvent.getTask() instanceof SchedulerServletTask) {
                SchedulerServletTask schedulerServletTask = (SchedulerServletTask)schedulerTaskEvent.getTask();
                this.report(schedulerServletTask.report());
                schedulerServletTask.clearReport();
            }
        }
    }

    private class StatusHandler
    extends ServletTaskHandler {
        public StatusHandler() {
            super(SchedulerServlet.MODE_STATUS, "View task(s) status");
        }

        public void executeRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            PrintWriter printWriter = httpServletResponse.getWriter();
            ((Writer)printWriter).write("<u><h2>Scheduled Tasks Status</h2></u><br>");
            LinkedList linkedList = new LinkedList();
            Object object = SchedulerServlet.this.myScheduler.tasks();
            while (object.hasMoreElements()) {
                linkedList.add(object.nextElement());
            }
            object = SchedulerServlet.this.myTasks.values().iterator();
            while (object.hasNext()) {
                TaskEntry taskEntry = (TaskEntry)object.next();
                SchedulerTask schedulerTask = taskEntry.getTask();
                boolean bl = schedulerTask.isExecuting();
                boolean bl2 = linkedList.contains(schedulerTask);
                ((Writer)printWriter).write("<h3>Task \"" + taskEntry.getName() + "\" ");
                if (bl2) {
                    ((Writer)printWriter).write("<b>Scheduled</b>&nbsp");
                } else {
                    ((Writer)printWriter).write("<b><i>Discarded</i></b>&nbsp");
                }
                if (bl) {
                    ((Writer)printWriter).write("<font color=\"green\"<b>Running</b></font>");
                } else {
                    ((Writer)printWriter).write("<font color=\"red\"<b>IDLE</b></font>");
                }
                ((Writer)printWriter).write("</h3>");
                ((Writer)printWriter).write("<br><b>Initial date   :</b> " + schedulerTask.getInitialDate());
                ((Writer)printWriter).write("<br><b>Delay :</b> " + schedulerTask.getRepeatDelay() / 1000L + " s");
                long l = schedulerTask.getRepeatCount();
                String string = l > 0L ? "" + l / 1000L + " s" : "disabled";
                ((Writer)printWriter).write("<br><b>Repeat Count :</b> " + string);
                ((Writer)printWriter).write("<br><b>Cancel on error :</b> " + schedulerTask.getCancelOnError());
                Date date = taskEntry.getLastStartDate();
                ((Writer)printWriter).write("<br><br><b>Last running   :</b> " + (null == date ? "N/A" : date.toString()));
                date = taskEntry.getLastStopDate();
                ((Writer)printWriter).write("<br><b>Last completed :</b> " + (null == date ? "N/A" : date.toString()));
                l = schedulerTask.getRemainingRepeatCount();
                string = l > 0L ? "" + l / 1000L + " s" : "disabled";
                ((Writer)printWriter).write("<br><b>Remaining Repeat Count :</b> " + string);
                Throwable throwable = taskEntry.getLastError();
                ((Writer)printWriter).write("<br><b>Last Exec Error:</b>");
                if (null == throwable) {
                    ((Writer)printWriter).write("<br><b>No error</b><br>");
                } else {
                    ((Writer)printWriter).write(SchedulerServlet.getStackTrace(throwable));
                }
                ((Writer)printWriter).write("<hr>");
            }
            ((Writer)printWriter).flush();
            httpServletResponse.setStatus(200);
        }
    }

    private class HelpHandler
    extends ServletTaskHandler {
        public HelpHandler() {
            super(SchedulerServlet.MODE_HELP, "List all commands (this command)");
        }

        public void executeRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            PrintWriter printWriter = httpServletResponse.getWriter();
            ((Writer)printWriter).write("<u><h2>Scheduler Help</h2></u><br>");
            ((Writer)printWriter).write("<h3>List of commands</h3>");
            ((Writer)printWriter).write("<ul>");
            Enumeration enumeration = SchedulerServlet.this.handlers();
            while (enumeration.hasMoreElements()) {
                ServletTaskHandler servletTaskHandler = (ServletTaskHandler)enumeration.nextElement();
                ((Writer)printWriter).write("<li>");
                ((Writer)printWriter).write("<b>" + servletTaskHandler.getName() + "</b> ");
                ((Writer)printWriter).write("<i>" + servletTaskHandler.getDescription() + "</i><br>");
                ((Writer)printWriter).write("</li>");
            }
            ((Writer)printWriter).write("</ul><br><hr>");
            ((Writer)printWriter).flush();
            httpServletResponse.setStatus(200);
        }
    }

    private class RemoveHandler
    extends ServletTaskHandler {
        public RemoveHandler() {
            super(SchedulerServlet.MODE_REMOVE, "Remove a named task (task=?)");
        }

        public void executeRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String string = this.getTaskName(httpServletRequest);
            if (null == string) {
                httpServletResponse.setStatus(400);
            } else {
                SchedulerServlet.this.removeTask(string);
                httpServletResponse.getWriter().write("<h2>Removed task \"" + string + "\"</h2>");
                httpServletResponse.setStatus(200);
            }
        }
    }

    private class AddHandler
    extends ServletTaskHandler {
        public AddHandler() {
            super(SchedulerServlet.MODE_ADD, "Add a new named task (task=?&class=?)");
        }

        public void executeRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String string = this.getTaskName(httpServletRequest);
            String string2 = this.getClassName(httpServletRequest);
            if (null == string || null == string2) {
                httpServletResponse.setStatus(400);
            } else {
                SchedulerServlet.this.addTask(string, string2);
                httpServletResponse.getWriter().write("<h2>Added task \"" + string + "\"</h2>");
                httpServletResponse.setStatus(200);
            }
        }

        private String getClassName(HttpServletRequest httpServletRequest) {
            String string = httpServletRequest.getParameter(SchedulerServlet.PARAMETER_CLASS_NAME);
            String string2 = string = null == string ? "" : string.trim();
            if (string.length() == 0) {
                return null;
            }
            return string;
        }
    }

    private class StartHandler
    extends ServletTaskHandler {
        public StartHandler() {
            super(SchedulerServlet.MODE_START, "Start a named task (task=?) or all tasks if the task name is not specified");
        }

        public void executeRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String string = this.getTaskName(httpServletRequest);
            if (null == string) {
                int n = SchedulerServlet.this.start();
                if (n > 0) {
                    httpServletResponse.getWriter().write("<h2>" + n + " task(s) started</h2>");
                    httpServletResponse.setStatus(200);
                } else {
                    httpServletResponse.getWriter().write("<h2> no task has been started</h2>");
                    httpServletResponse.setStatus(403);
                }
            } else if (SchedulerServlet.this.start(string)) {
                httpServletResponse.getWriter().write("<p>Task \"" + string + "\" started</p>");
                httpServletResponse.setStatus(200);
            } else {
                httpServletResponse.getWriter().write("<p>Cannot start task \"" + string + "\": task not stopped</p>");
                httpServletResponse.setStatus(403);
            }
        }
    }

    private class StopHandler
    extends ServletTaskHandler {
        public StopHandler() {
            super(SchedulerServlet.MODE_STOP, "Stop a task (task=?) or all tasks if the taskname is not specified");
        }

        public void executeRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String string = this.getTaskName(httpServletRequest);
            if (null == string) {
                int n = SchedulerServlet.this.stop();
                if (n > 0) {
                    httpServletResponse.getWriter().write("<h2>" + n + " task(s) stopped</h2>");
                    httpServletResponse.setStatus(200);
                } else {
                    httpServletResponse.getWriter().write("<h2> no task has been started</h2>");
                    httpServletResponse.setStatus(403);
                }
            } else if (SchedulerServlet.this.stop(string)) {
                httpServletResponse.getWriter().write("<p>Task \"" + string + "\" stopped</p>");
                httpServletResponse.setStatus(200);
            } else {
                httpServletResponse.getWriter().write("<p>Cannot stop task \"" + string + "\": task not started</p>");
                httpServletResponse.setStatus(403);
            }
        }
    }

    private class ClearLogHandler
    extends ServletTaskHandler {
        public ClearLogHandler() {
            super(SchedulerServlet.MODE_CLEARLOG, "Clear scheduler log");
        }

        public void executeRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            File file = SchedulerServlet.this.getReportFile();
            if (null == file) {
                httpServletResponse.getWriter().write("<h2>Report not available</h2>");
                httpServletResponse.setStatus(200);
            } else if (file.delete()) {
                httpServletResponse.getWriter().write("<h2>Report deleted</h2>");
                httpServletResponse.setStatus(200);
            } else {
                httpServletResponse.getWriter().write("<h2>Cannot delete report</h2>");
                httpServletResponse.setStatus(403);
            }
        }
    }

    private class LogHandler
    extends ServletTaskHandler {
        public LogHandler() {
            super(SchedulerServlet.MODE_LOG, "View scheduler log");
        }

        public void executeRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            File file = SchedulerServlet.this.getReportFile();
            if (null == file) {
                httpServletResponse.getWriter().write("<h2>Report not available</h2>");
            } else {
                BufferedWriter bufferedWriter = new BufferedWriter(httpServletResponse.getWriter());
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
                bufferedReader.close();
                bufferedWriter.flush();
            }
            httpServletResponse.setStatus(200);
        }
    }

    private abstract class ServletTaskHandler
    extends HttpServletRequestHandler {
        private String myRequestParameterValue;

        public ServletTaskHandler(String string, String string2) {
            super(string, null, string2);
            this.myRequestParameterValue = string;
        }

        public final void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            PrintWriter printWriter = httpServletResponse.getWriter();
            SchedulerServlet.this.writeHeader(printWriter);
            this.executeRequest(httpServletRequest, httpServletResponse);
            SchedulerServlet.this.writeFooter(printWriter);
            printWriter.flush();
        }

        public abstract void executeRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

        public boolean accept(HttpServletRequest httpServletRequest) {
            String string = httpServletRequest.getParameter(SchedulerServlet.GET_MODE);
            String string2 = string = null == string ? "" : string.trim();
            if (string.length() == 0) {
                return false;
            }
            return string.equalsIgnoreCase(this.myRequestParameterValue);
        }

        protected final String getTaskName(HttpServletRequest httpServletRequest) {
            String string = httpServletRequest.getParameter(SchedulerServlet.PARAMETER_TASK_NAME);
            String string2 = string = null == string ? "" : string.trim();
            if (string.length() == 0) {
                return null;
            }
            return string;
        }
    }

    private class TaskEntry
    extends SchedulerTaskAdapter {
        private String myName;
        private SchedulerTask myTask;
        private Date myLastStartDate;
        private Date myLastEndDate;
        private boolean myIsCancelled;
        private Throwable myLastError;

        public TaskEntry(String string, SchedulerTask schedulerTask) {
            this.myName = string;
            this.myTask = schedulerTask;
            this.myLastStartDate = null;
            this.myLastEndDate = null;
            this.myLastError = null;
            schedulerTask.addTaskListener(this);
        }

        public SchedulerTask getTask() {
            return this.myTask;
        }

        public String getName() {
            return this.myName;
        }

        public Date getLastStartDate() {
            return this.myLastStartDate;
        }

        public Date getLastStopDate() {
            return this.myLastEndDate;
        }

        public Throwable getLastError() {
            return this.myLastError;
        }

        public void taskStarted(SchedulerTaskEvent schedulerTaskEvent) {
            this.myLastStartDate = new Date();
            this.myIsCancelled = false;
        }

        public void taskCompleted(SchedulerTaskEvent schedulerTaskEvent) {
            this.myLastEndDate = new Date();
            this.myIsCancelled = false;
        }

        public void taskCancelled(SchedulerTaskEvent schedulerTaskEvent) {
            this.myLastEndDate = new Date();
            this.myIsCancelled = true;
        }

        public void taskError(SchedulerTaskEvent schedulerTaskEvent) {
            this.myLastError = schedulerTaskEvent.getError();
        }

        public String toString() {
            return "(Task) " + this.getName();
        }

        protected void finalize() throws Throwable {
            this.myTask.removeTaskListener(this);
            super.finalize();
        }
    }
}

