/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.servlet;

import com.tlabs.util.SchedulerTask;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public abstract class SchedulerServletTask
extends SchedulerTask {
    private static final String INIT_TASK_DELAY = "delay";
    private static final String INIT_TASK_DATE = "start";
    private static final String INIT_TASK_COUNT = "count";
    private static final String INIT_TASK_STOP = "stoponerror";
    private static final String INIT_TASK_AUTOSTART = "autostart";
    private ServletConfigAdapter myConfiguration;
    private StringBuffer myReportBuffer;

    public SchedulerServletTask(ServletConfig servletConfig) throws ServletException {
        this(new ServletConfigAdapter(servletConfig));
    }

    private SchedulerServletTask(ServletConfigAdapter servletConfigAdapter) throws ServletException {
        super(servletConfigAdapter.getStartDate(), servletConfigAdapter.getDelay(), servletConfigAdapter.getExecuteCount(), false);
        this.myConfiguration = servletConfigAdapter;
        this.myReportBuffer = new StringBuffer();
        this.setCancelOnError(servletConfigAdapter.getStopOnError());
    }

    public abstract Object execute();

    public boolean isAutoStartEnabled() {
        return this.myConfiguration.isAutoStartEnabled();
    }

    public final synchronized String report() {
        return this.myReportBuffer.toString();
    }

    protected final synchronized void clearReport() {
        this.myReportBuffer.delete(0, this.myReportBuffer.length());
    }

    protected final synchronized void report(String string) {
        this.myReportBuffer.append(string);
    }

    protected final synchronized void report(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        this.report(stringWriter.toString());
    }

    protected static final String getValidatedParameter(ServletConfig servletConfig, String string) throws ServletException {
        String string2 = SchedulerServletTask.getValidatedParameter(servletConfig, string, (String)null);
        if (null == string2) {
            throw new ServletException(string + ": missing or empty servlet parameter");
        }
        return string2;
    }

    protected static final String getValidatedParameter(ServletConfig servletConfig, String string, String string2) throws ServletException {
        String string3 = servletConfig.getInitParameter(string);
        String string4 = string3 = null == string3 ? "" : string3.trim();
        if (string3.length() == 0) {
            return string2;
        }
        return string3;
    }

    protected static final long getValidatedParameter(ServletConfig servletConfig, String string, long l) throws ServletException {
        String string2 = SchedulerServletTask.getValidatedParameter(servletConfig, string, (String)null);
        if (null == string2) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServletException(string + ": invalid servlet parameter (long) \"" + string2 + "\"");
        }
    }

    protected static final Date getValidatedParameter(ServletConfig servletConfig, String string, Date date) throws ServletException {
        String string2 = SchedulerServletTask.getValidatedParameter(servletConfig, string, (String)null);
        if (null == string2) {
            return date;
        }
        try {
            return DateFormat.getDateInstance().parse(string2);
        }
        catch (ParseException parseException) {
            throw new ServletException(string + ": invalid servlet parameter (date) \"" + string2 + "\"");
        }
    }

    protected static final boolean getValidatedParameter(ServletConfig servletConfig, String string, boolean bl) throws ServletException {
        String string2 = SchedulerServletTask.getValidatedParameter(servletConfig, string, (String)null);
        if (null == string2) {
            return bl;
        }
        return new Boolean(string2);
    }

    private static class ServletConfigAdapter {
        private long myTaskDelay;
        private long myExecuteCount;
        private boolean myAutoStartTask;
        private Date myStartDate;
        private boolean myStopOnError;

        public ServletConfigAdapter(ServletConfig servletConfig) throws ServletException {
            this.myTaskDelay = SchedulerServletTask.getValidatedParameter(servletConfig, SchedulerServletTask.INIT_TASK_DELAY, -1L);
            if (-1L == this.myTaskDelay) {
                throw new ServletException("delay: missing servlet parameter");
            }
            this.myTaskDelay *= 1000L;
            this.myStartDate = SchedulerServletTask.getValidatedParameter(servletConfig, SchedulerServletTask.INIT_TASK_DATE, new Date());
            this.myExecuteCount = SchedulerServletTask.getValidatedParameter(servletConfig, SchedulerServletTask.INIT_TASK_COUNT, -1L);
            this.myStopOnError = SchedulerServletTask.getValidatedParameter(servletConfig, SchedulerServletTask.INIT_TASK_STOP, false);
            this.myAutoStartTask = SchedulerServletTask.getValidatedParameter(servletConfig, SchedulerServletTask.INIT_TASK_AUTOSTART, true);
        }

        public long getDelay() {
            return this.myTaskDelay;
        }

        public boolean getStopOnError() {
            return this.myStopOnError;
        }

        public Date getStartDate() {
            return this.myStartDate;
        }

        public long getExecuteCount() {
            return this.myExecuteCount;
        }

        public boolean isAutoStartEnabled() {
            return this.myAutoStartTask;
        }
    }
}

