/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.sql;

import java.rmi.server.UID;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sql.DataSource;

public class SQL {
    private Connection myConnection;
    private ResultSetParser myParser;

    public SQL(String string, Properties properties) throws SQLException {
        this(DriverManager.getConnection(string, properties));
    }

    public SQL(String string, String string2, String string3) throws SQLException {
        this(DriverManager.getConnection(string, string2, string3));
    }

    public SQL(DataSource dataSource) throws SQLException {
        this(dataSource.getConnection());
    }

    public SQL(Connection connection) throws SQLException {
        if (null == connection) {
            throw new SQLException("Null connection");
        }
        this.myParser = new ResultSetParser();
        this.init(connection);
    }

    private void init(Connection connection) {
        this.myConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map executeQuery(String string) throws SQLException {
        Map map;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            statement = this.myConnection.createStatement();
            resultSet = this.executeQueryImpl(this.myConnection.nativeSQL(string), statement);
            Map map2 = this.myParser.parseMap(resultSet);
            resultSet.close();
            resultSet = null;
            statement.close();
            statement = null;
            map = map2;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null != resultSet) {
                resultSet.close();
            }
            if (null != statement) {
                statement.close();
            }
            throw throwable;
        }
        if (null != resultSet) {
            resultSet.close();
        }
        if (null != statement) {
            statement.close();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List executeOrderedQuery(String string) throws SQLException {
        List list;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            statement = this.myConnection.createStatement();
            resultSet = this.executeQueryImpl(this.myConnection.nativeSQL(string), statement);
            List list2 = this.myParser.parseList(resultSet);
            resultSet.close();
            resultSet = null;
            statement.close();
            statement = null;
            list = list2;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null != resultSet) {
                resultSet.close();
            }
            if (null != statement) {
                statement.close();
            }
            throw throwable;
        }
        if (null != resultSet) {
            resultSet.close();
        }
        if (null != statement) {
            statement.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int executeUpdate(String string) throws SQLException {
        int n;
        SQLException sQLException;
        block12: {
            Statement statement = null;
            sQLException = null;
            n = -1;
            statement = this.myConnection.createStatement();
            n = statement.executeUpdate(this.myConnection.nativeSQL(string));
            this.traceWarnings(statement);
            statement.close();
            statement = null;
            Object var7_5 = null;
            try {
                if (null != statement) {
                    statement.close();
                }
                break block12;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            break block12;
            {
                catch (SQLException sQLException3) {
                    sQLException = sQLException3;
                    Object var7_6 = null;
                    try {
                        if (null != statement) {
                            statement.close();
                        }
                        break block12;
                    }
                    catch (SQLException sQLException4) {
                        sQLException = sQLException4;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (null != statement) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException5) {
                    sQLException = sQLException5;
                }
                throw throwable;
            }
        }
        if (null != sQLException) {
            throw sQLException;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int[] executeBatchUpdate(List list) throws IllegalArgumentException, SQLException {
        Object object;
        Object object2;
        block17: {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int i = 0; i < list.size(); ++i) {
                object2 = (String)list.get(i);
                if (((String)object2).indexOf(";") >= 0) {
                    object = new StringTokenizer((String)object2, ";");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        linkedList.add(((StringTokenizer)object).nextToken());
                    }
                    continue;
                }
                linkedList.add((String)object2);
            }
            Statement statement = null;
            object2 = null;
            object = null;
            statement = this.myConnection.createStatement();
            object = this.executeBatchUpdateImpl(linkedList, statement);
            statement.close();
            statement = null;
            Object var9_7 = null;
            try {
                if (null != statement) {
                    statement.close();
                }
                break block17;
            }
            catch (SQLException sQLException) {
                object2 = sQLException;
            }
            break block17;
            {
                catch (SQLException sQLException) {
                    try {
                        object = this.executeSequentialUpdateImpl(linkedList, statement);
                    }
                    catch (SQLException sQLException2) {
                        object = null;
                        object2 = sQLException2;
                    }
                    Object var9_8 = null;
                    try {
                        if (null != statement) {
                            statement.close();
                        }
                        break block17;
                    }
                    catch (SQLException sQLException3) {
                        object2 = sQLException3;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (null != statement) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    object2 = sQLException;
                }
                throw throwable;
            }
        }
        if (null != object2) {
            throw object2;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final List executeStoredQuery(String string, Object[] objectArray) throws SQLException {
        List list;
        SQLException sQLException;
        block14: {
            Object[] objectArray2 = null == objectArray ? new Object[]{} : objectArray;
            Statement statement = null;
            sQLException = null;
            list = null;
            String string2 = this.formatCallableStatement(string, objectArray2, false);
            statement = this.myConnection.prepareCall(string2);
            this.setPreparedStatement((PreparedStatement)statement, objectArray2, 1);
            ResultSet resultSet = statement.executeQuery();
            this.traceWarnings(statement);
            try {
                list = this.myParser.parseList(resultSet);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            resultSet = null;
            statement.close();
            statement = null;
            Object var11_11 = null;
            try {
                if (null != statement) {
                    statement.close();
                }
                break block14;
            }
            catch (SQLException sQLException3) {
                sQLException = sQLException3;
            }
            break block14;
            {
                catch (SQLException sQLException4) {
                    list = null;
                    sQLException = sQLException4;
                    Object var11_12 = null;
                    try {
                        if (null != statement) {
                            statement.close();
                        }
                        break block14;
                    }
                    catch (SQLException sQLException5) {
                        sQLException = sQLException5;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (null != statement) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException6) {
                    sQLException = sQLException6;
                }
                throw throwable;
            }
        }
        if (null != sQLException) {
            throw sQLException;
        }
        return list;
    }

    public final List executeStoredQuery(String string) throws SQLException {
        return this.executeStoredQuery(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final int executeStoredUpdate(String string, Object[] objectArray) throws SQLException {
        int n;
        int n2;
        SQLException sQLException;
        block12: {
            Object[] objectArray2 = null;
            objectArray2 = null == objectArray ? new Object[]{} : objectArray;
            Statement statement = null;
            sQLException = null;
            n2 = -1;
            n = -1;
            String string2 = this.formatCallableStatement(string, objectArray2, true);
            statement = this.myConnection.prepareCall(string2);
            statement.registerOutParameter(1, 4);
            this.setPreparedStatement((PreparedStatement)statement, objectArray2, 2);
            n = statement.executeUpdate();
            n2 = statement.getInt(1);
            this.traceWarnings(statement);
            statement.close();
            statement = null;
            Object var10_10 = null;
            try {
                if (null != statement) {
                    statement.close();
                }
                break block12;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            break block12;
            {
                catch (SQLException sQLException3) {
                    sQLException = sQLException3;
                    Object var10_11 = null;
                    try {
                        if (null != statement) {
                            statement.close();
                        }
                        break block12;
                    }
                    catch (SQLException sQLException4) {
                        sQLException = sQLException4;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (null != statement) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException5) {
                    sQLException = sQLException5;
                }
                throw throwable;
            }
        }
        if (null != sQLException) {
            throw sQLException;
        }
        return n2 > 0 ? -1 * n2 : n;
    }

    public final int executeStoredUpdate(String string) throws SQLException {
        return this.executeStoredUpdate(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final List executePreparedQuery(String string, Object[] objectArray) throws SQLException {
        List list;
        SQLException sQLException;
        block14: {
            Object[] objectArray2 = null == objectArray ? new Object[]{} : objectArray;
            PreparedStatement preparedStatement = null;
            sQLException = null;
            list = null;
            preparedStatement = this.myConnection.prepareStatement(string);
            this.setPreparedStatement(preparedStatement, objectArray2, 1);
            ResultSet resultSet = preparedStatement.executeQuery();
            this.traceWarnings(preparedStatement);
            try {
                list = this.myParser.parseList(resultSet);
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            Object var10_10 = null;
            try {
                if (null != preparedStatement) {
                    preparedStatement.close();
                }
                break block14;
            }
            catch (SQLException sQLException3) {
                sQLException = sQLException3;
            }
            break block14;
            {
                catch (SQLException sQLException4) {
                    list = null;
                    sQLException = sQLException4;
                    Object var10_11 = null;
                    try {
                        if (null != preparedStatement) {
                            preparedStatement.close();
                        }
                        break block14;
                    }
                    catch (SQLException sQLException5) {
                        sQLException = sQLException5;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (null != preparedStatement) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException6) {
                    sQLException = sQLException6;
                }
                throw throwable;
            }
        }
        if (null != sQLException) {
            throw sQLException;
        }
        return list;
    }

    public final List executePreparedQuery(String string) throws SQLException {
        return this.executePreparedQuery(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final int executePreparedUpdate(String string, Object[] objectArray) throws SQLException {
        int n;
        SQLException sQLException;
        block12: {
            Object[] objectArray2 = null;
            objectArray2 = null == objectArray ? new Object[]{} : objectArray;
            CallableStatement callableStatement = null;
            sQLException = null;
            n = 0;
            callableStatement = this.myConnection.prepareCall(string);
            this.setPreparedStatement(callableStatement, objectArray2, 1);
            n = callableStatement.executeUpdate();
            this.traceWarnings(callableStatement);
            callableStatement.close();
            callableStatement = null;
            Object var9_7 = null;
            try {
                if (null != callableStatement) {
                    callableStatement.close();
                }
                break block12;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            break block12;
            {
                catch (SQLException sQLException3) {
                    sQLException = sQLException3;
                    Object var9_8 = null;
                    try {
                        if (null != callableStatement) {
                            callableStatement.close();
                        }
                        break block12;
                    }
                    catch (SQLException sQLException4) {
                        sQLException = sQLException4;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (null != callableStatement) {
                        callableStatement.close();
                    }
                }
                catch (SQLException sQLException5) {
                    sQLException = sQLException5;
                }
                throw throwable;
            }
        }
        if (null != sQLException) {
            throw sQLException;
        }
        return n;
    }

    public final int executePreparedUpdate(String string) throws SQLException {
        return this.executePreparedUpdate(string, null);
    }

    public static boolean containsSQL(String string) {
        if (null == string || string.length() == 0) {
            return false;
        }
        String string2 = string.toLowerCase();
        return string2.indexOf("insert ") >= 0 || string2.indexOf("select ") >= 0 || string2.indexOf("delete ") >= 0 || string2.indexOf("update ") >= 0;
    }

    public void dispose() {
        try {
            if (!this.myConnection.isClosed()) {
                this.myConnection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected Connection getConnection() {
        return this.myConnection;
    }

    public static final String doubleQuote(String string) {
        char c = '\'';
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Integer n = new Integer(string.indexOf(c));
        while (n != -1) {
            linkedList.add(n);
            n = new Integer(string.indexOf(c, n + 1));
        }
        if (linkedList.isEmpty()) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        Iterator iterator = linkedList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next() + n2++;
            stringBuffer.insert(n3, c);
        }
        return stringBuffer.toString();
    }

    public final void commit() throws SQLException {
        if (null != this.myConnection && !this.myConnection.getAutoCommit()) {
            this.myConnection.commit();
        }
    }

    public final void rollback() throws SQLException {
        if (null != this.myConnection && !this.myConnection.getAutoCommit()) {
            this.myConnection.rollback();
        }
    }

    protected final void traceWarnings(Statement statement) throws SQLException {
        SQLWarning sQLWarning = statement.getWarnings();
        if (null != sQLWarning) {
            System.err.println(sQLWarning.getMessage());
        }
    }

    protected final int[] executeSequentialUpdateImpl(List list, Statement statement) throws SQLException {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            n = statement.executeUpdate(this.myConnection.nativeSQL((String)list.get(i)));
            vector.addElement(new Integer(n));
        }
        int[] nArray = new int[vector.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = (Integer)vector.elementAt(n);
        }
        return nArray;
    }

    protected final ResultSet executeQueryImpl(String string, Statement statement) throws SQLException {
        ResultSet resultSet = null;
        resultSet = statement.executeQuery(this.myConnection.nativeSQL(string));
        this.traceWarnings(statement);
        return resultSet;
    }

    protected final int[] executeBatchUpdateImpl(List list, Statement statement) throws SQLException {
        try {
            statement.clearBatch();
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                statement.addBatch(this.myConnection.nativeSQL(string));
            }
        }
        catch (SQLException sQLException) {
            try {
                statement.clearBatch();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
        int[] nArray = statement.executeBatch();
        statement.clearBatch();
        return nArray;
    }

    public static final List executeSelect(String string, Connection connection) throws SQLException {
        return SQL.executeSelect(string, new SQL(connection), false);
    }

    public static final int executeUpdate(String string, Connection connection) throws SQLException {
        return SQL.executeUpdate(string, new SQL(connection), false);
    }

    public static final List executeStoredQuery(String string, Object[] objectArray, Connection connection) throws SQLException {
        return SQL.executeStoredQuery(string, objectArray, new SQL(connection), false);
    }

    public static final int executeStoredUpdate(String string, Object[] objectArray, Connection connection) throws SQLException {
        return SQL.executeStoredUpdate(string, objectArray, new SQL(connection), false);
    }

    public static final List executeSelect(String string, Connection connection, boolean bl) throws SQLException {
        return SQL.executeSelect(string, new SQL(connection), bl);
    }

    public static final int executeUpdate(String string, Connection connection, boolean bl) throws SQLException {
        return SQL.executeUpdate(string, new SQL(connection), bl);
    }

    public static final List executeStoredQuery(String string, Object[] objectArray, Connection connection, boolean bl) throws SQLException {
        return SQL.executeStoredQuery(string, objectArray, new SQL(connection), bl);
    }

    public static final int executeStoredUpdate(String string, Object[] objectArray, Connection connection, boolean bl) throws SQLException {
        return SQL.executeStoredUpdate(string, objectArray, new SQL(connection), bl);
    }

    public static final List executePreparedQuery(String string, Object[] objectArray, Connection connection) throws SQLException {
        return SQL.executePreparedQuery(string, objectArray, new SQL(connection), false);
    }

    public static final int executePreparedUpdate(String string, Object[] objectArray, Connection connection) throws SQLException {
        return SQL.executePreparedUpdate(string, objectArray, new SQL(connection), false);
    }

    public static final List executePreparedQuery(String string, Object[] objectArray, Connection connection, boolean bl) throws SQLException {
        return SQL.executePreparedQuery(string, objectArray, new SQL(connection), bl);
    }

    public static final int executePreparedUpdate(String string, Object[] objectArray, Connection connection, boolean bl) throws SQLException {
        return SQL.executePreparedUpdate(string, objectArray, new SQL(connection), bl);
    }

    private static List executeSelect(String string, SQL sQL, boolean bl) throws SQLException {
        try {
            List list = sQL.executeOrderedQuery(string);
            sQL.commit();
            List list2 = list;
            return list2;
        }
        catch (SQLException sQLException) {
            try {
                sQL.rollback();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
        finally {
            if (bl) {
                sQL.dispose();
            }
        }
    }

    private static int executeUpdate(String string, SQL sQL, boolean bl) throws SQLException {
        try {
            int n = sQL.executeUpdate(string);
            sQL.commit();
            int n2 = n;
            return n2;
        }
        catch (SQLException sQLException) {
            try {
                sQL.rollback();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
        finally {
            if (bl) {
                sQL.dispose();
            }
        }
    }

    private static List executeStoredQuery(String string, Object[] objectArray, SQL sQL, boolean bl) throws SQLException {
        try {
            List list = sQL.executeStoredQuery(string, objectArray);
            sQL.commit();
            List list2 = list;
            return list2;
        }
        catch (SQLException sQLException) {
            try {
                sQL.rollback();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
        finally {
            if (bl) {
                sQL.dispose();
            }
        }
    }

    private static int executeStoredUpdate(String string, Object[] objectArray, SQL sQL, boolean bl) throws SQLException {
        try {
            int n = sQL.executeStoredUpdate(string, objectArray);
            sQL.commit();
            int n2 = n;
            return n2;
        }
        catch (SQLException sQLException) {
            try {
                sQL.rollback();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
        finally {
            if (bl) {
                sQL.dispose();
            }
        }
    }

    private static List executePreparedQuery(String string, Object[] objectArray, SQL sQL, boolean bl) throws SQLException {
        try {
            List list = sQL.executePreparedQuery(string, objectArray);
            sQL.commit();
            List list2 = list;
            return list2;
        }
        catch (SQLException sQLException) {
            try {
                sQL.rollback();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
        finally {
            if (bl) {
                sQL.dispose();
            }
        }
    }

    private static int executePreparedUpdate(String string, Object[] objectArray, SQL sQL, boolean bl) throws SQLException {
        try {
            int n = sQL.executePreparedUpdate(string, objectArray);
            sQL.commit();
            int n2 = n;
            return n2;
        }
        catch (SQLException sQLException) {
            try {
                sQL.rollback();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
        finally {
            if (bl) {
                sQL.dispose();
            }
        }
    }

    private String formatCallableStatement(String string, Object[] objectArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        if (bl) {
            stringBuffer.append("?=");
        }
        stringBuffer.append("call " + string);
        Object[] objectArray2 = null == objectArray ? new Object[]{} : objectArray;
        StringBuffer stringBuffer2 = new StringBuffer();
        if (objectArray2.length > 0) {
            stringBuffer2.append("(");
            for (int i = 0; i < objectArray2.length; ++i) {
                stringBuffer2.append("?,");
            }
            stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
            stringBuffer2.append(")");
        }
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void setPreparedStatement(PreparedStatement preparedStatement, Object[] objectArray, int n) throws SQLException {
        int n2 = 0;
        try {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Object object = objectArray[n2];
                if (null == object) {
                    preparedStatement.setNull(n2 + n, 0);
                    continue;
                }
                if (object instanceof String) {
                    preparedStatement.setString(n2 + n, (String)object);
                    continue;
                }
                if (object instanceof Character) {
                    preparedStatement.setString(n2 + n, (String)object);
                    continue;
                }
                if (object instanceof Integer) {
                    preparedStatement.setInt(n2 + n, (Integer)object);
                    continue;
                }
                if (object instanceof Long) {
                    preparedStatement.setLong(n2 + n, (Long)object);
                    continue;
                }
                if (object instanceof java.util.Date) {
                    preparedStatement.setDate(n2 + n, new Date(((java.util.Date)object).getTime()));
                    continue;
                }
                if (object instanceof Clob) {
                    preparedStatement.setClob(n2 + n, (Clob)object);
                    continue;
                }
                preparedStatement.setObject(n2 + n, object, 1111);
            }
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("Parameter value does not match type : [" + objectArray[n2] + "] not of proper SQL type (" + classCastException.getLocalizedMessage() + ")");
        }
    }

    static final class ResultSetParser {
        private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.S";
        private DateFormat myDateFormat;

        public ResultSetParser() {
            this(DEFAULT_DATE_FORMAT);
        }

        public ResultSetParser(String string) {
            this.myDateFormat = new SimpleDateFormat(string);
        }

        public Map parseMap(ResultSet resultSet) throws SQLException {
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount() + 1;
            while (resultSet.next()) {
                hashMap.put(new UID().toString(), this.getRow(resultSetMetaData, resultSet, n));
            }
            return hashMap;
        }

        public List parseList(ResultSet resultSet) throws SQLException {
            LinkedList<Map> linkedList = new LinkedList<Map>();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount() + 1;
            while (resultSet.next()) {
                linkedList.add(this.getRow(resultSetMetaData, resultSet, n));
            }
            return linkedList;
        }

        protected String parseValue(Clob clob) throws SQLException {
            return null == clob ? null : clob.getSubString(1L, (int)clob.length());
        }

        protected String parseValue(java.util.Date date) throws SQLException {
            return null == date ? null : this.myDateFormat.format(date);
        }

        protected String parseValue(boolean bl) {
            return new Boolean(bl).toString();
        }

        private Map getRow(ResultSetMetaData resultSetMetaData, ResultSet resultSet, int n) throws SQLException {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 1; i < n; ++i) {
                String string = resultSetMetaData.getColumnName(i);
                String string2 = this.handleValue(resultSet, resultSetMetaData.getColumnType(i), i);
                if (resultSet.wasNull()) {
                    hashMap.put(string, "");
                    continue;
                }
                hashMap.put(string, string2);
            }
            return hashMap;
        }

        protected String handleValue(ResultSet resultSet, int n, int n2) throws SQLException {
            String string = null;
            switch (n) {
                case 2005: {
                    string = this.parseValue(resultSet.getClob(n2));
                    break;
                }
                case 91: {
                    string = this.parseValue(resultSet.getDate(n2));
                    break;
                }
                case 93: {
                    string = this.parseValue(resultSet.getTimestamp(n2));
                    break;
                }
                case 92: {
                    string = this.parseValue(resultSet.getTime(n2));
                    break;
                }
                case -7: {
                    string = this.parseValue(resultSet.getBoolean(n2));
                    break;
                }
                default: {
                    string = resultSet.getString(n2);
                }
            }
            return string;
        }
    }
}

