/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.swing;

import com.tlabs.util.Resource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;

public abstract class TAction
extends AbstractAction {
    public static final String SELECTED = "selected";
    public static final String ENABLED = "enabled";
    public static final String DISABLE_PARENT = "disableparent";
    private static Resource _resource = Resource.getInstance();
    private ButtonModel _buttonModel = null;

    public TAction(String string) {
        this(string, null);
    }

    public TAction(String string, Icon icon) {
        this(string, icon, false);
    }

    public TAction(String string, Icon icon, boolean bl) {
        super(string, icon);
        this.putValue(DISABLE_PARENT, new Boolean(bl));
        this.setTooltip(string);
    }

    public abstract void actionPerformed(ActionEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ButtonModel getButtonModel() {
        if (null == this._buttonModel) {
            TAction tAction = this;
            synchronized (tAction) {
                if (null == this._buttonModel) {
                    this._buttonModel = this.createButtonModel();
                }
            }
        }
        return this._buttonModel;
    }

    public final Icon getIcon() {
        return (Icon)super.getValue("SmallIcon");
    }

    public final void setIcon(Icon icon) {
        super.putValue("SmallIcon", icon);
    }

    public final String getName() {
        return (String)super.getValue("Name");
    }

    public final void setName(String string) {
        super.putValue("Name", string);
    }

    public final String getTooltip() {
        return (String)super.getValue("ShortDescription");
    }

    public final void setTooltip(String string) {
        super.putValue("ShortDescription", string);
    }

    public final String getDescription() {
        return (String)super.getValue("LongDescription");
    }

    public final void setDescription(String string) {
        super.putValue("LongDescription", string);
    }

    public final JButton createNewButton() {
        return this.createNewButton(true, true);
    }

    public final JButton createNewButton(boolean bl) {
        return this.createNewButton(true, bl);
    }

    public final JButton createNewButton(boolean bl, boolean bl2) {
        JButton jButton = null;
        jButton = bl ? (bl2 ? new JButton(this.getName(), this.getIcon()) : new JButton(this.getName())) : (bl2 ? new JButton(this.getIcon()) : new JButton());
        return (JButton)this.applyModel(jButton);
    }

    public final JMenuItem createNewMenuItem() {
        return this.createNewMenuItem(true, false);
    }

    public final JMenuItem createNewMenuItem(boolean bl) {
        return this.createNewMenuItem(true, bl);
    }

    public final JMenuItem createNewMenuItem(boolean bl, boolean bl2) {
        JMenuItem jMenuItem = null;
        jMenuItem = bl ? (bl2 ? new JMenuItem(this.getName(), this.getIcon()) : new JMenuItem(this.getName())) : (bl2 ? new JMenuItem(this.getIcon()) : new JMenuItem());
        return (JMenuItem)this.applyModel(jMenuItem);
    }

    public final JCheckBox createNewCheckBox() {
        return this.createNewCheckBox(true, false);
    }

    public final JCheckBox createNewCheckBox(boolean bl) {
        return this.createNewCheckBox(true, bl);
    }

    public final JCheckBox createNewCheckBox(boolean bl, boolean bl2) {
        JCheckBox jCheckBox = null;
        jCheckBox = bl ? (bl2 ? new JCheckBox(this.getName(), this.getIcon()) : new JCheckBox(this.getName())) : (bl2 ? new JCheckBox(this.getIcon()) : new JCheckBox());
        return (JCheckBox)this.applyModel(jCheckBox);
    }

    public final JRadioButton createNewRadioButton() {
        return this.createNewRadioButton(true, false);
    }

    public final JRadioButton createNewRadioButton(boolean bl) {
        return this.createNewRadioButton(true, bl);
    }

    public final JRadioButton createNewRadioButton(boolean bl, boolean bl2) {
        JRadioButton jRadioButton = null;
        jRadioButton = bl ? (bl2 ? new JRadioButton(this.getName(), this.getIcon()) : new JRadioButton(this.getName())) : (bl2 ? new JRadioButton(this.getIcon()) : new JRadioButton());
        return (JRadioButton)this.applyModel(jRadioButton);
    }

    protected final ButtonModel createButtonModel() {
        DefaultButtonModel defaultButtonModel = new DefaultButtonModel(){

            public void setSelected(boolean bl) {
                ButtonGroup buttonGroup = this.getGroup();
                if (buttonGroup != null) {
                    buttonGroup.setSelected(this, bl);
                    bl = buttonGroup.isSelected(this);
                }
                super.setSelected(bl);
            }
        };
        defaultButtonModel.setActionCommand(this.getName());
        defaultButtonModel.addActionListener(this);
        defaultButtonModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ButtonModel buttonModel;
                buttonModel.setSelected(!(buttonModel = (ButtonModel)actionEvent.getSource()).isSelected());
                TAction.this.putValue(TAction.SELECTED, new Boolean(buttonModel.isSelected()));
            }
        });
        return defaultButtonModel;
    }

    protected AbstractButton applyModel(AbstractButton abstractButton) {
        abstractButton.setModel(this.getButtonModel());
        this.addPropertyChangeListener(new ActionChangedListener(abstractButton));
        abstractButton.setEnabled(this.isEnabled());
        return abstractButton;
    }

    public AbstractButton setAction(AbstractButton abstractButton) {
        Icon icon;
        String string = this.getName();
        if (string != null) {
            abstractButton.setText(string);
        }
        if ((icon = this.getIcon()) != null) {
            abstractButton.setIcon(icon);
        }
        return this.applyModel(abstractButton);
    }

    protected static final String resString(String string) {
        return _resource.getString(string, string);
    }

    protected static final String resString(String string, String string2) {
        return _resource.getString(string, string2);
    }

    protected static final String resFormat(String string, Object object) {
        return _resource.formatString(string, object);
    }

    protected static final String resFormat(String string, Object[] objectArray) {
        return _resource.formatString(string, objectArray);
    }

    protected static final ImageIcon resIcon(String string) {
        return _resource.getIcon(string);
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton abstractButton) {
            this.setTarget(abstractButton);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                this.handleNameChanged((String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals(TAction.ENABLED)) {
                this.handleEnabledChanged((Boolean)propertyChangeEvent.getNewValue());
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                this.handleIconChanged((Icon)propertyChangeEvent.getNewValue());
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals(TAction.SELECTED)) {
                this.handleSelectedChanged((Boolean)propertyChangeEvent.getNewValue());
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                this.handleTooltipChanged((String)propertyChangeEvent.getNewValue());
                return;
            }
        }

        public void setTarget(AbstractButton abstractButton) {
            this.button = abstractButton;
        }

        private void handleNameChanged(String string) {
            this.button.setText(string);
            this.button.repaint();
        }

        private void handleTooltipChanged(String string) {
            this.button.setToolTipText(string);
            this.button.repaint();
        }

        private void handleEnabledChanged(boolean bl) {
            this.button.setEnabled(bl);
            this.button.repaint();
        }

        private void handleSelectedChanged(boolean bl) {
            this.button.setSelected(bl);
            this.button.repaint();
        }

        private void handleIconChanged(Icon icon) {
            this.button.setIcon(icon);
            this.button.repaint();
        }
    }
}

