/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.swing;

import com.tlabs.swing.MessageDialog;
import com.tlabs.util.Resource;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;

public class TFileChooser
extends JFileChooser {
    private File _lastDirectory = null;
    private boolean _isShowConfirmationOnSave;

    public TFileChooser() {
        this(null, true);
    }

    public TFileChooser(boolean bl) {
        this(null, bl);
    }

    public TFileChooser(File file, boolean bl) {
        this._lastDirectory = null == file || !file.isDirectory() ? new File(System.getProperty("user.dir", ".")) : file;
        this._isShowConfirmationOnSave = true;
    }

    public void setShowConfirmation(boolean bl) {
        this._isShowConfirmationOnSave = bl;
    }

    public boolean getShowConfirmation() {
        return this._isShowConfirmationOnSave;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            super.setCurrentDirectory(this._lastDirectory);
        } else {
            this.setCurrentDirectory(this.getCurrentDirectory());
        }
        super.setVisible(bl);
    }

    public void dispose() {
        this.setCurrentDirectory(super.getCurrentDirectory());
    }

    public void approveSelection() {
        super.approveSelection();
        this.setCurrentDirectory(super.getCurrentDirectory());
    }

    public void setCurrentDirectory(File file) {
        this._lastDirectory = null == file ? new File(System.getProperty("user.dir", ".")) : file;
        super.setCurrentDirectory(this._lastDirectory);
    }

    public int showDialog(Component component, String string) {
        super.setCurrentDirectory(this._lastDirectory);
        return super.showDialog(component, string);
    }

    public int showOpenDialog(Component component) {
        super.setCurrentDirectory(this._lastDirectory);
        return super.showOpenDialog(component);
    }

    public int showSaveDialog(Component component) {
        super.setCurrentDirectory(this._lastDirectory);
        int n = super.showSaveDialog(component);
        File file = this.getSelectedFile();
        if (null != file && file.exists() && n == 0 && this.getShowConfirmation()) {
            n = this.showConfirmationDialog(file);
        }
        return n;
    }

    public int showConfirmationDialog(File file) {
        if (MessageDialog.showModal(null, 3, 0, this.resString("ConfirmationDialogTitle"), this.resFormat("ConfirmationDialogMessage", file.getAbsolutePath())) == 0) {
            file.delete();
            return 0;
        }
        return 1;
    }

    private String resString(String string) {
        return Resource.getInstance().getString(string);
    }

    private String resFormat(String string, Object object) {
        return Resource.getInstance().formatString(string, object);
    }
}

