/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.swing;

import com.tlabs.util.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class TMatrixSelectionButton
extends JButton {
    public static final int DEFAULT_BASE_WIDTH = 2;
    public static final int DEFAULT_BASE_HEIGHT = 2;
    public static final int DEFAULT_MAX_WIDTH = 5;
    public static final int DEFAULT_MAX_HEIGHT = 5;
    public static final int DEFAULT_SQUARE_PANEL_SIZE = 30;
    static final String RESOURCE_CANCEL = "TMatrixSelectionButton.Cancel";
    static final String RESOURCE_LABEL = "TMatrixSelectionButton.Label";
    private static Resource _resource = Resource.getInstance();
    private boolean rememberSize;
    private Dimension baseSize;
    private Dimension maxSize;
    private Dimension panelSize;
    private int popupSizeX;
    private int currentSelectedX;
    private int previousSelectedX;
    private int returnSizeX;
    private int popupSizeY;
    private int currentSelectedY;
    private int previousSelectedY;
    private int returnSizeY;
    private JWindow popup;
    private JPanel tilePanel;
    private JLabel sizeLabel;

    public TMatrixSelectionButton() {
        this.init();
    }

    public TMatrixSelectionButton(String string) {
        super(string);
        this.init();
    }

    public TMatrixSelectionButton(Icon icon) {
        super(icon);
        this.init();
    }

    public TMatrixSelectionButton(String string, Icon icon) {
        super(string, icon);
        this.init();
    }

    private void init() {
        this.baseSize = new Dimension(2, 2);
        this.maxSize = new Dimension(5, 5);
        this.panelSize = new Dimension(30, 30);
        this.rememberSize = false;
        this.popupSizeX = this.baseSize.width;
        this.popupSizeY = this.baseSize.height;
        this.previousSelectedX = this.baseSize.width;
        this.previousSelectedY = this.baseSize.height;
        this.returnSizeX = -1;
        this.returnSizeY = -1;
        this.addMouseListener(new SpecialMouseAdapter());
        this.addMouseMotionListener(new SpecialMouseMotionAdapter());
    }

    public Dimension getSelectedSize() {
        return new Dimension(this.returnSizeX, this.returnSizeY);
    }

    public boolean isRememberSize() {
        return this.rememberSize;
    }

    public void setRememberSize(boolean bl) {
        this.rememberSize = bl;
    }

    public Dimension getBaseSize() {
        return this.baseSize;
    }

    public void setBaseSize(Dimension dimension) throws IllegalArgumentException {
        if (dimension.width <= 0 || dimension.width >= this.maxSize.width || dimension.height <= 0 || dimension.height >= this.maxSize.height) {
            throw new IllegalArgumentException("Base size out of bounds");
        }
        this.baseSize = dimension;
    }

    public Dimension getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Dimension dimension) throws IllegalArgumentException {
        if (dimension.width <= 0 || dimension.height <= 0) {
            throw new IllegalArgumentException("Max size out of bounds");
        }
        this.maxSize = dimension;
    }

    public Dimension getPanelSize() {
        return this.panelSize;
    }

    public void setPanelSize(Dimension dimension) {
        this.panelSize = dimension;
    }

    class SpecialMouseMotionAdapter
    extends MouseMotionAdapter {
        private int mouseLocationX;
        private int mouseLocationY;
        private int popupLocationX;
        private int popupLocationY;
        private int number;
        private Component[] tiles;

        SpecialMouseMotionAdapter() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16) {
                int n;
                this.mouseLocationX = mouseEvent.getX() + ((JButton)mouseEvent.getSource()).getLocationOnScreen().x;
                this.mouseLocationY = mouseEvent.getY() + ((JButton)mouseEvent.getSource()).getLocationOnScreen().y;
                this.popupLocationX = ((TMatrixSelectionButton)TMatrixSelectionButton.this).popup.getLocationOnScreen().x;
                this.popupLocationY = ((TMatrixSelectionButton)TMatrixSelectionButton.this).popup.getLocationOnScreen().y;
                this.tiles = TMatrixSelectionButton.this.tilePanel.getComponents();
                for (n = 0; n < this.tiles.length; ++n) {
                    this.tiles[n].setBackground(TMatrixSelectionButton.this.popup.getContentPane().getBackground());
                }
                TMatrixSelectionButton.this.currentSelectedX = 0;
                TMatrixSelectionButton.this.currentSelectedY = 0;
                TMatrixSelectionButton.this.returnSizeX = -1;
                TMatrixSelectionButton.this.returnSizeY = -1;
                if (this.mouseLocationX > this.popupLocationX && this.mouseLocationY > this.popupLocationY) {
                    TMatrixSelectionButton.this.currentSelectedX = 1 + (this.mouseLocationX - this.popupLocationX) / ((TMatrixSelectionButton)TMatrixSelectionButton.this).panelSize.width;
                    TMatrixSelectionButton.this.currentSelectedY = 1 + (this.mouseLocationY - this.popupLocationY) / ((TMatrixSelectionButton)TMatrixSelectionButton.this).panelSize.height;
                    if (TMatrixSelectionButton.this.currentSelectedX <= TMatrixSelectionButton.this.popupSizeX && TMatrixSelectionButton.this.currentSelectedY <= TMatrixSelectionButton.this.popupSizeY) {
                        TMatrixSelectionButton.this.returnSizeX = Math.min(TMatrixSelectionButton.this.currentSelectedX, ((TMatrixSelectionButton)TMatrixSelectionButton.this).maxSize.width);
                        TMatrixSelectionButton.this.returnSizeY = Math.min(TMatrixSelectionButton.this.currentSelectedY, ((TMatrixSelectionButton)TMatrixSelectionButton.this).maxSize.height);
                        for (n = 0; n < this.tiles.length; ++n) {
                            if (n % TMatrixSelectionButton.this.popupSizeX >= TMatrixSelectionButton.this.currentSelectedX || n / TMatrixSelectionButton.this.popupSizeX >= TMatrixSelectionButton.this.currentSelectedY) continue;
                            this.tiles[n].setBackground(Color.blue);
                        }
                    } else if (TMatrixSelectionButton.this.currentSelectedX <= ((TMatrixSelectionButton)TMatrixSelectionButton.this).maxSize.width && TMatrixSelectionButton.this.currentSelectedY <= ((TMatrixSelectionButton)TMatrixSelectionButton.this).maxSize.height) {
                        TMatrixSelectionButton.this.popupSizeX = Math.min(Math.max(TMatrixSelectionButton.this.currentSelectedX, ((TMatrixSelectionButton)TMatrixSelectionButton.this).baseSize.width), ((TMatrixSelectionButton)TMatrixSelectionButton.this).maxSize.width);
                        TMatrixSelectionButton.this.popupSizeY = Math.min(Math.max(TMatrixSelectionButton.this.currentSelectedY, ((TMatrixSelectionButton)TMatrixSelectionButton.this).baseSize.width), ((TMatrixSelectionButton)TMatrixSelectionButton.this).maxSize.width);
                        TMatrixSelectionButton.this.popup.setSize(TMatrixSelectionButton.this.popupSizeX * ((TMatrixSelectionButton)TMatrixSelectionButton.this).panelSize.width, (TMatrixSelectionButton.this.popupSizeY + 1) * ((TMatrixSelectionButton)TMatrixSelectionButton.this).panelSize.height);
                        TMatrixSelectionButton.this.tilePanel.removeAll();
                        TMatrixSelectionButton.this.tilePanel.setLayout(new GridLayout(TMatrixSelectionButton.this.popupSizeY, TMatrixSelectionButton.this.popupSizeX));
                        for (n = 0; n < TMatrixSelectionButton.this.popupSizeX * TMatrixSelectionButton.this.popupSizeY; ++n) {
                            JPanel jPanel = new JPanel();
                            jPanel.setBorder(BorderFactory.createBevelBorder(1));
                            TMatrixSelectionButton.this.tilePanel.add(jPanel);
                        }
                        TMatrixSelectionButton.this.popup.validate();
                    }
                }
                if (TMatrixSelectionButton.this.returnSizeX != -1 && TMatrixSelectionButton.this.returnSizeY != -1) {
                    Object[] objectArray = new Integer[]{new Integer(TMatrixSelectionButton.this.returnSizeX), new Integer(TMatrixSelectionButton.this.returnSizeY)};
                    TMatrixSelectionButton.this.sizeLabel.setText(_resource.formatString(TMatrixSelectionButton.RESOURCE_LABEL, objectArray, "{0,number,#} x {1,number,#}"));
                } else {
                    TMatrixSelectionButton.this.sizeLabel.setText(_resource.getString(TMatrixSelectionButton.RESOURCE_CANCEL, "Cancel"));
                }
            }
        }
    }

    class SpecialMouseAdapter
    extends MouseAdapter {
        SpecialMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16) {
                if (!TMatrixSelectionButton.this.rememberSize) {
                    TMatrixSelectionButton.this.popupSizeX = ((TMatrixSelectionButton)TMatrixSelectionButton.this).baseSize.width;
                    TMatrixSelectionButton.this.popupSizeY = ((TMatrixSelectionButton)TMatrixSelectionButton.this).baseSize.height;
                } else if (TMatrixSelectionButton.this.returnSizeX != -1 && TMatrixSelectionButton.this.returnSizeY != -1) {
                    TMatrixSelectionButton.this.popupSizeX = Math.max(TMatrixSelectionButton.this.returnSizeX, ((TMatrixSelectionButton)TMatrixSelectionButton.this).baseSize.width);
                    TMatrixSelectionButton.this.popupSizeY = Math.max(TMatrixSelectionButton.this.returnSizeY, ((TMatrixSelectionButton)TMatrixSelectionButton.this).baseSize.height);
                } else {
                    TMatrixSelectionButton.this.popupSizeX = Math.min(TMatrixSelectionButton.this.previousSelectedX, ((TMatrixSelectionButton)TMatrixSelectionButton.this).baseSize.width);
                    TMatrixSelectionButton.this.popupSizeY = Math.min(TMatrixSelectionButton.this.previousSelectedY, ((TMatrixSelectionButton)TMatrixSelectionButton.this).baseSize.height);
                }
                TMatrixSelectionButton.this.returnSizeX = -1;
                TMatrixSelectionButton.this.returnSizeY = -1;
                if (TMatrixSelectionButton.this.popup != null) {
                    TMatrixSelectionButton.this.popup.dispose();
                }
                TMatrixSelectionButton.this.popup = new JWindow();
                TMatrixSelectionButton.this.popup.setSize(TMatrixSelectionButton.this.popupSizeX * ((TMatrixSelectionButton)TMatrixSelectionButton.this).panelSize.width, (TMatrixSelectionButton.this.popupSizeY + 1) * ((TMatrixSelectionButton)TMatrixSelectionButton.this).panelSize.height);
                TMatrixSelectionButton.this.popup.setLocation(((JButton)mouseEvent.getSource()).getLocationOnScreen().x, ((JButton)mouseEvent.getSource()).getLocationOnScreen().y + ((JButton)mouseEvent.getSource()).getHeight());
                TMatrixSelectionButton.this.popup.getRootPane().setBorder(BorderFactory.createEtchedBorder());
                TMatrixSelectionButton.this.tilePanel = new JPanel();
                TMatrixSelectionButton.this.tilePanel.setLayout(new GridLayout(TMatrixSelectionButton.this.popupSizeY, TMatrixSelectionButton.this.popupSizeX));
                for (int i = 0; i < TMatrixSelectionButton.this.popupSizeX * TMatrixSelectionButton.this.popupSizeY; ++i) {
                    JPanel jPanel = new JPanel();
                    jPanel.setBorder(BorderFactory.createBevelBorder(1));
                    TMatrixSelectionButton.this.tilePanel.add(jPanel);
                }
                TMatrixSelectionButton.this.sizeLabel = new JLabel(_resource.getString(TMatrixSelectionButton.RESOURCE_CANCEL, "Cancel"), 0);
                TMatrixSelectionButton.this.sizeLabel.setSize(TMatrixSelectionButton.this.popupSizeX * ((TMatrixSelectionButton)TMatrixSelectionButton.this).panelSize.width, ((TMatrixSelectionButton)TMatrixSelectionButton.this).panelSize.height);
                TMatrixSelectionButton.this.popup.getContentPane().add((Component)TMatrixSelectionButton.this.tilePanel, "Center");
                TMatrixSelectionButton.this.popup.getContentPane().add((Component)TMatrixSelectionButton.this.sizeLabel, "South");
                TMatrixSelectionButton.this.popup.setVisible(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (TMatrixSelectionButton.this.popup != null) {
                TMatrixSelectionButton.this.popup.dispose();
                TMatrixSelectionButton.this.popup = null;
                TMatrixSelectionButton.this.tilePanel = null;
                TMatrixSelectionButton.this.sizeLabel = null;
            }
            if (TMatrixSelectionButton.this.returnSizeX != -1 && TMatrixSelectionButton.this.returnSizeY != -1) {
                TMatrixSelectionButton.this.previousSelectedX = TMatrixSelectionButton.this.returnSizeX;
                TMatrixSelectionButton.this.previousSelectedY = TMatrixSelectionButton.this.returnSizeY;
            }
            ((JButton)mouseEvent.getSource()).doClick();
        }
    }
}

