/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.swing;

import com.tlabs.awt.GridBags;
import com.tlabs.swing.TPanel;
import com.tlabs.util.Timer;
import com.tlabs.util.TimerTask;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class TMemoryDisplayPanel
extends TPanel {
    public static final byte FREE_MEMORY = 0;
    public static final byte USED_MEMORY = 1;
    private static final int DEFAULT_DELAY = 10000;
    private static final int MINIMUM_DELAY = 50;
    private static final int SQUARE_1024 = 0x100000;
    private JProgressBar _progress;
    private JLabel _label;
    private Timer _timer;
    private TimerTask _task;
    private int _delay;
    private boolean _displayOver;
    private byte _displayMode;

    public TMemoryDisplayPanel() {
        this(10000, false, 0);
    }

    public TMemoryDisplayPanel(int n) {
        this(n, false, 0);
    }

    public TMemoryDisplayPanel(boolean bl) {
        this(10000, bl, 0);
    }

    public TMemoryDisplayPanel(byte by) {
        this(10000, false, by);
    }

    public TMemoryDisplayPanel(int n, boolean bl) {
        this(n, bl, 0);
    }

    public TMemoryDisplayPanel(int n, byte by) {
        this(n, false, by);
    }

    public TMemoryDisplayPanel(boolean bl, byte by) {
        this(10000, bl, by);
    }

    public TMemoryDisplayPanel(int n, boolean bl, byte by) {
        super(new GridBagLayout());
        this._delay = n < 50 ? 10000 : n;
        this._task = new TimerTask(){

            public void run() {
                TMemoryDisplayPanel.this.refresh();
            }
        };
        this._timer = new Timer(true);
        this._timer.schedule(this._task, n, (long)n);
        this._progress = new JProgressBar();
        this._displayOver = bl;
        this._displayMode = by;
        this.add((Component)this._progress, GridBags.flat(0, 0).anchor(13));
        if (bl) {
            this._label = null;
            this._progress.setStringPainted(true);
        } else {
            this._label = new JLabel("     ");
            this.add((Component)this._label, GridBags.tight(1, 0).anchor(13));
        }
        this.refresh();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this._task.undoCancel();
            this._timer.schedule(this._task, this._delay, (long)this._delay);
            this.refresh();
        } else {
            this._task.cancel();
        }
    }

    public void refresh() {
        this.refreshMe();
        this.repaint();
    }

    private void refreshMe() {
        Runtime runtime = Runtime.getRuntime();
        Object[] objectArray = new Integer[]{new Integer((int)((1 == this._displayMode ? runtime.totalMemory() - runtime.freeMemory() : runtime.freeMemory()) / 0x100000L)), new Integer((int)(runtime.totalMemory() / 0x100000L))};
        String string = this.resFormat("TMemoryDisplayPanel.Label", objectArray, "{0,  number,#}Mb of {1, number,#}Mb");
        this._progress.setMinimum(0);
        this._progress.setMaximum((Integer)objectArray[1]);
        this._progress.setValue((Integer)objectArray[0]);
        this.setLabel(string);
    }

    private void setLabel(String string) {
        if (this._displayOver) {
            this._progress.setString(string);
        } else {
            this._label.setText(string);
        }
    }
}

