/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util;

import com.tlabs.util.SchedulerTaskEvent;
import com.tlabs.util.SchedulerTaskListener;
import com.tlabs.util.TimerTask;
import com.tlabs.util.debug.Debug;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public abstract class SchedulerTask
extends TimerTask {
    private static final String LOG = "TimerTask";
    private long myInitialTime;
    private long myRepeatDelay;
    private long myRepeatCount;
    private long myCurrentRepeatCount;
    private boolean myIsFixedRate;
    private boolean myIsRunning;
    private boolean myWasCancelled;
    private boolean myCancelOnError;
    private boolean myWaitForCompletion;
    private Object myConstruct = null;
    private Object myLock;
    private transient List myListenerList;

    private SchedulerTask(long l, long l2, long l3, boolean bl) {
        this(l, l2, l3, bl, true);
    }

    private SchedulerTask(long l, long l2, long l3, boolean bl, boolean bl2) {
        this.myInitialTime = l;
        this.myRepeatDelay = l2 <= 0L ? Long.MAX_VALUE : l2;
        this.myRepeatCount = l3;
        this.myIsFixedRate = bl;
        this.myCancelOnError = bl2;
        this.myCurrentRepeatCount = l3;
        this.myWasCancelled = false;
        this.myWaitForCompletion = true;
        this.myIsRunning = false;
        this.myListenerList = new Vector();
        this.myLock = new Object();
    }

    public SchedulerTask(Date date, long l, long l2, boolean bl) {
        this(date.getTime(), l, l2, bl);
    }

    public SchedulerTask(Date date, long l, long l2) {
        this(date, l, l2, true);
    }

    public SchedulerTask(Date date, long l) {
        this(date, l, true);
    }

    public SchedulerTask(Date date, long l, boolean bl) {
        this(date, l, -1L, bl);
    }

    public SchedulerTask(Date date) {
        this(date, Long.MAX_VALUE, 1L, false);
    }

    public final synchronized void run() {
        if (this.isCompleted()) {
            return;
        }
        this.taskStarting();
        if (this.isCancelled()) {
            this.trace("Task aborted");
        } else {
            new Thread(new SchedulerTaskThread()).start();
        }
    }

    public abstract Object execute();

    public final long getInitialTime() {
        return this.myInitialTime;
    }

    public final Date getInitialDate() {
        return new Date(this.getInitialTime());
    }

    public final long getRepeatDelay() {
        return this.myRepeatDelay;
    }

    public final long getRepeatCount() {
        return this.myRepeatCount;
    }

    public final long getRemainingRepeatCount() {
        return this.myCurrentRepeatCount;
    }

    public final boolean isFixedRepeatRate() {
        return this.myIsFixedRate;
    }

    public boolean cancel() {
        if (!this.myWasCancelled) {
            this.myWasCancelled = super.cancel();
            if (this.myWasCancelled) {
                this.taskCancelled();
            }
        }
        return this.myWasCancelled;
    }

    public boolean isCancelled() {
        return this.myWasCancelled;
    }

    public final boolean isExecuting() {
        return this.myIsRunning;
    }

    public boolean isCompleted() {
        return this.myWasCancelled || this.myCurrentRepeatCount == 0L;
    }

    public final Object getConstruct() {
        return this.myConstruct;
    }

    public final void setCancelOnError(boolean bl) {
        this.myCancelOnError = bl;
    }

    public final boolean getCancelOnError() {
        return this.myCancelOnError;
    }

    final void reset() {
        if (!this.myWasCancelled) {
            this.cancel();
        }
        this.myWasCancelled = false;
        this.myIsRunning = false;
        super.undoCancel();
    }

    public final void setWaitForCompletion(boolean bl) {
        this.myWaitForCompletion = bl;
    }

    public final boolean getWaitForCompletion() {
        return this.myWaitForCompletion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTaskListener(SchedulerTaskListener schedulerTaskListener) {
        List list = this.myListenerList;
        synchronized (list) {
            this.myListenerList.add(schedulerTaskListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTaskListener(SchedulerTaskListener schedulerTaskListener) {
        List list = this.myListenerList;
        synchronized (list) {
            this.myListenerList.remove(schedulerTaskListener);
        }
    }

    protected synchronized void taskError(Throwable throwable) {
        this.fireSchedulerEvent(new SchedulerTaskEvent(this, throwable));
    }

    protected synchronized void taskCompleted() {
        this.fireSchedulerEvent(new SchedulerTaskEvent(this, 2));
    }

    protected synchronized void taskStarted() {
        this.fireSchedulerEvent(new SchedulerTaskEvent(this, 1));
    }

    protected synchronized void taskCancelled() {
        this.fireSchedulerEvent(new SchedulerTaskEvent(this, 3));
    }

    protected synchronized void taskStarting() {
        this.fireSchedulerEvent(new SchedulerTaskEvent(this, 0));
    }

    protected void trace(String string) {
        Debug.trace(LOG, string);
    }

    protected void trace(Throwable throwable) {
        Debug.trace(LOG, throwable);
    }

    protected void log(String string) {
        Debug.log(string);
    }

    protected void log(Throwable throwable) {
        Debug.log(throwable);
    }

    protected void log(String string, Throwable throwable) {
        Debug.log(string);
        Debug.log(throwable);
    }

    private boolean getExecuting() {
        return this.myIsRunning;
    }

    private void setExecuting(boolean bl) {
        if (this.myIsRunning == bl) {
            return;
        }
        this.myIsRunning = bl;
        if (bl) {
            if (this.myCurrentRepeatCount != -1L) {
                --this.myCurrentRepeatCount;
            }
            this.taskStarted();
        } else {
            this.taskCompleted();
            if (this.myCurrentRepeatCount == 0L) {
                this.cancel();
            }
        }
    }

    private void setConstruct(Object object) {
        this.myConstruct = object;
    }

    protected void finalize() throws Throwable {
        this.myListenerList.clear();
        super.finalize();
    }

    private void fireSchedulerEvent(SchedulerTaskEvent schedulerTaskEvent) {
        SchedulerTaskEvent schedulerTaskEvent2 = schedulerTaskEvent;
        for (int i = 0; i < this.myListenerList.size(); ++i) {
            SchedulerTaskListener schedulerTaskListener = (SchedulerTaskListener)this.myListenerList.get(i);
            try {
                switch (schedulerTaskEvent2.getType()) {
                    case 0: {
                        schedulerTaskListener.taskStarting(schedulerTaskEvent2);
                        break;
                    }
                    case 1: {
                        schedulerTaskListener.taskStarted(schedulerTaskEvent2);
                        break;
                    }
                    case 2: {
                        schedulerTaskListener.taskCompleted(schedulerTaskEvent2);
                        break;
                    }
                    case 3: {
                        schedulerTaskListener.taskCancelled(schedulerTaskEvent2);
                        break;
                    }
                    case 4: {
                        schedulerTaskListener.taskError(schedulerTaskEvent2);
                        break;
                    }
                }
                continue;
            }
            catch (Exception exception) {
                this.trace(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(SchedulerTaskThread schedulerTaskThread) {
        Object object = this.myLock;
        synchronized (object) {
            this.trace("Locking Task " + schedulerTaskThread.getName());
            try {
                this.myLock.wait();
            }
            catch (InterruptedException interruptedException) {
                this.trace("Task interrupted : " + schedulerTaskThread.getName() + " (" + interruptedException.getLocalizedMessage() + ")");
                this.taskError(interruptedException);
                this.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(SchedulerTaskThread schedulerTaskThread) {
        Object object = this.myLock;
        synchronized (object) {
            this.trace("Unlocking Task " + schedulerTaskThread.getName());
            this.myLock.notify();
        }
    }

    private class SchedulerTaskThread
    extends Thread
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (SchedulerTask.this.getWaitForCompletion()) {
                while (SchedulerTask.this.getExecuting() && !SchedulerTask.this.isCancelled() && !SchedulerTask.this.isCompleted()) {
                    SchedulerTask.this.lock(this);
                }
            }
            if (SchedulerTask.this.isCancelled()) return;
            if (SchedulerTask.this.isCompleted()) {
                return;
            }
            try {
                try {
                    SchedulerTask.this.setExecuting(true);
                    SchedulerTask.this.setConstruct(SchedulerTask.this.execute());
                }
                catch (Exception exception) {
                    SchedulerTask.this.taskError(exception);
                    SchedulerTask.this.setConstruct(null);
                    Object var3_2 = null;
                    SchedulerTask.this.setExecuting(false);
                    SchedulerTask.this.unlock(this);
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                SchedulerTask.this.setExecuting(false);
                SchedulerTask.this.unlock(this);
                throw throwable;
            }
            SchedulerTask.this.setExecuting(false);
            SchedulerTask.this.unlock(this);
        }
    }
}

