/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.util.debug.log4j;

import com.tlabs.awt.GridBags;
import com.tlabs.swing.TAction;
import com.tlabs.swing.TPanel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.TTCCLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public final class PanelAppender
extends AsyncAppender {
    private Layout myLayout;
    private static LogPanel myLogPanel = new LogPanel(65536);

    public PanelAppender() {
        this.setLayout((Layout)new TTCCLayout());
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setLayout(Layout layout) {
        super.setLayout(layout);
        this.myLayout = null == layout ? new TTCCLayout() : layout;
    }

    public void append(LoggingEvent loggingEvent) {
        myLogPanel.append(this.myLayout.format(loggingEvent));
        ThrowableInformation throwableInformation = loggingEvent.getThrowableInformation();
        if (null != throwableInformation && null != throwableInformation.getThrowable()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwableInformation.getThrowable().printStackTrace(printWriter);
            printWriter.flush();
            stringWriter.flush();
            myLogPanel.append(stringWriter.toString());
        }
    }

    public static JPanel getPanel() {
        return myLogPanel;
    }

    public void setMaximumLength(int n) {
        myLogPanel.setMaximumLength(n);
    }

    public int getMaximumLength() {
        return myLogPanel.getMaximumLength();
    }

    public void clear() {
        myLogPanel.clear();
    }

    public void close() {
        myLogPanel.clear();
    }

    private static class LogPanel
    extends TPanel {
        private JTextArea myTextArea = new JTextArea();
        private JScrollPane myScrollPane;
        private int myMaximumLength;

        public LogPanel(int n) {
            super(new GridBagLayout());
            this.myMaximumLength = n;
            this.myScrollPane = new JScrollPane(this.myTextArea, 20, 30);
            this.add((Component)this.myScrollPane, GridBags.full(0, 0).anchor(11));
            this.add((Component)new TAction(this, this.resString("Clear")){
                private final /* synthetic */ LogPanel this$0;
                {
                    this.this$0 = logPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.clear();
                }
            }.createNewButton(), GridBags.tight(0, 1).anchor(16));
        }

        public void append(String string) {
            int n;
            if (this.myMaximumLength > 0 && (n = this.myTextArea.getText().length() + string.length()) > this.myMaximumLength) {
                this.myTextArea.replaceRange("", 0, n - this.myMaximumLength);
            }
            this.myTextArea.append(string);
        }

        public void clear() {
            this.myTextArea.setText("");
        }

        public void setMaximumLength(int n) {
            this.myMaximumLength = n;
        }

        public int getMaximumLength() {
            return this.myMaximumLength;
        }
    }
}

