/*
 * Decompiled with CFR 0.152.
 */
package com.tlabs.xml;

import com.tlabs.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUtil {
    private static XMLUtil mySingleton;
    private DocumentBuilderFactory myDocumentFactory = DocumentBuilderFactory.newInstance();
    private TransformerFactory myTransformerFactory;
    private ErrorHandler myErrorHandler;

    private XMLUtil(boolean bl) {
        this.myDocumentFactory.setValidating(bl);
        this.myDocumentFactory.setNamespaceAware(true);
        this.myTransformerFactory = TransformerFactory.newInstance();
        this.myErrorHandler = bl ? new OutErrorHandler() : new VoidErrorHandler();
    }

    public static XMLUtil newInstance(boolean bl) {
        return new XMLUtil(bl);
    }

    public static final String cdata(String string) {
        if (null == string) {
            return null;
        }
        return (string = string.trim()).length() == 0 ? "" : "<![CDATA[" + string + "]]>";
    }

    public void write(Document document, OutputStream outputStream) throws TransformerException, IOException {
        this.write(document, outputStream, "xml");
    }

    public void write(Document document, OutputStream outputStream, String string) throws TransformerException, IOException {
        this.write(document, outputStream, string, false);
    }

    public void write(Document document, OutputStream outputStream, String string, boolean bl) throws TransformerException, IOException {
        Object object;
        if (!this.myTransformerFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature")) {
            throw new TransformerException("DOM node processing not supported!");
        }
        DocumentType documentType = document.getDoctype();
        Transformer transformer = this.myTransformerFactory.newTransformer();
        transformer.setOutputProperty("method", string);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", bl ? "yes" : "no");
        if (null != documentType) {
            object = documentType.getPublicId();
            if (null != object) {
                transformer.setOutputProperty("doctype-public", (String)object);
            }
            if (null != (object = documentType.getSystemId())) {
                transformer.setOutputProperty("doctype-system", (String)object);
            }
        }
        object = new StreamResult();
        ((StreamResult)object).setOutputStream(outputStream);
        transformer.transform(new DOMSource(document), (Result)object);
        outputStream.flush();
    }

    public Document createDocument() throws ParserConfigurationException {
        return this.newDocumentBuilder().newDocument();
    }

    public Document createDocument(String string, String string2) throws ParserConfigurationException {
        return this.createDocument(string, string2, null, null);
    }

    public Document createDocument(String string, String string2, String string3) throws ParserConfigurationException {
        return this.createDocument(string, string2, string3, null);
    }

    public Document createDocument(String string, String string2, String string3, String string4) throws ParserConfigurationException {
        DocumentBuilder documentBuilder = this.newDocumentBuilder();
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        DocumentType documentType = dOMImplementation.createDocumentType(string2, string3, string4);
        return dOMImplementation.createDocument(string, string2, documentType);
    }

    public Document createDocument(Reader reader) throws SAXException, ParserConfigurationException, IOException {
        return this.createDocument(Streams.inputStream(reader));
    }

    public Document createDocument(InputStream inputStream) throws SAXException, ParserConfigurationException, IOException {
        return this.newDocumentBuilder().parse(inputStream);
    }

    public Templates createTransformer(URL uRL) throws TransformerException, IOException {
        InputStream inputStream = uRL.openStream();
        StreamSource streamSource = new StreamSource(inputStream);
        Templates templates = this.myTransformerFactory.newTemplates(streamSource);
        inputStream.close();
        return templates;
    }

    private DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = this.myDocumentFactory.newDocumentBuilder();
        if (this.myDocumentFactory.isValidating()) {
            documentBuilder.setErrorHandler(this.myErrorHandler);
        }
        return documentBuilder;
    }

    private static class VoidErrorHandler
    extends DefaultHandler {
        private VoidErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) {
            sAXParseException.printStackTrace();
        }

        public void fatalError(SAXParseException sAXParseException) {
            sAXParseException.printStackTrace();
        }

        public void warning(SAXParseException sAXParseException) {
            sAXParseException.printStackTrace();
        }
    }

    private static class OutErrorHandler
    extends DefaultHandler {
        private OutErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) {
            sAXParseException.printStackTrace();
        }

        public void fatalError(SAXParseException sAXParseException) {
            sAXParseException.printStackTrace();
        }

        public void warning(SAXParseException sAXParseException) {
            sAXParseException.printStackTrace();
        }
    }
}

