/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Frame;
import java.util.Collection;
import org.opensourcephysics.controls.AbstractAnimation;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.SimControl;
import org.opensourcephysics.controls.Simulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.display.GUIUtils;

public abstract class AbstractSimulation
extends AbstractAnimation
implements Simulation {
    protected SimControl control;
    protected boolean showStepsPerDisplay = false;
    protected int stepsPerDisplay = 1;
    protected int stepCounter = 0;

    public void setControl(Control control) {
        this.control = control instanceof SimControl ? (SimulationControl)control : new ShadowControl(control);
        ((AbstractAnimation)this).control = control;
        if (control != null) {
            control.setLockValues(true);
            this.resetAnimation();
            control.setLockValues(false);
            if (control instanceof Frame) {
                ((Frame)((Object)control)).pack();
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    public void startRunning() {
    }

    public void stopRunning() {
    }

    public void startAnimation() {
        if (this.showStepsPerDisplay) {
            this.stepsPerDisplay = this.control.getInt("steps per display");
        }
        this.start();
        this.startRunning();
        super.startAnimation();
    }

    public final void startSimulation() {
        this.startAnimation();
    }

    public void start() {
    }

    public void stopAnimation() {
        super.stopAnimation();
        this.stopRunning();
        this.stop();
    }

    public final void stopSimulation() {
        this.stopAnimation();
    }

    public void stop() {
    }

    public final void stepAnimation() {
        if (this.showStepsPerDisplay) {
            this.stepsPerDisplay = this.control.getInt("steps per display");
        }
        this.startRunning();
        super.stepAnimation();
        ++this.stepCounter;
        this.stopRunning();
        GUIUtils.repaintAnimatedFrames();
    }

    public void initializeAnimation() {
        if (this.control == null) {
            return;
        }
        super.initializeAnimation();
        this.initialize();
        this.stepCounter = 0;
    }

    public int getStepCounter() {
        return this.stepCounter;
    }

    public void initialize() {
    }

    public void resetAnimation() {
        if (this.control == null) {
            return;
        }
        super.resetAnimation();
        this.stepsPerDisplay = 1;
        if (this.showStepsPerDisplay) {
            this.control.setAdjustableValue("steps per display", this.stepsPerDisplay);
        }
        this.reset();
    }

    public void enableStepsPerDisplay(boolean enable) {
        this.showStepsPerDisplay = enable;
        if (this.showStepsPerDisplay) {
            this.control.setAdjustableValue("steps per display", this.stepsPerDisplay);
        } else {
            this.control.removeParameter("steps per display");
        }
    }

    public void setStepsPerDisplay(int num) {
        this.stepsPerDisplay = Math.max(num, 1);
        if (this.showStepsPerDisplay) {
            this.control.setAdjustableValue("steps per display", this.stepsPerDisplay);
        }
    }

    public int getStepsPerDisplay() {
        return this.stepsPerDisplay;
    }

    public void reset() {
    }

    public void run() {
        GUIUtils.setAnimatedFrameIgnoreRepaint(true);
        long sleepTime = this.delayTime;
        while (this.animationThread == Thread.currentThread()) {
            long currentTime = System.currentTimeMillis();
            for (int i = 0; i < this.stepsPerDisplay; ++i) {
                this.doStep();
                ++this.stepCounter;
                if (this.animationThread != Thread.currentThread()) break;
                Thread.yield();
            }
            GUIUtils.renderAnimatedFrames();
            sleepTime = Math.max(10L, (long)this.delayTime - (System.currentTimeMillis() - currentTime));
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException ie) {}
        }
        GUIUtils.setAnimatedFrameIgnoreRepaint(false);
    }

    private class ShadowControl
    implements SimControl {
        Control control;

        ShadowControl(Control control) {
            this.control = control;
        }

        public void setAdjustableValue(String name, boolean val) {
            this.control.setValue(name, val);
        }

        public void setAdjustableValue(String name, double val) {
            this.control.setValue(name, val);
        }

        public void setAdjustableValue(String name, int val) {
            this.control.setValue(name, val);
        }

        public void setAdjustableValue(String name, Object val) {
            this.control.setValue(name, val);
        }

        public void removeParameter(String name) {
        }

        public void setLockValues(boolean lock) {
            this.control.setLockValues(lock);
        }

        public void setValue(String name, Object val) {
            this.control.setValue(name, val);
        }

        public void setValue(String name, double val) {
            this.control.setValue(name, val);
        }

        public void setValue(String name, int val) {
            this.control.setValue(name, val);
        }

        public void setValue(String name, boolean val) {
            this.control.setValue(name, val);
        }

        public int getInt(String name) {
            return this.control.getInt(name);
        }

        public double getDouble(String name) {
            return this.control.getDouble(name);
        }

        public Object getObject(String name) {
            return this.control.getObject(name);
        }

        public String getString(String name) {
            return this.control.getString(name);
        }

        public boolean getBoolean(String name) {
            return this.control.getBoolean(name);
        }

        public Collection getPropertyNames() {
            return this.control.getPropertyNames();
        }

        public void println(String s) {
            this.control.println(s);
        }

        public void println() {
            this.control.println();
        }

        public void print(String s) {
            this.control.print(s);
        }

        public void clearMessages() {
            this.control.clearMessages();
        }

        public void clearValues() {
            this.control.clearValues();
        }

        public void calculationDone(String message) {
            this.control.calculationDone(message);
        }

        public void setParameterToFixed(String name, boolean fixed) {
        }
    }
}

