/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.XML;

public class Password
extends JDialog {
    private static Password dialog;
    private JLabel messageLabel;
    private JPasswordField passwordField;
    private String password;
    private boolean pass;

    public static boolean verify(String password, String fileName) {
        if (password == null || password.equals("")) {
            return true;
        }
        if (dialog == null) {
            dialog = new Password();
        }
        Password.dialog.password = password;
        if (fileName == null || fileName.equals("")) {
            Password.dialog.messageLabel.setText(ControlsRes.getString("Password.Message.Short"));
        } else {
            Password.dialog.messageLabel.setText(ControlsRes.getString("Password.Message.File") + "\"" + XML.getName(fileName) + "\".");
        }
        dialog.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - Password.dialog.getBounds().width) / 2;
        int y = (dim.height - Password.dialog.getBounds().height) / 2;
        ((Component)dialog).setLocation(x, y);
        Password.dialog.pass = false;
        ((JTextComponent)Password.dialog.passwordField).setText("");
        ((Component)dialog).setVisible(true);
        return Password.dialog.pass;
    }

    private Password() {
        super((Frame)null, true);
        this.setTitle(ControlsRes.getString("Password.Title"));
        this.createGUI();
        this.setResizable(false);
        this.passwordField.requestFocusInWindow();
    }

    private void createGUI() {
        GridBagLayout gridbag = new GridBagLayout();
        JPanel inputPanel = new JPanel(gridbag);
        this.messageLabel = new JLabel();
        JLabel fieldLabel = new JLabel(ControlsRes.getString("Password.Label"));
        this.passwordField = new JPasswordField(20);
        this.passwordField.setToolTipText(ControlsRes.getString("Password.Tooltip"));
        this.passwordField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String input = String.copyValueOf(Password.this.passwordField.getPassword());
                if (Password.this.password != null && !input.equals(Password.this.password)) {
                    Toolkit.getDefaultToolkit().beep();
                    ((JTextComponent)Password.this.passwordField).setText("");
                } else {
                    Password.this.pass = true;
                    ((Component)Password.this).setVisible(false);
                }
            }
        });
        this.passwordField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    Password.this.passwordField.requestFocusInWindow();
                    ((Component)Password.this).setVisible(false);
                }
            }
        });
        JButton cancelButton = new JButton(ControlsRes.getString("Password.Button.Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Password.this.passwordField.requestFocusInWindow();
                ((Component)Password.this).setVisible(false);
            }
        });
        JButton okButton = new JButton(ControlsRes.getString("Password.Button.Enter"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String input = String.copyValueOf(Password.this.passwordField.getPassword());
                if (Password.this.password != null && !input.equals(Password.this.password)) {
                    Toolkit.getDefaultToolkit().beep();
                    ((JTextComponent)Password.this.passwordField).setText("");
                    Password.this.passwordField.requestFocusInWindow();
                } else {
                    Password.this.pass = true;
                    ((Component)Password.this).setVisible(false);
                }
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.add((Component)inputPanel, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(20, 15, 10, 15);
        gridbag.setConstraints(this.messageLabel, c);
        inputPanel.add(this.messageLabel);
        JPanel entry = new JPanel();
        entry.add(fieldLabel);
        entry.add(this.passwordField);
        c.gridy = 1;
        c.insets = new Insets(0, 10, 10, 10);
        gridbag.setConstraints(entry, c);
        inputPanel.add(entry);
        JPanel buttonPane = new JPanel();
        contentPane.add((Component)buttonPane, "South");
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 4, 4));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(okButton);
        buttonPane.add(Box.createRigidArea(new Dimension(4, 0)));
        buttonPane.add(cancelButton);
    }
}

