/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTableInspector;
import org.opensourcephysics.controls.XMLTableModel;
import org.opensourcephysics.tools.ArrayInspector;
import org.opensourcephysics.tools.TranslatorTool;

public class XMLTable
extends JTable {
    static final Color LIGHT_BLUE = new Color(204, 204, 255);
    XMLTableModel tableModel;
    XMLCellRenderer xmlRenderer = new XMLCellRenderer();
    XMLValueEditor valueEditor = new XMLValueEditor();
    Color defaultBackgroundColor = Color.white;
    Map cellColors = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    public XMLTable(XMLControl control) {
        this.tableModel = new XMLTableModel(control);
        this.init();
    }

    public XMLTable(XMLTableModel model) {
        this.tableModel = model;
        this.init();
    }

    public XMLControl getControl() {
        return this.tableModel.control;
    }

    public void setEditable(boolean editable) {
        this.tableModel.editable = editable;
    }

    public boolean isEditable() {
        return this.tableModel.editable;
    }

    public void setEditable(String propName, boolean editable) {
        if (!editable) {
            this.tableModel.uneditablePropNames.add(propName);
        } else {
            this.tableModel.uneditablePropNames.remove(propName);
        }
    }

    public boolean isEditable(String propName) {
        return !this.tableModel.uneditablePropNames.contains(propName);
    }

    public boolean isCellEditable(int row, int col) {
        return this.tableModel.editable && this.tableModel.isCellEditable(row, col);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.xmlRenderer != null) {
            this.xmlRenderer.setFont(font);
            this.valueEditor.field.setFont(font);
            Runnable runner = new Runnable(){

                public void run() {
                    if (XMLTable.this.getTableHeader().getHeight() > 0) {
                        XMLTable.this.setRowHeight(XMLTable.this.getTableHeader().getHeight());
                    }
                }
            };
            SwingUtilities.invokeLater(runner);
        }
    }

    public void setBackgroundColor(String propName, Color color) {
        this.cellColors.put(propName, color);
    }

    public Color getBackgroundColor(String propName) {
        Color color = (Color)this.cellColors.get(propName);
        return color == null ? this.defaultBackgroundColor : color;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.xmlRenderer;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        return this.valueEditor;
    }

    public void refresh() {
        Runnable runner = new Runnable(){

            public synchronized void run() {
                XMLTable.this.tableChanged(new TableModelEvent(XMLTable.this.tableModel, -1));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.firePropertyChange("tableData", null, e);
        super.tableChanged(e);
    }

    public void addControlListener(String methodName, Object target) {
        this.addControlListener(null, methodName, target);
    }

    public void addControlListener(final String parameterName, String methodName, final Object target) {
        Class[] parameters = new Class[]{class$java$lang$String == null ? (class$java$lang$String = XMLTable.class$("java.lang.String")) : class$java$lang$String};
        try {
            final Method m = target.getClass().getMethod(methodName, parameters);
            this.tableModel.addTableModelListener(new TableModelListener(){
                final String par;
                {
                    this.par = parameterName;
                }

                public void tableChanged(TableModelEvent e) {
                    if (e.getType() != 0 || e.getColumn() != 1 || e.getFirstRow() < 0) {
                        return;
                    }
                    String name = XMLTable.this.getValueAt(e.getFirstRow(), 0).toString();
                    if (this.par == null || this.par.equals(name)) {
                        Object[] args = new Object[]{name};
                        try {
                            m.invoke(target, args);
                        }
                        catch (IllegalAccessException iae) {
                        }
                        catch (InvocationTargetException ite) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("The method " + methodName + "() does not exist.");
        }
    }

    private void init() {
        this.setModel(this.tableModel);
        JTableHeader header = this.getTableHeader();
        header.setReorderingAllowed(false);
        header.setForeground(Color.BLACK);
        this.setGridColor(Color.BLACK);
        InputMap im = this.getInputMap(1);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        final Action prevTabAction = this.getActionMap().get(im.get(tab));
        AbstractAction tabAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                prevTabAction.actionPerformed(e);
                JTable table = (JTable)e.getSource();
                int rowCount = table.getRowCount();
                int row = table.getSelectedRow();
                int column = table.getSelectedColumn();
                while (!table.isCellEditable(row, column)) {
                    if (column == 0) {
                        column = 1;
                    } else {
                        ++row;
                    }
                    if (row == rowCount) {
                        row = 0;
                    }
                    if (row != table.getSelectedRow() || column != table.getSelectedColumn()) continue;
                }
                table.changeSelection(row, column, false, false);
            }
        };
        this.getActionMap().put(im.get(tab), tabAction);
        AbstractAction enterAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JPanel panel;
                JTable table = (JTable)e.getSource();
                int row = table.getSelectedRow();
                int column = table.getSelectedColumn();
                table.editCellAt(row, column, e);
                Component comp = table.getEditorComponent();
                if (comp instanceof JPanel && (comp = (panel = (JPanel)comp).getComponent(0)) instanceof JTextField) {
                    JTextField field = (JTextField)comp;
                    field.requestFocus();
                    field.selectAll();
                }
            }
        };
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        this.getActionMap().put(im.get(enter), enterAction);
    }

    private boolean isInspectable(XMLProperty prop) {
        if (prop.getPropertyType().equals("object")) {
            return true;
        }
        if (prop.getPropertyType().equals("array")) {
            return ArrayInspector.canInspect(prop);
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class XMLValueEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        JTextField field = new JTextField();
        Object editObject;

        XMLValueEditor() {
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.panel.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 2));
            this.field.setBorder(null);
            this.field.setEditable(true);
            this.field.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XMLValueEditor.this.stopCellEditing();
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        XMLValueEditor.this.stopCellEditing();
                    } else {
                        XMLValueEditor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (XMLValueEditor.this.field.getBackground() != ((XMLValueEditor)XMLValueEditor.this).XMLTable.this.defaultBackgroundColor) {
                        XMLValueEditor.this.stopCellEditing();
                    }
                    XMLTable.this.requestFocusInWindow();
                }
            });
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editObject = null;
            if (value instanceof XMLControl) {
                XMLControl childControl = (XMLControl)value;
                XMLTableInspector inspector = new XMLTableInspector(childControl, XMLTable.this.isEditable());
                Container cont = XMLTable.this.getTopLevelAncestor();
                Point p = cont.getLocationOnScreen();
                ((Component)inspector).setLocation(p.x + 30, p.y + 30);
                ((Component)inspector).setVisible(true);
                return null;
            }
            if (value instanceof XMLProperty) {
                XMLProperty prop = (XMLProperty)value;
                XMLProperty arrayProp = prop.getParentProperty();
                ArrayInspector inspector = ArrayInspector.getInspector(arrayProp);
                if (inspector != null) {
                    String name = arrayProp.getPropertyName();
                    XMLProperty parent = arrayProp.getParentProperty();
                    while (!(parent instanceof XMLControl)) {
                        name = parent.getPropertyName();
                        arrayProp = parent;
                        parent = parent.getParentProperty();
                    }
                    final XMLControl arrayControl = (XMLControl)parent;
                    final String arrayName = name;
                    final Object arrayObj = inspector.getArray();
                    inspector.setEditable(XMLTable.this.tableModel.editable);
                    final int rowNumber = row;
                    final int colNumber = column;
                    inspector.addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent e) {
                            if (e.getPropertyName().equals("cell")) {
                                arrayControl.setValue(arrayName, arrayObj);
                            } else if (e.getPropertyName().equals("arrayData")) {
                                ((XMLValueEditor)XMLValueEditor.this).XMLTable.this.tableModel.fireTableCellUpdated(rowNumber, colNumber);
                            }
                        }
                    });
                    Container cont = XMLTable.this.getTopLevelAncestor();
                    Point p = cont.getLocationOnScreen();
                    ((Component)inspector).setLocation(p.x + 30, p.y + 30);
                    ((Component)inspector).setVisible(true);
                    cont.transferFocus();
                }
                return null;
            }
            this.field.setText(value.toString());
            return this.panel;
        }

        public boolean isCellEditable(EventObject e) {
            MouseEvent me;
            return e instanceof MouseEvent ? (me = (MouseEvent)e).getClickCount() == 2 : e instanceof ActionEvent;
        }

        public Object getCellEditorValue() {
            if (this.field.getBackground() != XMLTable.this.defaultBackgroundColor) {
                this.field.setBackground(XMLTable.this.defaultBackgroundColor);
                return this.field.getText();
            }
            return this.editObject;
        }
    }

    class XMLCellRenderer
    extends DefaultTableCellRenderer {
        Color lightGreen = new Color(204, 255, 204);
        Color lightGray = UIManager.getColor("Panel.background");
        Font font = new JTextField().getFont();

        public XMLCellRenderer() {
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setFont(this.font);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(Color.BLACK);
            if (value == null) {
                value = "";
            }
            if (column == 0) {
                this.setBackground(this.lightGray);
                this.setHorizontalAlignment(2);
                this.setText(TranslatorTool.getProperty(XMLTable.this, value.toString()));
                this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
            } else if (value instanceof XMLProperty) {
                XMLProperty prop = (XMLProperty)value;
                XMLProperty parent = prop.getParentProperty();
                String className = XML.getSimpleClassName(parent.getPropertyClass());
                if (parent.getPropertyType().equals("array")) {
                    XMLControl control = (XMLControl)parent.getParentProperty();
                    Object array = control.getObject(parent.getPropertyName());
                    Class<?> baseType = array.getClass().getComponentType();
                    int count = Array.getLength(array);
                    int insert = className.indexOf("[]") + 1;
                    className = className.substring(0, insert) + count + className.substring(insert);
                    while (baseType.getComponentType() != null) {
                        baseType = baseType.getComponentType();
                        if ((array = Array.get(array, 0)) == null) break;
                        count = Array.getLength(array);
                        insert = className.indexOf("[]", insert) + 1;
                        className = className.substring(0, insert) + count + className.substring(insert);
                    }
                }
                this.setText(className);
                this.setBackground(XMLTable.this.isInspectable(parent) ? this.lightGreen : this.lightGray);
                this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
                this.setHorizontalAlignment(0);
                if (isSelected && XMLTable.this.isInspectable(parent)) {
                    this.setBackground(LIGHT_BLUE);
                    this.setForeground(Color.RED);
                }
            } else {
                String propName = (String)XMLTable.this.tableModel.getValueAt(row, 0);
                if (isSelected) {
                    this.setBackground(LIGHT_BLUE);
                    this.setForeground(Color.RED);
                } else {
                    Color cellColor = (Color)XMLTable.this.cellColors.get(propName);
                    this.setBackground(cellColor == null ? XMLTable.this.defaultBackgroundColor : cellColor);
                }
                this.setHorizontalAlignment(2);
                this.setText(value.toString());
                this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
                if (!XMLTable.this.tableModel.editable || XMLTable.this.tableModel.uneditablePropNames.contains(propName)) {
                    this.setForeground(Color.GRAY);
                }
            }
            return this;
        }
    }
}

