/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTreeNode;

public class XMLTree {
    protected static Icon hiliteIcon;
    protected XMLTreeNode root;
    protected JTree tree;
    protected JScrollPane scroller;
    protected XMLControl control;
    protected List selectedProps = new ArrayList();
    protected Class hilite = class$java$lang$Object == null ? (class$java$lang$Object = XMLTree.class$("java.lang.Object")) : class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$opensourcephysics$controls$XMLTree;

    public XMLTree(XMLControl control) {
        this.control = control;
        this.createGUI();
    }

    public JTree getTree() {
        return this.tree;
    }

    public List getSelectedProperties() {
        this.selectedProps.clear();
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                XMLTreeNode node = (XMLTreeNode)paths[i].getLastPathComponent();
                this.selectedProps.add(node.getProperty());
            }
        }
        return this.selectedProps;
    }

    public JScrollPane getScrollPane() {
        return this.scroller;
    }

    public void setHighlightedClass(Class type) {
        if (type != null) {
            this.hilite = type;
            this.scroller.repaint();
        }
    }

    public Class getHighlightedClass() {
        return this.hilite;
    }

    public void selectHighlightedProperties() {
        Enumeration<TreeNode> e = this.root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            XMLTreeNode node = (XMLTreeNode)e.nextElement();
            XMLProperty prop = node.getProperty();
            Class type = prop.getPropertyClass();
            if (type == null || !this.hilite.isAssignableFrom(type)) continue;
            TreePath path = new TreePath(node.getPath());
            this.tree.addSelectionPath(path);
            this.tree.scrollPathToVisible(path);
        }
    }

    public void showHighlightedProperties() {
        Enumeration<TreeNode> e = this.root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            XMLTreeNode node = (XMLTreeNode)e.nextElement();
            XMLProperty prop = node.getProperty();
            Class type = prop.getPropertyClass();
            if (type == null || !this.hilite.isAssignableFrom(type)) continue;
            TreePath path = new TreePath(node.getPath());
            this.tree.scrollPathToVisible(path);
        }
    }

    protected void createGUI() {
        String imageFile = "/org/opensourcephysics/resources/controls/images/hilite.gif";
        hiliteIcon = new ImageIcon((class$org$opensourcephysics$controls$XMLTree == null ? (class$org$opensourcephysics$controls$XMLTree = XMLTree.class$("org.opensourcephysics.controls.XMLTree")) : class$org$opensourcephysics$controls$XMLTree).getResource(imageFile));
        this.root = new XMLTreeNode(this.control);
        this.tree = new JTree(this.root);
        this.tree.setCellRenderer(new HighlightRenderer());
        this.tree.getSelectionModel().setSelectionMode(4);
        this.scroller = new JScrollPane(this.tree);
        this.scroller.setPreferredSize(new Dimension(200, 200));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HighlightRenderer
    extends DefaultTreeCellRenderer {
        private HighlightRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            XMLTreeNode node = (XMLTreeNode)value;
            XMLProperty prop = node.getProperty();
            Class type = prop.getPropertyClass();
            if (type != null && XMLTree.this.hilite.isAssignableFrom(type)) {
                this.setIcon(hiliteIcon);
            }
            return this;
        }
    }
}

