/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;

public class XMLTreeNode
extends DefaultMutableTreeNode {
    protected XMLProperty prop;
    private boolean inspectable = false;

    public XMLTreeNode(XMLProperty property) {
        this.prop = property;
        this.setUserObject(this);
        Iterator it = property.getPropertyContent().iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof XMLProperty)) continue;
            XMLProperty prop = (XMLProperty)next;
            List content = prop.getPropertyContent();
            if (content.size() == 1 && (next = content.get(0)) instanceof XMLControl) {
                prop = (XMLProperty)next;
            }
            this.add(new XMLTreeNode(prop));
        }
        if (this.prop.getPropertyType().equals("array")) {
            Class<?> type = this.prop.getPropertyClass();
            if (type == null) {
                return;
            }
            while (type.getComponentType() != null) {
                type = type.getComponentType();
            }
            if (type.getName().equals("double") || type.getName().equals("int")) {
                XMLProperty proper = this.prop;
                XMLProperty parent = proper.getParentProperty();
                while (!(parent instanceof XMLControl)) {
                    proper = parent;
                    parent = parent.getParentProperty();
                }
                type = proper.getPropertyClass();
                int i = 0;
                while (type.getComponentType() != null) {
                    type = type.getComponentType();
                    ++i;
                }
                if (i <= 3) {
                    this.inspectable = true;
                }
            }
        }
    }

    public XMLProperty getProperty() {
        return this.prop;
    }

    public boolean isInspectable() {
        return this.inspectable;
    }

    public String toString() {
        XMLControl control;
        String name;
        if (this.prop instanceof XMLControl && (name = (control = (XMLControl)this.prop).getString("name")) != null) {
            return name;
        }
        return this.prop.getPropertyName();
    }
}

