/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.davidson.applets;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.opensourcephysics.controls.MessageFrame;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class ApplicationApplet
extends JApplet {
    JFrame mainFrame = null;
    JButton showFramesButton = new JButton("Show");
    String targetClassName;
    ArrayList newFrames = new ArrayList();
    ArrayList existingFrames = new ArrayList();
    Class target;
    String[] args = null;
    boolean singleApp = false;
    String targetError = null;
    static /* synthetic */ Class array$Ljava$lang$String;

    public String getParameter(String key, String def) {
        return this.getParameter(key) != null ? this.getParameter(key) : def;
    }

    public void init() {
        super.init();
        OSPFrame.applet = this;
        OSPFrame.appletMode = false;
        if (this.getParameter("showLog", "false").toLowerCase().trim().equals("true")) {
            OSPLog.showLog();
        }
        String arg0 = this.getParameter("xmldata", null);
        if ((arg0 = this.getParameter("args[0]", arg0)) != null) {
            this.args = new String[1];
        }
        String arg1 = this.getParameter("args[1]", null);
        String arg2 = this.getParameter("args[2]", null);
        if (arg2 != null) {
            this.args = new String[3];
            this.args[0] = arg0;
            this.args[1] = arg1;
            this.args[2] = arg2;
        } else if (arg1 != null) {
            this.args = new String[2];
            this.args[0] = arg0;
            this.args[1] = arg1;
        } else if (arg0 != null) {
            this.args = new String[1];
            this.args[0] = arg0;
        }
        this.targetClassName = this.getParameter("target", null);
        if (this.targetClassName == null) {
            this.targetClassName = this.getParameter("app", null);
        }
        if (this.targetClassName == null) {
            this.readManifest();
        }
        String title = this.getParameter("title", null);
        this.singleApp = this.getParameter("singleapp", "false").trim().equalsIgnoreCase("true");
        if (title == null) {
            String[] s = this.targetClassName.split("[.]");
            this.showFramesButton.setText(s[s.length - 1]);
        } else {
            this.showFramesButton.setText(title);
        }
        this.getRootPane().getContentPane().add((Component)this.showFramesButton, "Center");
        this.showFramesButton.addActionListener(new DisplayBtnListener());
    }

    static boolean isLaunchable(Class type) {
        if (type == null) {
            return false;
        }
        try {
            type.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ApplicationApplet.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    public void destroy() {
        this.disposeOwnedFrames();
        this.target = null;
        this.mainFrame = null;
        super.destroy();
    }

    private void readManifest() {
        String archive = this.getParameter("archive", null);
        archive = archive.split(";")[0];
        OSPLog.finer("archive applet tag=" + archive);
        if (archive == null) {
            return;
        }
        String name = "META-INF/MANIFEST.MF";
        Resource res = ResourceLoader.getResource(archive, name);
        if (res == null) {
            OSPLog.fine("manifest not found in=" + archive);
            return;
        }
        String manifest = res.getString();
        String[] lines = manifest.split("\n");
        int n = Math.min(10, lines.length);
        for (int i = 0; i < n; ++i) {
            int index = lines[i].indexOf("Main-Class:");
            if (index < 0) continue;
            this.targetClassName = lines[i].substring("Main-Class:".length() + index).trim();
            OSPLog.fine("target class in manifest=" + this.targetClassName);
            return;
        }
    }

    private Class createTarget() {
        Class<?> type = null;
        this.targetError = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            type = classLoader.loadClass(this.targetClassName);
        }
        catch (ClassNotFoundException ex1) {
            System.err.println("Class not found: " + this.targetClassName);
            this.targetError = "Class not found: " + this.targetClassName;
            return null;
        }
        if (!ApplicationApplet.isLaunchable(type)) {
            System.err.println("Main method not found in " + this.targetClassName);
            this.targetError = "Main method not found in " + this.targetClassName;
            return null;
        }
        Frame[] frame = Frame.getFrames();
        this.existingFrames.clear();
        int n = frame.length;
        for (int i = 0; i < n; ++i) {
            this.existingFrames.add(frame[i]);
        }
        String htmldata = this.getParameter("htmldata", null);
        if (htmldata != null) {
            TextFrame htmlframe = new TextFrame(htmldata, type);
            ((Component)htmlframe).setVisible(true);
        }
        try {
            Method m = type.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ApplicationApplet.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            m.invoke(type, new Object[]{this.args});
            frame = Frame.getFrames();
            int n2 = frame.length;
            for (int i = 0; i < n2; ++i) {
                if (frame[i] instanceof JFrame && ((JFrame)frame[i]).getDefaultCloseOperation() == 3) {
                    ((JFrame)frame[i]).setDefaultCloseOperation(1);
                    if (this.mainFrame == null) {
                        this.mainFrame = (JFrame)frame[i];
                    }
                }
                if (this.existingFrames.contains(frame[i])) continue;
                this.newFrames.add(frame[i]);
            }
        }
        catch (NoSuchMethodException ex) {
            System.err.println(ex);
            this.targetError = ex.toString();
        }
        catch (InvocationTargetException ex) {
            System.err.println(ex);
            this.targetError = ex.toString();
        }
        catch (IllegalAccessException ex) {
            System.err.println(ex);
            this.targetError = ex.toString();
        }
        return type;
    }

    private void disposeOwnedFrames() {
        Frame[] frame = Frame.getFrames();
        int n = frame.length;
        for (int i = 0; i < n; ++i) {
            if (frame[i].getClass().getName().startsWith("sun.plugin")) continue;
            if (frame[i] instanceof JFrame && ((JFrame)frame[i]).getDefaultCloseOperation() == 3) {
                ((JFrame)frame[i]).setDefaultCloseOperation(2);
            }
            if (this.existingFrames.contains(frame[i])) continue;
            ((Component)frame[i]).setVisible(false);
            frame[i].dispose();
        }
        this.newFrames.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DisplayBtnListener
    implements ActionListener {
        private DisplayBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ApplicationApplet.this.singleApp && OSPFrame.applet != ApplicationApplet.this) {
                ApplicationApplet.this.disposeOwnedFrames();
                ApplicationApplet.this.target = null;
                ApplicationApplet.this.mainFrame = null;
                OSPFrame.applet = ApplicationApplet.this;
            }
            if (ApplicationApplet.this.target == null) {
                ApplicationApplet.this.target = ApplicationApplet.this.createTarget();
                if (ApplicationApplet.this.targetError != null) {
                    ApplicationApplet.this.target = null;
                }
            } else {
                Iterator it = ((AbstractList)ApplicationApplet.this.newFrames).iterator();
                while (it.hasNext()) {
                    Frame frame = (Frame)it.next();
                    if (!frame.isDisplayable() || frame instanceof OSPLog || frame instanceof MessageFrame) continue;
                    ((Component)frame).setVisible(true);
                }
            }
            if (ApplicationApplet.this.mainFrame != null) {
                ApplicationApplet.this.mainFrame.setState(0);
                ((Component)ApplicationApplet.this.mainFrame).setVisible(true);
                ApplicationApplet.this.mainFrame.toFront();
            }
        }
    }
}

