/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import org.opensourcephysics.display.BoundedShape;
import org.opensourcephysics.display.DrawingPanel;

public class BoundedImage
extends BoundedShape
implements ImageObserver {
    protected Image image;

    public BoundedImage(Image image, double x, double y) {
        super(null, x, y);
        this.image = image;
        this.width = image.getWidth(this);
        this.width = Math.max(0.0, this.width);
        this.height = image.getHeight(this);
        this.height = Math.max(0.0, this.height);
        this.shapeClass = image.getClass().getName();
        this.setPixelSized(true);
    }

    public void draw(DrawingPanel panel, Graphics g) {
        this.toPixels = panel.getPixelTransform();
        Point2D pt = new Point2D.Double(this.x, this.y);
        pt = this.toPixels.transform(pt, pt);
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pt.getX(), pt.getY());
        AffineTransform trans = new AffineTransform();
        trans.translate(-this.width / 2.0, -this.height / 2.0);
        trans.rotate(-this.theta, this.width / 2.0, this.height / 2.0);
        trans.scale(this.width / (double)this.image.getWidth(null), this.height / (double)this.image.getHeight(null));
        g2.drawImage(this.image, trans, null);
        g2.translate(-pt.getX(), -pt.getY());
        this.drawFixedBounds(panel, g);
    }

    private void drawFixedBounds(DrawingPanel panel, Graphics g) {
        Point2D pt = new Point2D.Double(this.x, this.y);
        pt = this.toPixels.transform(pt, pt);
        Rectangle2D.Double temp = new Rectangle2D.Double(pt.getX() - this.width / 2.0, pt.getY() - this.height / 2.0, this.width, this.height);
        this.computeFixedHotSpots(temp.getBounds2D());
        this.pixelBounds = temp.getBounds2D();
        if (this.theta != 0.0) {
            this.pixelBounds = AffineTransform.getRotateInstance(-this.theta, pt.getX(), pt.getY()).createTransformedShape(this.pixelBounds);
        }
        if (!this.selected) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.boundsColor);
        g2.draw(this.pixelBounds);
        if (this.xyDrag) {
            g2.fillRect((int)this.hotSpots[BoundedShape.CENTER].getX() - this.delta, (int)this.hotSpots[BoundedShape.CENTER].getY() - this.delta, this.d2, this.d2);
            g2.setColor(this.edgeColor);
            g2.fillOval((int)this.hotSpots[BoundedShape.CENTER].getX() - 1, (int)this.hotSpots[BoundedShape.CENTER].getY() - 1, 3, 3);
            g2.setPaint(this.boundsColor);
        }
        if (this.rotateDrag) {
            g2.fillOval((int)this.hotSpots[BoundedShape.CORNER].getX() - this.delta, (int)this.hotSpots[BoundedShape.CORNER].getY() - this.delta, this.d2, this.d2);
        }
        if (this.heightDrag) {
            g2.fillRect((int)this.hotSpots[BoundedShape.TOP].getX() - this.delta, (int)this.hotSpots[BoundedShape.TOP].getY() - this.delta, this.d2, this.d2);
            g2.fillRect((int)this.hotSpots[BoundedShape.BOTTOM].getX() - this.delta, (int)this.hotSpots[BoundedShape.BOTTOM].getY() - this.delta, this.d2, this.d2);
        }
        if (this.widthDrag) {
            g2.fillRect((int)this.hotSpots[BoundedShape.LEFT].getX() - this.delta, (int)this.hotSpots[BoundedShape.LEFT].getY() - this.delta, this.d2, this.d2);
            g2.fillRect((int)this.hotSpots[BoundedShape.RIGHT].getX() - this.delta, (int)this.hotSpots[BoundedShape.RIGHT].getY() - this.delta, this.d2, this.d2);
        }
        g.setColor(Color.BLACK);
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 1) == 1) {
            this.width = width;
        }
        if ((infoflags & 2) == 1) {
            this.height = height;
        }
        return (infoflags & 0x20) != 1;
    }
}

