/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.AbstractInteractive;
import org.opensourcephysics.display.BoundedImage;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveArrow;
import org.opensourcephysics.display.InteractiveCenteredArrow;
import org.opensourcephysics.display.InteractiveShape;
import org.opensourcephysics.display.Selectable;

public class BoundedShape
extends InteractiveShape
implements Selectable {
    static int CENTER = 0;
    static int BOTTOM = 1;
    static int LEFT = 2;
    static int TOP = 3;
    static int RIGHT = 4;
    static int CORNER = 5;
    static int NONE = 6;
    int hotspot = NONE;
    int delta = 3;
    int deltaSqr = this.delta * this.delta;
    int d2 = 2 * this.delta + 1;
    boolean selected = false;
    boolean hideBounds = false;
    Color boundsColor = new Color(128, 128, 255);
    boolean widthDrag = false;
    boolean heightDrag = false;
    boolean xyDrag = true;
    boolean rotateDrag = false;
    Shape pixelBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    Point2D[] hotSpots = new Point2D[6];
    XYDelegate xyDelegate = new XYDelegate();

    public BoundedShape(Shape s, double x, double y) {
        super(s, x, y);
        int n = this.hotSpots.length;
        for (int i = 0; i < n; ++i) {
            this.hotSpots[i] = new Point2D.Float(0.0f, 0.0f);
        }
    }

    public static BoundedShape createBoundedRectangle(double x, double y, double w, double h) {
        Rectangle2D.Double shape = new Rectangle2D.Double(-w / 2.0, -h / 2.0, w, h);
        return new BoundedShape(shape, x, y);
    }

    public static BoundedShape createBoundedTriangle(double x, double y, double b, double h) {
        GeneralPath path = new GeneralPath();
        path.moveTo((float)(-b / 2.0), (float)(-h / 2.0));
        path.lineTo((float)(b / 2.0), (float)(-h / 2.0));
        path.lineTo(0.0f, (float)(h / 2.0));
        path.closePath();
        GeneralPath shape = path;
        return new BoundedShape(shape, x, y);
    }

    public static BoundedShape createBoundedArrow(double x, double y, double w, double h) {
        InteractiveArrow ia = new InteractiveArrow(x, y, w, h);
        ia.hideBounds = false;
        return ia;
    }

    public static BoundedShape createBoundedCenteredArrow(double x, double y, double w, double h) {
        InteractiveCenteredArrow ica = new InteractiveCenteredArrow(x, y, w, h);
        ica.hideBounds = false;
        return ica;
    }

    public static BoundedShape createBoundedImage(Image image, double x, double y) {
        return new BoundedImage(image, x, y);
    }

    public static BoundedShape createBoundedEllipse(double x, double y, double w, double h) {
        Ellipse2D.Double shape = new Ellipse2D.Double(-w / 2.0, -h / 2.0, w, h);
        return new BoundedShape(shape, x, y);
    }

    public static BoundedShape createBoundedCircle(double x, double y, double d) {
        Ellipse2D.Double shape = new Ellipse2D.Double(-d / 2.0, -d / 2.0, d, d);
        return new BoundedShape(shape, x, y);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setXYDrag(boolean enable) {
        this.xyDrag = enable;
    }

    public boolean isXYDrag() {
        return this.xyDrag;
    }

    public void setRotateDrag(boolean enable) {
        this.rotateDrag = enable;
    }

    public boolean isRotateDrag() {
        return this.rotateDrag;
    }

    public void setWidthDrag(boolean enable) {
        this.widthDrag = enable;
    }

    public boolean isWidthDrag() {
        return this.widthDrag;
    }

    public void setHeightDrag(boolean enable) {
        this.heightDrag = enable;
    }

    public boolean isHeightDrag() {
        return this.heightDrag;
    }

    public Cursor getPreferredCursor() {
        if (this.xyDrag && this.hotspot == CENTER) {
            return Cursor.getPredefinedCursor(13);
        }
        if (this.rotateDrag && this.hotspot == CORNER) {
            return Cursor.getPredefinedCursor(12);
        }
        if (this.widthDrag && this.hotspot == LEFT) {
            return this.theta == 0.0 ? Cursor.getPredefinedCursor(10) : Cursor.getPredefinedCursor(12);
        }
        if (this.widthDrag && this.hotspot == RIGHT) {
            return this.theta == 0.0 ? Cursor.getPredefinedCursor(11) : Cursor.getPredefinedCursor(12);
        }
        if (this.heightDrag && this.hotspot == TOP) {
            return this.theta == 0.0 ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(12);
        }
        if (this.heightDrag && this.hotspot == BOTTOM) {
            return this.theta == 0.0 ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(12);
        }
        if (this.selected) {
            return Cursor.getPredefinedCursor(1);
        }
        return Cursor.getPredefinedCursor(12);
    }

    public void toggleSelected() {
        this.selected = !this.selected;
    }

    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (this.isInside(panel, xpix, ypix)) {
            return this.xyDelegate;
        }
        return null;
    }

    public boolean isInside(DrawingPanel panel, int xpix, int ypix) {
        this.hotspot = NONE;
        if (!this.enabled) {
            return false;
        }
        if (this.pixelBounds.contains(xpix, ypix) && !this.selected) {
            return true;
        }
        if (this.selected) {
            this.hotspot = this.getHotSpotIndex(xpix, ypix, this.hotSpots);
            return true;
        }
        return false;
    }

    int getHotSpotIndex(int xpix, int ypix, Point2D[] hotSpots) {
        int n = hotSpots.length;
        for (int i = 0; i < n; ++i) {
            double dy;
            double dx = (double)xpix - hotSpots[i].getX();
            if (!(dx * dx + (dy = (double)ypix - hotSpots[i].getY()) * dy <= (double)this.deltaSqr)) continue;
            return i;
        }
        return NONE;
    }

    void computeScaledHotSpots(Rectangle2D rect, double ar) {
        double sin = Math.sin(this.theta);
        double cos = Math.cos(this.theta);
        double centerX = rect.getCenterX() - this.xoff * this.toPixels.getScaleX();
        double centerY = rect.getCenterY() - this.yoff * this.toPixels.getScaleY();
        double right = rect.getWidth() / 2.0 + this.xoff * this.toPixels.getScaleX();
        double left = rect.getWidth() / 2.0 - this.xoff * this.toPixels.getScaleX();
        double bottom = rect.getHeight() / 2.0 + this.yoff * this.toPixels.getScaleY();
        double top = rect.getHeight() / 2.0 - this.yoff * this.toPixels.getScaleY();
        this.hotSpots[CENTER].setLocation(centerX, centerY);
        this.hotSpots[BOTTOM].setLocation(centerX + this.xoff * this.toPixels.getScaleX() * cos + bottom * sin / ar, centerY - this.xoff * this.toPixels.getScaleX() * sin + bottom * cos);
        this.hotSpots[LEFT].setLocation(centerX - left * cos + this.yoff * this.toPixels.getScaleY() * sin, centerY + ar * left * sin + this.yoff * this.toPixels.getScaleY() * cos);
        this.hotSpots[TOP].setLocation(centerX + this.xoff * this.toPixels.getScaleX() * cos - top * sin / ar, centerY - this.xoff * this.toPixels.getScaleX() * sin - top * cos);
        this.hotSpots[RIGHT].setLocation(centerX + right * cos + this.yoff * this.toPixels.getScaleY() * sin, centerY - ar * right * sin + this.yoff * this.toPixels.getScaleY() * cos);
        this.hotSpots[CORNER].setLocation(centerX + right * cos - top * sin / ar, centerY - right * sin * ar - top * cos);
    }

    void computeFixedHotSpots(Rectangle2D rect) {
        double sin = Math.sin(this.theta);
        double cos = Math.cos(this.theta);
        double cx = rect.getCenterX() - this.xoff;
        double cy = rect.getCenterY() + this.yoff;
        double right = rect.getWidth() / 2.0 + this.xoff;
        double left = this.xoff - rect.getWidth() / 2.0;
        double bottom = this.yoff - rect.getHeight() / 2.0;
        double top = rect.getHeight() / 2.0 + this.yoff;
        this.hotSpots[0].setLocation(cx, cy);
        this.hotSpots[1].setLocation(cx + this.xoff * cos - bottom * sin, cy - bottom * cos - this.xoff * sin);
        this.hotSpots[2].setLocation(cx + left * cos - this.yoff * sin, cy - left * sin - this.yoff * cos);
        this.hotSpots[3].setLocation(cx + this.xoff * cos - top * sin, cy - top * cos - this.xoff * sin);
        this.hotSpots[4].setLocation(cx + right * cos - this.yoff * sin, cy - right * sin - this.yoff * cos);
        this.hotSpots[5].setLocation(cx + right * cos - top * sin, cy - right * sin - top * cos);
    }

    void setHotSpotXY(double x, double y) {
        if (this.hideBounds) {
            this.setXY(x, y);
            return;
        }
        if (this.xyDrag && this.selected && this.hotspot == CENTER) {
            this.setXY(x, y);
        } else if (this.rotateDrag && this.selected && this.hotspot == CORNER) {
            if (this.pixelSized) {
                double r = -this.toPixels.getScaleY() / this.toPixels.getScaleX();
                double dx = x - this.x;
                double dy = y - this.y;
                this.theta = Math.atan2(r * dy, dx) - Math.atan2(this.height / 2.0 + this.yoff, this.width / 2.0 + this.xoff);
            } else {
                double dx = x - this.x;
                double dy = y - this.y;
                double theta1 = Math.atan2(this.height / 2.0 + this.yoff, this.width / 2.0 + this.xoff);
                double theta2 = Math.atan2(dy, dx);
                this.setTheta(theta2 - theta1);
            }
        } else if (this.widthDrag && this.selected && (this.hotspot == LEFT || this.hotspot == RIGHT)) {
            if (this.pixelSized) {
                double dx = this.toPixels.getScaleX() * (x - this.x) - this.xoff;
                double dy = this.toPixels.getScaleY() * (y - this.y) + this.yoff;
                this.setWidth(2.0 * Math.sqrt(dx * dx + dy * dy));
            } else {
                double dx = x - this.x - this.xoff;
                double dy = y - this.y - this.yoff;
                this.setWidth(2.0 * Math.sqrt(dx * dx + dy * dy));
            }
        } else if (this.heightDrag && this.selected && (this.hotspot == TOP || this.hotspot == BOTTOM)) {
            if (this.pixelSized) {
                double dx = this.toPixels.getScaleX() * (x - this.x) - this.xoff;
                double dy = this.toPixels.getScaleY() * (y - this.y) + this.yoff;
                this.setHeight(2.0 * Math.sqrt(dx * dx + dy * dy));
            } else {
                double dx = x - this.x - this.xoff;
                double dy = y - this.y - this.yoff;
                this.setHeight(2.0 * Math.sqrt(dx * dx + dy * dy));
            }
        }
    }

    public void draw(DrawingPanel panel, Graphics g) {
        super.draw(panel, g);
        if (this.pixelSized) {
            this.drawFixedBounds(panel, g);
        } else {
            this.drawScaledBounds(panel, g);
        }
    }

    private void drawScaledBounds(DrawingPanel panel, Graphics g) {
        Shape temp;
        double r = -this.toPixels.getScaleY() / this.toPixels.getScaleX();
        if (this.theta == 0.0) {
            temp = this.toPixels.createTransformedShape(this.shape.getBounds2D());
            this.computeScaledHotSpots(temp.getBounds2D(), r);
            this.pixelBounds = temp.getBounds2D();
        } else {
            temp = AffineTransform.getRotateInstance(-this.theta, this.x, this.y).createTransformedShape(this.shape);
            temp = this.toPixels.createTransformedShape(temp);
            this.computeScaledHotSpots(temp.getBounds2D(), r);
            this.pixelBounds = temp.getBounds2D();
            if (panel.isSquareAspect()) {
                this.pixelBounds = AffineTransform.getRotateInstance(-this.theta, ((Rectangle2D)this.pixelBounds).getCenterX() - this.xoff * this.toPixels.getScaleX(), ((Rectangle2D)this.pixelBounds).getCenterY() - this.yoff * this.toPixels.getScaleY()).createTransformedShape(this.pixelBounds);
            } else {
                double px = ((Rectangle2D)this.pixelBounds).getCenterX() - this.xoff * this.toPixels.getScaleX();
                double py = ((Rectangle2D)this.pixelBounds).getCenterY() - this.yoff * this.toPixels.getScaleY();
                this.pixelBounds = AffineTransform.getTranslateInstance(-px, -py).createTransformedShape(this.pixelBounds);
                this.pixelBounds = AffineTransform.getScaleInstance(1.0, 1.0 / r).createTransformedShape(this.pixelBounds);
                this.pixelBounds = AffineTransform.getRotateInstance(-this.theta).createTransformedShape(this.pixelBounds);
                this.pixelBounds = AffineTransform.getScaleInstance(1.0, r).createTransformedShape(this.pixelBounds);
                this.pixelBounds = AffineTransform.getTranslateInstance(px, py).createTransformedShape(this.pixelBounds);
            }
        }
        if (!this.selected || this.hideBounds) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.boundsColor);
        g2.draw(this.pixelBounds);
        if (this.rotateDrag) {
            g2.fillOval((int)this.hotSpots[CORNER].getX() - this.delta, (int)this.hotSpots[CORNER].getY() - this.delta, this.d2, this.d2);
        }
        if (this.heightDrag) {
            g2.fillRect((int)this.hotSpots[TOP].getX() - this.delta, (int)this.hotSpots[TOP].getY() - this.delta, this.d2, this.d2);
            g2.fillRect((int)this.hotSpots[BOTTOM].getX() - this.delta, (int)this.hotSpots[BOTTOM].getY() - this.delta, this.d2, this.d2);
        }
        if (this.widthDrag) {
            g2.fillRect((int)this.hotSpots[LEFT].getX() - this.delta, (int)this.hotSpots[LEFT].getY() - this.delta, this.d2, this.d2);
            g2.fillRect((int)this.hotSpots[RIGHT].getX() - this.delta, (int)this.hotSpots[RIGHT].getY() - this.delta, this.d2, this.d2);
        }
        if (this.xyDrag) {
            g2.fillRect((int)this.hotSpots[CENTER].getX() - this.delta, (int)this.hotSpots[CENTER].getY() - this.delta, this.d2, this.d2);
            g2.setColor(this.edgeColor);
            g2.fillOval((int)this.hotSpots[CENTER].getX() - 1, (int)this.hotSpots[CENTER].getY() - 1, 3, 3);
            g2.setPaint(this.boundsColor);
        }
        g.setColor(Color.BLACK);
    }

    private void drawFixedBounds(DrawingPanel panel, Graphics g) {
        Point2D pt;
        if (this.theta == 0.0) {
            pt = new Point2D.Double(this.x, this.y);
            pt = this.toPixels.transform(pt, pt);
            Shape temp = AffineTransform.getTranslateInstance(-this.x + pt.getX() + this.xoff, -this.y + pt.getY() - this.yoff).createTransformedShape(this.shape.getBounds2D());
            this.computeFixedHotSpots(temp.getBounds2D());
            this.pixelBounds = temp.getBounds2D();
        } else {
            pt = new Point2D.Double(this.x, this.y);
            pt = this.toPixels.transform(pt, pt);
            Shape temp = AffineTransform.getTranslateInstance(-this.x + pt.getX() + this.xoff, -this.y + pt.getY() - this.yoff).createTransformedShape(this.shape);
            this.computeFixedHotSpots(temp.getBounds2D());
            this.pixelBounds = temp.getBounds2D();
            this.pixelBounds = AffineTransform.getRotateInstance(-this.theta, pt.getX(), pt.getY()).createTransformedShape(this.pixelBounds);
        }
        if (!this.selected || this.hideBounds) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.boundsColor);
        g2.draw(this.pixelBounds);
        if (this.rotateDrag) {
            g2.fillOval((int)this.hotSpots[CORNER].getX() - this.delta, (int)this.hotSpots[CORNER].getY() - this.delta, this.d2, this.d2);
        }
        if (this.heightDrag) {
            g2.fillRect((int)this.hotSpots[TOP].getX() - this.delta, (int)this.hotSpots[TOP].getY() - this.delta, this.d2, this.d2);
            g2.fillRect((int)this.hotSpots[BOTTOM].getX() - this.delta, (int)this.hotSpots[BOTTOM].getY() - this.delta, this.d2, this.d2);
        }
        if (this.widthDrag) {
            g2.fillRect((int)this.hotSpots[LEFT].getX() - this.delta, (int)this.hotSpots[LEFT].getY() - this.delta, this.d2, this.d2);
            g2.fillRect((int)this.hotSpots[RIGHT].getX() - this.delta, (int)this.hotSpots[RIGHT].getY() - this.delta, this.d2, this.d2);
        }
        if (this.xyDrag) {
            g2.fillRect((int)this.hotSpots[CENTER].getX() - this.delta, (int)this.hotSpots[CENTER].getY() - this.delta, this.d2, this.d2);
            g2.setColor(this.edgeColor);
            g2.fillOval((int)this.hotSpots[CENTER].getX() - 1, (int)this.hotSpots[CENTER].getY() - 1, 3, 3);
            g2.setPaint(this.boundsColor);
        }
        g.setColor(Color.BLACK);
    }

    public String toString() {
        return "BoundedShape:\n \t shape=" + this.shapeClass + "\n \t x=" + this.x + "\n \t y=" + this.y + "\n \t width=" + this.width + "\n \t height=" + this.height + "\n \t theta=" + this.theta;
    }

    public static XML.ObjectLoader getLoader() {
        return new BoundedShapeLoader();
    }

    class XYDelegate
    extends AbstractInteractive
    implements Selectable {
        XYDelegate() {
        }

        public void draw(DrawingPanel panel, Graphics g) {
        }

        public boolean isInside(DrawingPanel panel, int xpix, int ypix) {
            return BoundedShape.this.isInside(panel, xpix, ypix);
        }

        public void setXY(double x, double y) {
            BoundedShape.this.setHotSpotXY(x, y);
        }

        public void setSelected(boolean selectable) {
            BoundedShape.this.setSelected(selectable);
        }

        public void toggleSelected() {
            BoundedShape.this.toggleSelected();
        }

        public boolean isSelected() {
            return BoundedShape.this.isSelected();
        }

        public Cursor getPreferredCursor() {
            return BoundedShape.this.getPreferredCursor();
        }
    }

    protected static class BoundedShapeLoader
    extends InteractiveShape.InteractiveShapeLoader {
        protected BoundedShapeLoader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            super.saveObject(control, obj);
            BoundedShape boundedShape = (BoundedShape)obj;
            control.setValue("xy drag", boundedShape.isXYDrag());
            control.setValue("width drag", boundedShape.isWidthDrag());
            control.setValue("height drag", boundedShape.isHeightDrag());
            control.setValue("rotate drag", boundedShape.isRotateDrag());
        }

        public Object createObject(XMLControl control) {
            return new BoundedShape(new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0), 0.0, 0.0);
        }

        public Object loadObject(XMLControl control, Object obj) {
            BoundedShape boundedShape = (BoundedShape)obj;
            boundedShape.setXYDrag(control.getBoolean("xy drag"));
            boundedShape.setWidthDrag(control.getBoolean("width drag"));
            boundedShape.setHeightDrag(control.getBoolean("height drag"));
            boundedShape.setRotateDrag(control.getBoolean("rotate drag"));
            super.loadObject(control, obj);
            return boundedShape;
        }
    }
}

