/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.opensourcephysics.display.DataTableModel;
import org.opensourcephysics.display.SortDecorator;

public class DataTable
extends JTable
implements ActionListener {
    static final Color PANEL_BACKGROUND = UIManager.getColor("Panel.background");
    static final Color LIGHT_BLUE = new Color(204, 204, 255);
    final SortDecorator decorator;
    Map renderersByColumnName = new HashMap();
    DataTableModel dataTableModel;
    RowNumberRenderer rowNumberRenderer;
    int maximumFractionDigits = 3;
    int refreshDelay = 0;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;

    public DataTable() {
        this(new DefaultDataTableModel());
    }

    public DataTable(DataTableModel model) {
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.setModel(model);
        this.setColumnSelectionAllowed(true);
        this.setGridColor(Color.blue);
        this.setSelectionBackground(LIGHT_BLUE);
        JTableHeader header = this.getTableHeader();
        header.setForeground(Color.blue);
        this.setSelectionForeground(Color.red);
        this.setColumnModel(new DataTableColumnModel());
        this.setSelectionMode(1);
        this.setColumnSelectionAllowed(true);
        this.decorator = new SortDecorator(this.getModel());
        this.setModel(this.decorator);
        JTableHeader hdr = this.getTableHeader();
        hdr.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel tcm = DataTable.this.getColumnModel();
                int vc = tcm.getColumnIndexAtX(e.getX());
                int mc = DataTable.this.convertColumnIndexToModel(vc);
                DataTable.this.decorator.sort(mc);
            }
        });
    }

    public void setMaximumFractionDigits(String columnName, int maximumFractionDigits) {
        this.renderersByColumnName.put(columnName, new PrecisionRenderer(maximumFractionDigits));
    }

    public void sort(int col) {
        this.decorator.sort(col);
    }

    public void setMaximumFractionDigits(int maximumFractionDigits) {
        this.maximumFractionDigits = maximumFractionDigits;
        this.setDefaultRenderer(class$java$lang$Double == null ? (class$java$lang$Double = DataTable.class$("java.lang.Double")) : class$java$lang$Double, new PrecisionRenderer(maximumFractionDigits));
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public void setRowNumberVisible(boolean _rowNumberVisible) {
        if (this.dataTableModel.isRowNumberVisible() != _rowNumberVisible) {
            if (_rowNumberVisible && this.rowNumberRenderer == null) {
                this.rowNumberRenderer = new RowNumberRenderer(this);
            }
            this.dataTableModel.setRowNumberVisible(_rowNumberVisible);
        }
    }

    public void setModel(DataTableModel _model) {
        super.setModel(_model);
        this.dataTableModel = _model;
    }

    public void setStride(TableModel tableModel, int stride) {
        this.dataTableModel.setStride(tableModel, stride);
    }

    public void setColumnVisible(TableModel tableModel, int columnIndex, boolean b) {
        this.dataTableModel.setColumnVisible(tableModel, columnIndex, b);
    }

    public boolean isRowNumberVisible() {
        return this.dataTableModel.isRowNumberVisible();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        int i = this.convertColumnIndexToModel(column);
        if (i == 0 && this.dataTableModel.isRowNumberVisible()) {
            return this.rowNumberRenderer;
        }
        try {
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            TableCellRenderer renderer = tableColumn.getCellRenderer();
            if (renderer != null) {
                return renderer;
            }
            Iterator keys = this.renderersByColumnName.keySet().iterator();
            while (keys.hasNext()) {
                String columnName = (String)keys.next();
                if (!tableColumn.getHeaderValue().equals(columnName)) continue;
                return (TableCellRenderer)this.renderersByColumnName.get(columnName);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return this.getDefaultRenderer(this.getColumnClass(column));
    }

    public void setRefreshDelay(int delay) {
        if (delay > 0) {
            this.refreshTimer.setDelay(delay);
            this.refreshTimer.setInitialDelay(delay);
        } else if (delay <= 0) {
            this.refreshTimer.stop();
        }
        this.refreshDelay = delay;
    }

    public void refreshTable() {
        if (this.refreshDelay > 0) {
            this.refreshTimer.start();
        } else {
            Runnable doRefreshTable = new Runnable(){

                public synchronized void run() {
                    DataTable.this.tableChanged(new TableModelEvent(DataTable.this.dataTableModel, -1));
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                doRefreshTable.run();
            } else {
                SwingUtilities.invokeLater(doRefreshTable);
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        this.tableChanged(new TableModelEvent(this.dataTableModel, -1));
    }

    public void add(TableModel tableModel) {
        this.dataTableModel.add(tableModel);
    }

    public void remove(TableModel tableModel) {
        this.dataTableModel.remove(tableModel);
    }

    public void clear() {
        this.dataTableModel.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RowNumberRenderer
    extends JLabel
    implements TableCellRenderer {
        JTable table;

        public RowNumberRenderer(JTable _table) {
            this.table = _table;
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
            this.setForeground(Color.black);
            this.setBackground(PANEL_BACKGROUND);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table.isRowSelected(row)) {
                int[] i = table.getSelectedColumns();
                if (i.length == 1 && table.convertColumnIndexToModel(i[0]) == 0) {
                    this.setBackground(PANEL_BACKGROUND);
                } else {
                    this.setBackground(Color.gray);
                }
            } else {
                this.setBackground(PANEL_BACKGROUND);
            }
            this.setText(value.toString());
            return this;
        }
    }

    private static class PrecisionRenderer
    extends DefaultTableCellRenderer {
        NumberFormat numberFormat = NumberFormat.getInstance();

        public PrecisionRenderer(int precision) {
            this.numberFormat.setMaximumFractionDigits(precision);
            this.setHorizontalAlignment(4);
        }

        public void setValue(Object value) {
            this.setText(value == null ? "" : this.numberFormat.format(value));
        }

        public void setPrecision(int precision) {
            this.numberFormat.setMaximumFractionDigits(precision);
        }
    }

    private class DataTableColumnModel
    extends DefaultTableColumnModel {
        private DataTableColumnModel() {
        }

        public TableColumn getColumn(int columnIndex) {
            TableColumn tableColumn;
            try {
                tableColumn = super.getColumn(columnIndex);
            }
            catch (Exception ex) {
                return new TableColumn();
            }
            String headerValue = (String)tableColumn.getHeaderValue();
            if (headerValue == null) {
                return tableColumn;
            }
            if (headerValue.equals("row")) {
                tableColumn.setMaxWidth(40);
                tableColumn.setMinWidth(40);
                tableColumn.setResizable(false);
            }
            return tableColumn;
        }
    }

    private static class ModelFilterResult {
        DataTableElement tableElement;
        int column;

        public ModelFilterResult(DataTableElement _tableElement, int _column) {
            this.tableElement = _tableElement;
            this.column = _column;
        }

        public static ModelFilterResult find(boolean rowNumberVisible, ArrayList dataTableElements, int tableColumnIndex) {
            if (rowNumberVisible) {
                --tableColumnIndex;
            }
            int totalColumns = 0;
            for (int i = 0; i < dataTableElements.size(); ++i) {
                DataTableElement dte = (DataTableElement)dataTableElements.get(i);
                int columnCount = dte.getColumnCount();
                if ((totalColumns += columnCount) <= tableColumnIndex) continue;
                int columnIndex = columnCount + tableColumnIndex - totalColumns;
                boolean[] visible = dte.getColumnVisibilities();
                for (int j = 0; j < tableColumnIndex; ++j) {
                    if (visible[j]) continue;
                    ++columnIndex;
                }
                return new ModelFilterResult(dte, columnIndex);
            }
            return null;
        }
    }

    private static class DefaultDataTableModel
    implements DataTableModel {
        ArrayList dataTableElements = new ArrayList();
        boolean rowNumberVisible = false;

        private DefaultDataTableModel() {
        }

        public void setColumnVisible(TableModel tableModel, int columnIndex, boolean b) {
            DataTableElement dte = this.findElementContaining(tableModel);
            dte.setColumnVisible(columnIndex, b);
        }

        public void setStride(TableModel tableModel, int stride) {
            DataTableElement dte = this.findElementContaining(tableModel);
            dte.setStride(stride);
        }

        public void setRowNumberVisible(boolean _rowNumberVisible) {
            this.rowNumberVisible = _rowNumberVisible;
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
        }

        public boolean isRowNumberVisible() {
            return this.rowNumberVisible;
        }

        public String getColumnName(int columnIndex) {
            if (this.dataTableElements.size() == 0 && !this.rowNumberVisible) {
                return null;
            }
            if (this.rowNumberVisible && columnIndex == 0) {
                return "row";
            }
            ModelFilterResult mfr = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, columnIndex);
            DataTableElement dte = mfr.tableElement;
            return dte.getColumnName(mfr.column);
        }

        public int getRowCount() {
            int rowCount = 0;
            for (int i = 0; i < this.dataTableElements.size(); ++i) {
                DataTableElement dte = (DataTableElement)this.dataTableElements.get(i);
                int stride = dte.getStride();
                rowCount = Math.max(rowCount, (dte.getRowCount() + stride - 1) / stride);
            }
            return rowCount;
        }

        public int getColumnCount() {
            int columnCount = 0;
            for (int i = 0; i < this.dataTableElements.size(); ++i) {
                DataTableElement dte = (DataTableElement)this.dataTableElements.get(i);
                columnCount += dte.getColumnCount();
            }
            if (this.rowNumberVisible) {
                ++columnCount;
            }
            return columnCount;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.dataTableElements.size() == 0) {
                return null;
            }
            if (this.rowNumberVisible && columnIndex == 0) {
                return new Integer(rowIndex);
            }
            ModelFilterResult mfr = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, columnIndex);
            DataTableElement dte = mfr.tableElement;
            int stride = dte.getStride();
            if ((rowIndex *= stride) >= dte.getRowCount()) {
                return null;
            }
            return dte.getValueAt(rowIndex, mfr.column);
        }

        public Class getColumnClass(int columnIndex) {
            if (this.rowNumberVisible && columnIndex == 0) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = DataTable.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (columnIndex == 0 && this.rowNumberVisible) {
                --columnIndex;
            }
            ModelFilterResult mfr = ModelFilterResult.find(this.rowNumberVisible, this.dataTableElements, columnIndex);
            DataTableElement dte = mfr.tableElement;
            return dte.getColumnClass(mfr.column);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public void remove(TableModel tableModel) {
            DataTableElement dte = this.findElementContaining(tableModel);
            ((AbstractCollection)this.dataTableElements).remove(dte);
        }

        public void clear() {
            this.dataTableElements.clear();
        }

        public void add(TableModel tableModel) {
            this.dataTableElements.add(new DataTableElement(tableModel));
        }

        public void addTableModelListener(TableModelListener l) {
        }

        public void removeTableModelListener(TableModelListener l) {
        }

        private DataTableElement findElementContaining(TableModel tableModel) {
            for (int i = 0; i < this.dataTableElements.size(); ++i) {
                DataTableElement dte = (DataTableElement)this.dataTableElements.get(i);
                if (dte.tableModel != tableModel) continue;
                return dte;
            }
            return null;
        }
    }

    private static class DataTableElement {
        TableModel tableModel;
        boolean[] columnVisibilities;
        int stride = 1;

        public DataTableElement(TableModel t) {
            this.tableModel = t;
        }

        public void setStride(int _stride) {
            this.stride = _stride;
        }

        public void setColumnVisible(int columnIndex, boolean visible) {
            this.ensureCapacity(columnIndex + 1);
            this.columnVisibilities[columnIndex] = visible;
        }

        public int getStride() {
            return this.stride;
        }

        public boolean[] getColumnVisibilities() {
            return this.columnVisibilities;
        }

        public int getColumnCount() {
            int count = 0;
            int numberOfColumns = this.tableModel.getColumnCount();
            this.ensureCapacity(numberOfColumns);
            for (int i = 0; i < numberOfColumns; ++i) {
                boolean visible = this.columnVisibilities[i];
                if (!visible) continue;
                ++count;
            }
            return count;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.tableModel.getValueAt(rowIndex, columnIndex);
        }

        public String getColumnName(int columnIndex) {
            return this.tableModel.getColumnName(columnIndex);
        }

        public Class getColumnClass(int columnIndex) {
            return this.tableModel.getColumnClass(columnIndex);
        }

        public int getRowCount() {
            return this.tableModel.getRowCount();
        }

        private void ensureCapacity(int minimumCapacity) {
            if (this.columnVisibilities == null) {
                this.columnVisibilities = new boolean[minimumCapacity * 3 / 2 + 1];
                Arrays.fill(this.columnVisibilities, true);
            } else if (this.columnVisibilities.length < minimumCapacity) {
                boolean[] temp = this.columnVisibilities;
                this.columnVisibilities = new boolean[minimumCapacity * 3 / 2 + 1];
                System.arraycopy(temp, 0, this.columnVisibilities, 0, temp.length);
                Arrays.fill(this.columnVisibilities, temp.length, this.columnVisibilities.length, true);
            }
        }
    }
}

