/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;

public class DataTableFrame
extends OSPFrame {
    protected JMenuBar menuBar;
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenuItem saveAsItem;
    protected DataTable table;

    public DataTableFrame(DataTable table) {
        this(DisplayRes.getString("DataTableFrame.DefaultTitle"), table);
    }

    public DataTableFrame(String title, DataTable _table) {
        super(title);
        this.table = _table;
        JScrollPane scrollPane = new JScrollPane(this.table);
        Container c = this.getContentPane();
        c.add((Component)scrollPane, "Center");
        this.pack();
        if (!OSPFrame.appletMode) {
            this.createMenuBar();
            this.loadDisplayMenu();
        }
    }

    protected JMenu loadDisplayMenu() {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        JMenu displayMenu = new JMenu();
        displayMenu.setText(DisplayRes.getString("DataTableFrame.Display_menu_title"));
        menuBar.add(displayMenu);
        JMenuItem setFontItem = new JMenuItem(DisplayRes.getString("DataTableFrame.NumberFormat_menu_item_title"));
        setFontItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataTableFrame.this.setNumberFormat();
            }
        });
        displayMenu.add(setFontItem);
        return displayMenu;
    }

    private void createMenuBar() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.fileMenu = new JMenu(DisplayRes.getString("DataTableFrame.File_menu_item_title"));
        this.editMenu = new JMenu(DisplayRes.getString("DataTableFrame.Edit_menu_item_title"));
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        JMenuItem saveAsItem = new JMenuItem(DisplayRes.getString("DataTableFrame.SaveAs_menu_item_title"));
        JMenuItem copyItem = new JMenuItem(DisplayRes.getString("DataTableFrame.Copy_menu_item_title"));
        JMenuItem selectAlItem = new JMenuItem(DisplayRes.getString("DataTableFrame.SelectAll_menu_item_title"));
        this.fileMenu.add(saveAsItem);
        this.editMenu.add(copyItem);
        this.editMenu.add(selectAlItem);
        copyItem.setAccelerator(KeyStroke.getKeyStroke(67, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataTableFrame.this.copy();
            }
        });
        selectAlItem.setAccelerator(KeyStroke.getKeyStroke(65, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        selectAlItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataTableFrame.this.table.selectAll();
            }
        });
        saveAsItem.setAccelerator(KeyStroke.getKeyStroke(83, DrawingFrame.MENU_SHORTCUT_KEY_MASK));
        saveAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataTableFrame.this.saveAs();
            }
        });
        this.validate();
    }

    void setNumberFormat() {
        int digits = this.table.getMaximumFractionDigits();
        String str = JOptionPane.showInputDialog(this, DisplayRes.getString("DataTableFrame.NumberOfDigits_option_pane_title"), "" + digits);
        if (str == null) {
            return;
        }
        digits = Integer.parseInt(str);
        digits = Math.max(digits, 1);
        this.table.setMaximumFractionDigits(Math.min(digits, 16));
        this.table.refreshTable();
    }

    public void copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        int[] selectedRows = this.table.getSelectedRows();
        int[] selectedColumns = this.table.getSelectedColumns();
        StringBuffer buf = this.getSelectedData(selectedRows, selectedColumns);
        StringSelection stringSelection = new StringSelection(buf.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    public void refreshTable() {
        this.table.refreshTable();
    }

    public StringBuffer getSelectedData(int[] selectedRows, int[] selectedColumns) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < selectedRows.length; ++i) {
            for (int j = 0; j < selectedColumns.length; ++j) {
                int row = i;
                int temp = this.table.convertColumnIndexToModel(selectedColumns[j]);
                if (this.table.isRowNumberVisible() && temp == 0) continue;
                Object value = this.table.getValueAt(row, selectedColumns[j]);
                if (value != null) {
                    buf.append(value);
                }
                buf.append("\t");
            }
            buf.append("\n");
        }
        return buf;
    }

    public void sort(int col) {
        this.table.sort(col);
    }

    public void saveAs() {
        int i;
        File file = GUIUtils.showSaveDialog(this);
        if (file == null) {
            return;
        }
        int firstRow = 0;
        int lastRow = this.table.getRowCount() - 1;
        int lastColumn = this.table.getColumnCount() - 1;
        int firstColumn = 0;
        if (this.table.isRowNumberVisible()) {
            ++firstColumn;
        }
        int[] selectedRows = new int[lastRow + 1];
        int[] selectedColumns = new int[lastColumn + 1];
        for (i = firstRow; i <= lastRow; ++i) {
            selectedRows[i] = i;
        }
        for (i = firstColumn; i <= lastColumn; ++i) {
            selectedColumns[i] = i;
        }
        try {
            FileWriter fw = new FileWriter(file);
            PrintWriter pw = new PrintWriter(fw);
            pw.print(this.getSelectedData(selectedRows, selectedColumns));
            pw.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, DisplayRes.getString("DataTableFrame.SaveErrorMessage"), DisplayRes.getString("DataTableFrame.Error"), 0);
        }
    }
}

