/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Measurable;

public class DatasetManager
extends AbstractTableModel
implements Measurable {
    ArrayList datasets = new ArrayList();
    boolean connected;
    boolean sorted;
    int markerShape;
    int stride = 1;
    boolean linked = false;
    static Color[] lineColors = new Color[]{Color.red, Color.green, Color.blue, Color.yellow.darker(), Color.cyan, Color.magenta};
    static Color[] markerColors = new Color[]{Color.black, Color.blue, Color.red, Color.green, Color.darkGray, Color.lightGray};
    String xColumnName = "x";
    String yColumnName = "y";
    static /* synthetic */ Class class$java$lang$Double;

    public DatasetManager() {
        this(false, false, false, 2);
    }

    public DatasetManager(boolean linked) {
        this(false, false, linked, 2);
    }

    public DatasetManager(boolean _connected, boolean _sorted) {
        this(_connected, _sorted, false, 2);
    }

    public DatasetManager(boolean _connected, boolean _sorted, boolean _linked, int _markerShape) {
        this.connected = _connected;
        this.sorted = _sorted;
        this.markerShape = _markerShape;
        this.linked = _linked;
    }

    public void setXPointsLinked(boolean _linked) {
        this.linked = _linked;
        for (int i = 1; i < this.datasets.size(); ++i) {
            Dataset dataset = (Dataset)this.datasets.get(i);
            dataset.setXColumnVisible(!this.linked);
        }
    }

    public void setSorted(int datasetIndex, boolean _sorted) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.setSorted(_sorted);
    }

    public void setSorted(boolean _sorted) {
        this.sorted = _sorted;
        for (int i = 0; i < this.datasets.size(); ++i) {
            ((Dataset)this.datasets.get(i)).setSorted(_sorted);
        }
    }

    public void setConnected(int datasetIndex, boolean _connected) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.setConnected(_connected);
    }

    public void setConnected(boolean _connected) {
        this.connected = _connected;
        for (int i = 0; i < this.datasets.size(); ++i) {
            ((Dataset)this.datasets.get(i)).setConnected(_connected);
        }
    }

    public void setStride(int datasetIndex, int stride) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.setStride(stride);
    }

    public void setStride(int _stride) {
        this.stride = _stride;
        for (int i = 0; i < this.datasets.size(); ++i) {
            ((Dataset)this.datasets.get(i)).setStride(this.stride);
        }
    }

    public void setMarkerColor(int datasetIndex, Color _markerColor) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.setMarkerColor(_markerColor);
    }

    public void setMarkerColor(int datasetIndex, Color fillColor, Color edgeColor) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.setMarkerColor(fillColor, edgeColor);
    }

    public void setMarkerShape(int datasetIndex, int _markerShape) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.setMarkerShape(_markerShape);
    }

    public void setCustomMarker(int datasetIndex, Shape marker) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.setCustomMarker(marker);
    }

    public void setXColumnVisible(int datasetIndex, boolean visible) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.setXColumnVisible(visible);
    }

    public void setYColumnVisible(int datasetIndex, boolean visible) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.setYColumnVisible(visible);
    }

    public void setMarkerSize(int datasetIndex, int _markerSize) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.setMarkerSize(_markerSize);
    }

    public void setLineColor(int datasetIndex, Color _lineColor) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.setLineColor(_lineColor);
    }

    public void setXYColumnNames(int datasetIndex, String xColumnName, String yColumnName, String datsetName) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.setXYColumnNames(xColumnName, yColumnName, datsetName);
    }

    public void setXYColumnNames(int datasetIndex, String xColumnName, String yColumnName) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.setXYColumnNames(xColumnName, yColumnName);
    }

    public boolean isMeasured() {
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset d = (Dataset)this.datasets.get(i);
            if (!d.isMeasured()) continue;
            return true;
        }
        return false;
    }

    public double getXMin() {
        double xmin = Double.MAX_VALUE;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset d = (Dataset)this.datasets.get(i);
            if (!d.isMeasured()) continue;
            xmin = Math.min(xmin, d.getXMin());
        }
        return xmin;
    }

    public double getXMax() {
        double xmax = -1.7976931348623157E308;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset d = (Dataset)this.datasets.get(i);
            if (!d.isMeasured()) continue;
            xmax = Math.max(xmax, d.getXMax());
        }
        return xmax;
    }

    public double getYMin() {
        double ymin = Double.MAX_VALUE;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset d = (Dataset)this.datasets.get(i);
            if (!d.isMeasured()) continue;
            ymin = Math.min(ymin, d.getYMin());
        }
        return ymin;
    }

    public double getYMax() {
        double ymax = -1.7976931348623157E308;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset d = (Dataset)this.datasets.get(i);
            if (!d.isMeasured()) continue;
            ymax = Math.max(ymax, d.getYMax());
        }
        return ymax;
    }

    public double[] getXPoints(int datasetIndex) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        return dataset.getXPoints();
    }

    public double[] getYPoints(int datasetIndex) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        return dataset.getYPoints();
    }

    public boolean isSorted(int datasetIndex) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        return dataset.isSorted();
    }

    public boolean isConnected(int datasetIndex) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        return dataset.isConnected();
    }

    public int getColumnCount() {
        int columnCount = 0;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset d = (Dataset)this.datasets.get(i);
            columnCount += d.getColumnCount();
        }
        return columnCount;
    }

    public int getRowCount() {
        int rowCount = 0;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset d = (Dataset)this.datasets.get(i);
            rowCount = Math.max(rowCount, d.getRowCount());
        }
        return rowCount;
    }

    public String getColumnName(int tableColumnIndex) {
        if (this.datasets.size() == 0) {
            return null;
        }
        int totalColumns = 0;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset tableModel = (Dataset)this.datasets.get(i);
            int columnCount = tableModel.getColumnCount();
            if ((totalColumns += columnCount) <= tableColumnIndex) continue;
            int columnIndex = Math.abs(totalColumns - columnCount - tableColumnIndex);
            return tableModel.getColumnName(columnIndex);
        }
        return null;
    }

    public Object getValueAt(int rowIndex, int tableColumnIndex) {
        if (this.datasets.size() == 0) {
            return null;
        }
        int totalColumns = 0;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset tableModel = (Dataset)this.datasets.get(i);
            int columnCount = tableModel.getColumnCount();
            if ((totalColumns += columnCount) <= tableColumnIndex) continue;
            if (rowIndex >= tableModel.getRowCount()) {
                return null;
            }
            int columnIndex = Math.abs(totalColumns - columnCount - tableColumnIndex);
            return tableModel.getValueAt(rowIndex, columnIndex);
        }
        return null;
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$Double == null ? (class$java$lang$Double = DatasetManager.class$("java.lang.Double")) : class$java$lang$Double;
    }

    public void append(int datasetIndex, double x, double y) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.append(x, y);
    }

    public void append(int datasetIndex, double x, double y, double delx, double dely) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.append(x, y, delx, dely);
    }

    public void append(int datasetIndex, double[] xpoints, double[] ypoints) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.append(xpoints, ypoints);
    }

    public void append(int datasetIndex, double[] xpoints, double[] ypoints, double[] delx, double[] dely) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.append(xpoints, ypoints, delx, dely);
    }

    public void draw(DrawingPanel drawingPanel, Graphics g) {
        for (int i = 0; i < this.datasets.size(); ++i) {
            ((Dataset)this.datasets.get(i)).draw(drawingPanel, g);
        }
    }

    public void clear(int datasetIndex) {
        this.checkDatasetIndex(datasetIndex);
        Dataset dataset = (Dataset)this.datasets.get(datasetIndex);
        dataset.clear();
    }

    public void clear() {
        for (int i = 0; i < this.datasets.size(); ++i) {
            ((Dataset)this.datasets.get(i)).clear();
        }
    }

    public void removeDatasets() {
        this.clear();
        this.datasets.clear();
    }

    public Dataset getDataset(int datasetIndex) {
        this.checkDatasetIndex(datasetIndex);
        return (Dataset)this.datasets.get(datasetIndex);
    }

    public ArrayList getDatasets() {
        return (ArrayList)this.datasets.clone();
    }

    public String toString() {
        if (this.datasets.size() == 0) {
            return "No data in datasets.";
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.datasets.size(); ++i) {
            b.append("Dataset ");
            b.append(i);
            b.append('\n');
            b.append(this.datasets.get(i).toString());
        }
        return b.toString();
    }

    public void setXYColumnNames(String _xColumnName, String _yColumnName) {
        this.xColumnName = _xColumnName;
        this.yColumnName = _yColumnName;
        int size = this.datasets.size();
        for (int i = 0; i < size; ++i) {
            ((Dataset)this.datasets.get(i)).setXYColumnNames(_xColumnName, _yColumnName);
        }
    }

    public static Color getLineColor(int index) {
        if (index < lineColors.length - 1) {
            return lineColors[index];
        }
        return GUIUtils.randomColor();
    }

    protected void checkDatasetIndex(int datasetIndex) {
        while (datasetIndex >= this.datasets.size()) {
            Dataset d = null;
            d = datasetIndex < lineColors.length - 1 ? new Dataset(markerColors[datasetIndex], lineColors[datasetIndex], this.connected) : new Dataset(GUIUtils.randomColor(), GUIUtils.randomColor(), this.connected);
            if (this.linked && this.datasets.size() > 0) {
                d.setXColumnVisible(false);
            }
            d.setSorted(this.sorted);
            d.setXYColumnNames(this.xColumnName, this.yColumnName);
            d.setMarkerShape(this.markerShape);
            this.datasets.add(d);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            DatasetManager dsm = (DatasetManager)obj;
            control.setValue("connected", dsm.connected);
            control.setValue("sorted", dsm.sorted);
            control.setValue("maker_shape", dsm.markerShape);
            control.setValue("stride", dsm.stride);
            control.setValue("linked", dsm.linked);
            control.setValue("x_column_name", dsm.xColumnName);
            control.setValue("y_column_name", dsm.yColumnName);
            control.setValue("datasets", dsm.datasets);
        }

        public Object createObject(XMLControl control) {
            return new DatasetManager();
        }

        public Object loadObject(XMLControl control, Object obj) {
            DatasetManager dsm = (DatasetManager)obj;
            dsm.connected = control.getBoolean("connected");
            dsm.sorted = control.getBoolean("sorted");
            dsm.markerShape = control.getInt("maker_shape");
            dsm.stride = control.getInt("stride");
            dsm.linked = control.getBoolean("linked");
            dsm.xColumnName = control.getString("x_column_name");
            dsm.yColumnName = control.getString("y_column_name");
            Collection datasets = (Collection)control.getObject("datasets");
            dsm.removeDatasets();
            if (datasets != null) {
                Iterator it = datasets.iterator();
                while (it.hasNext()) {
                    dsm.datasets.add((Dataset)it.next());
                }
            }
            return obj;
        }
    }
}

