/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.False3D;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.MouseController;
import org.opensourcephysics.display.OSPLayout;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display.TextPanel;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.dialogs.AutoScaleInspector;
import org.opensourcephysics.display.dialogs.DrawingPanelInspector;
import org.opensourcephysics.display.dialogs.ScaleInspector;
import org.opensourcephysics.display.dialogs.XMLDrawingPanelInspector;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.VideoCaptureTool;

public class DrawingPanel
extends JPanel
implements Printable,
ActionListener,
Renderable {
    public static final int BOTTOM_LEFT = 0;
    public static final int BOTTOM_RIGHT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int TOP_LEFT = 3;
    protected JPopupMenu popupmenu = new JPopupMenu();
    protected JMenuItem propertiesItem;
    protected int leftGutter = 0;
    protected int topGutter = 0;
    protected int rightGutter = 0;
    protected int bottomGutter = 0;
    protected int width;
    protected int height;
    protected Color bgColor = new Color(239, 239, 255);
    protected boolean antialiasTextOn = false;
    protected boolean antialiasShapeOn = false;
    protected boolean squareAspect = false;
    protected boolean autoscaleX = true;
    protected boolean autoscaleY = true;
    protected double autoscaleMargin = 0.0;
    protected double xminPreferred = -10.0;
    protected double xmaxPreferred = 10.0;
    protected double yminPreferred = -10.0;
    protected double ymaxPreferred = 10.0;
    protected double xfloor = Double.NaN;
    protected double xceil = Double.NaN;
    protected double yfloor = Double.NaN;
    protected double yceil = Double.NaN;
    protected double xmin = this.xminPreferred;
    protected double xmax = this.xmaxPreferred;
    protected double ymin = this.yminPreferred;
    protected double ymax = this.xmaxPreferred;
    protected boolean fixedPixelPerUnit = false;
    protected double xPixPerUnit = 1.0;
    protected double yPixPerUnit = 1.0;
    protected AffineTransform pixelTransform = new AffineTransform();
    protected double[] pixelMatrix = new double[6];
    protected ArrayList drawableList = new ArrayList();
    protected boolean validImage = false;
    protected BufferedImage offscreenImage;
    protected BufferedImage workingImage = this.offscreenImage = new BufferedImage(1, 1, 1);
    private boolean buffered = false;
    protected TextPanel trMessageBox = new TextPanel();
    protected TextPanel tlMessageBox = new TextPanel();
    protected TextPanel brMessageBox = new TextPanel();
    protected TextPanel blMessageBox = new TextPanel();
    protected DecimalFormat scientificFormat = new DecimalFormat("0.###E0");
    protected DecimalFormat decimalFormat = new DecimalFormat("0.00");
    protected MouseController mouseController = new CMController();
    protected boolean showCoordinates = false;
    protected OptionController optionController = new OptionController();
    protected ZoomBox zoomBox = new ZoomBox();
    protected boolean enableZoom = false;
    protected boolean zoomMode = false;
    protected Window customInspector;
    protected boolean clipAtGutter = true;
    protected Dimensioned dimensionSetter = null;
    protected Rectangle viewRect = null;
    protected CoordinateStringBuilder coordinateStrBuilder = CoordinateStringBuilder.createCartesian();
    protected GlassPanel glassPanel = new GlassPanel();
    protected OSPLayout glassPanelLayout = new OSPLayout();
    int refreshDelay = 100;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    VideoCaptureTool vidCap;

    public DrawingPanel() {
        this.glassPanel.setLayout(this.glassPanelLayout);
        super.setLayout(new BorderLayout());
        this.glassPanel.add((Component)this.trMessageBox, "TopRightCorner");
        this.glassPanel.add((Component)this.tlMessageBox, "TopLeftCorner");
        this.glassPanel.add((Component)this.brMessageBox, "BottomRightCorner");
        this.glassPanel.add((Component)this.blMessageBox, "BottomLeftCorner");
        this.glassPanel.setOpaque(false);
        super.add((Component)this.glassPanel, "Center");
        this.setBackground(this.bgColor);
        this.setPreferredSize(new Dimension(300, 300));
        this.showCoordinates = true;
        this.addMouseListener(this.mouseController);
        this.addMouseMotionListener(this.mouseController);
        this.addMouseListener(this.optionController);
        this.addMouseMotionListener(this.optionController);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                DrawingPanel.this.validImage = false;
            }
        });
        this.buildPopupmenu();
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.setFontLevel(FontSizer.getLevel());
        FontSizer.addPropertyChangeListener("level", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                int level = (Integer)e.getNewValue();
                DrawingPanel.this.setFontLevel(level);
            }
        });
    }

    protected void setFontLevel(int level) {
        Font font;
        this.trMessageBox.font = font = FontSizer.getResizedFont(this.trMessageBox.font, level);
        this.tlMessageBox.font = font;
        this.brMessageBox.font = font;
        this.blMessageBox.font = font;
    }

    protected void buildPopupmenu() {
        this.popupmenu.setEnabled(true);
        PopupmenuListener listener = new PopupmenuListener();
        JMenuItem item = new JMenuItem("Snapshot");
        item.addActionListener(listener);
        this.popupmenu.add(item);
        item = new JMenuItem(DisplayRes.getString("DrawingFrame.Scale_menu_item"));
        item.addActionListener(listener);
        this.popupmenu.add(item);
        item = new JMenuItem("Zoom In");
        item.addActionListener(listener);
        this.popupmenu.add(item);
        item = new JMenuItem("Zoom Out");
        item.addActionListener(listener);
        this.popupmenu.add(item);
        this.propertiesItem = new JMenuItem(DisplayRes.getString("DrawingFrame.InspectMenuItem"));
        this.propertiesItem.addActionListener(listener);
        this.popupmenu.add(this.propertiesItem);
    }

    public void setAutoscaleMargin(double _autoscaleMargin) {
        this.autoscaleMargin = _autoscaleMargin;
    }

    public void setClipAtGutter(boolean clip) {
        this.clipAtGutter = clip;
    }

    public boolean isClipAtGutter() {
        return this.clipAtGutter;
    }

    public void setGutters(int left, int top, int right, int bottom) {
        this.leftGutter = left;
        this.topGutter = top;
        this.rightGutter = right;
        this.bottomGutter = bottom;
    }

    public void setMouseCursor(Cursor cursor) {
        Container c = this.getTopLevelAncestor();
        this.setCursor(cursor);
        if (c != null) {
            c.setCursor(cursor);
        }
    }

    protected synchronized boolean checkWorkingImage() {
        Rectangle r = this.getBounds();
        int width = (int)r.getWidth();
        int height = (int)r.getHeight();
        if (width <= 2 || height <= 2) {
            return false;
        }
        if (this.workingImage == null || width != this.workingImage.getWidth() || height != this.workingImage.getHeight()) {
            this.workingImage = this.getGraphicsConfiguration().createCompatibleImage(width, height);
            this.validImage = false;
        }
        if (this.workingImage == null) {
            this.validImage = false;
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent evt) {
        if (!this.validImage) {
            this.render();
        }
    }

    public boolean isIconified() {
        Container c = this.getTopLevelAncestor();
        if (c instanceof Frame) {
            return (((Frame)c).getExtendedState() & 1) == 1;
        }
        return false;
    }

    public BufferedImage render() {
        if (!this.isShowing() || this.isIconified()) {
            return this.offscreenImage;
        }
        if (this.buffered && this.checkWorkingImage()) {
            this.validImage = true;
            this.render(this.workingImage);
            BufferedImage temp = this.offscreenImage;
            this.offscreenImage = this.workingImage;
            this.workingImage = temp;
        }
        Runnable doNow = new Runnable(){

            public void run() {
                DrawingPanel.this.paintImmediately(DrawingPanel.this.getVisibleRect());
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.paintImmediately(this.getVisibleRect());
            } else {
                SwingUtilities.invokeAndWait(doNow);
            }
        }
        catch (InvocationTargetException ex1) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.buffered && this.vidCap != null) {
            this.vidCap.addFrame(this.offscreenImage);
        }
        return this.offscreenImage;
    }

    public synchronized Image render(Image image) {
        Graphics osg = image.getGraphics();
        if (osg != null) {
            Rectangle viewRect;
            this.paintEverything(osg);
            if (image == this.workingImage) {
                this.zoomBox.paint(osg);
            }
            if ((viewRect = this.viewRect) != null) {
                Rectangle r = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
                this.glassPanel.setBounds(r);
                this.glassPanelLayout.checkLayoutRect(this.glassPanel, r);
                this.glassPanel.render(osg);
                this.glassPanel.setBounds(viewRect);
                this.glassPanelLayout.checkLayoutRect(this.glassPanel, viewRect);
            } else {
                this.glassPanel.render(osg);
            }
            osg.dispose();
        }
        return image;
    }

    public void invalidateImage() {
        this.validImage = false;
    }

    public void paintComponent(Graphics g) {
        this.viewRect = this.findViewRect();
        if (this.buffered) {
            if (!this.validImage || this.getWidth() != this.offscreenImage.getWidth() || this.getHeight() != this.offscreenImage.getHeight()) {
                if (this.getWidth() != this.offscreenImage.getWidth() || this.getHeight() != this.offscreenImage.getHeight()) {
                    g.setColor(Color.WHITE);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    g.drawImage(this.offscreenImage, 0, 0, null);
                }
                this.refreshTimer.start();
            } else {
                g.drawImage(this.offscreenImage, 0, 0, null);
            }
        } else {
            this.paintEverything(g);
        }
        if (this.enableZoom || this.zoomMode) {
            this.zoomBox.paint(g);
        }
    }

    protected Rectangle getViewRect() {
        return this.viewRect;
    }

    protected Rectangle findViewRect() {
        Rectangle rect = null;
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JViewport)) continue;
            rect = ((JViewport)c).getViewRect();
            this.glassPanel.setBounds(rect);
            this.glassPanelLayout.checkLayoutRect(this.glassPanel, rect);
            break;
        }
        return rect;
    }

    protected void computeGutters() {
        Dimension interiorDimension;
        if (this.dimensionSetter != null && (interiorDimension = this.dimensionSetter.getInterior(this)) != null) {
            this.squareAspect = false;
            this.leftGutter = this.rightGutter = Math.max(0, this.getWidth() - interiorDimension.width) / 2;
            this.topGutter = this.bottomGutter = Math.max(0, this.getHeight() - interiorDimension.height) / 2;
        }
    }

    protected void paintFirst(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.black);
    }

    protected void paintLast(Graphics g) {
    }

    protected void paintEverything(Graphics g) {
        this.computeGutters();
        ArrayList tempList = this.getDrawables();
        this.scale(tempList);
        this.setPixelScale();
        if (this.antialiasTextOn) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.antialiasShapeOn) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.paintFirst(g);
        this.paintDrawableList(g, tempList);
        this.paintLast(g);
    }

    public void setAutoscaleX(boolean autoscale) {
        this.autoscaleX = autoscale;
    }

    public boolean isAutoscaleX() {
        return this.autoscaleX;
    }

    public void setAutoscaleY(boolean autoscale) {
        this.autoscaleY = autoscale;
    }

    public boolean isAutoscaleY() {
        return this.autoscaleY;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.validImage = false;
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.validImage = false;
    }

    public void setBuffered(boolean _buffered) {
        this.buffered = _buffered;
        if (this.buffered) {
            this.setDoubleBuffered(false);
        } else {
            this.offscreenImage = this.workingImage = new BufferedImage(1, 1, 1);
            this.setDoubleBuffered(true);
        }
        this.validImage = false;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        if (isVisible && this.buffered) {
            this.validImage = false;
        }
    }

    public void limitAutoscaleX(double floor, double ceil) {
        this.xfloor = floor;
        this.xceil = ceil;
    }

    public void limitAutoscaleY(double floor, double ceil) {
        this.yfloor = floor;
        this.yceil = ceil;
    }

    public void setPixelsPerUnit(boolean enable, double xPixPerUnit, double yPixPerUnit) {
        this.fixedPixelPerUnit = enable;
        this.xPixPerUnit = xPixPerUnit;
        this.yPixPerUnit = yPixPerUnit;
    }

    public void setPreferredMinMax(double xmin, double xmax, double ymin, double ymax) {
        if (!Double.isNaN(xmin) && !Double.isNaN(xmax)) {
            this.autoscaleX = false;
            if (xmin == xmax) {
                xmin = 0.9 * xmin - 0.5;
                xmax = 1.1 * xmax + 0.5;
            }
            this.xminPreferred = xmin;
            this.xmaxPreferred = xmax;
        }
        if (!Double.isNaN(ymin) && !Double.isNaN(ymax)) {
            this.autoscaleY = false;
            if (ymin == ymax) {
                ymin = 0.9 * ymin - 0.5;
                ymax = 1.1 * ymax + 0.5;
            }
            this.yminPreferred = ymin;
            this.ymaxPreferred = ymax;
        }
    }

    public void setPreferredMinMaxX(double xmin, double xmax) {
        this.autoscaleX = false;
        if (xmin == xmax) {
            xmin = 0.9 * xmin - 0.5;
            xmax = 1.1 * xmax + 0.5;
        }
        this.xminPreferred = xmin;
        this.xmaxPreferred = xmax;
    }

    public void setPreferredMinMaxY(double ymin, double ymax) {
        this.autoscaleY = false;
        if (ymin == ymax) {
            ymin = 0.9 * ymin - 0.5;
            ymax = 1.1 * ymax + 0.5;
        }
        this.yminPreferred = ymin;
        this.ymaxPreferred = ymax;
    }

    public void setSquareAspect(boolean val) {
        if (this.squareAspect == val) {
            return;
        }
        this.squareAspect = val;
        this.validImage = false;
        this.repaint();
    }

    public boolean isSquareAspect() {
        return this.squareAspect;
    }

    public void setAntialiasTextOn(boolean on) {
        this.antialiasTextOn = on;
    }

    public boolean isAntialiasTextOn() {
        return this.antialiasTextOn;
    }

    public void setAntialiasShapeOn(boolean on) {
        this.antialiasShapeOn = on;
    }

    public boolean isAntialiasShapeOn() {
        return this.antialiasShapeOn;
    }

    public boolean isPointInside(double x, double y) {
        if (this.xmin < this.xmax) {
            if (x < this.xmin) {
                return false;
            }
            if (x > this.xmax) {
                return false;
            }
        } else {
            if (x > this.xmin) {
                return false;
            }
            if (x < this.xmax) {
                return false;
            }
        }
        if (this.ymin < this.ymax) {
            if (y < this.ymin) {
                return false;
            }
            if (y > this.ymax) {
                return false;
            }
        } else {
            if (y > this.ymin) {
                return false;
            }
            if (y < this.ymax) {
                return false;
            }
        }
        return true;
    }

    public boolean isZoom() {
        return this.enableZoom;
    }

    public void setZoom(boolean _enableZoom) {
        this.enableZoom = _enableZoom;
    }

    protected void zoomOut() {
        double dx = this.xmax - this.xmin;
        double dy = this.ymax - this.ymin;
        this.setPreferredMinMax(this.xmin - dx / 2.0, this.xmax + dx / 2.0, this.ymin - dy / 2.0, this.ymax + dy / 2.0);
        this.validImage = false;
        if (!this.getIgnoreRepaint()) {
            this.repaint();
        }
    }

    protected void zoomIn() {
        this.setMessage("Click drag to zoom in.", 0);
        this.zoomMode = true;
    }

    public void snapshot() {
        int h;
        DrawingPanel panel = new DrawingPanel();
        DrawingFrame frame = new DrawingFrame(panel);
        frame.setDefaultCloseOperation(2);
        frame.setKeepHidden(false);
        panel.setSquareAspect(false);
        int w = this.isVisible() ? this.getWidth() : this.getPreferredSize().width;
        int n = h = this.isVisible() ? this.getHeight() : this.getPreferredSize().height;
        if (w == 0 || h == 0) {
            return;
        }
        BufferedImage snapimage = new BufferedImage(w, h, 2);
        this.render(snapimage);
        MeasuredImage mi = new MeasuredImage(snapimage, this.pixToX(0), this.pixToX(w), this.pixToY(h), this.pixToY(0));
        panel.addDrawable(mi);
        panel.setPreferredMinMax(this.pixToX(0), this.pixToX(w), this.pixToY(h), this.pixToY(0));
        panel.setPreferredSize(new Dimension(w, h));
        frame.setTitle("Snapshot");
        frame.pack();
        frame.setVisible(true);
    }

    public boolean hasInspector() {
        return this.popupmenu != null && this.popupmenu.isEnabled();
    }

    public void enableInspector(boolean isEnabled) {
        this.popupmenu.setEnabled(isEnabled);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.popupmenu = menu;
    }

    public void showInspector() {
        if (this.customInspector == null) {
            XMLDrawingPanelInspector.getInspector(this);
        } else {
            ((Component)this.customInspector).setVisible(true);
        }
    }

    public void hideInspector() {
        if (this.customInspector == null) {
            DrawingPanelInspector.hideInspector();
        } else {
            ((Component)this.customInspector).setVisible(false);
        }
    }

    public void setCustomInspector(Window w) {
        if (this.customInspector != null) {
            ((Component)this.customInspector).setVisible(false);
        }
        this.customInspector = w;
    }

    public void setVideoCaptureTool(VideoCaptureTool videoCap) {
        if (this.vidCap != null) {
            this.vidCap.setVisible(false);
        }
        this.vidCap = videoCap;
        if (this.vidCap != null) {
            this.setBuffered(true);
        }
    }

    public VideoCaptureTool getVideoCaptureTool() {
        return this.vidCap;
    }

    public double getAspectRatio() {
        return this.pixelMatrix[3] == 1.0 ? 1.0 : Math.abs(this.pixelMatrix[0] / this.pixelMatrix[3]);
    }

    public double getXPixPerUnit() {
        return this.pixelMatrix[0];
    }

    public double getYPixPerUnit() {
        return -this.pixelMatrix[3];
    }

    public double getMaxPixPerUnit() {
        return Math.max(Math.abs(this.pixelMatrix[0]), Math.abs(this.pixelMatrix[3]));
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getPreferredXMin() {
        return this.xminPreferred;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getPreferredXMax() {
        return this.xmaxPreferred;
    }

    public double getYMax() {
        return this.ymax;
    }

    public double getPreferredYMax() {
        return this.ymaxPreferred;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getPreferredYMin() {
        return this.yminPreferred;
    }

    public CoordinateStringBuilder getCoordinateStringBuilder() {
        return this.coordinateStrBuilder;
    }

    public void setCoordinateStringBuilder(CoordinateStringBuilder builder) {
        this.coordinateStrBuilder = builder;
    }

    public Rectangle2D getScale() {
        this.setPixelScale();
        return new Rectangle2D.Double(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public Rectangle2D getMeasure() {
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        boolean measurableFound = false;
        ArrayList tempList = this.getDrawables();
        Iterator it = ((AbstractList)tempList).iterator();
        while (it.hasNext()) {
            Measurable measurable;
            Object obj = it.next();
            if (!(obj instanceof Measurable) || !((Measurable)obj).isMeasured() || Double.isNaN((measurable = (Measurable)obj).getXMax()) || Double.isNaN(measurable.getXMin()) || Double.isNaN(measurable.getYMax()) || Double.isNaN(measurable.getYMin())) continue;
            xmin = Math.min(xmin, measurable.getXMin());
            xmax = Math.max(xmax, measurable.getXMax());
            ymin = Math.min(ymin, measurable.getYMin());
            ymax = Math.max(ymax, measurable.getYMax());
            measurableFound = true;
        }
        if (measurableFound) {
            return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        }
        return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public AffineTransform getPixelTransform() {
        return (AffineTransform)this.pixelTransform.clone();
    }

    public double[] getPixelMatrix() {
        return this.pixelMatrix;
    }

    public void setPixelScale() {
        this.xmin = this.xminPreferred;
        this.xmax = this.xmaxPreferred;
        this.ymin = this.yminPreferred;
        this.ymax = this.ymaxPreferred;
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.fixedPixelPerUnit) {
            this.xmin = (this.xmaxPreferred + this.xminPreferred) / 2.0 - (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / this.xPixPerUnit / 2.0;
            this.xmax = (this.xmaxPreferred + this.xminPreferred) / 2.0 + (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / this.xPixPerUnit / 2.0;
            this.ymin = (this.ymaxPreferred + this.yminPreferred) / 2.0 - (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / this.yPixPerUnit / 2.0;
            this.ymax = (this.ymaxPreferred + this.yminPreferred) / 2.0 + (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / this.yPixPerUnit / 2.0;
            this.pixelTransform = new AffineTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
            this.pixelTransform.getMatrix(this.pixelMatrix);
            return;
        }
        this.xPixPerUnit = (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / (this.xmax - this.xmin);
        this.yPixPerUnit = (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / (this.ymax - this.ymin);
        if (this.squareAspect) {
            double stretch = Math.abs(this.xPixPerUnit / this.yPixPerUnit);
            if (stretch >= 1.0) {
                stretch = Math.min(stretch, (double)this.width);
                this.xmin = this.xminPreferred - (this.xmaxPreferred - this.xminPreferred) * (stretch - 1.0) / 2.0;
                this.xmax = this.xmaxPreferred + (this.xmaxPreferred - this.xminPreferred) * (stretch - 1.0) / 2.0;
                this.xPixPerUnit = (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / (this.xmax - this.xmin);
            } else {
                stretch = Math.max(stretch, 1.0 / (double)this.height);
                this.ymin = this.yminPreferred - (this.ymaxPreferred - this.yminPreferred) * (1.0 / stretch - 1.0) / 2.0;
                this.ymax = this.ymaxPreferred + (this.ymaxPreferred - this.yminPreferred) * (1.0 / stretch - 1.0) / 2.0;
                this.yPixPerUnit = (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / (this.ymax - this.ymin);
            }
        }
        this.pixelTransform = new AffineTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
        this.pixelTransform.getMatrix(this.pixelMatrix);
    }

    public double[] project(double[] coordinate, double[] pixel) {
        switch (coordinate.length) {
            case 2: 
            case 3: {
                pixel[0] = this.xToPix(coordinate[0]);
                pixel[1] = this.yToPix(coordinate[1]);
                break;
            }
            case 4: {
                pixel[0] = this.xToPix(coordinate[0]);
                pixel[1] = this.yToPix(coordinate[1]);
                pixel[2] = this.xPixPerUnit * coordinate[2];
                pixel[3] = this.yPixPerUnit * coordinate[3];
                break;
            }
            case 6: {
                pixel[0] = this.xToPix(coordinate[0]);
                pixel[1] = this.yToPix(coordinate[1]);
                pixel[2] = this.xPixPerUnit * coordinate[3];
                pixel[3] = this.yPixPerUnit * coordinate[4];
                break;
            }
            default: {
                throw new IllegalArgumentException("Method project not supported for this length.");
            }
        }
        return pixel;
    }

    public double pixToX(int pix) {
        return this.xmin + (double)(pix - this.leftGutter) / this.xPixPerUnit;
    }

    public int xToPix(double x) {
        double pix = this.pixelMatrix[0] * x + this.pixelMatrix[4];
        if (pix > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (pix < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)pix);
    }

    public double pixToY(int pix) {
        return this.ymax - (double)(pix - this.topGutter) / this.yPixPerUnit;
    }

    public int yToPix(double y) {
        double pix = this.pixelMatrix[3] * y + this.pixelMatrix[5];
        if (pix > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (pix < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)pix);
    }

    public void scale() {
        ArrayList tempList = this.getDrawables();
        this.scale(tempList);
    }

    protected void scale(ArrayList tempList) {
        if (this.autoscaleX) {
            this.scaleX(tempList);
        }
        if (this.autoscaleY) {
            this.scaleY(tempList);
        }
    }

    public void measure() {
        ArrayList tempList = this.getDrawables();
        this.scaleX(tempList);
        this.scaleY(tempList);
        this.setPixelScale();
        this.validImage = false;
    }

    protected void scaleX() {
        ArrayList tempList = this.getDrawables();
        this.scaleX(tempList);
    }

    private void scaleX(ArrayList tempList) {
        double newXMin = Double.MAX_VALUE;
        double newXMax = -1.7976931348623157E308;
        boolean measurableFound = false;
        Iterator it = ((AbstractList)tempList).iterator();
        while (it.hasNext()) {
            Measurable measurable;
            Object obj = it.next();
            if (!(obj instanceof Measurable) || !(measurable = (Measurable)obj).isMeasured()) continue;
            double xmi = measurable.getXMin();
            double xma = measurable.getXMax();
            if (Double.isNaN(xmi) || Double.isNaN(xma)) continue;
            newXMin = Math.min(newXMin, xmi);
            newXMin = Math.min(newXMin, xma);
            newXMax = Math.max(newXMax, xma);
            newXMax = Math.max(newXMax, xmi);
            measurableFound = true;
        }
        if (measurableFound) {
            if (newXMax - newXMin < (double)1.4E-45f) {
                newXMin = Double.isNaN(this.xfloor) ? 0.9 * newXMin - 0.5 : this.xfloor;
                newXMax = Double.isNaN(this.xceil) ? 1.1 * newXMax + 0.5 : this.xceil;
            }
            double range = newXMax - newXMin;
            while (Math.abs((newXMax + range) / range) > 100000.0) {
                newXMin -= (range *= 2.0);
                newXMax += range;
            }
            this.xminPreferred = newXMin - this.autoscaleMargin * range;
            this.xmaxPreferred = newXMax + this.autoscaleMargin * range;
        } else {
            if (!Double.isNaN(this.xfloor)) {
                this.xminPreferred = this.xfloor;
            }
            if (!Double.isNaN(this.xceil)) {
                this.xmaxPreferred = this.xceil;
            }
        }
        if (!Double.isNaN(this.xfloor)) {
            this.xminPreferred = Math.min(this.xfloor, this.xminPreferred);
        }
        if (!Double.isNaN(this.xceil)) {
            this.xmaxPreferred = Math.max(this.xceil, this.xmaxPreferred);
        }
    }

    protected void scaleY() {
        ArrayList tempList = this.getDrawables();
        this.scaleY(tempList);
    }

    private void scaleY(ArrayList tempList) {
        double newYMin = Double.MAX_VALUE;
        double newYMax = -1.7976931348623157E308;
        boolean measurableFound = false;
        Iterator it = ((AbstractList)tempList).iterator();
        while (it.hasNext()) {
            Measurable measurable;
            Object obj = it.next();
            if (!(obj instanceof Measurable) || !(measurable = (Measurable)obj).isMeasured()) continue;
            double ymi = measurable.getYMin();
            double yma = measurable.getYMax();
            if (Double.isNaN(ymi) || Double.isNaN(yma)) continue;
            newYMin = Math.min(newYMin, ymi);
            newYMin = Math.min(newYMin, yma);
            newYMax = Math.max(newYMax, yma);
            newYMax = Math.max(newYMax, ymi);
            measurableFound = true;
        }
        if (measurableFound) {
            if (newYMax - newYMin < (double)1.4E-45f) {
                newYMin = Double.isNaN(this.yfloor) ? 0.9 * newYMin - 0.5 : this.yfloor;
                newYMax = Double.isNaN(this.yceil) ? 1.1 * newYMax + 0.5 : this.yceil;
            }
            double range = newYMax - newYMin;
            while (Math.abs((newYMax + range) / range) > 100000.0) {
                newYMin -= (range *= 2.0);
                newYMax += range;
            }
            this.yminPreferred = newYMin - this.autoscaleMargin * range;
            this.ymaxPreferred = newYMax + this.autoscaleMargin * range;
        } else {
            if (!Double.isNaN(this.yfloor)) {
                this.yminPreferred = this.yfloor;
            }
            if (!Double.isNaN(this.yceil)) {
                this.ymaxPreferred = this.yceil;
            }
        }
        if (!Double.isNaN(this.yfloor)) {
            this.yminPreferred = Math.min(this.yfloor, this.yminPreferred);
        }
        if (!Double.isNaN(this.yceil)) {
            this.ymaxPreferred = Math.max(this.yceil, this.ymaxPreferred);
        }
    }

    protected void paintDrawableList(Graphics g, ArrayList tempList) {
        Graphics2D g2 = (Graphics2D)g;
        Iterator it = ((AbstractList)tempList).iterator();
        Shape clipShape = g2.getClip();
        int w = this.getWidth() - this.leftGutter - this.rightGutter;
        int h = this.getHeight() - this.bottomGutter - this.topGutter;
        if (w < 0 || h < 0) {
            return;
        }
        if (this.clipAtGutter) {
            g2.clipRect(this.leftGutter, this.topGutter, w, h);
        }
        if (tempList != null && !tempList.isEmpty() && tempList.get(0) instanceof False3D) {
            ((Drawable)tempList.get(0)).draw(this, g2);
        } else {
            while (it.hasNext()) {
                Drawable drawable = (Drawable)it.next();
                drawable.draw(this, g2);
            }
        }
        g2.setClip(clipShape);
    }

    public JPanel getGlassPanel() {
        return this.glassPanel;
    }

    public void setIgnoreRepaint(boolean ignoreRepaint) {
        super.setIgnoreRepaint(ignoreRepaint);
        this.glassPanel.setIgnoreRepaint(ignoreRepaint);
    }

    public Dimensioned getDimensionSetter() {
        return this.dimensionSetter;
    }

    public synchronized void addDrawable(Drawable drawable) {
        if (drawable != null && !this.drawableList.contains(drawable)) {
            this.drawableList.add(drawable);
            this.validImage = false;
        }
        if (drawable instanceof Dimensioned) {
            this.dimensionSetter = (Dimensioned)((Object)drawable);
        }
    }

    public synchronized void addDrawables(Collection drawables) {
        Iterator it = drawables.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof Drawable)) continue;
            this.addDrawable((Drawable)obj);
        }
    }

    public synchronized void replaceDrawable(Drawable oldDrawable, Drawable newDrawable) {
        if (oldDrawable != null && this.drawableList.contains(oldDrawable)) {
            int i = this.drawableList.indexOf(oldDrawable);
            this.drawableList.set(i, newDrawable);
            if (newDrawable instanceof Dimensioned) {
                this.dimensionSetter = (Dimensioned)((Object)newDrawable);
            }
        } else {
            this.addDrawable(newDrawable);
        }
    }

    public synchronized void removeDrawable(Drawable drawable) {
        ((AbstractCollection)this.drawableList).remove(drawable);
        if (drawable instanceof Dimensioned) {
            this.dimensionSetter = null;
        }
    }

    public synchronized void removeObjectsOfClass(Class c) {
        Iterator it = ((AbstractList)this.drawableList).iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (element.getClass() != c) continue;
            it.remove();
            if (!(element instanceof Dimensioned)) continue;
            this.dimensionSetter = null;
        }
    }

    public synchronized void removeDrawables(Class c) {
        Iterator it = ((AbstractList)this.drawableList).iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!c.isInstance(element)) continue;
            it.remove();
            if (!(element instanceof Dimensioned)) continue;
            this.dimensionSetter = null;
        }
    }

    public void removeOptionController() {
        this.removeMouseListener(this.optionController);
        this.removeMouseMotionListener(this.optionController);
    }

    public synchronized void clear() {
        this.drawableList.clear();
        this.dimensionSetter = null;
    }

    public synchronized ArrayList getDrawables() {
        return (ArrayList)this.drawableList.clone();
    }

    public synchronized ArrayList getDrawables(Class c) {
        ArrayList newList = (ArrayList)this.drawableList.clone();
        Iterator it = ((AbstractList)newList).iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (c.isInstance(obj)) continue;
            it.remove();
        }
        return newList;
    }

    public synchronized ArrayList getObjectOfClass(Class c) {
        ArrayList newList = (ArrayList)this.drawableList.clone();
        Iterator it = ((AbstractList)newList).iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj.getClass() == c) continue;
            it.remove();
        }
        return newList;
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= 1) {
            return 1;
        }
        if (g == null) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double scalex = pageFormat.getImageableWidth() / (double)this.getWidth();
        double scaley = pageFormat.getImageableHeight() / (double)this.getHeight();
        double scale = Math.min(scalex, scaley);
        g2.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        g2.scale(scale, scale);
        this.paintEverything(g2);
        return 0;
    }

    public int[] getGutters() {
        return new int[]{this.leftGutter, this.topGutter, this.rightGutter, this.bottomGutter};
    }

    public void setGutters(int[] gutters) {
        this.leftGutter = gutters[0];
        this.topGutter = gutters[1];
        this.rightGutter = gutters[2];
        this.bottomGutter = gutters[3];
    }

    public int getBottomGutter() {
        return this.bottomGutter;
    }

    public int getTopGutter() {
        return this.topGutter;
    }

    public int getLeftGutter() {
        return this.leftGutter;
    }

    public int getRightGutter() {
        return this.rightGutter;
    }

    public void setMessage(String msg) {
        this.brMessageBox.setText(msg);
    }

    public void setMessage(String msg, int location) {
        switch (location) {
            case 0: {
                this.blMessageBox.setText(msg);
                break;
            }
            case 1: {
                this.brMessageBox.setText(msg);
                break;
            }
            case 2: {
                this.trMessageBox.setText(msg);
                break;
            }
            case 3: {
                this.tlMessageBox.setText(msg);
            }
        }
    }

    public void setShowCoordinates(boolean show) {
        if (this.showCoordinates && !show) {
            this.removeMouseListener(this.mouseController);
            this.removeMouseMotionListener(this.mouseController);
        } else if (!this.showCoordinates && show) {
            this.addMouseListener(this.mouseController);
            this.addMouseMotionListener(this.mouseController);
        }
        this.showCoordinates = show;
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawingPanelLoader();
    }

    static class DrawingPanelLoader
    implements XML.ObjectLoader {
        DrawingPanelLoader() {
        }

        public void saveObject(XMLControl control, Object obj) {
            DrawingPanel panel = (DrawingPanel)obj;
            control.setValue("preferred x min", panel.getPreferredXMin());
            control.setValue("preferred x max", panel.getPreferredXMax());
            control.setValue("preferred y min", panel.getPreferredYMin());
            control.setValue("preferred y max", panel.getPreferredYMax());
            control.setValue("autoscale x", panel.isAutoscaleX());
            control.setValue("autoscale y", panel.isAutoscaleY());
            control.setValue("square aspect", panel.isSquareAspect());
            control.setValue("drawables", panel.getDrawables());
        }

        public Object createObject(XMLControl control) {
            DrawingPanel panel = new DrawingPanel();
            double xmin = control.getDouble("preferred x min");
            double xmax = control.getDouble("preferred x max");
            double ymin = control.getDouble("preferred y min");
            double ymax = control.getDouble("preferred y max");
            panel.setPreferredMinMax(xmin, xmax, ymin, ymax);
            if (control.getBoolean("autoscale x")) {
                panel.setAutoscaleX(true);
            }
            if (control.getBoolean("autoscale y")) {
                panel.setAutoscaleY(true);
            }
            return panel;
        }

        public Object loadObject(XMLControl control, Object obj) {
            Collection drawables;
            DrawingPanel panel = (DrawingPanel)obj;
            double xmin = control.getDouble("preferred x min");
            double xmax = control.getDouble("preferred x max");
            double ymin = control.getDouble("preferred y min");
            double ymax = control.getDouble("preferred y max");
            panel.setPreferredMinMax(xmin, xmax, ymin, ymax);
            panel.squareAspect = control.getBoolean("square aspect");
            if (control.getBoolean("autoscale x")) {
                panel.setAutoscaleX(true);
            }
            if (control.getBoolean("autoscale y")) {
                panel.setAutoscaleY(true);
            }
            if ((drawables = (Collection)control.getObject("drawables")) != null) {
                panel.clear();
                Iterator it = drawables.iterator();
                while (it.hasNext()) {
                    panel.addDrawable((Drawable)it.next());
                }
            }
            return obj;
        }
    }

    class GlassPanel
    extends JPanel {
        GlassPanel() {
        }

        public void render(Graphics g) {
            Component[] c = DrawingPanel.this.glassPanelLayout.getComponents();
            int n = c.length;
            for (int i = 0; i < n; ++i) {
                if (c[i] == null) continue;
                g.translate(c[i].getX(), c[i].getY());
                c[i].print(g);
                g.translate(-c[i].getX(), -c[i].getY());
            }
        }
    }

    class OptionController
    extends MouseController {
        OptionController() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && DrawingPanel.this.popupmenu != null && DrawingPanel.this.popupmenu.isEnabled()) {
                DrawingPanel.this.popupmenu.show(e.getComponent(), e.getX(), e.getY());
                return;
            }
            if (e.isPopupTrigger() && DrawingPanel.this.popupmenu == null && DrawingPanel.this.customInspector != null) {
                ((Component)DrawingPanel.this.customInspector).setVisible(true);
                return;
            }
            if (DrawingPanel.this.enableZoom && e.isControlDown()) {
                DrawingPanel.this.zoomBox.endZoom(e.getX(), e.getY());
                if (!DrawingPanel.this.autoscaleX && !DrawingPanel.this.autoscaleY) {
                    DrawingPanel.this.scaleX();
                    DrawingPanel.this.scaleY();
                } else if (!DrawingPanel.this.autoscaleX) {
                    DrawingPanel.this.scaleX();
                } else if (!DrawingPanel.this.autoscaleY) {
                    DrawingPanel.this.scaleY();
                }
                DrawingPanel.this.setPixelScale();
                if (DrawingPanel.this.customInspector == null) {
                    DrawingPanelInspector.updateValues(DrawingPanel.this);
                }
                return;
            }
            if (DrawingPanel.this.enableZoom && e.isShiftDown() || DrawingPanel.this.zoomMode) {
                DrawingPanel.this.zoomBox.startZoom(e.getX(), e.getY());
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (DrawingPanel.this.zoomBox.visible) {
                DrawingPanel.this.zoomBox.drag(e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && DrawingPanel.this.popupmenu != null && DrawingPanel.this.popupmenu.isEnabled()) {
                DrawingPanel.this.popupmenu.show(e.getComponent(), e.getX(), e.getY());
                return;
            }
            if (e.isPopupTrigger() && DrawingPanel.this.popupmenu == null && DrawingPanel.this.customInspector != null) {
                ((Component)DrawingPanel.this.customInspector).setVisible(true);
                return;
            }
            if (DrawingPanel.this.zoomBox.visible) {
                DrawingPanel.this.zoomBox.endZoom(e.getX(), e.getY());
                if (DrawingPanel.this.customInspector == null) {
                    DrawingPanelInspector.updateValues(DrawingPanel.this);
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger() && DrawingPanel.this.popupmenu != null && DrawingPanel.this.popupmenu.isEnabled()) {
                DrawingPanel.this.popupmenu.show(e.getComponent(), e.getX(), e.getY());
                return;
            }
            if (e.isPopupTrigger() && DrawingPanel.this.popupmenu == null && DrawingPanel.this.customInspector != null) {
                ((Component)DrawingPanel.this.customInspector).setVisible(true);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    class PopupmenuListener
    implements ActionListener {
        PopupmenuListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            DrawingPanel.this.zoomMode = false;
            String cmd = evt.getActionCommand();
            if (cmd.equals(DisplayRes.getString("DrawingFrame.InspectMenuItem"))) {
                DrawingPanel.this.showInspector();
            } else if (cmd.equals("Snapshot")) {
                DrawingPanel.this.snapshot();
            } else if (cmd.equals("Zoom In")) {
                if (DrawingPanel.this.autoscaleX || DrawingPanel.this.autoscaleY) {
                    AutoScaleInspector plotInspector = new AutoScaleInspector(DrawingPanel.this);
                    plotInspector.setLocationRelativeTo(DrawingPanel.this);
                    plotInspector.updateDisplay();
                    ((Component)plotInspector).setVisible(true);
                }
                DrawingPanel.this.zoomIn();
            } else if (cmd.equals("Zoom Out")) {
                if (DrawingPanel.this.autoscaleX || DrawingPanel.this.autoscaleY) {
                    AutoScaleInspector plotInspector = new AutoScaleInspector(DrawingPanel.this);
                    plotInspector.setLocationRelativeTo(DrawingPanel.this);
                    plotInspector.updateDisplay();
                    ((Component)plotInspector).setVisible(true);
                }
                DrawingPanel.this.zoomOut();
            } else if (cmd.equals(DisplayRes.getString("DrawingFrame.Scale_menu_item"))) {
                ScaleInspector plotInspector = new ScaleInspector(DrawingPanel.this);
                plotInspector.setLocationRelativeTo(DrawingPanel.this);
                plotInspector.updateDisplay();
                ((Component)plotInspector).setVisible(true);
            }
        }
    }

    public class ZoomBox {
        boolean visible = false;
        int xstart;
        int ystart;
        int xstop;
        int ystop;
        int xlast;
        int ylast;

        public void startZoom(int xpix, int ypix) {
            this.xstop = this.xstart = xpix;
            this.xlast = this.xstart;
            this.ystop = this.ystart = ypix;
            this.ylast = this.ystart;
            this.visible = true;
        }

        public void endZoom(int xpix, int ypix) {
            DrawingPanel.this.zoomMode = false;
            DrawingPanel.this.setMessage(null, 0);
            if (!this.visible) {
                return;
            }
            this.xstop = xpix;
            this.ystop = ypix;
            this.visible = false;
            if (this.xstart == this.xstop || this.ystart == this.ystop) {
                return;
            }
            double xmin = DrawingPanel.this.pixToX(this.xstart);
            double xmax = DrawingPanel.this.pixToX(this.xstop);
            double ymax = DrawingPanel.this.pixToY(this.ystart);
            double ymin = DrawingPanel.this.pixToY(this.ystop);
            if (!DrawingPanel.this.autoscaleX && !DrawingPanel.this.autoscaleY) {
                DrawingPanel.this.setPreferredMinMax(xmin, xmax, ymin, ymax);
            } else if (!DrawingPanel.this.autoscaleX) {
                DrawingPanel.this.setPreferredMinMaxX(xmin, xmax);
            } else if (!DrawingPanel.this.autoscaleY) {
                DrawingPanel.this.setPreferredMinMaxY(ymin, ymax);
            }
            this.xstart = 0;
            this.xstop = 0;
            this.xlast = 0;
            this.ystart = 0;
            this.ystop = 0;
            this.ylast = 0;
            DrawingPanel.this.validImage = false;
            if (!DrawingPanel.this.getIgnoreRepaint()) {
                DrawingPanel.this.repaint();
            }
        }

        public synchronized void drag(int xpix, int ypix) {
            if (!this.visible) {
                return;
            }
            this.xstop = xpix;
            this.ystop = ypix;
            Graphics g = DrawingPanel.this.getGraphics();
            if (g == null) {
                return;
            }
            g.setXORMode(Color.green);
            g.drawRect(Math.min(this.xstart, this.xlast), Math.min(this.ystart, this.ylast), Math.abs(this.xlast - this.xstart), Math.abs(this.ylast - this.ystart));
            this.xlast = this.xstop;
            this.ylast = this.ystop;
            g.drawRect(Math.min(this.xstart, this.xlast), Math.min(this.ystart, this.ylast), Math.abs(this.xlast - this.xstart), Math.abs(this.ylast - this.ystart));
            g.setPaintMode();
            g.dispose();
        }

        synchronized void paint(Graphics g) {
            if (!this.visible) {
                return;
            }
            g.setXORMode(Color.green);
            this.xlast = this.xstop;
            this.ylast = this.ystop;
            g.drawRect(Math.min(this.xstart, this.xlast), Math.min(this.ystart, this.ylast), Math.abs(this.xlast - this.xstart), Math.abs(this.ylast - this.ystart));
            g.setPaintMode();
        }
    }

    private class CMController
    extends MouseController {
        protected DecimalFormat scientificFormat = new DecimalFormat("0.###E0");
        protected DecimalFormat decimalFormat = new DecimalFormat("0.00");

        private CMController() {
        }

        public void mousePressed(MouseEvent e) {
            String s = DrawingPanel.this.coordinateStrBuilder.getCoordinateString(DrawingPanel.this, e);
            DrawingPanel.this.blMessageBox.setText(s);
        }

        public void mouseReleased(MouseEvent e) {
            DrawingPanel.this.blMessageBox.setText(null);
        }

        public void mouseEntered(MouseEvent e) {
            if (DrawingPanel.this.showCoordinates) {
                DrawingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            }
        }

        public void mouseExited(MouseEvent e) {
            DrawingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            String s = DrawingPanel.this.coordinateStrBuilder.getCoordinateString(DrawingPanel.this, e);
            DrawingPanel.this.blMessageBox.setText(s);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

