/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import org.jibble.epsgraphics.EpsGraphics2D;
import org.opensourcephysics.display.DataTableFrame;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display3d.core.DrawingFrame3D;

public class GUIUtils {
    public static Map charMap = new HashMap();
    static /* synthetic */ Class class$org$opensourcephysics$display$DataTableFrame;
    static /* synthetic */ Class class$org$opensourcephysics$display$DrawingFrame;
    static /* synthetic */ Class class$org$opensourcephysics$display$OSPFrame;

    private GUIUtils() {
    }

    public static String parseTeX(String inputStr) {
        if (inputStr == null) {
            return null;
        }
        String[] chunks = inputStr.split("\\$");
        boolean mathMode = false;
        for (int i = 0; i < chunks.length; ++i) {
            String val;
            if (mathMode && (val = (String)charMap.get(chunks[i].trim())) != null) {
                chunks[i] = val;
            }
            mathMode = !mathMode;
        }
        String outStr = "";
        for (int i = 0; i < chunks.length; ++i) {
            outStr = outStr + chunks[i];
        }
        return outStr;
    }

    public static Component findInstance(Container container, Class c) {
        if (container == null || c.isInstance(container)) {
            return container;
        }
        Component[] components = container.getComponents();
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            Component comp;
            if (c.isInstance(components[i])) {
                return components[i];
            }
            if (!(components[i] instanceof Container) || !c.isInstance(comp = GUIUtils.findInstance((Container)components[i], c))) continue;
            return comp;
        }
        return null;
    }

    public static void showDrawingAndTableFrames() {
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isDisplayable() || frames[i].getName() != null && frames[i].getName().indexOf("Tool") > -1 || !(class$org$opensourcephysics$display$OSPFrame == null ? GUIUtils.class$("org.opensourcephysics.display.OSPFrame") : class$org$opensourcephysics$display$OSPFrame).isInstance(frames[i])) continue;
            if ((class$org$opensourcephysics$display$DataTableFrame == null ? GUIUtils.class$("org.opensourcephysics.display.DataTableFrame") : class$org$opensourcephysics$display$DataTableFrame).isInstance(frames[i])) {
                ((DataTableFrame)frames[i]).refreshTable();
            }
            ((Component)frames[i]).setVisible(true);
            ((OSPFrame)frames[i]).invalidateImage();
            frames[i].repaint();
            frames[i].toFront();
        }
        if (OSPFrame.applet != null) {
            OSPFrame.applet.getRootPane().repaint();
        }
    }

    public static void renderAnimatedFrames() {
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isDisplayable() || !(class$org$opensourcephysics$display$OSPFrame == null ? GUIUtils.class$("org.opensourcephysics.display.OSPFrame") : class$org$opensourcephysics$display$OSPFrame).isInstance(frames[i]) || !((OSPFrame)frames[i]).isAnimated()) continue;
            ((OSPFrame)frames[i]).render();
        }
        if (OSPFrame.applet != null && OSPFrame.applet instanceof Renderable) {
            ((Renderable)((Object)OSPFrame.applet)).render();
        }
    }

    public static void repaintAnimatedFrames() {
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isDisplayable() || !(class$org$opensourcephysics$display$OSPFrame == null ? GUIUtils.class$("org.opensourcephysics.display.OSPFrame") : class$org$opensourcephysics$display$OSPFrame).isInstance(frames[i]) || !((OSPFrame)frames[i]).isAnimated()) continue;
            ((OSPFrame)frames[i]).invalidateImage();
            ((OSPFrame)frames[i]).repaint();
        }
    }

    public static void clearDrawingFrameData(boolean clearAll) {
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isDisplayable() || !(class$org$opensourcephysics$display$OSPFrame == null ? GUIUtils.class$("org.opensourcephysics.display.OSPFrame") : class$org$opensourcephysics$display$OSPFrame).isInstance(frames[i])) continue;
            OSPFrame frame = (OSPFrame)frames[i];
            if (!clearAll && !frame.isAutoclear()) continue;
            frame.clearDataAndRepaint();
        }
    }

    public static void setAnimatedFrameIgnoreRepaint(boolean ignoreRepaint) {
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            DrawingPanel dp;
            if (!frames[i].isDisplayable() || !(class$org$opensourcephysics$display$DrawingFrame == null ? GUIUtils.class$("org.opensourcephysics.display.DrawingFrame") : class$org$opensourcephysics$display$DrawingFrame).isInstance(frames[i]) || !((DrawingFrame)frames[i]).isAnimated() || (dp = ((DrawingFrame)frames[i]).getDrawingPanel()) == null) continue;
            dp.setIgnoreRepaint(ignoreRepaint);
        }
    }

    public static void enableMenubars(boolean enable) {
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            JMenuBar bar;
            if (!frames[i].isDisplayable() || frames[i].getName() != null && frames[i].getName().indexOf("Tool") > -1 || !(class$org$opensourcephysics$display$DrawingFrame == null ? GUIUtils.class$("org.opensourcephysics.display.DrawingFrame") : class$org$opensourcephysics$display$DrawingFrame).isInstance(frames[i]) && !(frames[i] instanceof DrawingFrame3D) || (bar = ((JFrame)frames[i]).getJMenuBar()) == null) continue;
            int n = bar.getMenuCount();
            for (int j = 0; j < n; ++j) {
                bar.getMenu(j).setEnabled(enable);
            }
        }
    }

    public static void closeAndDisposeOSPFrames(Frame frame) {
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i] == frame || !(class$org$opensourcephysics$display$OSPFrame == null ? GUIUtils.class$("org.opensourcephysics.display.OSPFrame") : class$org$opensourcephysics$display$OSPFrame).isInstance(frames[i])) continue;
            ((OSPFrame)frames[i]).setDefaultCloseOperation(2);
            ((OSPFrame)frames[i]).setVisible(false);
            ((OSPFrame)frames[i]).dispose();
        }
    }

    public static Color randomColor() {
        return new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
    }

    public static File showSaveDialog(Component parent) {
        return GUIUtils.showSaveDialog(parent, "Save");
    }

    public static File showSaveDialog(Component parent, String title) {
        int selected;
        JFileChooser fileChooser = OSPFrame.getChooser();
        if (fileChooser == null) {
            return null;
        }
        String oldTitle = fileChooser.getDialogTitle();
        fileChooser.setDialogTitle(title);
        int result = fileChooser.showSaveDialog(parent);
        fileChooser.setDialogTitle(oldTitle);
        if (result != 0) {
            return null;
        }
        OSPFrame.chooserDir = fileChooser.getCurrentDirectory().toString();
        File file = fileChooser.getSelectedFile();
        if (file.exists() && (selected = JOptionPane.showConfirmDialog(parent, "A file named " + file.getName() + " already exists.\nAre you sure you want to replace it?", "Warning", 1)) != 0) {
            return null;
        }
        return file;
    }

    public static File showOpenDialog(Component parent) {
        JFileChooser fileChooser = OSPFrame.getChooser();
        int result = fileChooser.showOpenDialog(parent);
        if (result != 0) {
            return null;
        }
        OSPFrame.chooserDir = fileChooser.getCurrentDirectory().toString();
        File file = fileChooser.getSelectedFile();
        return file;
    }

    public static void timingTest(Drawable drawable) {
        DrawingPanel dp = new DrawingPanel();
        DrawingFrame df = new DrawingFrame(dp);
        df.setVisible(true);
        dp.addDrawable(drawable);
        dp.scale();
        dp.setPixelScale();
        Graphics g2 = dp.getGraphics();
        if (g2 == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        drawable.draw(dp, g2);
        System.out.print("first drawing=" + (System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        for (int i = 0; i < 5; ++i) {
            drawable.draw(dp, g2);
        }
        System.out.println("  avg time/drawing=" + (System.currentTimeMillis() - startTime) / 5L);
        g2.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveImage(JComponent comp, File outputFile, String outputFileFormat) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFile);
            if (outputFileFormat.equals("eps")) {
                EpsGraphics2D g = new EpsGraphics2D("", fos, 0, 0, comp.getWidth(), comp.getHeight());
                comp.paint(g);
                g.scale(0.24, 0.24);
                g.close();
            } else {
                BufferedImage bi = new BufferedImage(comp.getWidth(), comp.getHeight(), 5);
                Graphics g = bi.getGraphics();
                comp.paint(g);
                g.dispose();
                ImageIO.write((RenderedImage)bi, outputFileFormat, fos);
                fos.close();
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void saveImage(JComponent component, String ouputFileFormat, Component parent) {
        File outputFile = GUIUtils.showSaveDialog(component, "Save Image");
        if (outputFile == null) {
            return;
        }
        try {
            GUIUtils.saveImage(component, outputFile, ouputFileFormat);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(parent, "An error occurred while saving the file " + outputFile.getName() + ".'");
        }
    }

    static {
        charMap.put("\\Alpha", "\u0391");
        charMap.put("\\Beta", "\u0392");
        charMap.put("\\Gamma", "\u0393");
        charMap.put("\\Delta", "\u0394");
        charMap.put("\\Epsilon", "\u0395");
        charMap.put("\\Zeta", "\u0396");
        charMap.put("\\Eta", "\u0397");
        charMap.put("\\Theta", "\u0398");
        charMap.put("\\Pi", "\u03a0");
        charMap.put("\\Rho", "\u03a1");
        charMap.put("\\Sigma", "\u03a3");
        charMap.put("\\Tau", "\u03a4");
        charMap.put("\\Phi", "\u03a6");
        charMap.put("\\Chi", "\u03a7");
        charMap.put("\\Psi", "\u03a8");
        charMap.put("\\Omega", "\u03a9");
        charMap.put("\\Xi", "\u039e");
        charMap.put("\\alpha", "\u03b1");
        charMap.put("\\beta", "\u03b2");
        charMap.put("\\gamma", "\u03b3");
        charMap.put("\\delta", "\u03b4");
        charMap.put("\\epsilon", "\u03b5");
        charMap.put("\\zeta", "\u03b6");
        charMap.put("\\eta", "\u03b7");
        charMap.put("\\theta", "\u03b8");
        charMap.put("\\iota", "\u03b9");
        charMap.put("\\kappa", "\u03ba");
        charMap.put("\\lamda", "\u03bb");
        charMap.put("\\mu", "\u03bc");
        charMap.put("\\micro", "\u03bc");
        charMap.put("\\nu", "\u03bd");
        charMap.put("\\xi", "\u03be");
        charMap.put("\\pi", "\u03c0");
        charMap.put("\\rho", "\u03c1");
        charMap.put("\\sigma", "\u03c3");
        charMap.put("\\tau", "\u03c4");
        charMap.put("\\phi", "\u03c6");
        charMap.put("\\chi", "\u03c7");
        charMap.put("\\psi", "\u03c8");
        charMap.put("\\omega", "\u03c9");
        charMap.put("\\degree", "\u00b0");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

