/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class MeasuredImage
implements Measurable {
    protected BufferedImage image;
    protected double xmin;
    protected double xmax;
    protected double ymin;
    protected double ymax;
    protected boolean visible = true;

    public MeasuredImage() {
        this(null, 0.0, 0.0, 0.0, 0.0);
    }

    public MeasuredImage(BufferedImage image) {
        this(image, 0.0, image.getWidth(), 0.0, image.getHeight());
    }

    public MeasuredImage(BufferedImage _image, double _xmin, double _xmax, double _ymin, double _ymax) {
        this.image = _image;
        this.xmin = _xmin;
        this.xmax = _xmax;
        this.ymin = _ymin;
        this.ymax = _ymax;
    }

    public void setImage(BufferedImage _image) {
        this.image = _image;
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.image == null) {
            panel.setMessage("No image");
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform gat = g2.getTransform();
        RenderingHints hints = g2.getRenderingHints();
        g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        double sx = (this.xmax - this.xmin) * panel.xPixPerUnit / (double)this.image.getWidth();
        double sy = (this.ymax - this.ymin) * panel.yPixPerUnit / (double)this.image.getHeight();
        g2.transform(AffineTransform.getTranslateInstance((double)panel.leftGutter + panel.xPixPerUnit * (this.xmin - panel.xmin), (double)panel.topGutter + panel.yPixPerUnit * (panel.ymax - this.ymax)));
        g2.transform(AffineTransform.getScaleInstance(sx, sy));
        g2.drawImage((Image)this.image, 0, 0, panel);
        g2.setTransform(gat);
        g2.setRenderingHints(hints);
    }

    public boolean isMeasured() {
        return this.image != null;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    public void setXMin(double _xmin) {
        this.xmin = _xmin;
    }

    public void setXMax(double _xmax) {
        this.xmax = _xmax;
    }

    public void setYMin(double _ymin) {
        this.ymin = _ymin;
    }

    public void setYMax(double _ymax) {
        this.ymax = _ymax;
    }

    public void setMinMax(double _xmin, double _xmax, double _ymin, double _ymax) {
        this.xmin = _xmin;
        this.xmax = _xmax;
        this.ymin = _ymin;
        this.ymax = _ymax;
    }
}

