/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferStrategy;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.OSPParameters;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.TranslatorTool;

public class OSPFrame
extends JFrame
implements Printable {
    public static boolean DEFAULT_LOOK_AND_FEEL = true;
    public static final String osp_icon_file = "/org/opensourcephysics/resources/controls/images/osp_icon.gif";
    public static String chooserDir;
    protected ArrayList customButtons = new ArrayList();
    protected static Locale[] defaultLocales;
    static int topx;
    static int topy;
    protected boolean animated = false;
    protected boolean autoclear = false;
    public static boolean appletMode;
    protected static boolean launcherMode;
    protected static boolean authorMode;
    private volatile boolean wishesToExit = false;
    public static JApplet applet;
    public ThreadGroup constructorThreadGroup = Thread.currentThread().getThreadGroup();
    protected boolean keepHidden = false;
    protected BufferStrategy strategy;
    private static JFileChooser chooser;
    protected JPanel buttonPanel = new JPanel();
    static /* synthetic */ Class class$org$opensourcephysics$tools$LaunchNode;

    public static Locale[] getDefaultLocales() {
        return defaultLocales;
    }

    public static void setAuthorMode(boolean b) {
        authorMode = b;
    }

    public static boolean isAuthorMode() {
        return authorMode;
    }

    public static void setLauncherMode(boolean b) {
        launcherMode = b;
    }

    public static boolean isLauncherMode() {
        return launcherMode;
    }

    public OSPFrame(String title) {
        super(GUIUtils.parseTeX(title));
        if (appletMode) {
            this.keepHidden = true;
        }
        this.buttonPanel.setVisible(false);
        ((Component)this).setLocation(topx, topy);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        topx = Math.min(topx + 20, (int)d.getWidth() - 100);
        topy = Math.min(topy + 20, (int)d.getHeight() - 100);
        this.setDefaultCloseOperation(1);
        this.setFontLevel(FontSizer.getLevel());
        FontSizer.addPropertyChangeListener("level", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                int level = (Integer)e.getNewValue();
                OSPFrame.this.setFontLevel(level);
            }
        });
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                OSPFrame.this.refreshGUI();
            }
        });
        ((Frame)this).setIconImage(ResourceLoader.getImage(osp_icon_file));
    }

    public OSPFrame() {
        this("Open Source Physics");
    }

    public OSPFrame(Container contentPane) {
        this();
        this.setContentPane(contentPane);
    }

    public void setTitle(String title) {
        super.setTitle(GUIUtils.parseTeX(title));
    }

    public boolean isIconified() {
        return (this.getExtendedState() & 1) == 1;
    }

    public void invalidateImage() {
    }

    protected void setFontLevel(int level) {
        FontSizer.setFonts(this.getJMenuBar(), level);
        FontSizer.setFonts(this.getContentPane(), level);
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean isAutoclear() {
        return this.autoclear;
    }

    public void setAutoclear(boolean autoclear) {
        this.autoclear = autoclear;
    }

    protected JMenu loadDisplayMenu() {
        return null;
    }

    protected JMenu loadToolsMenu() {
        return null;
    }

    public void clearData() {
    }

    public void clearDataAndRepaint() {
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    public void show() {
        if (!this.keepHidden) {
            super.show();
        }
    }

    public void dispose() {
        this.keepHidden = true;
        super.dispose();
    }

    public void setVisible(boolean b) {
        if (!this.keepHidden) {
            boolean shouldRender = !this.isVisible() && this.animated;
            super.setVisible(b);
            if (shouldRender) {
                this.render();
            }
        }
    }

    public void setKeepHidden(boolean _keepHidden) {
        this.keepHidden = _keepHidden;
        if (this.keepHidden) {
            super.setVisible(false);
        }
    }

    public boolean isKeepHidden() {
        return this.keepHidden;
    }

    public ThreadGroup getConstructorThreadGroup() {
        return this.constructorThreadGroup;
    }

    public void createBufferStrategy() {
        this.createBufferStrategy(2);
        this.strategy = this.getBufferStrategy();
    }

    public void bufferStrategyShow() {
        if (this.strategy == null) {
            this.createBufferStrategy();
        }
        if (this.isIconified() || !this.isShowing()) {
            return;
        }
        Graphics g = this.strategy.getDrawGraphics();
        this.paintComponents(g);
        g.dispose();
        this.strategy.show();
    }

    public void render() {
    }

    public JMenu getMenu(String menuName) {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        menuName = menuName.trim();
        JMenu menu = null;
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu next = menuBar.getMenu(i);
            if (!next.getText().trim().equals(menuName)) continue;
            menu = next;
            break;
        }
        return menu;
    }

    public JMenu removeMenu(String menuName) {
        JMenuBar menuBar = this.getJMenuBar();
        if (menuBar == null) {
            return null;
        }
        menuName = menuName.trim();
        JMenu menu = null;
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu next = menuBar.getMenu(i);
            if (!next.getText().trim().equals(menuName)) continue;
            menu = next;
            menuBar.remove(i);
            break;
        }
        return menu;
    }

    public JMenuItem removeMenuItem(String menuName, String itemName) {
        JMenu menu = this.getMenu(menuName);
        if (menu == null) {
            return null;
        }
        itemName = itemName.trim();
        JMenuItem item = null;
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem next = menu.getItem(i);
            if (!next.getText().trim().equals(itemName)) continue;
            item = next;
            menu.remove(i);
            break;
        }
        return item;
    }

    public void parseXMLMenu(String xmlMenu) {
        this.parseXMLMenu(xmlMenu, null);
    }

    public void parseXMLMenu(String xmlMenu, Class type) {
        Resource res;
        XMLControl xml = null;
        if (type != null && (res = ResourceLoader.getResource(xmlMenu, type)) != null) {
            xml = new XMLControlElement(res.getString());
        }
        if (xml == null) {
            xml = new XMLControlElement(xmlMenu);
        }
        if (xml.failedToRead()) {
            OSPLog.info("Menu not found: " + xmlMenu);
        } else {
            type = xml.getObjectClass();
            if (type != null && (class$org$opensourcephysics$tools$LaunchNode == null ? (class$org$opensourcephysics$tools$LaunchNode = OSPFrame.class$("org.opensourcephysics.tools.LaunchNode")) : class$org$opensourcephysics$tools$LaunchNode).isAssignableFrom(type)) {
                LaunchNode node = (LaunchNode)xml.loadObject(null);
                JMenuBar menuBar = this.getJMenuBar();
                if (menuBar == null) {
                    return;
                }
                String menuName = node.toString();
                JMenu menu = this.getMenu(menuName);
                if (menu == null) {
                    menu = new JMenu(menuName);
                    menuBar.add(menu);
                    menuBar.validate();
                }
                node.addMenuItemsTo(menu);
                OSPLog.finest("Menu loaded: " + xmlMenu);
            }
        }
    }

    public static JFileChooser getChooser() {
        if (chooser != null) {
            return chooser;
        }
        chooser = chooserDir == null ? new JFileChooser() : new JFileChooser(new File(chooserDir));
        FileFilter defaultFilter = chooser.getFileFilter();
        FileFilter xmlFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = null;
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i > 0 && i < name.length() - 1) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                return extension != null && extension.equals("xml");
            }

            public String getDescription() {
                return "XML files";
            }
        };
        FileFilter txtFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.isDirectory()) {
                    return true;
                }
                String extension = null;
                String name = f.getName();
                int i = name.lastIndexOf(46);
                if (i > 0 && i < name.length() - 1) {
                    extension = name.substring(i + 1).toLowerCase();
                }
                return extension != null && extension.equals("txt");
            }

            public String getDescription() {
                return "TXT files";
            }
        };
        chooser.addChoosableFileFilter(xmlFilter);
        chooser.addChoosableFileFilter(txtFilter);
        chooser.setFileFilter(defaultFilter);
        return chooser;
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= 1) {
            return 1;
        }
        if (g == null) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double scalex = pageFormat.getImageableWidth() / (double)this.getWidth();
        double scaley = pageFormat.getImageableHeight() / (double)this.getHeight();
        double scale = Math.min(scalex, scaley);
        g2.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        g2.scale(scale, scale);
        this.paintAll(g2);
        return 0;
    }

    protected void refreshGUI() {
        Iterator it = ((AbstractList)this.customButtons).iterator();
        while (it.hasNext()) {
            TranslatableButton b = (TranslatableButton)it.next();
            b.refreshGUI();
        }
        this.buttonPanel.validate();
    }

    public JButton addButton(String methodName, String text, String toolTipText, final Object target) {
        TranslatableButton b = new TranslatableButton(text, toolTipText, target);
        text = TranslatorTool.getProperty(target.getClass(), "custom_button." + text, text);
        b.setText(text);
        toolTipText = TranslatorTool.getProperty(target.getClass(), "custom_button." + toolTipText, toolTipText);
        b.setToolTipText(toolTipText);
        Class[] parameters = new Class[]{};
        try {
            final Method m = target.getClass().getMethod(methodName, parameters);
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Object[] args = new Object[]{};
                    try {
                        m.invoke(target, args);
                    }
                    catch (IllegalAccessException iae) {
                        System.err.println(iae);
                    }
                    catch (InvocationTargetException ite) {
                        System.err.println(ite);
                    }
                }
            });
            this.buttonPanel.setVisible(true);
            this.buttonPanel.add(b);
            this.validate();
            this.pack();
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("Error adding custom button " + text + ". The method " + methodName + "() does not exist.");
        }
        this.customButtons.add(b);
        return b;
    }

    public void setDefaultCloseOperation(int operation) {
        if (operation == 3 && OSPParameters.launchingInSingleVM) {
            operation = 2;
            this.wishesToExit = true;
        }
        super.setDefaultCloseOperation(operation);
    }

    public boolean wishesToExit() {
        return this.wishesToExit;
    }

    static {
        defaultLocales = new Locale[]{Locale.ENGLISH, new Locale("es"), new Locale("de"), new Locale("sk"), Locale.TAIWAN};
        topx = 10;
        topy = 100;
        appletMode = false;
        launcherMode = false;
        authorMode = true;
        JFrame.setDefaultLookAndFeelDecorated(DEFAULT_LOOK_AND_FEEL);
        JDialog.setDefaultLookAndFeelDecorated(DEFAULT_LOOK_AND_FEEL);
        try {
            chooserDir = System.getProperty("user.dir", null);
        }
        catch (SecurityException ex) {
            chooserDir = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TranslatableButton
    extends JButton {
        String text;
        String tip;
        Object target;

        public TranslatableButton(String text, String tip, Object target) {
            this.text = text;
            this.tip = tip;
            this.target = target;
        }

        void refreshGUI() {
            this.setText(TranslatorTool.getProperty(this.target.getClass(), "custom_button." + this.text, this.text));
            this.setToolTipText(TranslatorTool.getProperty(this.target.getClass(), "custom_button." + this.tip, this.tip));
        }
    }
}

