/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveCircle;
import org.opensourcephysics.display.InteractiveLabel;
import org.opensourcephysics.numerics.PBC;

public class Protractor
extends InteractiveCircle
implements Drawable {
    static final String thetaStr = "$\\theta$=";
    int protractorRadius;
    int protractorRadius2;
    int arrowLengthPix;
    protected Tip tip = new Tip();
    protected double arrowTheta = 0.0;
    protected double orientation = 0.0;
    protected DecimalFormat f = new DecimalFormat("000");
    protected boolean showTheta = false;
    protected InteractiveLabel tauBox = new InteractiveLabel("$\\theta$=" + this.f.format(this.getTheta()));

    public Protractor(int protractorRadius) {
        this.protractorRadius = protractorRadius;
        this.protractorRadius2 = protractorRadius * 2;
        this.arrowLengthPix = protractorRadius;
        this.tip.color = Color.BLUE;
        this.tauBox.setOffsetX(-20);
        this.tauBox.setOffsetY(5);
    }

    public Protractor() {
        this(40);
    }

    public void setTheta(double angle) {
        this.arrowTheta = angle + this.orientation;
    }

    public double getTheta() {
        return PBC.separation(this.arrowTheta - this.orientation, Math.PI * 2);
    }

    public void setOrientation(double angle) {
        this.orientation = angle;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public void setShowTheta(boolean show) {
        this.showTheta = show;
    }

    public boolean isShowTheta() {
        return this.showTheta;
    }

    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Interactive interactive = super.findInteractive(panel, xpix, ypix);
        if (interactive != null) {
            return interactive;
        }
        interactive = this.tip.findInteractive(panel, xpix, ypix);
        if (interactive != null) {
            return interactive;
        }
        return this.tauBox.findInteractive(panel, xpix, ypix);
    }

    public void draw(DrawingPanel panel, Graphics g) {
        AffineTransform at;
        Graphics2D g2 = (Graphics2D)g;
        double i1 = panel.xToPix(this.x);
        double j1 = panel.yToPix(this.y);
        g2.setColor(new Color(240, 40, 40, 40));
        double start = Math.toDegrees(this.orientation);
        g2.fill(new Arc2D.Double(i1 - (double)this.protractorRadius, j1 - (double)this.protractorRadius, this.protractorRadius2, this.protractorRadius2, start, 180.0, 2));
        g2.setColor(new Color(40, 40, 240, 40));
        g2.fill(new Arc2D.Double(i1 - (double)this.protractorRadius, j1 - (double)this.protractorRadius, this.protractorRadius2, this.protractorRadius2, start + 180.0, 180.0, 2));
        g2.setColor(Color.gray);
        g2.setStroke(new BasicStroke(0.5f));
        for (int i = 0; i < 36; ++i) {
            at = g2.getTransform();
            at.rotate((double)(-i * 2) * Math.PI / 36.0, i1, j1);
            g2.setTransform(at);
            g2.draw(new Line2D.Double(i1 + (double)this.protractorRadius - 5.0, j1, i1 + (double)this.protractorRadius, j1));
            at.rotate((double)(i * 2) * Math.PI / 36.0, i1, j1);
            g2.setTransform(at);
        }
        this.tauBox.setText(thetaStr + this.f.format(Math.toDegrees(this.getTheta())), this.x, this.y);
        if (this.showTheta) {
            this.tauBox.draw(panel, g);
        }
        g2.setColor(Color.RED);
        Stroke currentStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.5f));
        at = g2.getTransform();
        at.rotate(-this.arrowTheta, i1, j1);
        g2.setTransform(at);
        g2.draw(new Line2D.Double(i1, j1, i1 + (double)this.arrowLengthPix, j1));
        GeneralPath arrowHead = new GeneralPath();
        g2.draw(new Line2D.Double());
        arrowHead.moveTo((float)(i1 + (double)this.arrowLengthPix), (float)j1);
        arrowHead.lineTo((float)(i1 + (double)this.arrowLengthPix - 15.0), (float)(j1 - 5.0));
        arrowHead.lineTo((float)(i1 + (double)this.arrowLengthPix - 15.0), (float)(j1 + 5.0));
        arrowHead.closePath();
        g2.fill(arrowHead);
        g2.draw(arrowHead);
        at.rotate(this.arrowTheta, i1, j1);
        g2.setTransform(at);
        g2.setStroke(currentStroke);
        double length = (double)this.arrowLengthPix / panel.getXPixPerUnit();
        this.tip.setXY(this.x + length * Math.cos(this.arrowTheta), this.y + length * Math.sin(this.arrowTheta));
    }

    public class Tip
    extends InteractiveCircle {
        public void setXY(double x, double y) {
            this.x = x;
            this.y = y;
            Protractor.this.arrowTheta = Math.atan2(y - Protractor.this.y, x - Protractor.this.x);
        }
    }
}

